/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PerfModules;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiJmxMapper;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.extutils.AdminUtil;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.websphere.pmi.stat.MBeanLevelSpec;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.websphere.pmi.stat.StatLevelSpec;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.collaborator.PmiJmxBridge;
import com.ibm.ws.pmi.component.PMIImpl;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.ModuleAggregate;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PerfLevelDescriptor;
import com.ibm.ws.pmi.server.PmiConfigManager;
import com.ibm.ws.pmi.server.PmiJmxMapParser;
import com.ibm.ws.pmi.server.PmiUtil;
import com.ibm.ws.pmi.stat.StatsConfigHelper;
import com.ibm.ws.pmi.stat.StatsImpl;
import com.ibm.ws.pmi.wire.WpdCollection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.management.ObjectName;

public class PmiRegistry
implements PmiConstants {
    public static final String COPYRIGHT = "Product 5639-D57,  (C) COPYRIGHT International Business Machines Corp., 2000, 2004\nAll Rights Reserved * Licensed Materials - Property of IBM\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String MSG_BUNDLE = "com.ibm.ws.pmi.properties.PMIMessages";
    public static final boolean Z = AdminHelper.getPlatformHelper().isZOS();
    public static final String PLATFORM = PmiRegistry.initPlatform();
    private static boolean disabled = true;
    private static boolean initialized = false;
    private static boolean allLevelNone = true;
    private static boolean beanMethodDisabled = true;
    public static String nodeName = "mynode";
    public static String serverName = "myserver";
    private static ModuleItem moduleRoot;
    private static int[] rootEnabled;
    private static Hashtable moduleAggregates;
    private static HashMap mbeanToModuleMap;
    private static PerfLevelDescriptor[] _plds;
    private static final TraceComponent tc;
    public static PmiJmxMapper jmxMapper;
    private static ObjectName serverMBean;
    private static final String beanMethodWccmType = "beanModule#beanModule.methods";

    private static String initPlatform() {
        if (Z) {
            return "zos";
        }
        return "distributed";
    }

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        moduleRoot = new ModuleItem();
        try {
            jmxMapper = new PmiJmxMapper(null, null, true);
        }
        catch (Exception exception) {
            Tr.warning(tc, "PMI0004W", exception.getMessage());
            disabled = true;
        }
        PmiJmxMapParser pmiJmxMapParser = new PmiJmxMapParser(jmxMapper);
        pmiJmxMapParser.parse("/com/ibm/websphere/pmi/xml/pmiJmxMapper.xml");
        pmiJmxMapParser.parseExtensions();
        AdminUtil adminUtil = jmxMapper.getAdminUtil();
        disabled = adminUtil == null;
    }

    public static boolean isDisabled() {
        return disabled;
    }

    public static void disable() {
        disabled = true;
    }

    public static void enable() {
        disabled = false;
    }

    public static boolean isAllLevelNone() {
        System.out.println("PmiRegistry.isAllLevelNone()");
        new Exception().fillInStackTrace().printStackTrace();
        return allLevelNone;
    }

    public static boolean isBeanMethodDisabled() {
        if (moduleRoot != null) {
            beanMethodDisabled = PmiRegistry.checkBeanMethodDisabled(moduleRoot);
            return beanMethodDisabled;
        }
        return beanMethodDisabled;
    }

    public static void setAllLevelNone(boolean bl) {
        allLevelNone = bl;
    }

    public static synchronized ModuleItem registerModule(PmiModule pmiModule) {
        Object[] objectArray;
        Serializable serializable;
        Object object;
        if (disabled) {
            return null;
        }
        if (!PmiRegistry.validateModule(pmiModule)) {
            Tr.entry(tc, "registerModule");
            Tr.exit(tc, "registerModule - module is null");
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerModule: " + pmiModule.getModuleID() + ", " + pmiModule.getName());
        }
        String[] stringArray = pmiModule.getPath();
        ModuleItem moduleItem = null;
        if (stringArray == null || stringArray.length == 0) {
            Tr.warning(tc, "PMI0001W", pmiModule.getName());
            return null;
        }
        if (stringArray.length == 1) {
            moduleItem = moduleRoot;
        } else {
            object = PmiRegistry.getParentPath(stringArray);
            moduleItem = moduleRoot.add((String[])object, 0);
        }
        if (!PMIImpl.isCustomSet()) {
            pmiModule.setInstrumentationBySet(PMIImpl.getStatisticSet());
        } else {
            int n;
            object = PmiConfigManager.getSpec(pmiModule.getPath());
            if (object != null) {
                if (object[0] != null) {
                    pmiModule.setInstrumentationLevel((int)object[0][0]);
                } else {
                    pmiModule.setFineGrainedInstrumentation((int[])object[1], (int[])object[2]);
                }
            } else if (stringArray.length == 1) {
                n = PmiRegistry.moduleRoot.level;
                if (n == -2) {
                    pmiModule.setFineGrainedInstrumentation(rootEnabled, new int[0]);
                } else {
                    pmiModule.setInstrumentationLevel(n);
                }
            } else {
                n = moduleItem.getInstance().getInstrumentationLevel();
                if (n == -2) {
                    serializable = PmiRegistry._getAggregateParent(moduleItem);
                    if (serializable != null) {
                        pmiModule.setFineGrainedInstrumentation(((ModuleItem)serializable).getInstance().getEnabled(), ((ModuleItem)serializable).getInstance().getEnabledSync());
                        objectArray = pmiModule.getEnabled();
                        if (objectArray == null || objectArray.length == 0) {
                            ModuleItem moduleItem2 = PmiRegistry._getAggregateParent(moduleItem);
                            object = null;
                            while (moduleItem2 != null && object == null) {
                                if (moduleItem2 != null && moduleItem2.getInstance() instanceof ModuleAggregate) {
                                    object = PmiConfigManager.getSpec(moduleItem2.getInstance().getPath());
                                }
                                if (object != null) continue;
                                moduleItem2 = moduleItem2.getParent();
                            }
                            if (object != null) {
                                if (object[0] != null) {
                                    pmiModule.setInstrumentationLevel((int)object[0][0]);
                                } else {
                                    pmiModule.setFineGrainedInstrumentation((int[])object[1], (int[])object[2]);
                                }
                            }
                        }
                    } else if (PmiRegistry.moduleRoot.level == -2 && rootEnabled != null && rootEnabled.length > 0 && rootEnabled[0] == -3) {
                        pmiModule.setFineGrainedInstrumentation(rootEnabled, new int[0]);
                    } else {
                        pmiModule.setInstrumentationLevel(n);
                    }
                } else {
                    pmiModule.setInstrumentationLevel(n);
                }
            }
        }
        object = new ModuleItem(pmiModule);
        if (!moduleItem.add((ModuleItem)object)) {
            Tr.warning(tc, "PMI0023W", pmiModule.getName());
            if (tc.isDebugEnabled()) {
                String string = "root";
                if (moduleItem.getInstance() != null) {
                    string = moduleItem.getInstance().getName();
                }
                serializable = new StringBuffer("Current entries under: " + string);
                objectArray = moduleItem.children();
                if (objectArray != null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        PmiModule pmiModule2 = objectArray[i].getInstance();
                        if (pmiModule2 == null) continue;
                        ((StringBuffer)serializable).append("\r\n").append(pmiModule2.getName());
                    }
                }
                Tr.debug(tc, ((StringBuffer)serializable).toString());
            }
            object = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerModule");
        }
        return object;
    }

    private static ModuleItem _getAggregateParent(ModuleItem moduleItem) {
        ModuleItem moduleItem2 = moduleItem;
        do {
            if (moduleItem2.getInstance() == null) {
                return null;
            }
            if (!(moduleItem2.getInstance() instanceof ModuleAggregate)) continue;
            return moduleItem2;
        } while ((moduleItem2 = moduleItem2.getParent()) != null);
        return null;
    }

    public static synchronized void unregisterModule(PmiModule pmiModule) {
        if (disabled) {
            return;
        }
        if (pmiModule == null) {
            return;
        }
        String[] stringArray = pmiModule.getPath();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null) continue;
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unregisterModule: " + pmiModule.getModuleID() + ", " + pmiModule.getName());
        }
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
        ModuleItem moduleItem = moduleRoot.find(stringArray2, 0);
        if (moduleItem != null) {
            String[] stringArray3;
            moduleItem.remove(moduleItem.find(stringArray[stringArray.length - 1]));
            if (pmiModule.isCustomModule()) {
                return;
            }
            if (!(moduleItem.children != null && moduleItem.children.size() != 0 || moduleItem.getInstance() == null || (stringArray3 = moduleItem.getInstance().getPath()).length == 2 && stringArray3[0].equals("webServicesModule"))) {
                moduleItem.getInstance().unregister();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unregisterModule");
        }
    }

    private static boolean validateModule(PmiModule pmiModule) {
        return pmiModule != null;
    }

    private static String[] getParentPath(String[] stringArray) {
        if (stringArray == null || stringArray.length <= 1) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
        return stringArray2;
    }

    public static synchronized boolean addModuleInfo(String string, String string2) {
        return PerfModules.addModuleInfo(string2 + string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ModuleAggregate getModuleAggregate(String string) {
        ModuleAggregate moduleAggregate = (ModuleAggregate)moduleAggregates.get(string);
        if (moduleAggregate != null) {
            return moduleAggregate;
        }
        Hashtable hashtable = moduleAggregates;
        synchronized (hashtable) {
            moduleAggregate = (ModuleAggregate)moduleAggregates.get(string);
            if (moduleAggregate != null) {
                return moduleAggregate;
            }
            PmiModuleConfig pmiModuleConfig = PmiRegistry.getConfig(string);
            if (pmiModuleConfig == null) {
                return null;
            }
            moduleAggregate = new ModuleAggregate(string);
            moduleAggregates.put(string, moduleAggregate);
            return moduleAggregate;
        }
    }

    public static PmiModuleConfig getConfig(String string) {
        if (disabled) {
            return null;
        }
        return StatsConfigHelper.getTranslatedStatsConfig(string);
    }

    public static PmiModuleConfig[] getConfigs() {
        return PmiRegistry.getConfigs(null);
    }

    public static PmiModuleConfig[] getConfigs(Locale locale) {
        if (disabled) {
            return null;
        }
        PmiModuleConfig[] pmiModuleConfigArray = PerfModules.getConfigs();
        for (int i = 0; i < pmiModuleConfigArray.length; ++i) {
            if (pmiModuleConfigArray[i].getMbeanType() == null) {
                String string = jmxMapper.getMBeanType(pmiModuleConfigArray[i].getShortName());
                pmiModuleConfigArray[i].setMbeanType(string);
            }
            StatsConfigHelper.translateAndCache(pmiModuleConfigArray[i], locale);
        }
        return StatsConfigHelper.getAllConfigs(null);
    }

    public static PmiModule findPmiModule(MBeanStatDescriptor mBeanStatDescriptor) {
        if (disabled) {
            return null;
        }
        ModuleItem moduleItem = PmiRegistry.findModuleItem(mBeanStatDescriptor);
        if (moduleItem == null) {
            return null;
        }
        return moduleItem.getInstance();
    }

    public static PmiModule findPmiModule(DataDescriptor dataDescriptor) {
        if (disabled) {
            return null;
        }
        ModuleItem moduleItem = PmiRegistry.findModuleItem(dataDescriptor);
        if (moduleItem == null) {
            return null;
        }
        return moduleItem.getInstance();
    }

    public static ModuleItem findModuleItem(ObjectName objectName) {
        DataDescriptor dataDescriptor;
        if (disabled) {
            return null;
        }
        if (objectName == null) {
            return null;
        }
        if (!PmiRegistry.isSameNodeAndServer(objectName)) {
            return null;
        }
        MBeanStatDescriptor mBeanStatDescriptor = new MBeanStatDescriptor(objectName);
        String string = mBeanStatDescriptor.getIdentifier();
        ModuleItem moduleItem = (ModuleItem)mbeanToModuleMap.get(string);
        if (moduleItem != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "findModuleItem() for: " + string);
            }
            return moduleItem;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string);
        }
        if ((dataDescriptor = jmxMapper.getDataDescriptor(objectName, null)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.warning(tc, "PMI0002W", objectName.toString());
            }
            return null;
        }
        moduleItem = PmiRegistry.findModuleItem(dataDescriptor);
        if (moduleItem == null) {
            if (tc.isDebugEnabled()) {
                Tr.warning(tc, "PMI0002W", dataDescriptor.toString());
            }
            return null;
        }
        PmiRegistry.setMBeanToModuleMap(moduleItem, mBeanStatDescriptor);
        return moduleItem;
    }

    public static ModuleItem findModuleItem(MBeanStatDescriptor mBeanStatDescriptor) {
        if (disabled) {
            return null;
        }
        if (mBeanStatDescriptor == null) {
            return null;
        }
        if (!PmiRegistry.isSameNodeAndServer(mBeanStatDescriptor.getObjectName())) {
            return null;
        }
        String string = mBeanStatDescriptor.getIdentifier();
        if (string == null) {
            return null;
        }
        ModuleItem moduleItem = (ModuleItem)mbeanToModuleMap.get(string);
        if (moduleItem != null) {
            return moduleItem;
        }
        DataDescriptor dataDescriptor = PmiRegistry.mBeanToDataDescriptor(mBeanStatDescriptor);
        if (dataDescriptor == null) {
            return null;
        }
        if (dataDescriptor.getPath() == null) {
            return moduleRoot;
        }
        ModuleItem moduleItem2 = PmiRegistry.findModuleItem(dataDescriptor);
        if (moduleItem2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.warning(tc, "PMI0002W", dataDescriptor.toString());
            }
            return null;
        }
        PmiRegistry.setMBeanToModuleMap(moduleItem2, mBeanStatDescriptor);
        return moduleItem2;
    }

    public static ModuleItem findModuleItem(String[] stringArray) {
        if (disabled) {
            return null;
        }
        if (stringArray == null || stringArray[0].equals("pmi")) {
            return moduleRoot;
        }
        return moduleRoot.find(stringArray, 0);
    }

    public static ModuleItem findModuleItem(DataDescriptor dataDescriptor) {
        if (disabled) {
            return null;
        }
        if (dataDescriptor == null || dataDescriptor.getModuleName().equals("pmi")) {
            return moduleRoot;
        }
        return moduleRoot.find(dataDescriptor.getPath(), 0);
    }

    private static ModuleItem findParentModuleItem(DataDescriptor dataDescriptor) {
        String[] stringArray = dataDescriptor.getPath();
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
        return PmiRegistry.findModuleItem(new DataDescriptor(stringArray2));
    }

    private static boolean isSameNodeAndServer(ObjectName objectName) {
        String string = objectName.getKeyProperty("process");
        String string2 = objectName.getKeyProperty("node");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isSameNodeAndServer: " + objectName.toString());
        }
        if (string != null && !string.equals(serverName)) {
            if (tc.isDebugEnabled()) {
                Tr.warning(tc, "PMI0002W", objectName.toString() + ", expected process name is " + serverName);
            }
            return false;
        }
        if (string2 != null && !string2.equals(nodeName)) {
            if (tc.isDebugEnabled()) {
                Tr.warning(tc, "PMI0002W", objectName.toString() + ", expected node name is " + nodeName);
            }
            return false;
        }
        return true;
    }

    public static DataDescriptor[] listMembers() {
        if (disabled) {
            return null;
        }
        ModuleItem[] moduleItemArray = moduleRoot.children();
        if (moduleItemArray == null) {
            return null;
        }
        DataDescriptor[] dataDescriptorArray = new DataDescriptor[moduleItemArray.length];
        for (int i = 0; i < dataDescriptorArray.length; ++i) {
            dataDescriptorArray[i] = new DataDescriptor(new String[]{moduleItemArray[i].getInstance().getName()});
        }
        return dataDescriptorArray;
    }

    public static DataDescriptor[] listMembers(DataDescriptor dataDescriptor) {
        if (disabled) {
            return null;
        }
        if (dataDescriptor == null || dataDescriptor.getPath() == null) {
            return PmiRegistry.listMembers();
        }
        if (dataDescriptor.getType() == -1) {
            return null;
        }
        ModuleItem moduleItem = PmiRegistry.findModuleItem(dataDescriptor);
        if (moduleItem == null) {
            return null;
        }
        return moduleItem.listMembers(dataDescriptor, false);
    }

    public static MBeanStatDescriptor[] listStatMembers(ObjectName objectName) {
        if (disabled) {
            return null;
        }
        if (objectName == null) {
            return null;
        }
        return PmiRegistry.listStatMembers(new MBeanStatDescriptor(objectName));
    }

    public static MBeanStatDescriptor[] listStatMembers(MBeanStatDescriptor mBeanStatDescriptor) {
        if (disabled) {
            return null;
        }
        ModuleItem moduleItem = PmiRegistry.findModuleItem(mBeanStatDescriptor);
        if (moduleItem == null) {
            return null;
        }
        ModuleItem[] moduleItemArray = moduleItem.children();
        if (moduleItemArray == null || moduleItemArray.length == 0) {
            return null;
        }
        MBeanStatDescriptor[] mBeanStatDescriptorArray = new MBeanStatDescriptor[moduleItemArray.length];
        for (int i = 0; i < moduleItemArray.length; ++i) {
            mBeanStatDescriptorArray[i] = moduleItemArray[i].getInstance().getMBeanStatDescriptor();
        }
        return mBeanStatDescriptorArray;
    }

    public static StatDescriptor[] listStatMembers(StatDescriptor statDescriptor, boolean bl) {
        if (disabled) {
            return null;
        }
        ModuleItem moduleItem = null;
        moduleItem = statDescriptor == null ? moduleRoot : PmiRegistry.findModuleItem(statDescriptor.getPath());
        if (moduleItem == null) {
            return null;
        }
        ArrayList arrayList = moduleItem.listChildStatDescriptors(bl);
        int n = arrayList.size();
        StatDescriptor[] statDescriptorArray = new StatDescriptor[n];
        for (int i = 0; i < n; ++i) {
            statDescriptorArray[i] = (StatDescriptor)arrayList.get(i);
        }
        return statDescriptorArray;
    }

    public static WpdCollection get(DataDescriptor dataDescriptor, boolean bl) {
        if (disabled) {
            return null;
        }
        return PmiRegistry.getStats(PmiRegistry.findModuleItem(dataDescriptor), bl);
    }

    public static WpdCollection[] gets(DataDescriptor[] dataDescriptorArray, boolean bl) {
        if (disabled) {
            return null;
        }
        WpdCollection[] wpdCollectionArray = new StatsImpl[dataDescriptorArray.length];
        for (int i = 0; i < wpdCollectionArray.length; ++i) {
            wpdCollectionArray[i] = PmiRegistry.getStats(PmiRegistry.findModuleItem(dataDescriptorArray[i]), bl);
        }
        return wpdCollectionArray;
    }

    private static StatsImpl getStats(ModuleItem moduleItem, boolean bl) {
        if (moduleItem == null) {
            return null;
        }
        return moduleItem.getStats(bl);
    }

    public static StatsImpl getStats(DataDescriptor dataDescriptor, boolean bl) {
        if (disabled) {
            return null;
        }
        return PmiRegistry.getStats(PmiRegistry.findModuleItem(dataDescriptor), bl);
    }

    public static StatsImpl[] getStats(DataDescriptor[] dataDescriptorArray, boolean bl) {
        if (disabled) {
            return null;
        }
        StatsImpl[] statsImplArray = new StatsImpl[dataDescriptorArray.length];
        for (int i = 0; i < dataDescriptorArray.length; ++i) {
            statsImplArray[i] = PmiRegistry.getStats(dataDescriptorArray[i], bl);
        }
        return statsImplArray;
    }

    public static StatsImpl[] getStats(StatDescriptor[] statDescriptorArray, boolean bl) {
        if (disabled) {
            return null;
        }
        StatsImpl[] statsImplArray = new StatsImpl[statDescriptorArray.length];
        for (int i = 0; i < statDescriptorArray.length; ++i) {
            statsImplArray[i] = PmiRegistry.getStats(PmiRegistry.findModuleItem(statDescriptorArray[i].getPath()), bl);
        }
        return statsImplArray;
    }

    public static StatsImpl getStats(MBeanStatDescriptor mBeanStatDescriptor, boolean bl) {
        if (disabled) {
            return null;
        }
        if (mBeanStatDescriptor == null) {
            return null;
        }
        return PmiRegistry.getStats(PmiRegistry.findModuleItem(mBeanStatDescriptor), bl);
    }

    public static StatsImpl[] getStats(MBeanStatDescriptor[] mBeanStatDescriptorArray, boolean bl) {
        if (disabled) {
            return null;
        }
        StatsImpl[] statsImplArray = new StatsImpl[mBeanStatDescriptorArray.length];
        for (int i = 0; i < mBeanStatDescriptorArray.length; ++i) {
            statsImplArray[i] = PmiRegistry.getStats(mBeanStatDescriptorArray[i], bl);
        }
        return statsImplArray;
    }

    public static StatsImpl[] getStats(ObjectName[] objectNameArray, boolean bl) {
        if (disabled) {
            return null;
        }
        StatsImpl[] statsImplArray = new StatsImpl[objectNameArray.length];
        for (int i = 0; i < objectNameArray.length; ++i) {
            statsImplArray[i] = PmiRegistry.getStats(PmiRegistry.findModuleItem(objectNameArray[i]), bl);
        }
        return statsImplArray;
    }

    public static MBeanLevelSpec[] getMBeanLevelSpecs(ObjectName objectName, StatDescriptor statDescriptor, boolean bl) {
        if (disabled) {
            return null;
        }
        if (objectName == null) {
            return null;
        }
        ModuleItem moduleItem = PmiRegistry.findModuleItem(new MBeanStatDescriptor(objectName, statDescriptor));
        if (moduleItem == null) {
            if (tc.isDebugEnabled()) {
                Tr.warning(tc, "PMI0002W", objectName.toString());
            }
            return null;
        }
        if (!bl) {
            if (moduleItem.getInstance() != null) {
                int n = moduleItem.getInstance().getInstrumentationLevel();
                MBeanLevelSpec mBeanLevelSpec = new MBeanLevelSpec(objectName, statDescriptor, n);
                if (n == -2) {
                    mBeanLevelSpec.setEnabled(moduleItem.getInstance().getEnabled());
                }
                return new MBeanLevelSpec[]{mBeanLevelSpec};
            }
            return null;
        }
        ArrayList arrayList = moduleItem.getPerfLevelDescriptors(true);
        MBeanLevelSpec[] mBeanLevelSpecArray = new MBeanLevelSpec[arrayList.size()];
        for (int i = 0; i < mBeanLevelSpecArray.length; ++i) {
            mBeanLevelSpecArray[i] = (MBeanLevelSpec)arrayList.get(i);
        }
        return mBeanLevelSpecArray;
    }

    public static StatLevelSpec[] getInstrumentationLevel(StatDescriptor statDescriptor, boolean bl) {
        if (disabled) {
            return null;
        }
        ModuleItem moduleItem = PmiRegistry.findModuleItem(statDescriptor.getPath());
        if (moduleItem == null) {
            return null;
        }
        if (!bl) {
            StatLevelSpec[] statLevelSpecArray = new StatLevelSpec[1];
            PmiModule pmiModule = moduleItem.getInstance();
            if (pmiModule != null) {
                statLevelSpecArray[0] = new StatLevelSpec(statDescriptor.getPath(), pmiModule.getEnabled());
                return statLevelSpecArray;
            }
            return null;
        }
        ArrayList arrayList = moduleItem.getStatLevelSpec(bl);
        StatLevelSpec[] statLevelSpecArray = new StatLevelSpec[arrayList.size()];
        for (int i = 0; i < statLevelSpecArray.length; ++i) {
            statLevelSpecArray[i] = (StatLevelSpec)arrayList.get(i);
        }
        return statLevelSpecArray;
    }

    public static void appendInstrumentationLevel(StatLevelSpec[] statLevelSpecArray, boolean bl) {
        if (disabled) {
            return;
        }
        for (int i = 0; i < statLevelSpecArray.length; ++i) {
            int[] nArray;
            ModuleItem moduleItem;
            if (statLevelSpecArray[i] == null || (moduleItem = PmiRegistry.findModuleItem(statLevelSpecArray[i].getPath())) == null) continue;
            if (moduleItem.getInstance() == null) {
                nArray = statLevelSpecArray[i].getEnabled();
                if (nArray == null || nArray.length <= 0 || nArray[0] != -3) continue;
                moduleItem.setInstanceLevel(nArray, new int[0], -2, bl);
                continue;
            }
            nArray = moduleItem.getInstance().getEnabled();
            int[] nArray2 = statLevelSpecArray[i].getEnabled();
            if (nArray.length != 0 && nArray[0] == -3 || nArray2.length == 0) continue;
            if (nArray2[0] == -3 || nArray.length == 0) {
                moduleItem.setInstanceLevel(nArray2, new int[0], -2, bl);
                continue;
            }
            moduleItem.setInstanceLevel(PmiRegistry.getUnionForAppendInstrumentationLevel(nArray, nArray2), new int[0], -2, bl);
        }
        beanMethodDisabled = PmiRegistry.checkBeanMethodDisabled(moduleRoot);
    }

    private static int[] getUnionForAppendInstrumentationLevel(int[] nArray, int[] nArray2) {
        int n;
        int[] nArray3 = new int[nArray2.length + nArray.length];
        int n2 = -1;
        for (n = 0; n < nArray.length; ++n) {
            nArray3[n] = nArray[n];
            ++n2;
        }
        boolean bl = false;
        for (n = 0; n < nArray2.length; ++n) {
            for (int i = 0; i < nArray.length && !bl; ++i) {
                if (nArray2[n] != nArray[i]) continue;
                bl = true;
            }
            if (!bl) {
                nArray3[++n2] = nArray2[n];
            }
            bl = false;
        }
        int[] nArray4 = new int[n2 + 1];
        for (n = 0; n <= n2; ++n) {
            nArray4[n] = nArray3[n];
        }
        return nArray4;
    }

    public static PerfLevelDescriptor[] getInstrumentationLevel(DataDescriptor dataDescriptor, boolean bl) {
        if (disabled) {
            return null;
        }
        ModuleItem moduleItem = PmiRegistry.findModuleItem(dataDescriptor);
        if (moduleItem == null) {
            return null;
        }
        if (!bl) {
            PerfLevelDescriptor[] perfLevelDescriptorArray = new PerfLevelDescriptor[1];
            String[] stringArray = moduleItem.getInstance().getPath();
            PmiModule pmiModule = moduleItem.getInstance();
            perfLevelDescriptorArray[0] = new PerfLevelDescriptor(pmiModule.getPath(), pmiModule.getInstrumentationLevel(), pmiModule.getModuleID());
            return perfLevelDescriptorArray;
        }
        ArrayList arrayList = moduleItem.getPerfLevelDescriptors(false);
        PerfLevelDescriptor[] perfLevelDescriptorArray = new PerfLevelDescriptor[arrayList.size()];
        for (int i = 0; i < perfLevelDescriptorArray.length; ++i) {
            perfLevelDescriptorArray[i] = (PerfLevelDescriptor)arrayList.get(i);
        }
        return perfLevelDescriptorArray;
    }

    public static int getInstrumentationLevel(String[] stringArray) {
        if (disabled) {
            return -1;
        }
        DataDescriptor dataDescriptor = new DataDescriptor(stringArray);
        ModuleItem moduleItem = PmiRegistry.findModuleItem(dataDescriptor);
        if (moduleItem == null) {
            return -1;
        }
        return moduleItem.getInstance().getInstrumentationLevel();
    }

    public static PerfLevelDescriptor[] getAllInstrumentationLevels() {
        if (disabled) {
            return null;
        }
        ArrayList arrayList = moduleRoot.getPerfLevelDescriptors(false);
        PerfLevelDescriptor[] perfLevelDescriptorArray = new PerfLevelDescriptor[arrayList.size()];
        for (int i = 0; i < perfLevelDescriptorArray.length; ++i) {
            perfLevelDescriptorArray[i] = (PerfLevelDescriptor)arrayList.get(i);
        }
        return perfLevelDescriptorArray;
    }

    public static String getInstrumentationLevelString() {
        if (disabled) {
            return null;
        }
        Map map = PmiRegistry.moduleRoot.children;
        if (map == null) {
            return "";
        }
        PerfLevelDescriptor[] perfLevelDescriptorArray = new PerfLevelDescriptor[map.size()];
        Iterator iterator = map.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            PmiModule pmiModule = ((ModuleItem)iterator.next()).getInstance();
            perfLevelDescriptorArray[n++] = new PerfLevelDescriptor(pmiModule.getPath(), pmiModule.getInstrumentationLevel(), pmiModule.getModuleID());
        }
        return PmiUtil.getStringFromPerfLevelSpecs(perfLevelDescriptorArray);
    }

    public static String getInstrumentationLevelString60() {
        StatLevelSpec[] statLevelSpecArray = PmiRegistry.getInstrumentationLevel(new StatDescriptor(null), true);
        if (statLevelSpecArray == null || statLevelSpecArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(statLevelSpecArray[0].toString());
        for (int i = 1; i < statLevelSpecArray.length; ++i) {
            stringBuffer.append(":").append(statLevelSpecArray[i].toString());
        }
        return stringBuffer.toString();
    }

    public static void setInstrumentationLevel(StatLevelSpec[] statLevelSpecArray, boolean bl) {
        if (disabled) {
            return;
        }
        for (int i = 0; i < statLevelSpecArray.length; ++i) {
            ModuleItem moduleItem;
            if (statLevelSpecArray[i] == null || (moduleItem = PmiRegistry.findModuleItem(statLevelSpecArray[i].getPath())) == null) continue;
            if (moduleItem.getInstance() == null) {
                int[] nArray = statLevelSpecArray[i].getEnabled();
                if (nArray == null || nArray.length <= 0 || nArray[0] != -3) continue;
                moduleItem.setInstanceLevel(nArray, new int[0], -2, bl);
                continue;
            }
            moduleItem.setInstanceLevel(statLevelSpecArray[i].getEnabled(), new int[0], -2, bl);
        }
        beanMethodDisabled = PmiRegistry.checkBeanMethodDisabled(moduleRoot);
    }

    public static void setInstrumentationLevel(PerfLevelDescriptor perfLevelDescriptor, boolean bl) {
        if (disabled) {
            return;
        }
        PmiRegistry.setLevel(perfLevelDescriptor, bl);
        allLevelNone = PmiRegistry.checkAllLevelNone(moduleRoot);
        beanMethodDisabled = PmiRegistry.checkBeanMethodDisabled(moduleRoot);
    }

    public static void setInstrumentationLevel(PerfLevelDescriptor[] perfLevelDescriptorArray, boolean bl) {
        if (disabled) {
            return;
        }
        for (int i = 0; i < perfLevelDescriptorArray.length; ++i) {
            PmiRegistry.setLevel(perfLevelDescriptorArray[i], bl);
        }
        allLevelNone = PmiRegistry.checkAllLevelNone(moduleRoot);
        beanMethodDisabled = PmiRegistry.checkBeanMethodDisabled(moduleRoot);
    }

    private static void setLevel(PerfLevelDescriptor perfLevelDescriptor, boolean bl) {
        if (perfLevelDescriptor == null) {
            return;
        }
        String[] stringArray = perfLevelDescriptor.getPath();
        ModuleItem moduleItem = null;
        if (stringArray == null) {
            Tr.warning(tc, "PMI0001W", "PmiRegistry.setLevel");
            return;
        }
        if (stringArray.length == 1 && stringArray[0].equals("pmi")) {
            moduleItem = moduleRoot;
        } else if (stringArray[0].equals("pmi")) {
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            moduleItem = PmiRegistry.findModuleItem(new DataDescriptor(stringArray2));
        }
        if (moduleItem != null) {
            moduleItem.setInstanceLevel(null, null, perfLevelDescriptor.getLevel(), bl);
        }
    }

    public static void setMBeanLevel(MBeanLevelSpec mBeanLevelSpec, boolean bl) {
        if (disabled) {
            return;
        }
        if (mBeanLevelSpec == null) {
            return;
        }
        PmiRegistry.setLevel(mBeanLevelSpec, bl);
        allLevelNone = PmiRegistry.checkAllLevelNone(moduleRoot);
        beanMethodDisabled = PmiRegistry.checkBeanMethodDisabled(moduleRoot);
    }

    public static void setMBeanLevel(MBeanLevelSpec[] mBeanLevelSpecArray, boolean bl) {
        if (disabled) {
            return;
        }
        if (mBeanLevelSpecArray == null || mBeanLevelSpecArray.length == 0) {
            return;
        }
        for (int i = 0; i < mBeanLevelSpecArray.length; ++i) {
            if (mBeanLevelSpecArray[i] == null) continue;
            PmiRegistry.setLevel(mBeanLevelSpecArray[i], bl);
        }
        allLevelNone = PmiRegistry.checkAllLevelNone(moduleRoot);
        beanMethodDisabled = PmiRegistry.checkBeanMethodDisabled(moduleRoot);
    }

    public static void setInstrumentationLevel(String string) {
        if (string != null && !string.equals(PMIImpl.getStatisticSet()) && PmiConfigManager.isValidStatisticSet(string)) {
            moduleRoot.setInstanceLevel_Set(string, true);
        }
    }

    private static void setLevel(MBeanLevelSpec mBeanLevelSpec, boolean bl) {
        if (mBeanLevelSpec == null) {
            return;
        }
        MBeanStatDescriptor mBeanStatDescriptor = new MBeanStatDescriptor(mBeanLevelSpec.getObjectName(), mBeanLevelSpec.getStatDescriptor());
        ModuleItem moduleItem = PmiRegistry.findModuleItem(mBeanStatDescriptor);
        if (moduleItem != null) {
            moduleItem.setInstanceLevel(mBeanLevelSpec.getEnabled(), new int[0], mBeanLevelSpec.getLevel(), bl);
        } else if (tc.isDebugEnabled()) {
            Tr.warning(tc, "PMI0002W", mBeanLevelSpec.toString());
        }
    }

    private static boolean checkAllLevelNone(ModuleItem moduleItem) {
        if (moduleItem.instance != null && moduleItem.instance.getInstrumentationLevel() != 0) {
            return false;
        }
        if (moduleItem.children == null) {
            return true;
        }
        ModuleItem moduleItem2 = null;
        Iterator iterator = moduleItem.children.values().iterator();
        while (iterator.hasNext()) {
            moduleItem2 = (ModuleItem)iterator.next();
            if (PmiRegistry.checkAllLevelNone(moduleItem2)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkBeanMethodDisabled(ModuleItem moduleItem) {
        Object object;
        if (moduleItem.instance != null && !moduleItem.instance.getModuleID().equals("beanModule")) {
            return true;
        }
        if (moduleItem.instance != null) {
            int n = moduleItem.instance.getInstrumentationLevel();
            if (n >= 7) {
                return false;
            }
            if (n == -2 && moduleItem.instance.getModuleID().equals("beanModule") && (object = (Object)moduleItem.instance.getEnabled()) != null && ((Object)object).length > 0) {
                return false;
            }
        }
        if (moduleItem.children == null) {
            return true;
        }
        ModuleItem moduleItem2 = null;
        object = moduleItem.children.values().iterator();
        while (object.hasNext()) {
            moduleItem2 = (ModuleItem)object.next();
            if (!moduleItem2.getInstance().getModuleID().equals("beanModule") || PmiRegistry.checkBeanMethodDisabled(moduleItem2)) continue;
            return false;
        }
        return true;
    }

    private static int retrieveLevel(String[] stringArray) {
        if (_plds == null) {
            return -1;
        }
        boolean bl = false;
        String[] stringArray2 = null;
        if (stringArray == null || stringArray.length == 0) {
            stringArray2 = new String[]{"pmi"};
            bl = true;
        } else {
            stringArray2 = new String[stringArray.length + 1];
            stringArray2[0] = "pmi";
            System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        }
        for (int i = 0; i < _plds.length; ++i) {
            if (_plds[i].comparePath(stringArray2) != 0) continue;
            return _plds[i].getLevel();
        }
        return -1;
    }

    public static void restorePmiLevel() {
        if (disabled) {
            return;
        }
        PmiRegistry.moduleRoot.level = -2;
        int[][] nArray = PmiConfigManager.getSpec(new String[]{"pmi"});
        if (nArray == null) {
            return;
        }
        if (nArray[0] != null) {
            PmiRegistry.moduleRoot.level = nArray[0][0];
        } else if (nArray[1].length > 1 || nArray[2].length > 1) {
            PmiRegistry.moduleRoot.level = 0;
        } else if (nArray[1].length != 0) {
            if (nArray[1][0] == -3) {
                rootEnabled = new int[1];
                PmiRegistry.rootEnabled[0] = -3;
                PmiRegistry.moduleRoot.level = -2;
            }
        } else if (nArray[2].length != 0 && nArray[2][0] == -3) {
            rootEnabled = new int[1];
            PmiRegistry.rootEnabled[0] = -3;
            PmiRegistry.moduleRoot.level = -2;
        }
        allLevelNone = true;
        beanMethodDisabled = true;
    }

    public static void enableData(DataDescriptor[] dataDescriptorArray, boolean bl) {
        if (disabled) {
            return;
        }
        PmiRegistry.turnOnOffData(dataDescriptorArray, true, bl);
    }

    public static void disableData(DataDescriptor[] dataDescriptorArray, boolean bl) {
        if (disabled) {
            return;
        }
        PmiRegistry.turnOnOffData(dataDescriptorArray, false, bl);
    }

    private static void turnOnOffData(DataDescriptor[] dataDescriptorArray, boolean bl, boolean bl2) {
        for (int i = 0; i < dataDescriptorArray.length; ++i) {
            ModuleItem moduleItem = PmiRegistry.findModuleItem(dataDescriptorArray[i]);
            if (moduleItem == null) continue;
            int[] nArray = dataDescriptorArray[i].getDataIds();
            if (nArray == null) {
                moduleItem.turnOnOffData(-3, bl, bl2);
                continue;
            }
            for (int j = 0; j < nArray.length; ++j) {
                moduleItem.turnOnOffData(nArray[j], bl, bl2);
            }
        }
    }

    public static PerfLevelDescriptor[] getDefaultPerfLevelSpecs() {
        String[] stringArray = PerfModules.moduleIDs;
        PerfLevelDescriptor[] perfLevelDescriptorArray = new PerfLevelDescriptor[stringArray.length + 1];
        perfLevelDescriptorArray[0] = new PerfLevelDescriptor(null, 0);
        for (int i = 0; i < stringArray.length; ++i) {
            perfLevelDescriptorArray[i + 1] = new PerfLevelDescriptor(new String[]{stringArray[i]}, 0);
        }
        return perfLevelDescriptorArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setMBeanToModuleMap(ModuleItem moduleItem, MBeanStatDescriptor mBeanStatDescriptor) {
        if (moduleItem == null || mBeanStatDescriptor == null) {
            return false;
        }
        HashMap hashMap = mbeanToModuleMap;
        synchronized (hashMap) {
            ModuleItem moduleItem2 = mbeanToModuleMap.put(mBeanStatDescriptor.getIdentifier(), moduleItem);
            if (moduleItem.getInstance() != null) {
                moduleItem.getInstance().setMBeanName(mBeanStatDescriptor.getObjectName(), mBeanStatDescriptor.getStatDescriptor());
            }
            if (moduleItem2 != null && tc.isDebugEnabled()) {
                Tr.warning(tc, "PMI0024W", moduleItem2.getInstance().getName());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setMBeanToModuleMap(): " + mBeanStatDescriptor.getIdentifier());
            }
        }
        return true;
    }

    public static void removeMBeanToModuleMap(MBeanStatDescriptor mBeanStatDescriptor) {
        if (mBeanStatDescriptor != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removeMBeanToModuleMap(): " + mBeanStatDescriptor.getIdentifier());
            }
            mbeanToModuleMap.remove(mBeanStatDescriptor.getIdentifier());
        }
    }

    public static DataDescriptor mBeanToDataDescriptor(MBeanStatDescriptor mBeanStatDescriptor) {
        int n;
        ModuleItem moduleItem = PmiRegistry.findModuleItem(mBeanStatDescriptor.getObjectName());
        if (moduleItem == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mBeanToDataDescriptor(): ModuleItem not found for key:" + mBeanStatDescriptor.getObjectName().toString());
            }
            return null;
        }
        if (moduleItem.getInstance() == null) {
            StatDescriptor statDescriptor = mBeanStatDescriptor.getStatDescriptor();
            if (statDescriptor == null) {
                return new DataDescriptor(new String[]{"pmi"});
            }
            String[] stringArray = mBeanStatDescriptor.getStatDescriptor().getPath();
            if (stringArray == null || stringArray.length == 0) {
                return new DataDescriptor(new String[]{"pmi"});
            }
            return new DataDescriptor(stringArray);
        }
        int n2 = 0;
        String[] stringArray = moduleItem.getInstance().getPath();
        String[] stringArray2 = null;
        StatDescriptor statDescriptor = mBeanStatDescriptor.getStatDescriptor();
        if (statDescriptor != null && (stringArray2 = mBeanStatDescriptor.getStatDescriptor().getPath()) != null) {
            n2 = stringArray2.length;
        }
        String[] stringArray3 = new String[stringArray.length + n2];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray3[n] = stringArray[n];
        }
        for (n = stringArray.length; n < stringArray3.length; ++n) {
            stringArray3[n] = stringArray2[n - stringArray.length];
        }
        return new DataDescriptor(stringArray3);
    }

    public static boolean isDuplicateModule(String string) {
        return moduleRoot.find(string) != null;
    }

    public static ObjectName getServerMBean() {
        if (serverMBean == null) {
            serverMBean = jmxMapper.findObjectName(null, "Server", null, null);
        }
        return serverMBean;
    }

    public static PmiJmxBridge getPmiJmxBridge(ObjectName objectName) {
        return (PmiJmxBridge)((Object)PmiRegistry.findModuleItem(objectName));
    }

    public static WSStats getServerSnapshot() {
        return moduleRoot.getStats(true);
    }

    public static void printpath(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("printpath: ");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]).append("/");
        }
        Tr.debug(tc, stringBuffer.toString());
    }

    private static String pathToString(int n, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("|");
        while (n != 0) {
            stringBuffer.append("_");
            --n;
        }
        stringBuffer.append("_ ");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("/").append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public static void printPMITree(ModuleItem moduleItem) {
        if (moduleRoot == null) {
            Tr.debug(tc, "Specified PMI ModuleItem is empty!");
            return;
        }
        Tr.debug(tc, ">> Begin PMI tree");
        StringBuffer stringBuffer = new StringBuffer();
        PmiRegistry._printTree(0, moduleItem, stringBuffer);
        System.err.println(stringBuffer.toString());
        Tr.debug(tc, "<< End PMI tree");
    }

    private static void _printTree(int n, ModuleItem moduleItem, StringBuffer stringBuffer) {
        ModuleItem[] moduleItemArray = moduleItem.children();
        if (moduleItemArray == null) {
            return;
        }
        for (int i = 0; i < moduleItemArray.length; ++i) {
            stringBuffer.append("\r\n").append(PmiRegistry.pathToString(n, moduleItemArray[i].getInstance().getPath()));
            PmiRegistry._printTree(n + 1, moduleItemArray[i], stringBuffer);
        }
    }

    public static void setSynchronizedUpdate(boolean bl) {
        if (moduleRoot != null) {
            PmiRegistry._setSyncEnabled(moduleRoot, bl);
        }
    }

    private static void _setSyncEnabled(ModuleItem moduleItem, boolean bl) {
        if (moduleItem != null) {
            ModuleItem[] moduleItemArray;
            PmiModule pmiModule = moduleItem.getInstance();
            if (pmiModule != null) {
                pmiModule.setSyncEnabled(bl);
            }
            if ((moduleItemArray = moduleItem.children()) != null) {
                for (int i = 0; i < moduleItemArray.length; ++i) {
                    PmiRegistry._setSyncEnabled(moduleItemArray[i], bl);
                }
            }
        }
    }

    static {
        rootEnabled = new int[0];
        moduleAggregates = new Hashtable();
        mbeanToModuleMap = new HashMap();
        _plds = null;
        tc = Tr.register(PmiRegistry.class, null, MSG_BUNDLE);
        jmxMapper = null;
    }
}

