/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.jvmpi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.websphere.pmi.server.SpdLongExternalValue;
import com.ibm.websphere.pmi.server.SpdStatExternalValue;
import com.ibm.ws.pmi.server.PmiUtil;
import com.ibm.ws.pmi.server.data.SpdLongExternal;
import com.ibm.ws.pmi.server.data.SpdStatExternal;
import com.ibm.ws.pmi.server.jvmpi.JvmpiGroup;
import com.ibm.ws.pmi.server.jvmpi.JvmpiJni;
import com.ibm.ws.pmi.stat.CountStatisticImpl;
import com.ibm.ws.pmi.stat.TimeStatisticImpl;
import com.ibm.wsspi.pmi.stat.SPIStatistic;

public class JvmpiInfo
implements PmiConstants {
    private int dataId;
    private int dataType;
    private int code;
    private int level;
    protected SpdData pmiData = null;
    static final int DATAID_OFFSET = 10;
    static final int INT = 0;
    static final int LONG = 1;
    static final int DOUBLE = 2;
    static final int STAT = 3;
    protected static TraceComponent tc = Tr.register(JvmpiInfo.class, null, "com.ibm.ws.pmi.properties.PMIMessages");

    public JvmpiInfo(int n, int n2, int n3, int n4) {
        this.dataId = n;
        this.dataType = n2;
        this.code = n3;
        this.level = 15;
        switch (n2) {
            case 1: {
                this.pmiData = new SpdLongExternal(n, new JvmpiLongData(n3));
                this.pmiData.disable();
                break;
            }
            case 3: {
                this.pmiData = new SpdStatExternal(n, new JvmpiTimeStatistic(n3));
                this.pmiData.disable();
                break;
            }
        }
    }

    public void setLevel(int n) {
        if (n >= this.level) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void disable() {
        if (this.pmiData == null) {
            return;
        }
        this.pmiData.disable();
    }

    public void enable() {
        if (this.pmiData != null) {
            this.pmiData.enable(this.level);
            return;
        }
        switch (this.dataType) {
            case 1: {
                this.pmiData = new SpdLongExternal(this.dataId, new JvmpiLongData(this.code));
                break;
            }
            case 3: {
                this.pmiData = new SpdStatExternal(this.dataId, new JvmpiTimeStatistic(this.code));
                break;
            }
        }
    }

    class JvmpiTimeStatistic
    implements SpdStatExternalValue {
        private int code;
        private long startTime = 0L;
        private TimeStatisticImpl jvmpiData;

        public JvmpiTimeStatistic(int n) {
            this.code = n;
            this.startTime = PmiUtil.currentTime();
            this.jvmpiData = new TimeStatisticImpl(n);
        }

        public SPIStatistic getStatValue() {
            this.updateTimeStat(JvmpiJni.getStatData(this.code));
            return this.jvmpiData;
        }

        public void updateStatistic() {
            this.updateTimeStat(JvmpiJni.getStatData(this.code));
        }

        private void updateTimeStat(long[] lArray) {
            if (lArray != null) {
                this.jvmpiData.set(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], this.startTime, PmiUtil.currentTime());
            } else {
                this.jvmpiData.set(-1L, -1L, -1L, -1L, -1.0, -1L, -1L);
            }
        }
    }

    class JvmpiLongData
    implements SpdLongExternalValue {
        private int code;
        private CountStatisticImpl jvmpiData;

        public JvmpiLongData(int n) {
            this.code = n;
            this.jvmpiData = new CountStatisticImpl(n);
        }

        public SPIStatistic getLongValue() {
            return this.jvmpiData;
        }

        public void updateStatistic() {
            if (tc.isDebugEnabled()) {
                if (JvmpiGroup.jvmpiDebug == 0) {
                    Tr.debug(tc, "Enabling JVMPI native debug");
                    JvmpiJni.setDebug(1);
                    JvmpiGroup.jvmpiDebug = 1;
                }
            } else if (JvmpiGroup.jvmpiDebug == 1) {
                Tr.debug(tc, "Disabling JVMPI native debug");
                JvmpiJni.setDebug(0);
                JvmpiGroup.jvmpiDebug = 0;
            }
            this.jvmpiData.setCount(JvmpiJni.getLong(this.code));
        }
    }
}

