/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.J2CPerf;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdLoadExternalValue;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.data.SpdLoadExternal;
import com.ibm.ws.pmi.server.modules.ResourcePmiModule;
import com.ibm.ws.pmi.stat.BoundedRangeStatisticImpl;
import com.ibm.ws.pmi.stat.CountStatisticImpl;
import com.ibm.ws.pmi.stat.JCAConnectionPoolStatsImpl;
import com.ibm.ws.pmi.stat.JCAConnectionStatsImpl;
import com.ibm.ws.pmi.stat.JDBCConnectionPoolStatsImpl;
import com.ibm.ws.pmi.stat.JDBCConnectionStatsImpl;
import com.ibm.ws.pmi.stat.RangeStatisticImpl;
import com.ibm.ws.pmi.stat.StatsImpl;
import com.ibm.ws.pmi.stat.TimeStatisticImpl;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import java.util.Hashtable;
import javax.management.ObjectName;

public class J2CModule
extends PmiAbstractModule
implements J2CPerf {
    private static final long serialVersionUID = -6259549258220316293L;
    private static final TraceComponent tc = Tr.register(J2CModule.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    public String moduleID = "j2cModule";
    private static final int defaultLevel = 0;
    private CountStatisticImpl numManagedConnections = null;
    private CountStatisticImpl numConnectionHandles = null;
    private CountStatisticImpl numManagedConnectionsCreated = null;
    private CountStatisticImpl numManagedConnectionsDestroyed = null;
    private CountStatisticImpl numManagedConnectionsAllocated = null;
    private CountStatisticImpl numManagedConnectionsReleased = null;
    private CountStatisticImpl numManagedConnectionTimeouts = null;
    private BoundedRangeStatisticImpl freePoolSize = null;
    private BoundedRangeStatisticImpl poolSize = null;
    private RangeStatisticImpl concurrentWaiters = null;
    private RangeStatisticImpl percentMaxed = null;
    private TimeStatisticImpl averageWait = null;
    private TimeStatisticImpl useTime = null;
    private TimeStatisticImpl jdbcOpTimer = null;
    private CountStatisticImpl numDiscardedStmts = null;
    private Hashtable connectionToStartTime = new Hashtable();
    private Hashtable jdbcOpTimerTable = new Hashtable();
    private long localMaxPoolSize = 0L;
    private long localMinPoolSize = 0L;
    public static final int NUM_CREATES = 1;
    public static final int NUM_DESTROYS = 2;
    public static final int NUM_ALLOCATES = 3;
    public static final int NUM_FREES = 4;
    public static final int POOL_SIZE = 5;
    public static final int FREE_POOL_SIZE = 6;
    public static final int CONCURRENT_WAITERS = 7;
    public static final int NUM_FAULTS = 8;
    public static final int PERCENT_USED = 9;
    public static final int PERCENT_MAXED = 10;
    public static final int USE_TIME = 12;
    public static final int AVERAGE_WAIT = 13;
    public static final int NUM_MANAGED_CONNECTIONS = 14;
    public static final int NUM_CONNECTIONS = 15;
    public static final int PREPSTMT_DISCARDS = 21;
    public static final int JDBC_OPERATION_TIMER = 22;
    private String pName = null;
    private ObjectName providerOName = null;
    private ObjectName cfOName = null;
    private ObjectName mcfOName = null;
    private boolean nonPoolModule = false;

    public J2CModule(String string, String string2, ObjectName objectName, ObjectName objectName2) {
        super(string, string2);
        this._createModule(string, string2, objectName, objectName2, null);
        this.categoryName = "pool";
        this.registerModule(this);
    }

    public J2CModule(String string, String string2, ObjectName objectName, ObjectName objectName2, ObjectName objectName3, boolean bl) {
        super(string, null);
        if (bl) {
            this.instanceName = string2 + " (non-pool)";
            this.categoryName = "non-pool";
            this.nonPoolModule = true;
        } else {
            this.instanceName = string2;
            this.categoryName = "pool";
            this.nonPoolModule = false;
        }
        this._createModule(string, this.instanceName, objectName, objectName2, objectName3);
        this.registerModule(this);
    }

    private void _createModule(String string, String string2, ObjectName objectName, ObjectName objectName2, ObjectName objectName3) {
        DataDescriptor dataDescriptor;
        this.moduleID = string;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "new J2CModule: " + string2);
        }
        this.pName = objectName == null ? "jmsConnections" : objectName.getKeyProperty("name");
        if (this.pName == null) {
            this.pName = "undefined";
        }
        if (PmiRegistry.findPmiModule(dataDescriptor = new DataDescriptor(new String[]{this.moduleID, this.pName})) == null) {
            new ResourcePmiModule(this.moduleID, this.pName, objectName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "new J2CModule: modId=" + string + ", eis=" + string2 + "\n  provider=" + objectName + "\n  factory=" + objectName2 + "\n   pname=" + this.pName);
        }
        this.providerOName = objectName;
        this.cfOName = objectName2;
        this.mcfOName = objectName3;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "provider name=" + this.pName);
        }
    }

    public String[] getPath() {
        if (this.pName != null) {
            return new String[]{this.moduleID, this.pName, this.instanceName};
        }
        return new String[]{this.moduleID, this.instanceName};
    }

    protected SpdData createOneData(PmiDataInfo pmiDataInfo) {
        int n = pmiDataInfo.getId();
        if (n == 9) {
            return new SpdLoadExternal(n, new PercentUsedData(n));
        }
        return super.createOneData(pmiDataInfo);
    }

    protected boolean longCreated(SpdLong spdLong) {
        switch (spdLong.getId()) {
            case 14: {
                this.numManagedConnections = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 15: {
                this.numConnectionHandles = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 1: {
                this.numManagedConnectionsCreated = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 2: {
                this.numManagedConnectionsDestroyed = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 3: {
                this.numManagedConnectionsAllocated = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 4: {
                this.numManagedConnectionsReleased = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 8: {
                this.numManagedConnectionTimeouts = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 21: {
                this.numDiscardedStmts = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected boolean loadCreated(SpdLoad spdLoad) {
        switch (spdLoad.getId()) {
            case 6: {
                this.freePoolSize = (BoundedRangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
            case 5: {
                this.poolSize = (BoundedRangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
            case 10: {
                this.percentMaxed = (RangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
            case 7: {
                this.concurrentWaiters = (RangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected boolean statCreated(SpdStat spdStat) {
        switch (spdStat.getId()) {
            case 13: {
                this.averageWait = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
            case 12: {
                this.useTime = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
            case 22: {
                this.jdbcOpTimer = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
        }
        return false;
    }

    public String getModuleID() {
        return this.moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    public final void incrementManagedConnectionCount() {
        if (this.numManagedConnections != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "incrementManagedConnectionCount");
            }
            this.numManagedConnections.increment();
        }
    }

    public final void decrementManagedConnectionCount() {
        if (this.numManagedConnections != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "decrementManagedConnectionCount");
            }
            this.numManagedConnections.decrement();
        }
    }

    public final void incrementConnectionHandleCount() {
        if (this.numConnectionHandles != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "incrementConnectionHandleCount");
            }
            this.numConnectionHandles.increment();
        }
    }

    public final void decrementConnectionHandleCount() {
        if (this.numConnectionHandles != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "decrementConnectionHandleCount");
            }
            this.numConnectionHandles.decrement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void managedConnectionCreated() {
        if (this.numManagedConnectionsCreated != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "managedConnectionCreated");
            }
            this.numManagedConnectionsCreated.increment();
        }
        this.incrementManagedConnectionCount();
        if (this.poolSize != null && this.freePoolSize != null) {
            long l = System.currentTimeMillis();
            BoundedRangeStatisticImpl boundedRangeStatisticImpl = this.poolSize;
            synchronized (boundedRangeStatisticImpl) {
                this.poolSize.incrementWithoutSync(l, 1L);
                this.freePoolSize.incrementWithoutSync(l, 1L);
            }
        } else {
            if (this.poolSize != null) {
                this.poolSize.increment();
            }
            if (this.freePoolSize != null) {
                this.freePoolSize.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void managedConnectionDestroyed(boolean bl) {
        if (this.numManagedConnectionsDestroyed != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "managedConnectionDestroyed");
            }
            this.numManagedConnectionsDestroyed.increment();
        }
        this.decrementManagedConnectionCount();
        if (this.poolSize != null && this.freePoolSize != null) {
            long l = System.currentTimeMillis();
            BoundedRangeStatisticImpl boundedRangeStatisticImpl = this.poolSize;
            synchronized (boundedRangeStatisticImpl) {
                this.poolSize.decrementWithoutSync(l, 1L);
                if (this.freePoolSize.getCurrent() > 0L && !bl) {
                    this.freePoolSize.decrementWithoutSync(l, 1L);
                }
            }
        } else {
            if (this.poolSize != null) {
                this.poolSize.decrement();
            }
            if (this.freePoolSize != null && this.freePoolSize.getCurrent() > 0L && !bl) {
                this.freePoolSize.decrement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void managedConnectionAllocated() {
        if (this.numManagedConnectionsAllocated != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "managedConnectionAllocated");
            }
            this.numManagedConnectionsAllocated.increment();
        }
        if (this.freePoolSize != null && this.percentMaxed != null && this.poolSize != null) {
            long l = System.currentTimeMillis();
            BoundedRangeStatisticImpl boundedRangeStatisticImpl = this.freePoolSize;
            synchronized (boundedRangeStatisticImpl) {
                if (this.freePoolSize.getCurrent() > 0L) {
                    this.freePoolSize.decrementWithoutSync(l, 1L);
                }
                long l2 = this.poolSize.getCurrent() - this.freePoolSize.getCurrent();
                if (this.localMaxPoolSize != 0L && l2 >= this.localMaxPoolSize) {
                    this.percentMaxed.set(l, 100L);
                }
            }
        } else if (this.freePoolSize != null) {
            this.freePoolSize.decrement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void managedConnectionFreed() {
        if (this.numManagedConnectionsReleased != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "managedConnectionFreed");
            }
            this.numManagedConnectionsReleased.increment();
        }
        if (this.freePoolSize != null && this.percentMaxed != null && this.poolSize != null) {
            long l = System.currentTimeMillis();
            BoundedRangeStatisticImpl boundedRangeStatisticImpl = this.freePoolSize;
            synchronized (boundedRangeStatisticImpl) {
                this.freePoolSize.incrementWithoutSync(l, 1L);
                long l2 = this.poolSize.getCurrent() - this.freePoolSize.getCurrent();
                if (this.localMaxPoolSize != 0L && l2 < this.localMaxPoolSize) {
                    this.percentMaxed.set(0L);
                }
            }
        } else if (this.freePoolSize != null) {
            this.freePoolSize.increment();
        }
    }

    public final void beginWaitForManagedConnection() {
        if (this.concurrentWaiters != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "beginWaitForManagedConnection");
            }
            this.concurrentWaiters.increment();
        }
    }

    public final void endWaitForManagedConnection(long l) {
        if (this.concurrentWaiters != null) {
            this.concurrentWaiters.decrement();
        }
        if (this.averageWait != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "endWaitForManagedConnection");
            }
            this.averageWait.add(l);
        }
    }

    public void managedConnectionFault() {
        if (this.numManagedConnectionTimeouts != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "managedConnectionFault");
            }
            this.numManagedConnectionTimeouts.increment();
        }
    }

    public final void beginUseManagedConnection(Object object) {
        if (this.useTime != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "beginUseManagedConnection");
            }
            this.connectionToStartTime.put(object, new Long(System.currentTimeMillis()));
        }
    }

    public final void endUseManagedConnection(Object object) {
        if (this.useTime != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "endUseManagedConnection");
            }
            long l = System.currentTimeMillis();
            Long l2 = (Long)this.connectionToStartTime.remove(object);
            if (l2 != null) {
                long l3 = l - l2;
                this.useTime.add(l3);
            }
        }
    }

    public void setMaxPoolSize(long l) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setMaxPoolSize, max=" + l);
        }
        this.setPoolSize(0L, l);
    }

    public void setPoolSize(long l, long l2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setPoolSize, min=" + l + ", max=" + l2);
        }
        this.localMaxPoolSize = l2;
        this.localMinPoolSize = l;
        if (this.poolSize != null) {
            this.poolSize.setLowerBound(0L);
            this.poolSize.setUpperBound(this.localMaxPoolSize);
        }
        if (this.freePoolSize != null) {
            this.freePoolSize.setLowerBound(0L);
            this.freePoolSize.setUpperBound(this.localMaxPoolSize);
        }
    }

    public final void jdbcOperationCompleted() {
        if (this.jdbcOpTimer != null) {
            Long l = (Long)this.jdbcOpTimerTable.get(Thread.currentThread());
            if (l == null) {
                return;
            }
            long l2 = System.currentTimeMillis() - l;
            this.jdbcOpTimerTable.remove(Thread.currentThread());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "jdbcOperationCompleted in (ms) " + l2);
            }
            this.jdbcOpTimer.add(l2);
        }
    }

    public final void jdbcOperationStarted() {
        if (this.jdbcOpTimer != null) {
            Long l = new Long(System.currentTimeMillis());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "jdbcOperationStarted at " + l);
            }
            this.jdbcOpTimerTable.put(Thread.currentThread(), l);
        }
    }

    public final void statementDiscardedFromCache(Object object) {
        if (this.numDiscardedStmts != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "statementDiscardedFromCache");
            }
            this.numDiscardedStmts.increment();
        }
    }

    public StatsImpl getJSR77Stats(ModuleItem moduleItem) {
        if (this.moduleID.equals("j2cModule")) {
            if (this.nonPoolModule) {
                JCAConnectionStatsImpl jCAConnectionStatsImpl = new JCAConnectionStatsImpl(this.name, this.type, this.currentLevel, this.listStatistics(), null);
                jCAConnectionStatsImpl.setConnectionFactory(this.cfOName);
                jCAConnectionStatsImpl.setManagedConnectionFactory(this.mcfOName);
                return jCAConnectionStatsImpl;
            }
            JCAConnectionPoolStatsImpl jCAConnectionPoolStatsImpl = new JCAConnectionPoolStatsImpl(this.name, this.type, this.currentLevel, this.listStatistics(), null);
            jCAConnectionPoolStatsImpl.setConnectionFactory(this.cfOName);
            jCAConnectionPoolStatsImpl.setManagedConnectionFactory(this.mcfOName);
            return jCAConnectionPoolStatsImpl;
        }
        if (this.nonPoolModule) {
            JDBCConnectionStatsImpl jDBCConnectionStatsImpl = new JDBCConnectionStatsImpl(this.name, this.type, this.currentLevel, this.listStatistics(), null);
            jDBCConnectionStatsImpl.setJdbcDataSource(this.cfOName);
            return jDBCConnectionStatsImpl;
        }
        JDBCConnectionPoolStatsImpl jDBCConnectionPoolStatsImpl = new JDBCConnectionPoolStatsImpl(this.name, this.type, this.currentLevel, this.listStatistics(), null);
        jDBCConnectionPoolStatsImpl.setJdbcDataSource(this.cfOName);
        return jDBCConnectionPoolStatsImpl;
    }

    public ObjectName getMyMBean() {
        return this.cfOName;
    }

    protected void initializeMe(int n) {
        if (this.currentLevel >= 7 || n < 7) {
            return;
        }
        long l = 0L;
        long l2 = 0L;
        if (this.poolSize != null) {
            l2 = this.poolSize.getCurrent();
        }
        if (l2 < 0L) {
            this.poolSize.setLastValue(0L);
        }
        long l3 = 0L;
        if (this.freePoolSize != null) {
            l3 = this.freePoolSize.getCurrent();
        }
        if (l3 < 0L) {
            this.freePoolSize.setLastValue(0L);
            l = l2;
        } else {
            l = l2 - l3;
        }
        long l4 = 0L;
        if (this.concurrentWaiters != null) {
            l4 = this.concurrentWaiters.getCurrent();
        }
        if (l4 < 0L) {
            this.concurrentWaiters.setLastValue(0L);
        }
        if (this.localMaxPoolSize > 0L && this.percentMaxed != null && l >= this.localMaxPoolSize) {
            this.percentMaxed.set(100L);
        }
    }

    final class PercentUsedData
    implements SpdLoadExternalValue {
        private RangeStatisticImpl percentUsedValue = null;

        public PercentUsedData(int n) {
            this.percentUsedValue = new RangeStatisticImpl(n);
        }

        public SPIStatistic getLoadValue() {
            return this.percentUsedValue;
        }

        public void updateStatistic() {
            if (J2CModule.this.poolSize == null || J2CModule.this.freePoolSize == null || this.percentUsedValue == null) {
                return;
            }
            if (J2CModule.this.localMaxPoolSize == 0L) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: PercentUsedData localMaxPoolSize is 0");
                }
                this.percentUsedValue.set(0L, 0L, 0L, 0.0, this.percentUsedValue.getStartTime(), J2CModule.this.poolSize.getLastSampleTime());
            } else {
                long l = (J2CModule.this.poolSize.getCurrent() - J2CModule.this.freePoolSize.getCurrent()) * 100L / J2CModule.this.localMaxPoolSize;
                long l2 = J2CModule.this.poolSize.updateIntegral();
                J2CModule.this.poolSize.setLastSampleTime(l2);
                J2CModule.this.freePoolSize.updateIntegral(l2);
                J2CModule.this.freePoolSize.setLastSampleTime(l2);
                double d = (J2CModule.this.poolSize.getIntegral() - J2CModule.this.freePoolSize.getIntegral()) * 100.0 / (double)J2CModule.this.localMaxPoolSize;
                long l3 = J2CModule.this.poolSize.getLastSampleTime();
                long l4 = (J2CModule.this.localMaxPoolSize - J2CModule.this.freePoolSize.getHighWaterMark()) * 100L / J2CModule.this.localMaxPoolSize;
                long l5 = (J2CModule.this.localMaxPoolSize - J2CModule.this.freePoolSize.getLowWaterMark()) * 100L / J2CModule.this.localMaxPoolSize;
                this.percentUsedValue.set(l4, l5, l, (long)d, this.percentUsedValue.getStartTime(), J2CModule.this.poolSize.getLastSampleTime());
            }
        }
    }
}

