/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.ThreadPoolPerf;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.ws.pmi.server.PMIServiceState;
import com.ibm.ws.pmi.server.PmiAttribute;
import com.ibm.ws.pmi.server.PmiCallback;
import com.ibm.ws.pmi.stat.BoundedRangeStatisticImpl;
import com.ibm.ws.pmi.stat.CountStatisticImpl;
import com.ibm.ws.pmi.stat.RangeStatisticImpl;
import com.ibm.ws.pmi.stat.TimeStatisticImpl;

public class ThreadPoolModule
extends PmiAbstractModule
implements ThreadPoolPerf {
    private static final long serialVersionUID = 4314008022513737052L;
    private static TraceComponent tc = Tr.register(ThreadPoolModule.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    public static final String moduleID = "threadPoolModule";
    private static final int defaultLevel = 0;
    private CountStatisticImpl threadCreates = null;
    private CountStatisticImpl threadDestroys = null;
    private BoundedRangeStatisticImpl activeThreads = null;
    private BoundedRangeStatisticImpl poolSize = null;
    private BoundedRangeStatisticImpl percentMaxed = null;
    private CountStatisticImpl declaredThreadHung = null;
    private CountStatisticImpl declaredThreadHangCleared = null;
    private RangeStatisticImpl concurrentlyHungThreads = null;
    private TimeStatisticImpl activeTime = null;
    private boolean isThreadHangDetectionEnabled = false;
    public static final int THREAD_CREATES = 1;
    public static final int THREAD_DESTROYS = 2;
    public static final int ACTIVE_THREADS = 3;
    public static final int POOL_SIZE = 4;
    public static final int PERCENT_MAXED = 5;
    public static final int THREAD_HUNG = 6;
    public static final int HANG_CLEARED = 7;
    public static final int CONCURRENT_HUNG = 8;
    public static final int ACTIVE_TIME = 9;
    private int minPoolSize = 0;
    private int maxPoolSize = 0;

    public ThreadPoolModule(String string, int n, int n2) {
        this(string, n, n2, null);
    }

    public ThreadPoolModule(String string, int n, int n2, PmiCallback pmiCallback) {
        super(moduleID, string, pmiCallback);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "new ThreadPoolModule, pool=" + string);
        }
        this.registerModule(this);
        this.maxPoolSize = n2;
        this.minPoolSize = n;
        if (this.poolSize != null) {
            this.poolSize.setLowerBound(n);
            this.poolSize.setUpperBound(n2);
        }
    }

    protected boolean longCreated(SpdLong spdLong) {
        switch (spdLong.getId()) {
            case 1: {
                this.threadCreates = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 2: {
                this.threadDestroys = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 6: {
                this.declaredThreadHung = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 7: {
                this.declaredThreadHangCleared = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected boolean loadCreated(SpdLoad spdLoad) {
        switch (spdLoad.getId()) {
            case 3: {
                this.activeThreads = (BoundedRangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
            case 4: {
                this.poolSize = (BoundedRangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
            case 5: {
                this.percentMaxed = (BoundedRangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
            case 8: {
                this.concurrentlyHungThreads = (RangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected boolean statCreated(SpdStat spdStat) {
        switch (spdStat.getId()) {
            case 9: {
                this.activeTime = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
        }
        return false;
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    public synchronized void setInstrumentationLevel(int n) {
        super.setInstrumentationLevel(n);
        if (n == 15 && !this.isThreadHangDetectionEnabled) {
            this.setStatisticEnabled(6, false, false);
            this.setStatisticEnabled(7, false, false);
            this.setStatisticEnabled(8, false, false);
            this.setStatisticEnabled(9, false, false);
            this.updateDataList();
            this.updateEnabledByLevel();
        }
    }

    public synchronized boolean setFineGrainedInstrumentation(int[] nArray, int[] nArray2) {
        boolean bl = super.setFineGrainedInstrumentation(nArray, nArray2);
        if (!this.isThreadHangDetectionEnabled) {
            this.setStatisticEnabled(6, false, false);
            this.setStatisticEnabled(7, false, false);
            this.setStatisticEnabled(8, false, false);
            this.setStatisticEnabled(9, false, false);
            this.updateDataList();
        }
        return bl;
    }

    public void setThreadMonitorServiceEnabled(boolean bl) {
        if (this.isThreadHangDetectionEnabled != bl) {
            this.isThreadHangDetectionEnabled = bl;
            this.setStatisticEnabled(6, bl, false);
            this.setStatisticEnabled(7, bl, false);
            this.setStatisticEnabled(8, bl, false);
            this.setStatisticEnabled(9, bl, false);
            this.updateDataList();
        }
    }

    public void threadCreated(int n) {
        long l = 0L;
        if (this.threadCreates != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "threadCreated: numThreadsInPool=" + n);
            }
            l = System.currentTimeMillis();
            this.threadCreates.increment(l, 1L);
        }
        if (this.poolSize != null) {
            if (l == 0L) {
                l = System.currentTimeMillis();
            }
            this.poolSize.set(l, n);
        }
    }

    public void threadDestroyed(int n) {
        long l = 0L;
        if (this.threadDestroys != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "threadDestroyed: numThreadsInPool=" + n);
            }
            l = System.currentTimeMillis();
            this.threadDestroys.increment(l, 1L);
        }
        if (this.poolSize != null) {
            if (l == 0L) {
                l = System.currentTimeMillis();
            }
            this.poolSize.set(l, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void threadStarted(int n, int n2) {
        BoundedRangeStatisticImpl boundedRangeStatisticImpl;
        long l = 0L;
        if (this.activeThreads != null && this.percentMaxed != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "threadStarted: numActiveThreads=" + n + ", maxSize=" + n2);
            }
            l = System.currentTimeMillis();
            BoundedRangeStatisticImpl boundedRangeStatisticImpl2 = this.activeThreads;
            synchronized (boundedRangeStatisticImpl2) {
                this.activeThreads.set(l, n);
                if (n >= n2) {
                    this.percentMaxed.set(l, 100L);
                }
            }
        }
        if (this.activeThreads != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "threadStarted: numActiveThreads=" + n + ", maxSize=" + n2);
            }
            l = System.currentTimeMillis();
            boundedRangeStatisticImpl = this.activeThreads;
            synchronized (boundedRangeStatisticImpl) {
                this.activeThreads.set(l, n);
            }
        }
        if (this.percentMaxed != null && n >= n2) {
            if (l == 0L) {
                l = System.currentTimeMillis();
            }
            boundedRangeStatisticImpl = this.percentMaxed;
            synchronized (boundedRangeStatisticImpl) {
                this.percentMaxed.set(l, 100L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void threadReturned(int n, int n2) {
        BoundedRangeStatisticImpl boundedRangeStatisticImpl;
        long l = 0L;
        if (this.activeThreads != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "threadReturned: numActiveThreads=" + n + ", maxSize=" + n2);
            }
            l = System.currentTimeMillis();
            boundedRangeStatisticImpl = this.activeThreads;
            synchronized (boundedRangeStatisticImpl) {
                this.activeThreads.set(l, n);
            }
        }
        if (this.percentMaxed != null && n < n2) {
            if (l == 0L) {
                l = System.currentTimeMillis();
            }
            boundedRangeStatisticImpl = this.percentMaxed;
            synchronized (boundedRangeStatisticImpl) {
                this.percentMaxed.set(l, 0L);
            }
        }
    }

    public void threadCreated() {
        if (this.poolSize != null) {
            this.poolSize.increment();
        }
        if (this.threadCreates != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "threadCreated");
            }
            this.threadCreates.increment();
        }
    }

    public void threadDestroyed() {
        if (this.poolSize != null) {
            this.poolSize.decrement();
        }
        if (this.threadDestroys != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "threadDestroyed");
            }
            this.threadDestroys.increment();
        }
    }

    public final void threadStarted(int n) {
        if (PMIServiceState.iStatisticSet < 2) {
            return;
        }
        long l = 0L;
        if (this.activeThreads != null) {
            long l2;
            l = System.currentTimeMillis();
            this.activeThreads.increment(l, 1L);
            if (this.percentMaxed != null && (l2 = this.activeThreads.getCurrent()) >= (long)n) {
                this.percentMaxed.set(l, 100L);
            }
        }
    }

    public final void threadReturned(int n) {
        if (PMIServiceState.iStatisticSet < 2) {
            return;
        }
        long l = 0L;
        if (this.activeThreads != null) {
            long l2;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "threadReturned : maxSize=" + n + ", activeThreads=" + this.activeThreads);
            }
            l = System.currentTimeMillis();
            this.activeThreads.decrement(l, 1L);
            if (this.percentMaxed != null && (l2 = this.activeThreads.getCurrent()) < (long)n) {
                this.percentMaxed.set(l, 0L);
            }
        }
    }

    protected void callbackRuntime(int n) {
        Tr.debug(tc, "callbackRuntime");
        if (n < 7) {
            Tr.exit(tc, "callbackRuntime - level is not high enough");
            return;
        }
        if (this.callback == null) {
            Tr.exit(tc, "callbackRuntime - callback is null");
            return;
        }
        PmiAttribute[] pmiAttributeArray = this.callback.getPmiAttributes();
        for (int i = 0; i < pmiAttributeArray.length; ++i) {
            if (!pmiAttributeArray[i].getName().equals("NumThreadsInPool")) continue;
            long l = pmiAttributeArray[i].getValue();
            if (this.poolSize == null) continue;
            this.poolSize.set(l);
        }
        Tr.exit(tc, "callbackRuntime");
    }

    public void setConfigData(String string, long l, long l2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setConfigData, min=" + l + ", maxSize=" + l2);
        }
        if (string.equalsIgnoreCase("PoolSize")) {
            if (this.poolSize != null) {
                this.poolSize.setLowerBound(l);
                this.poolSize.setUpperBound(l2);
            }
        } else {
            Tr.warning(tc, "PMI9999E", "setConfigData: wrong config data name");
        }
    }

    protected void initializeMe(int n) {
        if (this.currentLevel >= 7 || n < 7) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "initializeMe");
        }
        long l = 0L;
        if (this.poolSize != null) {
            l = this.poolSize.getCurrent();
        }
        if (l < 0L) {
            this.poolSize.setLastValue(0L);
        }
        long l2 = 0L;
        if (this.activeThreads != null) {
            l2 = this.activeThreads.getCurrent();
        }
        if (l2 < 0L) {
            this.activeThreads.setLastValue(0L);
        }
        if (this.maxPoolSize > 0 && l2 >= (long)this.maxPoolSize && this.percentMaxed != null) {
            this.percentMaxed.set(100L);
        }
    }

    public void threadHangDetected() {
        long l = 0L;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "threadHangDetected");
        }
        if (this.declaredThreadHung != null) {
            l = System.currentTimeMillis();
            this.declaredThreadHung.increment(l, 1L);
        }
        if (this.concurrentlyHungThreads != null) {
            if (l != 0L) {
                l = System.currentTimeMillis();
            }
            this.concurrentlyHungThreads.increment(l, 1L);
        }
    }

    public void threadHangCleared(long l) {
        long l2 = 0L;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "threadHangCleared");
        }
        if (this.declaredThreadHung != null) {
            l2 = System.currentTimeMillis();
            this.declaredThreadHung.decrement(l2, 1L);
        }
        if (this.declaredThreadHangCleared != null) {
            if (l2 != 0L) {
                l2 = System.currentTimeMillis();
            }
            this.declaredThreadHangCleared.increment(l2, 1L);
        }
        if (this.concurrentlyHungThreads != null) {
            if (l2 != 0L) {
                l2 = System.currentTimeMillis();
            }
            this.concurrentlyHungThreads.decrement(l2, 1L);
        }
        if (this.activeTime != null) {
            if (l2 != 0L) {
                l2 = System.currentTimeMillis();
            }
            this.activeTime.add(l2, l);
        }
    }
}

