/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.stat;

import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.ws.pmi.stat.StatisticImpl;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;

public class CountStatisticImpl
extends StatisticImpl
implements SPICountStatistic {
    private static final long serialVersionUID = 6335644998767409978L;
    protected long count = 0L;
    protected CountStatisticImpl baseValue = null;

    public int getStatisticType() {
        return 1;
    }

    public CountStatisticImpl(int n) {
        super(n);
    }

    public CountStatisticImpl(int n, long l, long l2, long l3) {
        super(n, null, null, null, l2, l3);
        this.count = l;
    }

    public CountStatisticImpl(int n, String string, String string2, String string3, long l, long l2) {
        super(n, string, string2, string3, l, l2);
    }

    public WSStatistic copy() {
        CountStatisticImpl countStatisticImpl = new CountStatisticImpl(this.id, this.count, this.startTime, this.lastSampleTime);
        countStatisticImpl.baseValue = this.baseValue;
        return countStatisticImpl;
    }

    public long getCount() {
        return this.count;
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean bl) {
        if (bl) {
            super.reset();
        }
        this.count = 0L;
    }

    public void set(long l, long l2, long l3) {
        this.count = l;
        this.startTime = l2;
        this.lastSampleTime = l3;
    }

    public void combine(WSStatistic wSStatistic) {
        if (!this.validate(wSStatistic)) {
            return;
        }
        CountStatisticImpl countStatisticImpl = (CountStatisticImpl)wSStatistic;
        this.count += countStatisticImpl.count;
        if (countStatisticImpl.lastSampleTime > this.lastSampleTime) {
            this.lastSampleTime = countStatisticImpl.lastSampleTime;
        }
    }

    public void setCount(long l) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        this.count = l;
    }

    public void setCount(long l, long l2) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = l2;
        this.count = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void increment(long l, long l2) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = l;
        if (!this.sync) {
            this.count += l2;
        } else {
            CountStatisticImpl countStatisticImpl = this;
            synchronized (countStatisticImpl) {
                this.count += l2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void decrement(long l, long l2) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = l;
        if (!this.sync) {
            this.count -= l2;
        } else {
            CountStatisticImpl countStatisticImpl = this;
            synchronized (countStatisticImpl) {
                this.count -= l2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void increment() {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            ++this.count;
        } else {
            CountStatisticImpl countStatisticImpl = this;
            synchronized (countStatisticImpl) {
                ++this.count;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void increment(long l) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            this.count += l;
        } else {
            CountStatisticImpl countStatisticImpl = this;
            synchronized (countStatisticImpl) {
                this.count += l;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void decrement() {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            --this.count;
        } else {
            CountStatisticImpl countStatisticImpl = this;
            synchronized (countStatisticImpl) {
                --this.count;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void decrement(long l) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            this.count -= l;
        } else {
            CountStatisticImpl countStatisticImpl = this;
            synchronized (countStatisticImpl) {
                this.count -= l;
            }
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer(super.toString(""));
        stringBuffer.append(", type=").append("CountStatistic");
        stringBuffer.append(", count=").append(this.count);
        return stringBuffer.toString();
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<CS");
        stringBuffer.append(" id=\"");
        stringBuffer.append(this.id);
        stringBuffer.append("\" sT=\"");
        stringBuffer.append(this.startTime);
        stringBuffer.append("\" lST=\"");
        stringBuffer.append(this.lastSampleTime);
        stringBuffer.append("\" ct=\"");
        stringBuffer.append(this.count);
        stringBuffer.append("\">\n");
        stringBuffer.append("</CS>");
        return stringBuffer.toString();
    }

    public void update(WSStatistic wSStatistic) {
        if (!this.validate(wSStatistic)) {
            return;
        }
        CountStatisticImpl countStatisticImpl = (CountStatisticImpl)wSStatistic;
        if (this.baseValue == null) {
            this.count = countStatisticImpl.getCount();
            this.startTime = countStatisticImpl.getStartTime();
        } else {
            this.count = countStatisticImpl.count - this.baseValue.count;
            this.startTime = this.baseValue.lastSampleTime;
        }
        this.lastSampleTime = countStatisticImpl.lastSampleTime;
    }

    public WSStatistic delta(WSStatistic wSStatistic) {
        if (!this.validate(wSStatistic)) {
            return null;
        }
        CountStatisticImpl countStatisticImpl = (CountStatisticImpl)wSStatistic;
        CountStatisticImpl countStatisticImpl2 = new CountStatisticImpl(this.id);
        countStatisticImpl2.count = this.count - countStatisticImpl.getCount();
        countStatisticImpl2.startTime = this.startTime;
        countStatisticImpl2.lastSampleTime = this.lastSampleTime;
        return countStatisticImpl2;
    }

    public WSStatistic rateOfChange(WSStatistic wSStatistic) {
        if (!this.validate(wSStatistic)) {
            return null;
        }
        CountStatisticImpl countStatisticImpl = (CountStatisticImpl)wSStatistic;
        CountStatisticImpl countStatisticImpl2 = new CountStatisticImpl(this.id);
        long l = (this.lastSampleTime - countStatisticImpl.lastSampleTime) / 1000L;
        if (l == 0L) {
            return null;
        }
        countStatisticImpl2.count = (this.count - countStatisticImpl.count) / l;
        countStatisticImpl2.startTime = this.startTime;
        countStatisticImpl2.lastSampleTime = this.lastSampleTime;
        return countStatisticImpl2;
    }

    public void resetOnClient(WSStatistic wSStatistic) {
        if (wSStatistic == null) {
            if (this.baseValue == null) {
                this.baseValue = new CountStatisticImpl(this.id);
            }
            this.baseValue.set(this.count, this.startTime, this.lastSampleTime);
            this.update(this.baseValue);
        } else if (this.validate(wSStatistic)) {
            this.baseValue = (CountStatisticImpl)wSStatistic;
            this.update(this.baseValue);
        }
    }

    private boolean validate(WSStatistic wSStatistic) {
        if (wSStatistic == null) {
            return false;
        }
        if (!(wSStatistic instanceof CountStatisticImpl)) {
            return false;
        }
        return wSStatistic.getId() == this.id;
    }
}

