/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.stat;

import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.ws.pmi.stat.StatisticImpl;
import com.ibm.wsspi.pmi.stat.SPIDoubleStatistic;

public class DoubleStatisticImpl
extends StatisticImpl
implements SPIDoubleStatistic {
    private static final long serialVersionUID = -8967426759755629774L;
    protected double count = 0.0;
    protected DoubleStatisticImpl baseValue = null;

    public DoubleStatisticImpl(int n) {
        super(n);
    }

    public DoubleStatisticImpl(int n, double d, long l, long l2) {
        super(n, null, null, null, l, l2);
        this.count = d;
    }

    public DoubleStatisticImpl(int n, String string, String string2, String string3, long l, long l2) {
        super(n, string, string2, string3, l, l2);
    }

    public int getStatisticType() {
        return 2;
    }

    public WSStatistic copy() {
        DoubleStatisticImpl doubleStatisticImpl = new DoubleStatisticImpl(this.id, this.count, this.startTime, this.lastSampleTime);
        doubleStatisticImpl.baseValue = this.baseValue;
        return doubleStatisticImpl;
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean bl) {
        if (bl) {
            super.reset();
        }
        this.count = 0.0;
    }

    public void set(double d, long l, long l2) {
        this.count = d;
        this.startTime = l;
        this.lastSampleTime = l2;
    }

    public double getDouble() {
        if (this.baseValue == null) {
            return this.count;
        }
        return this.count - this.baseValue.getDouble();
    }

    public void combine(WSStatistic wSStatistic) {
        if (!this.validate(wSStatistic)) {
            return;
        }
        DoubleStatisticImpl doubleStatisticImpl = (DoubleStatisticImpl)wSStatistic;
        this.count += doubleStatisticImpl.count;
    }

    public void setDouble(double d) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        this.count = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment() {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            this.count += 1.0;
        } else {
            DoubleStatisticImpl doubleStatisticImpl = this;
            synchronized (doubleStatisticImpl) {
                this.count += 1.0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(double d) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            this.count += d;
        } else {
            DoubleStatisticImpl doubleStatisticImpl = this;
            synchronized (doubleStatisticImpl) {
                this.count += d;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrement() {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            this.count -= 1.0;
        } else {
            DoubleStatisticImpl doubleStatisticImpl = this;
            synchronized (doubleStatisticImpl) {
                this.count -= 1.0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrement(double d) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            this.count -= d;
        } else {
            DoubleStatisticImpl doubleStatisticImpl = this;
            synchronized (doubleStatisticImpl) {
                this.count -= d;
            }
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer(super.toString(""));
        stringBuffer.append(", type=").append("DoubleStatistic");
        stringBuffer.append(", count=").append(this.count);
        return stringBuffer.toString();
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<DS");
        stringBuffer.append(" id=\"");
        stringBuffer.append(this.id);
        stringBuffer.append("\" sT=\"");
        stringBuffer.append(this.startTime);
        stringBuffer.append("\" lST=\"");
        stringBuffer.append(this.lastSampleTime);
        stringBuffer.append("\" ct=\"");
        stringBuffer.append(this.count);
        stringBuffer.append("\">\n");
        stringBuffer.append("</DS>");
        return stringBuffer.toString();
    }

    public void update(WSStatistic wSStatistic) {
        if (!this.validate(wSStatistic)) {
            return;
        }
        DoubleStatisticImpl doubleStatisticImpl = (DoubleStatisticImpl)wSStatistic;
        if (this.baseValue == null) {
            this.count = doubleStatisticImpl.getDouble();
            this.startTime = doubleStatisticImpl.getStartTime();
        } else {
            this.count = doubleStatisticImpl.count - this.baseValue.count;
            this.startTime = this.baseValue.lastSampleTime;
        }
        this.lastSampleTime = doubleStatisticImpl.lastSampleTime;
    }

    public WSStatistic delta(WSStatistic wSStatistic) {
        if (!this.validate(wSStatistic)) {
            return null;
        }
        DoubleStatisticImpl doubleStatisticImpl = (DoubleStatisticImpl)wSStatistic;
        DoubleStatisticImpl doubleStatisticImpl2 = new DoubleStatisticImpl(this.id);
        doubleStatisticImpl2.count = this.count - doubleStatisticImpl.getDouble();
        doubleStatisticImpl2.startTime = this.startTime;
        doubleStatisticImpl2.lastSampleTime = this.lastSampleTime;
        return doubleStatisticImpl2;
    }

    public WSStatistic rateOfChange(WSStatistic wSStatistic) {
        if (!this.validate(wSStatistic)) {
            return null;
        }
        DoubleStatisticImpl doubleStatisticImpl = (DoubleStatisticImpl)wSStatistic;
        DoubleStatisticImpl doubleStatisticImpl2 = new DoubleStatisticImpl(this.id);
        long l = (this.lastSampleTime - doubleStatisticImpl.lastSampleTime) / 1000L;
        if (l == 0L) {
            return null;
        }
        doubleStatisticImpl2.count = (this.count - doubleStatisticImpl.count) / (double)l;
        doubleStatisticImpl2.startTime = this.startTime;
        doubleStatisticImpl2.lastSampleTime = this.lastSampleTime;
        return doubleStatisticImpl2;
    }

    public void resetOnClient(WSStatistic wSStatistic) {
        if (wSStatistic == null) {
            if (this.baseValue == null) {
                this.baseValue = new DoubleStatisticImpl(this.id);
            }
            this.baseValue.set(this.count, this.startTime, this.lastSampleTime);
            this.update(this.baseValue);
        } else if (this.validate(wSStatistic)) {
            this.baseValue = (DoubleStatisticImpl)wSStatistic;
            this.update(this.baseValue);
        }
    }

    private boolean validate(WSStatistic wSStatistic) {
        if (wSStatistic == null) {
            return false;
        }
        if (!(wSStatistic instanceof DoubleStatisticImpl)) {
            return false;
        }
        return wSStatistic.getId() == this.id;
    }
}

