/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.stat;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.ws.pmi.stat.BoundedRangeStatisticImpl;
import com.ibm.ws.pmi.stat.CountStatisticImpl;
import com.ibm.ws.pmi.stat.DoubleStatisticImpl;
import com.ibm.ws.pmi.stat.StatisticImpl;
import com.ibm.ws.pmi.stat.TimeStatisticImpl;
import java.util.ArrayList;

public class StatisticAggregateImpl
extends StatisticImpl
implements PmiConstants {
    private static final long serialVersionUID = 8625154880422057621L;
    private ArrayList members = new ArrayList();
    private StatisticImpl aggregateValue = null;
    private int _type = -1;

    public StatisticAggregateImpl(PmiDataInfo pmiDataInfo) {
        super(pmiDataInfo.getId());
        this._type = pmiDataInfo.getType();
        switch (this._type) {
            case 2: {
                this.aggregateValue = new CountStatisticImpl(this.id);
                break;
            }
            case 3: {
                this.aggregateValue = new DoubleStatisticImpl(this.id);
                break;
            }
            case 4: {
                this.aggregateValue = new TimeStatisticImpl(this.id);
                break;
            }
            case 5: {
                this.aggregateValue = new BoundedRangeStatisticImpl(this.id);
                break;
            }
            default: {
                this._type = -1;
                System.err.println("[StatisticAggregateImpl] Invalid statistic type");
            }
        }
    }

    public WSStatistic copy() {
        return null;
    }

    public synchronized boolean add(StatisticImpl statisticImpl) {
        if (statisticImpl == null) {
            return false;
        }
        if (this.members.contains(statisticImpl)) {
            return false;
        }
        return this.members.add(statisticImpl);
    }

    public synchronized boolean remove(StatisticImpl statisticImpl) {
        if (statisticImpl == null) {
            return false;
        }
        return this.members.remove(statisticImpl);
    }

    public StatisticImpl getStatistic() {
        StatisticImpl statisticImpl = this._getAggregate();
        statisticImpl.setLastSampleTime(System.currentTimeMillis());
        return statisticImpl;
    }

    private StatisticImpl _getAggregate() {
        this.aggregateValue.reset(false);
        for (int i = 0; i < this.members.size(); ++i) {
            Object e2 = this.members.get(i);
            if (e2 == null) continue;
            if (e2 instanceof StatisticAggregateImpl) {
                this.aggregateValue.combine(((StatisticAggregateImpl)e2)._getAggregate());
                continue;
            }
            this.aggregateValue.combine((StatisticImpl)e2);
        }
        return this.aggregateValue;
    }

    public void update(WSStatistic wSStatistic) {
    }

    public WSStatistic delta(WSStatistic wSStatistic) {
        return null;
    }

    public WSStatistic rateOfChange(WSStatistic wSStatistic) {
        return null;
    }

    public void combine(WSStatistic wSStatistic) {
    }

    public void resetOnClient(WSStatistic wSStatistic) {
    }

    public void reset(boolean bl) {
    }

    public String toXML() {
        return null;
    }
}

