/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.wire;

import com.ibm.ws.pmi.wire.WpdData;
import com.ibm.ws.pmi.wire.WpdDataImpl;

public class WpdLoad
extends WpdDataImpl {
    private static final long serialVersionUID = -1608134391368458856L;
    private long createTime;
    private double currentLevel;
    private double integral;

    public WpdLoad(int n, long l, double d, double d2, long l2) {
        super(n, l);
        this.currentLevel = d;
        this.integral = d2;
        this.createTime = l2;
    }

    public double getLastValue() {
        return this.currentLevel;
    }

    public double getIntegral() {
        return this.integral;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public String toXML() {
        String string = "<PerfInt ID=\"" + this.id + "\" time=\"" + this.time + "\" lastValue=\"" + this.currentLevel + "\" integral=\"" + this.integral + "\" createTime=\"" + this.createTime + "\"/>\n";
        return string;
    }

    public String toString() {
        return "Data Id=" + this.id + " time=" + this.time + " currentLevel=" + this.currentLevel + " integral=" + this.integral + " createTime=" + this.createTime;
    }

    public void combine(WpdData wpdData) {
        if (wpdData == null) {
            return;
        }
        if (!(wpdData instanceof WpdLoad)) {
            System.err.println("WpdLoad.combine: wrong type. WpdLoad is needed!");
        } else {
            WpdLoad wpdLoad = (WpdLoad)wpdData;
            this.currentLevel += wpdLoad.getLastValue();
            double d = this.time - this.createTime;
            double d2 = wpdLoad.getTime() - wpdLoad.getCreateTime();
            this.integral = d2 <= d ? (this.integral += wpdLoad.getIntegral()) : (this.integral += wpdLoad.getIntegral() * (d / d2));
        }
    }
}

