/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.process;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.process.CreationParams;
import com.ibm.ws.process.LinuxProcessSpawnerThread;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.UnixProcessGlue;
import com.ibm.ws.process.UnixProcessImpl;
import com.ibm.ws.process.exception.CreateProcessTimeoutException;
import com.ibm.ws.process.exception.InvalidDirectoryException;
import com.ibm.ws.process.exception.InvalidExecutableException;
import com.ibm.ws.process.exception.InvalidFileException;
import com.ibm.ws.process.exception.InvalidGroupException;
import com.ibm.ws.process.exception.InvalidPriorityException;
import com.ibm.ws.process.exception.InvalidProcessGroupException;
import com.ibm.ws.process.exception.InvalidUsernameException;
import com.ibm.ws.process.exception.OutOfFileHandlesException;
import com.ibm.ws.process.exception.OutOfMemoryException;
import com.ibm.ws.process.exception.ProcessHasExitedException;
import com.ibm.ws.process.exception.ProcessOpException;
import com.ibm.ws.process.linuxutil.Mutex;
import com.ibm.ws.process.linuxutil.ThreadUtil;

public class LinuxProcessImpl
extends UnixProcessImpl {
    private static TraceComponent tc = Tr.register(LinuxProcessImpl.class);
    private LinuxProcessSpawnerThread pSpawner = null;
    private Mutex spawnerThreadMutex = new Mutex();

    public Process create(CreationParams creationParams) throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create() : Calling for a process create.");
        }
        if (creationParams == null) {
            throw new ProcessOpException("A 'null' value was passed in for creation parameters.  Cannot execute.");
        }
        if (creationParams.getExecutable() == null) {
            throw new InvalidExecutableException("A 'null' string was passed in as executable.  Cannot execute.");
        }
        LinuxProcessImpl linuxProcessImpl = new LinuxProcessImpl();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creation params are: " + creationParams.toString());
        }
        try {
            linuxProcessImpl.initializeProcess(new LinuxProcessSpawnerThread(creationParams));
        }
        catch (Exception exception) {
            ProcessOpException processOpException = new ProcessOpException(exception.toString());
            if (exception instanceof InvalidUsernameException) {
                String string = LinuxProcessImpl.getXFormattedString("PROC0001E", new Object[]{creationParams.getUserId()});
                processOpException = new InvalidUsernameException(string);
            } else if (exception instanceof InvalidGroupException) {
                String string = LinuxProcessImpl.getXFormattedString("PROC0002E", new Object[]{creationParams.getGroupId()});
                processOpException = new InvalidGroupException(string);
            } else if (exception instanceof InvalidDirectoryException) {
                String string = LinuxProcessImpl.getXFormattedString("PROC0003E", new Object[]{creationParams.getWorkingDirectory()});
                processOpException = new InvalidDirectoryException(string);
            } else if (exception instanceof InvalidExecutableException) {
                String string = LinuxProcessImpl.getXFormattedString("PROC0004E", new Object[]{creationParams.getExecutable()});
                processOpException = new InvalidExecutableException(string);
            } else if (exception instanceof InvalidPriorityException) {
                String string = LinuxProcessImpl.getXFormattedString("PROC0005E", new Object[]{new Integer(creationParams.getProcessPriority())});
                processOpException = new InvalidPriorityException(string);
            } else if (exception instanceof InvalidProcessGroupException) {
                String string = LinuxProcessImpl.getXFormattedString("PROC0006E", new Object[]{new Integer(creationParams.getProcessGroupId())});
                processOpException = new InvalidGroupException(string);
            } else if (exception instanceof InvalidFileException) {
                Object object;
                Object[] objectArray = new Object[5];
                objectArray[0] = creationParams.getUserId() != null && !creationParams.getUserId().trim().equals("") ? creationParams.getUserId().trim() : "";
                objectArray[1] = creationParams.getWorkingDirectory() != null && !creationParams.getWorkingDirectory().trim().equals("") ? creationParams.getWorkingDirectory().trim() : "";
                if (creationParams.getStdFileNames() != null) {
                    object = creationParams.getStdFileNames();
                    objectArray[2] = object[0] != null ? object[0] : "";
                    objectArray[3] = object[1] != null ? object[1] : "";
                    objectArray[4] = object[2] != null ? object[2] : "";
                } else {
                    objectArray[2] = "";
                    objectArray[3] = "";
                    objectArray[4] = "";
                }
                if (objectArray[0].equals("") && objectArray[1].equals("") && objectArray[2].equals("") && objectArray[3].equals("") && objectArray[4].equals("")) {
                    object = LinuxProcessImpl.getXString("PROC0007E");
                    processOpException = new InvalidFileException((String)object);
                } else if (creationParams.getUserId() != null) {
                    object = LinuxProcessImpl.getXFormattedString("PROC0015E", objectArray);
                    processOpException = new InvalidFileException((String)object);
                } else {
                    object = LinuxProcessImpl.getXFormattedString("PROC0016E", objectArray);
                    processOpException = new InvalidFileException((String)object);
                }
            } else if (exception instanceof OutOfFileHandlesException) {
                String string = LinuxProcessImpl.getXString("PROC0008E");
                processOpException = new OutOfFileHandlesException(string);
            } else if (exception instanceof OutOfMemoryException) {
                String string = LinuxProcessImpl.getXString("PROC0009E");
                processOpException = new OutOfMemoryException(string);
            } else if (exception instanceof CreateProcessTimeoutException) {
                String string = LinuxProcessImpl.getXFormattedString("PROC0031E", new Object[]{creationParams.getExecutable(), new Integer(creationParams.getProcessPriority())});
                processOpException = new CreateProcessTimeoutException(string);
            }
            throw processOpException;
        }
        if (creationParams.getDetachProcess()) {
            linuxProcessImpl.reclaimSpawnerThread();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create() : Process created.");
        }
        this.addToProcessTable(linuxProcessImpl);
        return linuxProcessImpl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Process bindTo(String string) throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindTo() : Rebinding to a running porcess.");
        }
        LinuxProcessImpl linuxProcessImpl = null;
        if (string == null) throw new ProcessOpException("A 'null' string was passed in as the identifier for the process to bind to.  Cannot bind.");
        if ((string = string.trim()).equals("")) throw new ProcessOpException("PID cannot be an empty string.  Cannot bind.");
        UnixProcessImpl unixProcessImpl = this.getProcessFromTable(string);
        if (unixProcessImpl != null) {
            linuxProcessImpl = (LinuxProcessImpl)unixProcessImpl;
        } else {
            linuxProcessImpl = new LinuxProcessImpl();
            try {
                linuxProcessImpl.nativeHandle = UnixProcessGlue.recreate(string);
            }
            catch (Exception exception) {
                ProcessOpException processOpException = new ProcessOpException(exception.toString());
                if (!(exception instanceof ProcessHasExitedException)) throw processOpException;
                String string2 = LinuxProcessImpl.getXFormattedString("PROC0010E", new Object[]{string});
                processOpException = new ProcessHasExitedException(string2);
                throw processOpException;
            }
            this.addToProcessTable(linuxProcessImpl);
        }
        if (!tc.isEntryEnabled()) return linuxProcessImpl;
        Tr.exit(tc, "bindTo() : Done with rebind.");
        return linuxProcessImpl;
    }

    public Process createSelf() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSelf() : Creating a process object to represent ourself.");
        }
        LinuxProcessImpl linuxProcessImpl = new LinuxProcessImpl();
        linuxProcessImpl.nativeHandle = UnixProcessGlue.createSelf();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSelf() : Done creating self-process object.");
        }
        return linuxProcessImpl;
    }

    public boolean isPOSIXThreading() {
        boolean bl = false;
        bl = ThreadUtil.isPOSIXThreading();
        return bl;
    }

    public void waitForTermination() throws ProcessOpException {
        ProcessOpException processOpException = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForTermination() : Requesting to wait for process termination");
        }
        if (!this.released) {
            this.checkNativeHandle();
            this.spawnerThreadMutex.lock();
            if (this.pSpawner != null && this.pSpawner.isAlive()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting PM thread operaton to WAIT_FOR_PROCESS");
                }
                this.pSpawner.setOperation(1, null);
                this.pSpawner.interrupt();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Halting this thread for results of PM thread operaton WAIT_FOR_PROCESS");
                }
                this.pSpawner.waitForCommandOutcome();
                processOpException = this.pSpawner.getException();
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Waiting for pSpawner thread to terminate.");
                    }
                    this.pSpawner.join();
                    this.pSpawner = null;
                    this.spawnerThreadMutex.unlock();
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.process.LinuxProcessImpl.waitForTermination", "135", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The wait was aborted due to some interruption, throwing exception.");
                    }
                    this.spawnerThreadMutex.unlock();
                    throw new ProcessOpException(interruptedException.toString());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking to see if an operation exception occured in the PM thread.");
                }
                if (processOpException != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Operation exception occured, propagating the exception.");
                    }
                    throw processOpException;
                }
            } else {
                this.spawnerThreadMutex.unlock();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Either the PM thread is locked, doesn't exist, or has already terminated.  Calling old monitor method.");
                }
                UnixProcessGlue.waitForTermination(this.nativeHandle);
            }
        } else {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.removeProcessFromTable(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForTermination() : Done with waiting for process termination");
        }
    }

    public void waitForTermination(int n) throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForTermination() : Requesting to wait for process termination over a set time.");
        }
        ProcessOpException processOpException = null;
        if (!this.released) {
            this.checkNativeHandle();
            int[] nArray = new int[]{n};
            boolean bl = this.spawnerThreadMutex.trylock();
            if (this.pSpawner != null && bl && this.pSpawner.isAlive()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting PM thread operaton to WAIT_FOR_PROCESS_WITH_TIMEOUT");
                }
                this.pSpawner.setOperation(2, nArray);
                this.pSpawner.interrupt();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Halting this thread for results of PM thread operaton WAIT_FOR_PROCESS_WITH_TIMEOUT");
                }
                this.pSpawner.waitForCommandOutcome();
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Waiting for pSpawner thread to terminate.");
                    }
                    processOpException = this.pSpawner.getException();
                    if (this.pSpawner != null && !this.pSpawner.isAlive()) {
                        this.pSpawner.join();
                        this.pSpawner = null;
                    }
                    this.spawnerThreadMutex.unlock();
                    bl = false;
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.process.LinuxProcessImpl.waitForTermination", "196", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The wait was aborted due to some interruption, throwing exception.");
                    }
                    this.spawnerThreadMutex.unlock();
                    bl = false;
                    ProcessOpException processOpException2 = processOpException != null ? new ProcessOpException(interruptedException.toString() + processOpException) : new ProcessOpException(interruptedException.toString());
                    throw processOpException2;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking to see if an operation exception occured in the PM thread.");
                }
                if (processOpException != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Operation exception occured, propagating the exception.");
                    }
                    throw processOpException;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Either the PM thread is locked, doesn't exist, or has already terminated.  Calling old monitor method.");
                }
                if (bl) {
                    this.spawnerThreadMutex.unlock();
                    bl = false;
                }
                UnixProcessGlue.waitForTerminationWithTimeout(this.nativeHandle, n);
            }
        } else {
            throw new ProcessOpException("Process Object already finalized.  No further calls allowed.");
        }
        this.removeProcessFromTable(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForTermination() : Done with waiting for process termination");
        }
    }

    private void initializeProcess(LinuxProcessSpawnerThread linuxProcessSpawnerThread) throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeProcess() : Initializing process object.");
        }
        this.pSpawner = linuxProcessSpawnerThread;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Checking to see if the process spawned correctly.");
        }
        if (this.pSpawner.getException() != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Process spawn failure, throwing exception.");
            }
            ProcessOpException processOpException = this.pSpawner.getException();
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Process spawn failure, cleaning up spawner thread.");
                }
                this.pSpawner.join();
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.process.LinuxProcessImpl.initializeProcess", "258", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Process spawn failure, couldn't clean up spawner thread.");
                }
                processOpException = new ProcessOpException(processOpException.toString() + interruptedException.toString());
            }
            throw processOpException;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Process spawn success, setting pointer to native process structure.");
        }
        this.nativeHandle = this.pSpawner.getNativeHandle();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeProcess() : Done initializing process object.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAlive() throws ProcessOpException {
        int n = 0;
        ProcessOpException processOpException = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ping() : Checking to see if a process exists.");
        }
        if (this.released) throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        this.checkNativeHandle();
        boolean bl = this.spawnerThreadMutex.trylock();
        if (this.pSpawner != null && bl && this.pSpawner.isAlive()) {
            this.pSpawner.setOperation(4, null);
            this.pSpawner.interrupt();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Pinging process through PM thread");
            }
            this.pSpawner.waitForCommandOutcome();
            processOpException = this.pSpawner.getException();
            if (this.pSpawner != null && !this.pSpawner.isAlive()) {
                try {
                    this.reclaimSpawnerThread();
                }
                catch (ProcessOpException processOpException2) {
                    this.spawnerThreadMutex.unlock();
                    throw processOpException2;
                }
            }
            this.spawnerThreadMutex.unlock();
            if (processOpException == null) {
                n = 1;
            } else {
                if (!(processOpException instanceof ProcessHasExitedException)) throw processOpException;
                n = 0;
                this.removeProcessFromTable(this);
            }
        } else {
            if (bl) {
                this.spawnerThreadMutex.unlock();
                bl = false;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Either the PM thread is locked, doesn't exist, or has already terminated.  Calling old monitor method.");
            }
            n = UnixProcessGlue.ping(this.nativeHandle);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ping() : Done with existance check");
        }
        if (n == 0) return false;
        return true;
    }

    public void stop() throws ProcessOpException {
        super.stop();
    }

    public int getExitCode() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExitCode() : Getting process exitCode (Return code)");
        }
        int n = 0;
        this.isAlive();
        n = super.getExitCode();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExitCode() : Got return code: " + n);
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void release() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "release() : Doing finalization on process object.");
        }
        if (!this.released) {
            if (this.pSpawner != null) {
                this.removeProcessFromTable(this);
                if (this.pSpawner.getOperation() != 0) throw new ProcessOpException("Process object is in use.  Cannot finalize.");
                this.checkNativeHandle();
                if (this.pSpawner.isAlive()) {
                    this.pSpawner.setOperation(3, null);
                    this.pSpawner.interrupt();
                    try {
                        this.pSpawner.join();
                        this.pSpawner = null;
                    }
                    catch (InterruptedException interruptedException) {
                        FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.process.LinuxProcessImpl.release", "320", this);
                        throw new ProcessOpException("Could not wait for spawner thread to join");
                    }
                }
                super.release();
            } else {
                super.release();
            }
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "release() : Done with finalization on process object.");
    }

    private void reclaimSpawnerThread() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reclaimSpawnerThread() : Join with the spawner thread.  Process spawned as 'detached'");
        }
        try {
            this.pSpawner.join();
            this.pSpawner = null;
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.process.LinuxProcessImpl.reclaimSpawnerThread", "371", this);
            throw new ProcessOpException("Could not wait for spawner thread to join");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reclaimSpawnerThread() : Joined with the spawner thread.");
        }
    }
}

