/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.process;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.process.CreationParams;
import com.ibm.ws.process.EnvUtilImpl;
import com.ibm.ws.process.UnixProcessGlue;
import com.ibm.ws.process.exception.ProcessHasExitedException;
import com.ibm.ws.process.exception.ProcessOpException;

class LinuxProcessSpawnerThread
extends Thread {
    private static TraceComponent tc = Tr.register(LinuxProcessSpawnerThread.class);
    private Integer operation = null;
    private int[] params = null;
    private long nativeHandle;
    private CreationParams pParams = null;
    private ProcessOpException failedException = null;
    private Integer wait = new Integer(0);
    boolean initialized = false;
    boolean startDetached = false;
    boolean exiting = false;

    LinuxProcessSpawnerThread(CreationParams creationParams) throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "LinuxProcessSpawnerThread() : Constructing PM thread");
        }
        this.pParams = creationParams;
        this.operation = new Integer(0);
        this.setDaemon(true);
        this.start();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "LinuxProcessSpawnerThread() : Done constructing PM thread");
        }
    }

    private void createProcess() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createProcess() : Spawning process...");
        }
        this.nativeHandle = UnixProcessGlue.create(this.pParams.getExecutable(), this.pParams.getCommandLineArgs(), EnvUtilImpl.static_expandEnvironment(this.pParams.getEnvironment()), this.pParams.getWorkingDirectory(), this.pParams.getProcessPriority(), this.pParams.getStdFileNames(), this.pParams.getUmask(), this.pParams.getGroupId(), this.pParams.getUserId(), this.pParams.getProcessGroupId(), this.pParams.getProcessName(), this.pParams.getInheritParentStreams(), this.pParams.getDetachProcess());
        this.initialized = true;
        if (this.pParams.getDetachProcess()) {
            this.startDetached = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createProcess() : Done spawning process...");
        }
    }

    private void waitForProcess() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForProcess() : Waiting for process to exit.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Calling nativeCode to wait.");
        }
        UnixProcessGlue.waitForTermination(this.nativeHandle);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForProcess() : Done waiting for process to exit.");
        }
    }

    private void stopProcess() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopProcess() : Stopping process");
        }
        UnixProcessGlue.stop(this.nativeHandle);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopProcess() : Done stopping process.");
        }
    }

    public void run() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "run() : Starting up PM thread...");
        }
        try {
            this.createProcess();
            if (!this.startDetached) {
                this.commandPoll();
            }
        }
        catch (ProcessOpException processOpException) {
            FFDCFilter.processException((Throwable)processOpException, "com.ibm.ws.process.LinuxProcessSpawnerThread.run", "143", this);
            this.failedException = processOpException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "run() : PM Thread exited.");
        }
    }

    private synchronized void waitForOperation() throws InterruptedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForOperation() : PM Thread Waiting for operation to perform.");
        }
        if (this.getOperation() == 0) {
            this.wait();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "waitForOperation() : PM Thread interrupted, operation to perform.");
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "waitForOperation() : PM Thread OP isn't currently SLEEP.  Therefore, operation came in before wait.");
            }
            throw new InterruptedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void commandPoll() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commandPoll() : PM Thread command poll started.");
        }
        boolean bl = true;
        while (bl) {
            try {
                this.waitForOperation();
            }
            catch (InterruptedException interruptedException) {
                Integer n = this.wait;
                synchronized (n) {
                    switch (this.getOperation()) {
                        case 0: {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "PM Thread requested to sleep.");
                            }
                            bl = true;
                            break;
                        }
                        case 1: {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "PM Thread requested to wait for process to terminate.");
                            }
                            try {
                                this.waitForProcess();
                            }
                            catch (ProcessOpException processOpException) {
                                this.failedException = processOpException;
                            }
                            this.exiting = true;
                            bl = false;
                            this.operation = new Integer(0);
                            break;
                        }
                        case 2: {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "PM Thread requested to wait for process (with a timeout).");
                            }
                            if (this.params == null) {
                                throw new ProcessOpException();
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Calling native to wait with a timeout.");
                            }
                            try {
                                this.failedException = null;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Calling native to wait with a timeout.");
                                }
                                UnixProcessGlue.waitForTerminationWithTimeout(this.nativeHandle, this.params[0]);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Exited the waitForTerm call.");
                                }
                            }
                            catch (Exception exception) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Exited the waitForTerm call with an exception.");
                                }
                                this.failedException = (ProcessOpException)exception;
                            }
                            int n2 = 0;
                            try {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Pinging the process to make sure it's there.");
                                }
                                n2 = UnixProcessGlue.ping(this.nativeHandle);
                            }
                            catch (Exception exception) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Some problem, process gone.");
                                }
                                n2 = 0;
                                this.failedException = (ProcessOpException)exception;
                            }
                            if (n2 == 1) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Continuing loop.");
                                }
                                bl = true;
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Exiting loop");
                                }
                                this.exiting = true;
                                bl = false;
                            }
                            this.operation = new Integer(0);
                            break;
                        }
                        case 3: {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "requested to kill off the spawner thread.");
                            }
                            this.exiting = true;
                            bl = false;
                            this.operation = new Integer(0);
                            break;
                        }
                        case 4: {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "requested to check process existance.");
                            }
                            int n3 = 0;
                            try {
                                n3 = UnixProcessGlue.ping(this.nativeHandle);
                                if (n3 == 0) {
                                    this.failedException = new ProcessHasExitedException();
                                    this.exiting = true;
                                    bl = false;
                                } else {
                                    this.failedException = null;
                                }
                            }
                            catch (Exception exception) {
                                this.failedException = (ProcessOpException)exception;
                                this.exiting = true;
                                bl = false;
                            }
                            this.operation = new Integer(0);
                            break;
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commandPoll() : PM Thread command poll complete.  Exiting Poll..");
        }
    }

    public long getNativeHandle() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNativeHandle() : Obtaining native handle (pointer) to native process object..");
        }
        while (this.nativeHandle == 0L && this.failedException == null) {
            try {
                LinuxProcessSpawnerThread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNativeHandle() : Obtained native handle (pointer) to native process object.");
        }
        return this.nativeHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setOperation(int n, int[] nArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setOperation() : Setting operation to perform.");
        }
        if (!this.exiting) {
            Integer n2 = this.wait;
            synchronized (n2) {
                this.operation = new Integer(n);
                this.params = nArray;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setOperation() : Set operation to perform.");
        }
    }

    public ProcessOpException getException() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getException() : Getting exception object");
        }
        while (!this.initialized && this.failedException == null) {
            try {
                LinuxProcessSpawnerThread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getException() : Got exception object");
        }
        return this.failedException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getOperation() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOperation() : Getting operation to perform.");
        }
        Integer n = this.operation;
        synchronized (n) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getOperation() : Got operation to perform.");
            }
            return this.operation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCommandOutcome() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForCommandOutcome() : Halting caller to wait for operation to complete.");
        }
        while (this.getOperation() != 0) {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "waitForCommandOutcome() : Operation currently is: " + this.getOperation());
            }
            try {
                LinuxProcessSpawnerThread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Integer n = this.wait;
            synchronized (n) {
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForCommandOutcome() : Operation completed.");
        }
    }
}

