/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.process;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.process.CreationParams;
import com.ibm.ws.process.EnvUtilImpl;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.process.ProcessObjectFactory;
import com.ibm.ws.process.StopParams;
import com.ibm.ws.process.UnixProcessGlue;
import com.ibm.ws.process.exception.AccessDeniedException;
import com.ibm.ws.process.exception.CreateProcessTimeoutException;
import com.ibm.ws.process.exception.InvalidDirectoryException;
import com.ibm.ws.process.exception.InvalidExecutableException;
import com.ibm.ws.process.exception.InvalidFileException;
import com.ibm.ws.process.exception.InvalidGroupException;
import com.ibm.ws.process.exception.InvalidPriorityException;
import com.ibm.ws.process.exception.InvalidProcessGroupException;
import com.ibm.ws.process.exception.InvalidUsernameException;
import com.ibm.ws.process.exception.OutOfFileHandlesException;
import com.ibm.ws.process.exception.OutOfMemoryException;
import com.ibm.ws.process.exception.ProcessHasExitedException;
import com.ibm.ws.process.exception.ProcessOpException;
import com.ibm.ws.process.exception.ProcessStillActiveException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class UnixProcessImpl
implements Process,
ProcessObjectFactory {
    private static TraceComponent tc = Tr.register(UnixProcessImpl.class);
    protected long nativeHandle = 0L;
    private static String osName = System.getProperty("os.name");
    protected boolean released = false;
    private static final String resourceBundlePackage = "com.ibm.ws.process.processmessages";
    private static ResourceBundle resourceBundle = null;
    protected static Hashtable procTable = null;
    protected boolean inTable = false;

    public UnixProcessImpl() {
        if (procTable == null) {
            procTable = new Hashtable();
        }
    }

    public Process create(CreationParams creationParams) throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create() : Calling for a process create.");
        }
        if (creationParams == null) {
            throw new ProcessOpException("A 'null' value was passed in for creation parameters.  Cannot execute.");
        }
        if (creationParams.getExecutable() == null) {
            throw new InvalidExecutableException("A 'null' string was passed in as executable.  Cannot execute.");
        }
        UnixProcessImpl unixProcessImpl = new UnixProcessImpl();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creation params are: " + creationParams.toString());
        }
        try {
            unixProcessImpl.nativeHandle = UnixProcessGlue.create(creationParams.getExecutable(), creationParams.getCommandLineArgs(), EnvUtilImpl.static_expandEnvironment(creationParams.getEnvironment()), creationParams.getWorkingDirectory(), creationParams.getProcessPriority(), creationParams.getStdFileNames(), creationParams.getUmask(), creationParams.getGroupId(), creationParams.getUserId(), creationParams.getProcessGroupId(), creationParams.getProcessName(), creationParams.getInheritParentStreams(), creationParams.getDetachProcess());
        }
        catch (Exception exception) {
            ProcessOpException processOpException = new ProcessOpException(exception.toString());
            if (exception instanceof InvalidUsernameException) {
                String string = UnixProcessImpl.getXFormattedString("PROC0001E", new Object[]{creationParams.getUserId()});
                processOpException = new InvalidUsernameException(string);
            } else if (exception instanceof InvalidGroupException) {
                String string = UnixProcessImpl.getXFormattedString("PROC0002E", new Object[]{creationParams.getGroupId()});
                processOpException = new InvalidGroupException(string);
            } else if (exception instanceof InvalidDirectoryException) {
                String string = UnixProcessImpl.getXFormattedString("PROC0003E", new Object[]{creationParams.getWorkingDirectory()});
                processOpException = new InvalidDirectoryException(string);
            } else if (exception instanceof InvalidExecutableException) {
                String string = UnixProcessImpl.getXFormattedString("PROC0004E", new Object[]{creationParams.getExecutable()});
                processOpException = new InvalidExecutableException(string);
            } else if (exception instanceof InvalidPriorityException) {
                String string = UnixProcessImpl.getXFormattedString("PROC0005E", new Object[]{new Integer(creationParams.getProcessPriority())});
                processOpException = new InvalidPriorityException(string);
            } else if (exception instanceof InvalidProcessGroupException) {
                String string = UnixProcessImpl.getXFormattedString("PROC0006E", new Object[]{new Integer(creationParams.getProcessGroupId())});
                processOpException = new InvalidGroupException(string);
            } else if (exception instanceof InvalidFileException) {
                Object object;
                Object[] objectArray = new Object[5];
                objectArray[0] = creationParams.getUserId() != null && !creationParams.getUserId().trim().equals("") ? creationParams.getUserId().trim() : "";
                objectArray[1] = creationParams.getWorkingDirectory() != null && !creationParams.getWorkingDirectory().trim().equals("") ? creationParams.getWorkingDirectory().trim() : "";
                if (creationParams.getStdFileNames() != null) {
                    object = creationParams.getStdFileNames();
                    objectArray[2] = object[0] != null ? object[0] : "";
                    objectArray[3] = object[1] != null ? object[1] : "";
                    objectArray[4] = object[2] != null ? object[2] : "";
                } else {
                    objectArray[2] = "";
                    objectArray[3] = "";
                    objectArray[4] = "";
                }
                if (objectArray[0].equals("") && objectArray[1].equals("") && objectArray[2].equals("") && objectArray[3].equals("") && objectArray[4].equals("")) {
                    object = UnixProcessImpl.getXString("PROC0007E");
                    processOpException = new InvalidFileException((String)object);
                } else if (creationParams.getUserId() != null) {
                    object = UnixProcessImpl.getXFormattedString("PROC0015E", objectArray);
                    processOpException = new InvalidFileException((String)object);
                } else {
                    object = UnixProcessImpl.getXFormattedString("PROC0016E", objectArray);
                    processOpException = new InvalidFileException((String)object);
                }
            } else if (exception instanceof OutOfFileHandlesException) {
                String string = UnixProcessImpl.getXString("PROC0008E");
                processOpException = new OutOfFileHandlesException(string);
            } else if (exception instanceof OutOfMemoryException) {
                String string = UnixProcessImpl.getXString("PROC0009E");
                processOpException = new OutOfMemoryException(string);
            } else if (exception instanceof CreateProcessTimeoutException) {
                String string = UnixProcessImpl.getXFormattedString("PROC0031E", new Object[]{creationParams.getExecutable(), new Integer(creationParams.getProcessPriority())});
                processOpException = new CreateProcessTimeoutException(string);
            }
            throw processOpException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create() : Process created.");
        }
        this.addToProcessTable(unixProcessImpl);
        return unixProcessImpl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Process bindTo(String string) throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recreate() : Rebinding to a running process.");
        }
        UnixProcessImpl unixProcessImpl = null;
        if (string == null) throw new ProcessOpException("A 'null' string was passed in as the identifier for the process to bind to.  Cannot bind.");
        if ((string = string.trim()).equals("")) throw new ProcessOpException("PID cannot be an empty string.  Cannot bind.");
        UnixProcessImpl unixProcessImpl2 = this.getProcessFromTable(string);
        if (unixProcessImpl2 != null) {
            unixProcessImpl = unixProcessImpl2;
        } else {
            unixProcessImpl = new UnixProcessImpl();
            try {
                unixProcessImpl.nativeHandle = UnixProcessGlue.recreate(string);
            }
            catch (Exception exception) {
                ProcessOpException processOpException = new ProcessOpException(exception.toString());
                if (!(exception instanceof ProcessHasExitedException)) throw processOpException;
                String string2 = UnixProcessImpl.getXFormattedString("PROC0010E", new Object[]{string});
                processOpException = new ProcessHasExitedException(string2);
                throw processOpException;
            }
            this.addToProcessTable(unixProcessImpl);
        }
        if (!tc.isEntryEnabled()) return unixProcessImpl;
        Tr.exit(tc, "recreate() : Done with rebind.");
        return unixProcessImpl;
    }

    public Process createSelf() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSelf() : Creating a process object to represent ourself.");
        }
        UnixProcessImpl unixProcessImpl = new UnixProcessImpl();
        unixProcessImpl.nativeHandle = UnixProcessGlue.createSelf();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSelf() : Done creating self-process object.");
        }
        return unixProcessImpl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void terminate(StopParams stopParams) throws ProcessOpException {
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "terminate() : Calling for a process termination.");
            }
            if (stopParams != null && stopParams.getProcessID() != null) {
                try {
                    UnixProcessImpl unixProcessImpl = (UnixProcessImpl)ProcessFactory.bindTo(stopParams.getProcessID());
                    if (stopParams.getStopMode() == 0) {
                        unixProcessImpl.stop();
                    } else {
                        UnixProcessGlue.kill(unixProcessImpl.nativeHandle);
                    }
                    try {
                        unixProcessImpl.waitForTermination(20);
                        break block12;
                    }
                    catch (ProcessOpException processOpException) {
                        if (processOpException instanceof ProcessStillActiveException) {
                            String string = UnixProcessImpl.getXFormattedString("PROC0014E", new Object[]{stopParams.getProcessID()});
                            throw new ProcessStillActiveException(string);
                        }
                        break block12;
                    }
                }
                catch (Exception exception) {
                    if (exception instanceof ProcessHasExitedException) {
                        String string = UnixProcessImpl.getXFormattedString("PROC0010E", new Object[]{stopParams.getProcessID()});
                        throw new ProcessHasExitedException(string);
                    }
                    if (exception instanceof AccessDeniedException) {
                        String string = UnixProcessImpl.getXFormattedString("PROC0011E", new Object[]{stopParams.getProcessID()});
                        throw new AccessDeniedException(string);
                    }
                    String string = UnixProcessImpl.getXFormattedString("PROC0013E", new Object[]{exception.toString()});
                    throw new ProcessOpException(string);
                }
            }
            String string = UnixProcessImpl.getXString("PROC0012E");
            throw new ProcessOpException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Terminate()");
        }
    }

    public boolean isPOSIXThreading() {
        return true;
    }

    static byte[][] strArray2ByteArrArray(String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "strArray2ByteArrArray() : Converting a string array to a byte array.");
        }
        if (stringArray != null) {
            byte[][] byArrayArray = new byte[stringArray.length][];
            for (int i = 0; i < stringArray.length; ++i) {
                byArrayArray[i] = stringArray[i].getBytes();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "strArray2ByteArrArray() : Done with converting a string array to a byte array.");
            }
            return byArrayArray;
        }
        byte[][] byArrayArray = new byte[1][];
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "strArray2ByteArrArray() : Done with converting a string array to a byte array.");
        }
        return byArrayArray;
    }

    public String id() throws ProcessOpException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "id() : Obtaining process ID.");
        }
        if (!this.released) {
            try {
                this.checkNativeHandle();
                string = UnixProcessGlue.id(this.nativeHandle);
            }
            catch (ProcessOpException processOpException) {
                FFDCFilter.processException((Throwable)processOpException, "com.ibm.ws.process.UnixProcessImpl.id", "186", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Bad nativeHandle, returning PID: 0:");
                }
                return "0";
            }
        } else {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "id() : Obtained process ID: " + string);
        }
        return string;
    }

    public void waitForTermination() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForTermination() : Requesting to wait for process termination");
        }
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        UnixProcessGlue.waitForTermination(this.nativeHandle);
        this.removeProcessFromTable(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForTermination() : Done with waiting for process termination");
        }
    }

    public void waitForTermination(int n) throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForTermination() : Requesting to wait for process termination over a set time.");
        }
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        UnixProcessGlue.waitForTerminationWithTimeout(this.nativeHandle, n);
        this.removeProcessFromTable(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForTermination() : Done with waiting for process termination");
        }
    }

    public int getExitCode() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExitCode() : Getting process exitCode (Return code)");
        }
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        int n = UnixProcessGlue.getExitCode(this.nativeHandle);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExitCode() : Got return code: " + n);
        }
        return n;
    }

    public boolean ping() throws ProcessOpException {
        return this.isAlive();
    }

    public boolean isAlive() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ping() : Checking to see if a process exists.");
        }
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        int n = UnixProcessGlue.ping(this.nativeHandle);
        if (n == 0) {
            this.removeProcessFromTable(this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ping() : Done with existance check");
        }
        return n != 0;
    }

    public void stop() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop() : Requesting to kill a running process.");
        }
        if (!this.released) {
            this.checkNativeHandle();
            try {
                UnixProcessGlue.stop(this.nativeHandle);
            }
            catch (Exception exception) {
                if (exception instanceof ProcessHasExitedException) {
                    String string = UnixProcessImpl.getXFormattedString("PROC0010E", new Object[]{this.id()});
                    throw new ProcessHasExitedException(string);
                }
                if (exception instanceof AccessDeniedException) {
                    String string = UnixProcessImpl.getXFormattedString("PROC0011E", new Object[]{this.id()});
                    throw new AccessDeniedException(string);
                }
                if (exception instanceof ProcessOpException) {
                    throw (ProcessOpException)exception;
                }
                String string = UnixProcessImpl.getXFormattedString("PROC0013E", new Object[]{exception.toString()});
                throw new ProcessOpException(string);
            }
        } else {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop() : Done STOP_PROCESS operation.");
        }
    }

    public void release() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "release() : Doing finalization on process object.");
        }
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        this.removeProcessFromTable(this);
        this.released = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "release() : Done with finalization on process object.");
        }
    }

    protected void checkNativeHandle() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkNativeHandle() : Checking validity of nativeHandle.");
        }
        if (this.nativeHandle == 0L) {
            throw new ProcessOpException("Invalid process object.  nativeHandle (pointer) is 'null'");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkNativeHandle() : Done checking validity of nativeHandle.  Appears valid.");
        }
    }

    public void generateJVMDump() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateJVMDump() : Attempting to cause JVM Thread Dump.");
        }
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        UnixProcessGlue.pokeVMThreadDump(this.nativeHandle);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateJVMDump() : Done attempting to cause JVM Thread Dump.");
        }
    }

    protected void finalize() throws Throwable {
        if (!this.released && this.nativeHandle != 0L) {
            this.release();
        }
        if (this.nativeHandle != 0L) {
            UnixProcessGlue.done(this.nativeHandle);
            this.nativeHandle = 0L;
        }
        super.finalize();
    }

    protected static String getXString(String string) {
        String string2;
        try {
            if (resourceBundle == null) {
                resourceBundle = ResourceBundle.getBundle(resourceBundlePackage);
            }
            string2 = resourceBundle != null ? resourceBundle.getString(string) : string;
        }
        catch (MissingResourceException missingResourceException) {
            string2 = string;
        }
        return string2;
    }

    protected static String getXFormattedString(String string, Object[] objectArray) {
        String string2;
        try {
            if (resourceBundle == null) {
                resourceBundle = ResourceBundle.getBundle(resourceBundlePackage);
            }
            if (resourceBundle != null) {
                string2 = resourceBundle.getString(string);
                string2 = MessageFormat.format(string2, objectArray);
            } else {
                string2 = string;
            }
        }
        catch (MissingResourceException missingResourceException) {
            string2 = string;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToProcessTable(UnixProcessImpl unixProcessImpl) throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToProcessTable() : Adding processto tracking table.");
        }
        if (unixProcessImpl != null) {
            Hashtable hashtable = procTable;
            synchronized (hashtable) {
                if (!procTable.containsKey(unixProcessImpl.id())) {
                    procTable.put(unixProcessImpl.id(), unixProcessImpl);
                    unixProcessImpl.inTable = true;
                } else {
                    UnixProcessImpl unixProcessImpl2 = (UnixProcessImpl)procTable.remove(unixProcessImpl.id());
                    if (unixProcessImpl2 != null) {
                        unixProcessImpl2.inTable = false;
                    }
                    procTable.put(unixProcessImpl.id(), unixProcessImpl);
                    unixProcessImpl.inTable = true;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToProcessTable() : Done adding process to tracking table.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UnixProcessImpl getProcessFromTable(String string) throws ProcessOpException {
        UnixProcessImpl unixProcessImpl = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProcessFromTable() : Retrieving process object for pid: " + string);
        }
        Hashtable hashtable = procTable;
        synchronized (hashtable) {
            if (string != null) {
                unixProcessImpl = (UnixProcessImpl)procTable.get(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProcessFromTable() : Retrieved process for pid: " + string);
        }
        return unixProcessImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UnixProcessImpl removeProcessFromTable(UnixProcessImpl unixProcessImpl) throws ProcessOpException {
        UnixProcessImpl unixProcessImpl2 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeProcessFromTable() : Removing process object from table");
        }
        Hashtable hashtable = procTable;
        synchronized (hashtable) {
            String string = null;
            if (unixProcessImpl != null && !unixProcessImpl.released && unixProcessImpl.inTable) {
                string = unixProcessImpl.id();
                if (procTable.containsKey(string)) {
                    unixProcessImpl2 = (UnixProcessImpl)procTable.remove(string);
                    if (unixProcessImpl2 != null) {
                        unixProcessImpl2.inTable = false;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "removeProcessFromTable() : Removed process object for pid: [" + string + "]");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removeProcessFromTable() : Not removing process object for pid: [" + string + "].  No such object mapping");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeProcessFromTable()");
        }
        return unixProcessImpl2;
    }
}

