/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.process;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.process.CreationParams;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessObjectFactory;
import com.ibm.ws.process.StopParams;
import com.ibm.ws.process.WS390ProcessGlue;
import com.ibm.ws.process.exception.ProcessHasExitedException;
import com.ibm.ws.process.exception.ProcessOpException;
import com.ibm.ws.process.exception.ProcessStillActiveException;
import com.ibm.ws.util.PlatformHelper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class WS390ProcessImpl
implements Process,
ProcessObjectFactory {
    private static TraceComponent tc = Tr.register(WS390ProcessImpl.class);
    private byte[] mvsIdentifier = null;
    private boolean released = false;
    private static String stopCmd = "STOP";
    private static String forceCmd = "FORCE";
    private static String cancelCmd = "CANCEL";
    private static String EBCDIC_CP = "cp1047";
    private static String ASCII_CP = "US-ASCII";
    private static final String resourceBundlePackage = "com.ibm.ws.process.processmessages";
    private static ResourceBundle resourceBundle = null;
    private static final String BBO3CSL_RETURN_STOKEN_START = "bbo3cslStokenStart(";
    private static final String BBO3CSL_RETURN_STOKEN_END = ")bbo3cslStokenEnd";

    public Process create(CreationParams creationParams) throws ProcessOpException {
        PlatformHelper platformHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create() : Calling for a process create.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creation params are: " + creationParams.toString());
        }
        WS390ProcessImpl wS390ProcessImpl = new WS390ProcessImpl();
        byte[] byArray = new byte[16];
        int n = 0;
        if (creationParams.getExecutable().equalsIgnoreCase("java")) {
            throw new ProcessOpException("WS390ProcessImpl Object does not support creation of generic java processes.");
        }
        if (creationParams.getCommandLineArgs() == null) {
            creationParams.setCommandLineArgs(new String[]{""});
        }
        if ((platformHelper = AdminHelper.getPlatformHelper()).isZOS() && !platformHelper.isControlJvm() && !platformHelper.isServantJvm()) {
            wS390ProcessImpl = this.scriptLaunch(creationParams);
        } else {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "create() : Calling for a process create.");
            }
            try {
                String string = WS390ProcessImpl.generateCommaCommandLine(creationParams.getCommandLineArgs());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "create() : Executing command: [" + creationParams.getExecutable() + "] with args [" + string + "].");
                }
                n = WS390ProcessGlue.create(creationParams.getExecutable(), string, byArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new ProcessOpException("WS390ProcessImpl create failed with exception: " + exception);
            }
            if (n != 0) {
                if (n == 1) {
                    throw new ProcessOpException("WS390ProcessImpl create failed.  It could be any of many problems, OPT is too long, MGCRE failures, or even config problems.  Return code was: [" + n + "]");
                }
                if (n == 8) {
                    throw new ProcessOpException("WS390ProcessImpl create failed.  The returned unique process identifier was not the proper length.  Return code was: [" + n + "]");
                }
                if (n == 12) {
                    throw new ProcessOpException("WS390ProcessImpl create failed.  The creation call occurred outside the controller region.  This is not allowed.  Return code was: [" + n + "]");
                }
                if (n == 16) {
                    throw new ProcessOpException("WS390ProcessImpl create failed.  A system exception was caught.  A message was logged.  Return code: [" + n + "]");
                }
                if (n == 20) {
                    throw new ProcessOpException("WS390ProcessImpl create failed.  An user exception was caught.  A message was logged.  Return code was: [" + n + "]");
                }
                if (n == 24) {
                    throw new ProcessOpException("WS390ProcessImpl create failed.  An unknown exception was caught.  A message was logged.  Return code was: [" + n + "]");
                }
                throw new ProcessOpException("WS390ProcessImpl create failed.  Unknown error.  Return code was: [" + n + "]");
            }
            wS390ProcessImpl.mvsIdentifier = byArray;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "create(): process id: " + wS390ProcessImpl.id());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create() : Return Code " + n);
        }
        return wS390ProcessImpl;
    }

    public void terminate(StopParams stopParams) throws ProcessOpException {
        int n = 0;
        if (stopParams != null) {
            String string = stopParams.getProcessID();
            String string2 = stopParams.getZOSCommand();
            int n2 = stopParams.getStopMode();
            StringBuffer stringBuffer = new StringBuffer("");
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "terminate() : Calling for a process termination.");
            }
            if (string2 == null) {
                switch (n2) {
                    case 2: {
                        stringBuffer.append(cancelCmd);
                        stringBuffer.append(" ");
                        stringBuffer.append(string);
                        break;
                    }
                    case 1: {
                        stringBuffer.append(forceCmd);
                        stringBuffer.append(" ");
                        stringBuffer.append(string);
                        break;
                    }
                    case 0: {
                        stringBuffer.append(stopCmd);
                        stringBuffer.append(" ");
                        stringBuffer.append(string);
                    }
                }
            } else {
                stringBuffer.append(string2);
                stringBuffer.append(" ");
                stringBuffer.append(string);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Terminate params are: " + stopParams.toString());
            }
            try {
                n = WS390ProcessGlue.terminate(stringBuffer.toString(), "");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new ProcessOpException("WS390ProcessImpl terminate failed with exception: " + exception);
            }
            if (n != 0) {
                if (n == 1) {
                    throw new ProcessOpException("A failure occurred issuing the command (MVS MCGRE service return was non-zero).");
                }
                if (n == 12) {
                    throw new ProcessOpException("Stop call was done outside the controller region.  Not allowed.");
                }
                if (n == 16) {
                    throw new ProcessOpException("A system exception was caught.  A message with the exception was logged.");
                }
                if (n == 20) {
                    throw new ProcessOpException("A user exception was caught.  A message with the exception was logged.");
                }
                if (n == 24) {
                    throw new ProcessOpException("An unknown exception was caught.  A message with the exception was logged.");
                }
                throw new ProcessOpException("WS390ProcessImpl terminate failed: " + n);
            }
        } else {
            throw new ProcessOpException("StopParams for process termination cannot be null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "terminate() : Return Code: " + n);
        }
    }

    public Process bindTo(String string) throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindTo() : Rebinding to a running process.");
        }
        int n = 0;
        WS390ProcessImpl wS390ProcessImpl = new WS390ProcessImpl();
        if (string != null) {
            if (string.length() != 16) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "bindTo() : Malformed PID.  Not 16 characters.");
                }
                throw new ProcessOpException("WS390ProcessImpl bindTo/recreate; input incorrect length");
            }
            try {
                n = WS390ProcessGlue.recreate(string.getBytes(ASCII_CP));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new ProcessOpException("WS390ProcessImpl bindTo/recreate failed: " + exception);
            }
            if (n == 0) {
                try {
                    wS390ProcessImpl.mvsIdentifier = string.getBytes(ASCII_CP);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    wS390ProcessImpl.mvsIdentifier = string.getBytes();
                }
            } else {
                if (n == 8) {
                    String string2 = "Failure on lookup of job with PID: [{0}].  The native error code was: [{1}].  The process requested is not active.";
                    string2 = MessageFormat.format(string2, string, new Integer(n));
                    throw new ProcessHasExitedException(string2);
                }
                String string3 = "Failure on lookup of job with PID: [{0}].  The native error code was: [{1}]";
                string3 = MessageFormat.format(string3, string, new Integer(n));
                throw new ProcessOpException(string3);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "bindTo() : Done with rebind.");
            }
        } else {
            throw new ProcessOpException("WS390ProcessImpl bindTo/recreate failed.  'null' passed in for 'pid'");
        }
        return wS390ProcessImpl;
    }

    public Process createSelf() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSelf() : Creating a process object to represent ourself.");
        }
        int n = 0;
        WS390ProcessImpl wS390ProcessImpl = new WS390ProcessImpl();
        byte[] byArray = new byte[16];
        try {
            n = WS390ProcessGlue.createSelf(byArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createSelf(), rc =" + n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ProcessOpException("WS390ProcessImpl createSelf failed with exception class: [" + exception.getClass().getName() + "] value: [" + this.toString() + "]");
        }
        if (n != 0) {
            if (n == 8) {
                String string = "Internal error.  The Process ID array was too small to contain the 16 byte PID.";
                throw new ProcessOpException(string);
            }
            throw new ProcessOpException("WS390ProcessImpl createSelf failed.  Native error code was: [" + n + "]");
        }
        wS390ProcessImpl.mvsIdentifier = new byte[16];
        System.arraycopy(byArray, 0, wS390ProcessImpl.mvsIdentifier, 0, wS390ProcessImpl.mvsIdentifier.length);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSelf()");
        }
        return wS390ProcessImpl;
    }

    public String id() throws ProcessOpException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "id() : Obtaining process ID.");
        }
        if (!this.released) {
            try {
                this.checkNativeHandle();
                try {
                    string = new String(this.mvsIdentifier, ASCII_CP);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    string = new String(this.mvsIdentifier);
                }
            }
            catch (ProcessOpException processOpException) {
                FFDCFilter.processException((Throwable)processOpException, "com.ibm.ws.process.WS390ProcessImpl.id", "186", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Bad nativeHandle, returning PID: 0:");
                }
                string = "0";
            }
        } else {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "id() : Obtained process ID: " + string);
        }
        return string;
    }

    public void waitForTermination() throws ProcessOpException {
        int n = 0;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForTermination() : Requesting to wait for process termination");
        }
        if (!this.released) {
            this.checkNativeHandle();
            n = WS390ProcessGlue.waitForTerminationWithTimeout(this.mvsIdentifier, 0);
            if (n != 0) {
                throw new ProcessStillActiveException("waitForTermination(): Process still active.");
            }
        } else {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForTermination() : Done with waiting for process termination");
        }
    }

    public void waitForTermination(int n) throws ProcessOpException {
        int n2 = 0;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForTermination(" + n + ") : Requesting to wait for process termination over a set time.");
        }
        if (!this.released) {
            this.checkNativeHandle();
            n2 = WS390ProcessGlue.waitForTerminationWithTimeout(this.mvsIdentifier, n);
            if (n2 != 0) {
                String string = "waitForTermination(int): Process represented by PID: [{0}] still active.";
                MessageFormat.format(string, new String(this.mvsIdentifier));
                throw new ProcessStillActiveException(string);
            }
        } else {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForTermination() : Done with waiting for process termination");
        }
    }

    public int getExitCode() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExitCode() : Getting process exitCode (Return code)");
        }
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        int n = WS390ProcessGlue.getExitCode(this.mvsIdentifier);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExitCode() : Got return code: " + n);
        }
        return n;
    }

    public boolean ping() throws ProcessOpException {
        return this.isAlive();
    }

    public boolean isAlive() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ping() : Checking to see if a process exists.");
        }
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        int n = WS390ProcessGlue.ping(this.mvsIdentifier);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ping() : Done with existence check (" + n + ")");
        }
        return n != 0;
    }

    public void stop() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop() : Requesting to kill a running process.");
        }
        int n = 0;
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        n = WS390ProcessGlue.stop(this.mvsIdentifier);
        if (n != 0) {
            if (n == 1) {
                throw new ProcessOpException("WS390ProcessImpl stop failed.  The MCGRE service return was non-zero.  JNI return code was: [" + n + "]");
            }
            if (n == 4) {
                throw new ProcessHasExitedException("WS390ProcessImpl stop failed.  Could not find job name associated with the unique process ID.  JNI return code was: [" + n + "]");
            }
            if (n == 12) {
                throw new ProcessOpException("WS390ProcessImpl stop failed.  The stop command was issued outside of the controller region.  Not allowed.  JNI return code was: [" + n + "]");
            }
            if (n == 16) {
                throw new ProcessOpException("WS390ProcessImpl create failed.  A system exception was caught.  A message was logged.  Return code: [" + n + "]");
            }
            if (n == 20) {
                throw new ProcessOpException("WS390ProcessImpl create failed.  An user exception was caught.  A message was logged.  Return code was: [" + n + "]");
            }
            if (n == 24) {
                throw new ProcessOpException("WS390ProcessImpl create failed.  An unknown exception was caught.  A message was logged.  Return code was: [" + n + "]");
            }
            throw new ProcessOpException("WS390ProcessImpl stop failed.  JNI return code was: [" + n + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop() : Done STOP_PROCESS operation.");
        }
    }

    public void release() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "release() : Doing finalization on process object.");
        }
        if (!this.released) {
            this.checkNativeHandle();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "release pid :" + new String(this.mvsIdentifier));
            }
        } else {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.released = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "release() : Done with finalization on process object.");
        }
    }

    protected void checkNativeHandle() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkNativeHandle() : Checking validity of nativeHandle.");
        }
        if (this.mvsIdentifier == null) {
            throw new ProcessOpException("Invalid process object.  nativeHandle (mvsToken) is 'null'");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkNativeHandle() : Done checking validity of nativeHandle.  Appears valid.");
        }
    }

    public void generateJVMDump() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateJVMDump() : Attempting to cause JVM Thread Dump.");
        }
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        WS390ProcessGlue.pokeVMThreadDump(this.mvsIdentifier);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateJVMDump() : Done attempting to cause JVM Thread Dump.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.released && this.mvsIdentifier != null) {
                this.release();
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            super.finalize();
        }
    }

    public boolean isPOSIXThreading() {
        return true;
    }

    protected static String getXString(String string) {
        String string2;
        try {
            if (resourceBundle == null) {
                resourceBundle = ResourceBundle.getBundle(resourceBundlePackage);
            }
            string2 = resourceBundle != null ? resourceBundle.getString(string) : string;
        }
        catch (MissingResourceException missingResourceException) {
            string2 = string;
        }
        return string2;
    }

    protected static String getXFormattedString(String string, Object[] objectArray) {
        String string2;
        try {
            if (resourceBundle == null) {
                resourceBundle = ResourceBundle.getBundle(resourceBundlePackage);
            }
            if (resourceBundle != null) {
                string2 = resourceBundle.getString(string);
                string2 = MessageFormat.format(string2, objectArray);
            } else {
                string2 = string;
            }
        }
        catch (MissingResourceException missingResourceException) {
            string2 = string;
        }
        return string2;
    }

    private WS390ProcessImpl scriptLaunch(CreationParams creationParams) throws ProcessOpException {
        WS390ProcessImpl wS390ProcessImpl = new WS390ProcessImpl();
        String string = "0000000000000000";
        byte[] byArray = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "scriptLaunch() : Process create from shell.");
        }
        try {
            byArray = string.getBytes(ASCII_CP);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        java.lang.Process process = null;
        int n = 999;
        BufferedReader bufferedReader = null;
        BufferedReader bufferedReader2 = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            Runtime runtime2 = Runtime.getRuntime();
            String string5 = WS390ProcessImpl.generateCommaCommandLine(creationParams.getCommandLineArgs());
            String[] stringArray = new String[]{"bbo3csl.exe", "start", creationParams.getExecutable(), string5};
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WS390ProcessImpl: Executing command: [bbo3csl.exe start " + creationParams.getExecutable() + " " + string5 + "]");
            }
            process = runtime2.exec(stringArray);
            process.waitFor();
            n = process.exitValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WS390ProcessImpl: Runtime exec exit value: [" + n + "]");
            }
            if ((string4 = (bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream(), EBCDIC_CP))).readLine()) != null) {
                string2 = string4 + "\n";
                while ((string4 = bufferedReader.readLine()) != null) {
                    string2 = string2 + string4 + "\n";
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WS390ProcessImpl: Error stream from bbo3csl:\n" + string2);
            }
            if ((string4 = (bufferedReader2 = new BufferedReader(new InputStreamReader(process.getInputStream(), EBCDIC_CP))).readLine()) != null) {
                string3 = string4 + "\n";
                while ((string4 = bufferedReader2.readLine()) != null) {
                    string3 = string3 + string4 + "\n";
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WS390ProcessImpl: Output stream of bbo3csl:\n" + string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ProcessOpException("WS390ProcessImpl: (from shell) create failed with exception: " + exception);
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        if (n != 0) {
            throw new ProcessOpException("WS390ProcessImpl: (from shell) create failed. Return code = " + n + ", errorStream = " + string2);
        }
        try {
            if (string3 != null) {
                int n2 = 0;
                n2 = string3.indexOf(BBO3CSL_RETURN_STOKEN_START);
                if (n2 != -1) {
                    int n3 = n2 + BBO3CSL_RETURN_STOKEN_START.length();
                    int n4 = n3 + byArray.length;
                    String string6 = string3.substring(n3, n4);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WS390ProcessImpl: Determined local mvsToken to be: [" + string6 + "]");
                    }
                    if (string6.length() == byArray.length) {
                        try {
                            byArray = string6.getBytes(ASCII_CP);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            byArray = string6.getBytes();
                        }
                    }
                }
            }
            wS390ProcessImpl.mvsIdentifier = byArray;
        }
        catch (Exception exception) {
            throw new ProcessOpException("WS390ProcessImpl (from shell) create failed. Error retrieving PID/STOKEN: " + exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "scriptLaunch() : Process create from shell.");
        }
        return wS390ProcessImpl;
    }

    private static String generateCommaCommandLine(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string == null || string.equals("")) continue;
                string = WS390ProcessImpl.processArg(string.trim());
                stringBuffer.append(string);
                if (i >= stringArray.length - 1) continue;
                stringBuffer.append(",");
            }
        }
        return stringBuffer.toString().trim();
    }

    private static String processArg(String string) {
        if (string != null) {
            if (string.startsWith(",") && string.length() > 1) {
                string = string.substring(1, string.length());
            }
            if (string.endsWith(",") && string.length() > 1) {
                string = string.substring(0, string.length() - 1);
            }
            if (((string = string.trim()).startsWith(",") || string.endsWith(",")) && string.length() > 1) {
                string = WS390ProcessImpl.processArg(string);
            }
        }
        return string;
    }
}

