/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.process;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.process.CreationParams;
import com.ibm.ws.process.EnvUtilImpl;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.process.ProcessObjectFactory;
import com.ibm.ws.process.StopParams;
import com.ibm.ws.process.Win32ProcessGlue;
import com.ibm.ws.process.exception.AccessDeniedException;
import com.ibm.ws.process.exception.InvalidDirectoryException;
import com.ibm.ws.process.exception.InvalidExecutableException;
import com.ibm.ws.process.exception.InvalidFileException;
import com.ibm.ws.process.exception.InvalidGroupException;
import com.ibm.ws.process.exception.InvalidPriorityException;
import com.ibm.ws.process.exception.InvalidProcessGroupException;
import com.ibm.ws.process.exception.InvalidUsernameException;
import com.ibm.ws.process.exception.OutOfFileHandlesException;
import com.ibm.ws.process.exception.OutOfMemoryException;
import com.ibm.ws.process.exception.ProcessHasExitedException;
import com.ibm.ws.process.exception.ProcessOpException;
import com.ibm.ws.process.exception.ProcessStillActiveException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Win32ProcessImpl
implements Process,
ProcessObjectFactory {
    private static TraceComponent tc = Tr.register(Win32ProcessImpl.class);
    protected long nativeHandle = 0L;
    protected boolean released = false;
    private static ResourceBundle resourceBundle = null;
    private static final String resourceBundlePackage = "com.ibm.ws.process.processmessages";
    private static Hashtable procTable = null;
    private boolean inTable = false;

    public Win32ProcessImpl() {
        if (procTable == null) {
            procTable = new Hashtable();
        }
    }

    public Process create(CreationParams creationParams) throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create() : Calling for a process create.");
        }
        if (creationParams == null) {
            throw new ProcessOpException("A 'null' value was passed in for creation parameters.  Cannot execute.");
        }
        if (creationParams.getExecutable() == null) {
            throw new InvalidExecutableException("A 'null' string was passed in as executable.  Cannot execute.");
        }
        Win32ProcessImpl win32ProcessImpl = new Win32ProcessImpl();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "create() : Creation params are: " + creationParams.toString());
        }
        try {
            win32ProcessImpl.nativeHandle = Win32ProcessGlue.create(Win32ProcessImpl.getCmdlineString(creationParams), EnvUtilImpl.static_expandEnvironment(creationParams.getEnvironment()), creationParams.getWorkingDirectory(), creationParams.getProcessPriority(), creationParams.getStdFileNames(), creationParams.getInheritParentStreams());
        }
        catch (Exception exception) {
            ProcessOpException processOpException = new ProcessOpException(exception.toString());
            if (exception instanceof InvalidUsernameException) {
                String string = Win32ProcessImpl.getXFormattedString("PROC0001E", new Object[]{creationParams.getUserId()});
                processOpException = new InvalidUsernameException(string);
            } else if (exception instanceof InvalidGroupException) {
                String string = Win32ProcessImpl.getXFormattedString("PROC0002E", new Object[]{creationParams.getGroupId()});
                processOpException = new InvalidGroupException(string);
            } else if (exception instanceof InvalidDirectoryException) {
                String string = Win32ProcessImpl.getXFormattedString("PROC0003E", new Object[]{creationParams.getWorkingDirectory()});
                processOpException = new InvalidDirectoryException(string);
            } else if (exception instanceof InvalidExecutableException) {
                String string = Win32ProcessImpl.getXFormattedString("PROC0004E", new Object[]{creationParams.getExecutable()});
                processOpException = new InvalidExecutableException(string);
            } else if (exception instanceof InvalidPriorityException) {
                String string = Win32ProcessImpl.getXFormattedString("PROC0005E", new Object[]{new Integer(creationParams.getProcessPriority())});
                processOpException = new InvalidPriorityException(string);
            } else if (exception instanceof InvalidProcessGroupException) {
                String string = Win32ProcessImpl.getXFormattedString("PROC0006E", new Object[]{new Integer(creationParams.getProcessGroupId())});
                processOpException = new InvalidGroupException(string);
            } else if (exception instanceof InvalidFileException) {
                String string = Win32ProcessImpl.getXString("PROC0007E");
                processOpException = new InvalidFileException(string);
            } else if (exception instanceof OutOfFileHandlesException) {
                String string = Win32ProcessImpl.getXString("PROC0008E");
                processOpException = new OutOfFileHandlesException(string);
            } else if (exception instanceof OutOfMemoryException) {
                String string = Win32ProcessImpl.getXString("PROC0009E");
                processOpException = new OutOfMemoryException(string);
            }
            throw processOpException;
        }
        this.addToProcessTable(win32ProcessImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create() : Done with process create.");
        }
        return win32ProcessImpl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Process bindTo(String string) throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recreate() : Rebinding to a running process.");
        }
        Win32ProcessImpl win32ProcessImpl = null;
        if (string == null) throw new ProcessOpException("A 'null' string was passed in as the identifier for the process to bind to.  Cannot bind.");
        if ((string = string.trim()).equals("")) throw new ProcessOpException("PID cannot be an empty string.  Cannot bind.");
        boolean bl = false;
        try {
            long l = Long.parseLong(string);
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        if (bl) {
            Win32ProcessImpl win32ProcessImpl2 = this.getProcessFromTable(string);
            if (win32ProcessImpl2 != null) {
                win32ProcessImpl = win32ProcessImpl2;
            } else {
                win32ProcessImpl = new Win32ProcessImpl();
                try {
                    win32ProcessImpl.nativeHandle = Win32ProcessGlue.recreate(string);
                }
                catch (Exception exception) {
                    ProcessOpException processOpException = new ProcessOpException(exception.toString());
                    if (exception instanceof ProcessHasExitedException) {
                        String string2 = Win32ProcessImpl.getXFormattedString("PROC0010E", new Object[]{string});
                        processOpException = new ProcessHasExitedException(string2);
                        throw processOpException;
                    } else {
                        if (!(exception instanceof AccessDeniedException)) throw processOpException;
                        String string3 = Win32ProcessImpl.getXFormattedString("PROC0018E", new Object[]{string});
                        processOpException = new AccessDeniedException(string3);
                    }
                    throw processOpException;
                }
                this.addToProcessTable(win32ProcessImpl);
            }
        } else {
            String string4 = Win32ProcessImpl.getXFormattedString("PROC0017E", new Object[]{string});
            throw new ProcessOpException(string4);
        }
        if (!tc.isEntryEnabled()) return win32ProcessImpl;
        Tr.exit(tc, "recreate() : Done with rebind.");
        return win32ProcessImpl;
    }

    public Process createSelf() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSelf() : Calling for a process create of myself.");
        }
        Win32ProcessImpl win32ProcessImpl = new Win32ProcessImpl();
        win32ProcessImpl.nativeHandle = Win32ProcessGlue.createSelf();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSelf() : Done with process create of myself.");
        }
        return win32ProcessImpl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void terminate(StopParams stopParams) throws ProcessOpException {
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "terminate() : Calling for a process termination.");
            }
            if (stopParams != null && stopParams.getProcessID() != null) {
                try {
                    Win32ProcessImpl win32ProcessImpl = (Win32ProcessImpl)ProcessFactory.bindTo(stopParams.getProcessID());
                    if (stopParams.getStopMode() == 0) {
                        win32ProcessImpl.stop();
                    } else {
                        Win32ProcessGlue.kill(win32ProcessImpl.nativeHandle);
                    }
                    try {
                        win32ProcessImpl.waitForTermination(20);
                        break block12;
                    }
                    catch (ProcessOpException processOpException) {
                        if (processOpException instanceof ProcessStillActiveException) {
                            String string = Win32ProcessImpl.getXFormattedString("PROC0014E", new Object[]{stopParams.getProcessID()});
                            throw new ProcessStillActiveException(string);
                        }
                        break block12;
                    }
                }
                catch (Exception exception) {
                    if (exception instanceof ProcessHasExitedException) {
                        String string = Win32ProcessImpl.getXFormattedString("PROC0010E", new Object[]{stopParams.getProcessID()});
                        throw new ProcessHasExitedException(string);
                    }
                    if (exception instanceof AccessDeniedException) {
                        String string = Win32ProcessImpl.getXFormattedString("PROC0011E", new Object[]{stopParams.getProcessID()});
                        throw new AccessDeniedException(string);
                    }
                    String string = Win32ProcessImpl.getXFormattedString("PROC0013E", new Object[]{exception.toString()});
                    throw new ProcessOpException(string);
                }
            }
            String string = Win32ProcessImpl.getXString("PROC0012E");
            throw new ProcessOpException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Terminate()");
        }
    }

    public boolean isPOSIXThreading() {
        return true;
    }

    public String id() throws ProcessOpException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "id() : Obtaining process ID.");
        }
        if (!this.released) {
            try {
                this.checkNativeHandle();
                string = Win32ProcessGlue.id(this.nativeHandle);
            }
            catch (ProcessOpException processOpException) {
                FFDCFilter.processException((Throwable)processOpException, "com.ibm.ws.process.Win32ProcessImpl.id", "199", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Bad nativeHandle, returning PID: 0:");
                }
                return "0";
            }
        } else {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "id() : Obtained process ID: " + string);
        }
        return string;
    }

    public void waitForTermination() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForTermination() : Requesting to wait for process termination");
        }
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        Win32ProcessGlue.waitForTermination(this.nativeHandle);
        this.removeProcessFromTable(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForTermination() : Done with waiting for process termination");
        }
    }

    public void waitForTermination(int n) throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForTermination() : Requesting to wait for process termination over a set time.");
        }
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        Win32ProcessGlue.waitForTerminationWithTimeout(this.nativeHandle, n);
        this.removeProcessFromTable(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForTermination() : Done with waiting for process termination");
        }
    }

    public int getExitCode() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExitCode() : Getting process exitCode (Return code)");
        }
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        int n = Win32ProcessGlue.getExitCode(this.nativeHandle);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExitCode() : Got return code: " + n);
        }
        return n;
    }

    public boolean ping() throws ProcessOpException {
        return this.isAlive();
    }

    public boolean isAlive() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ping() : Checking to see if a process exists.");
        }
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        int n = Win32ProcessGlue.ping(this.nativeHandle);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ping() : Done with existance check");
        }
        if (n == 0) {
            this.removeProcessFromTable(this);
        }
        return n != 0;
    }

    public void stop() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop() : Requesting to kill a running process.");
        }
        if (!this.released) {
            this.checkNativeHandle();
            try {
                Win32ProcessGlue.stop(this.nativeHandle);
            }
            catch (Exception exception) {
                if (exception instanceof ProcessHasExitedException) {
                    String string = Win32ProcessImpl.getXFormattedString("PROC0010E", new Object[]{this.id()});
                    throw new ProcessHasExitedException(string);
                }
                if (exception instanceof AccessDeniedException) {
                    String string = Win32ProcessImpl.getXFormattedString("PROC0011E", new Object[]{this.id()});
                    throw new AccessDeniedException(string);
                }
                if (exception instanceof ProcessOpException) {
                    throw (ProcessOpException)exception;
                }
                String string = Win32ProcessImpl.getXFormattedString("PROC0013E", new Object[]{exception.toString()});
                throw new ProcessOpException(string);
            }
        } else {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop() : Done STOP_PROCESS operation.");
        }
    }

    public void release() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "release() : Doing finalization on process object.");
        }
        if (!this.released) {
            try {
                this.checkNativeHandle();
                this.removeProcessFromTable(this);
            }
            catch (ProcessOpException processOpException) {
                FFDCFilter.processException((Throwable)processOpException, "com.ibm.ws.process.Win32ProcessImpl.done", "304", this);
            }
        } else {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "release() : Done with finalization on process object.");
        }
    }

    public void generateJVMDump() throws ProcessOpException {
        block22: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "generateJVMDump() : Attempting to cause JVM Thread Dump.");
            }
            if (!this.released) {
                String string = System.getProperty("java.vendor");
                if ((string = string.toLowerCase()) == null || string.startsWith("ibm")) {
                    try {
                        Class<?> clazz = Class.forName("com.ibm.jvm.Dump");
                        if (clazz != null) {
                            try {
                                Method method2 = clazz.getMethod("JavaDump", null);
                                if (method2 != null) {
                                    try {
                                        method2.invoke(null, null);
                                    }
                                    catch (IllegalAccessException illegalAccessException) {
                                        String string2 = Win32ProcessImpl.getXFormattedString("PROC0027E", new Object[]{"com.ibm.jvm.Dump", System.getProperty("java.version"), System.getProperty("java.vendor"), "JavaDump()"});
                                        Tr.error(tc, string2);
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        String string3 = Win32ProcessImpl.getXFormattedString("PROC0028E", new Object[]{"com.ibm.jvm.Dump", System.getProperty("java.version"), System.getProperty("java.vendor"), "JavaDump()"});
                                        Tr.error(tc, string3);
                                    }
                                    catch (InvocationTargetException invocationTargetException) {
                                        String string4 = Win32ProcessImpl.getXFormattedString("PROC0029E", new Object[]{"com.ibm.jvm.Dump", System.getProperty("java.version"), System.getProperty("java.vendor"), "JavaDump()"});
                                        Tr.error(tc, string4);
                                    }
                                    catch (NullPointerException nullPointerException) {
                                        String string5 = Win32ProcessImpl.getXFormattedString("PROC0024E", new Object[]{"com.ibm.jvm.Dump", System.getProperty("java.version"), System.getProperty("java.vendor"), "JavaDump()"});
                                        Tr.error(tc, string5);
                                    }
                                    catch (ExceptionInInitializerError exceptionInInitializerError) {
                                        String string6 = Win32ProcessImpl.getXFormattedString("PROC0026E", new Object[]{"JavaDump()", System.getProperty("java.version"), System.getProperty("java.vendor")});
                                        Tr.error(tc, string6);
                                    }
                                    break block22;
                                }
                                String string7 = Win32ProcessImpl.getXFormattedString("PROC0023E", new Object[]{"com.ibm.jvm.Dump", System.getProperty("java.version"), System.getProperty("java.vendor"), "JavaDump()"});
                                Tr.error(tc, string7);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                String string8 = Win32ProcessImpl.getXFormattedString("PROC0023E", new Object[]{"com.ibm.jvm.Dump", System.getProperty("java.version"), System.getProperty("java.vendor"), "JavaDump()"});
                                Tr.error(tc, string8);
                            }
                            catch (NullPointerException nullPointerException) {
                                String string9 = Win32ProcessImpl.getXFormattedString("PROC0024E", new Object[]{"com.ibm.jvm.Dump", System.getProperty("java.version"), System.getProperty("java.vendor"), "JavaDump()"});
                                Tr.error(tc, string9);
                            }
                            catch (SecurityException securityException) {
                                String string10 = Win32ProcessImpl.getXFormattedString("PROC0025E", new Object[]{"com.ibm.jvm.Dump", System.getProperty("java.version"), System.getProperty("java.vendor"), "JavaDump()"});
                                Tr.error(tc, string10);
                            }
                            break block22;
                        }
                        String string11 = Win32ProcessImpl.getXFormattedString("PROC0019E", new Object[]{"com.ibm.jvm.Dump", System.getProperty("java.version"), System.getProperty("java.vendor")});
                        Tr.error(tc, string11);
                    }
                    catch (ExceptionInInitializerError exceptionInInitializerError) {
                        String string12 = Win32ProcessImpl.getXFormattedString("PROC0020E", new Object[]{"com.ibm.jvm.Dump", System.getProperty("java.version"), System.getProperty("java.vendor")});
                        Tr.error(tc, string12);
                    }
                    catch (LinkageError linkageError) {
                        String string13 = Win32ProcessImpl.getXFormattedString("PROC0021E", new Object[]{"com.ibm.jvm.Dump", System.getProperty("java.version"), System.getProperty("java.vendor")});
                        Tr.error(tc, string13);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        String string14 = Win32ProcessImpl.getXFormattedString("PROC0019E", new Object[]{"com.ibm.jvm.Dump", System.getProperty("java.version"), System.getProperty("java.vendor")});
                        Tr.error(tc, string14);
                    }
                } else {
                    String string15 = Win32ProcessImpl.getXFormattedString("PROC0030E", new Object[]{System.getProperty("java.version"), System.getProperty("java.vendor")});
                    Tr.error(tc, string15);
                }
            } else {
                throw new ProcessOpException("Process Object already released.  No further calls allowed.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateJVMDump() : Done attempting to cause JVM Thread Dump.");
        }
    }

    protected void checkNativeHandle() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkNativeHandle() : Checking validity of nativeHandle.");
        }
        if (this.nativeHandle == 0L) {
            throw new ProcessOpException("Invalid process object.  nativeHandle (pointer) is 'null'");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkNativeHandle() : Done checking validity of nativeHandle.  Appears valid.");
        }
    }

    protected void finalize() throws Throwable {
        if (!this.released && this.nativeHandle != 0L) {
            this.release();
        }
        if (this.nativeHandle != 0L) {
            Win32ProcessGlue.done(this.nativeHandle);
            this.nativeHandle = 0L;
        }
        super.finalize();
    }

    static String getCmdlineString(CreationParams creationParams) {
        StringBuffer stringBuffer = new StringBuffer(4096);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCmdLineString() : Commandline conversion.");
        }
        stringBuffer.append(Win32ProcessImpl.processArg(Win32ProcessImpl.trimQuotes(creationParams.getExecutable())));
        String[] stringArray = creationParams.getCommandLineArgs();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                stringBuffer.append(" ");
                stringBuffer.append(Win32ProcessImpl.processArg(Win32ProcessImpl.trimQuotes(stringArray[i])));
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Commandline called was: " + stringBuffer.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCmdLineString() : Done with commandline conversion.");
        }
        return stringBuffer.toString();
    }

    private static String trimQuotes(String string) {
        int n = string.length();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "trimQuotes() : Stripping begin and end quotes off of initial arg if necessary");
        }
        if (n > 0 && string.charAt(0) == '\"' && string.charAt(n - 1) == '\"') {
            string = string.substring(1, n - 1);
            string = Win32ProcessImpl.trimQuotes(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "trimQuotes() : Done processing");
        }
        return string;
    }

    private static String processArg(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = string.length();
        int n2 = 0;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processArg() : Escaping and examining args.");
        }
        if (string.indexOf(" ") != -1) {
            bl = true;
            stringBuffer.append('\"');
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                ++n2;
                if (i + 1 < n && string.charAt(i + 1) == '\"') {
                    stringBuffer.append('\\');
                }
            } else {
                n2 = 0;
            }
            if (c == '\"') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        while (n2-- > 0) {
            stringBuffer.append('\\');
        }
        if (bl) {
            stringBuffer.append('\"');
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processArg() : Done escaping and examining args.");
        }
        return stringBuffer.toString();
    }

    protected static String getXString(String string) {
        String string2;
        try {
            if (resourceBundle == null) {
                resourceBundle = ResourceBundle.getBundle(resourceBundlePackage);
            }
            string2 = resourceBundle != null ? resourceBundle.getString(string) : string;
        }
        catch (MissingResourceException missingResourceException) {
            string2 = string;
        }
        return string2;
    }

    protected static String getXFormattedString(String string, Object[] objectArray) {
        String string2;
        try {
            if (resourceBundle == null) {
                resourceBundle = ResourceBundle.getBundle(resourceBundlePackage);
            }
            if (resourceBundle != null) {
                string2 = resourceBundle.getString(string);
                string2 = MessageFormat.format(string2, objectArray);
            } else {
                string2 = string;
            }
        }
        catch (MissingResourceException missingResourceException) {
            string2 = string;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToProcessTable(Win32ProcessImpl win32ProcessImpl) throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToProcessTable() : Adding processto tracking table.");
        }
        if (win32ProcessImpl != null) {
            Hashtable hashtable = procTable;
            synchronized (hashtable) {
                if (!procTable.containsKey(win32ProcessImpl.id())) {
                    procTable.put(win32ProcessImpl.id(), win32ProcessImpl);
                    win32ProcessImpl.inTable = true;
                } else {
                    Win32ProcessImpl win32ProcessImpl2 = (Win32ProcessImpl)procTable.remove(win32ProcessImpl.id());
                    if (win32ProcessImpl2 != null) {
                        win32ProcessImpl2.inTable = false;
                    }
                    procTable.put(win32ProcessImpl.id(), win32ProcessImpl);
                    win32ProcessImpl.inTable = true;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToProcessTable() : Done adding process to tracking table.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Win32ProcessImpl getProcessFromTable(String string) throws ProcessOpException {
        Win32ProcessImpl win32ProcessImpl = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProcessFromTable() : Retrieving process object for pid: " + string);
        }
        Hashtable hashtable = procTable;
        synchronized (hashtable) {
            if (string != null) {
                win32ProcessImpl = (Win32ProcessImpl)procTable.get(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProcessFromTable() : Retrieved process for pid: " + string);
        }
        return win32ProcessImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Win32ProcessImpl removeProcessFromTable(Win32ProcessImpl win32ProcessImpl) throws ProcessOpException {
        Win32ProcessImpl win32ProcessImpl2 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeProcessFromTable() : Removing process object from table");
        }
        Hashtable hashtable = procTable;
        synchronized (hashtable) {
            String string = null;
            if (win32ProcessImpl != null && !win32ProcessImpl.released && win32ProcessImpl.inTable) {
                string = win32ProcessImpl.id();
                if (procTable.containsKey(string)) {
                    win32ProcessImpl2 = (Win32ProcessImpl)procTable.remove(string);
                    if (win32ProcessImpl2 != null) {
                        win32ProcessImpl2.inTable = false;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "removeProcessFromTable() : Removed process object for pid: [" + string + "]");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removeProcessFromTable() : Not removing process object for pid: [" + string + "].  No such object mapping");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeProcessFromTable()");
        }
        return win32ProcessImpl2;
    }
}

