/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.process.linuxutil;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.process.linuxutil.ThreadUtil;

public class Mutex {
    private static TraceComponent tc = Tr.register(Mutex.class);
    private long mutexHandle = 0L;

    public Mutex() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Mutex() : Creating new mutex object.");
        }
        this.mutexHandle = ThreadUtil.createMutex();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Mutex() : Done creating new mutex object.");
        }
    }

    public void lock() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lock() : Trying to lock mutex.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "lock() : Locking mutex at native address: 0x" + Long.toHexString(this.mutexHandle));
        }
        ThreadUtil.mutexLock(this.mutexHandle);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lock() : Locked mutex.");
        }
    }

    public void unlock() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unlock() : Unlocking mutex.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "unlock() : Unlocking mutex at native address: 0x" + Long.toHexString(this.mutexHandle));
        }
        ThreadUtil.mutexUnlock(this.mutexHandle);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unlock() : Unlocked mutex.");
        }
    }

    public boolean trylock() {
        boolean bl = false;
        int n = 0;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "trylock() : Testing to see if we can lock the mutex and locking if we can.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "trylock() : Trying to lock mutex at native address: 0x" + Long.toHexString(this.mutexHandle));
        }
        bl = (n = ThreadUtil.mutexTrylock(this.mutexHandle)) == 0;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "trylock() : Lock obtained? " + bl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "trylock() : Done with test/lock.");
        }
        return bl;
    }

    protected void finalize() throws Throwable {
        if (this.mutexHandle != 0L) {
            ThreadUtil.freeMutex(this.mutexHandle);
            this.mutexHandle = 0L;
        }
        super.finalize();
    }
}

