/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.process.script;

import com.ibm.ws.process.CreationParams;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.process.exception.ProcessOpException;
import java.io.File;
import java.util.StringTokenizer;

public class BatchFileCommand {
    private String batFile = null;
    private String[] cmdLineArgs = null;
    private String stdOutFile = null;
    private String stdErrFile = null;
    private static StringBuffer classpath = null;

    public BatchFileCommand(String string, String[] stringArray, String string2, String string3) {
        this.batFile = string;
        this.cmdLineArgs = stringArray;
        this.stdOutFile = string2;
        this.stdErrFile = string3;
        if (classpath == null) {
            classpath = new StringBuffer();
            classpath.append(System.getProperty("java.class.path") + File.pathSeparator);
            String string4 = System.getProperty("ws.ext.dirs");
            if (string4 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string4, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken();
                    File file = new File(string5);
                    if (!file.exists() || !file.isDirectory()) continue;
                    File[] fileArray = file.listFiles();
                    for (int i = 0; i < fileArray.length; ++i) {
                        int n;
                        if (fileArray[i].isDirectory()) continue;
                        String string6 = null;
                        try {
                            string6 = fileArray[i].getCanonicalPath();
                        }
                        catch (Exception exception) {
                            string6 = "";
                        }
                        if (string6.indexOf(".jar") == -1 || (n = string6.indexOf(".jar")) != string6.length() - 4) continue;
                        classpath.append(string6 + File.pathSeparator);
                    }
                }
            }
        }
    }

    public int execute(boolean bl) throws ProcessOpException {
        if (this.batFile == null) {
            throw new ProcessOpException("Error.  No batchfile specified.");
        }
        String[] stringArray = null;
        Process process = null;
        int n = 0;
        stringArray = this.cmdLineArgs == null ? new String[5] : new String[5 + this.cmdLineArgs.length];
        stringArray[0] = bl ? "-Dcom.ibm.ws.process.script.batchlauncher.wait=true" : "-Dcom.ibm.ws.process.script.batchlauncher.wait=false";
        stringArray[1] = "-classpath";
        stringArray[2] = classpath.toString();
        stringArray[3] = "com.ibm.ws.process.script.BatchLauncher";
        stringArray[4] = this.batFile;
        if (this.cmdLineArgs != null) {
            for (int i = 0; i < this.cmdLineArgs.length; ++i) {
                stringArray[i + 5] = this.cmdLineArgs[i];
            }
        }
        CreationParams creationParams = new CreationParams();
        String string = System.getProperty("java.home");
        String string2 = null;
        if (string != null) {
            string = string.replace('/', File.separatorChar);
            if ((string = string.replace('\\', File.separatorChar)).indexOf("jre") != -1) {
                string = string.substring(0, string.indexOf("jre"));
            }
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            string2 = string + "bin" + File.separator + "java";
        } else {
            string2 = "java";
        }
        creationParams.setExecutable(string2);
        creationParams.setCommandLineArgs(stringArray);
        creationParams.setInheritParentStreams(true);
        if (this.stdOutFile != null) {
            creationParams.setStdFileName(1, this.stdOutFile);
            creationParams.setInheritParentStreams(false);
        }
        if (this.stdErrFile != null) {
            creationParams.setStdFileName(2, this.stdErrFile);
            creationParams.setInheritParentStreams(false);
        }
        process = ProcessFactory.create(creationParams);
        process.waitForTermination();
        n = process.getExitCode();
        process.release();
        return n;
    }

    public int executeNoWait() throws ProcessOpException {
        return this.execute(false);
    }

    public int executeAndWait() throws ProcessOpException {
        return this.execute(true);
    }
}

