/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import com.ibm.ws.profile.bootstrap.WSProfileProperties;
import com.ibm.ws.profile.validators.NoInvalidCharactersValidator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WASUtilities {
    private static final Logger LOGGER = LoggerFactory.createLogger(WASUtilities.class);
    private static final String S_CLASS_NAME = WASUtilities.class.getName();
    public static final String S_WINDOWS = "Windows";
    public static final String S_LINUX = "Linux";
    public static final String S_SOLARIS = "Solaris";
    public static final String S_SUN_OS = "SUN OS";
    public static final String S_HP_UX = "HP UX";
    public static final String S_AIX = "AIX";
    public static final String S_PASSWD_HIDE = "**********";
    public static final String S_LOCALHOST = "localhost";

    public static String getWASProperty(String string) throws IOException {
        String string2 = "";
        if (string != null && !string.equals("")) {
            WSProfileProperties wSProfileProperties = new WSProfileProperties();
            string2 = wSProfileProperties.getProperty(string);
        }
        return string2;
    }

    public static boolean isWindows() {
        return PlatformConstants.isCurrentPlatformWindows();
    }

    public static boolean isUnix() {
        return PlatformConstants.isCurrentPlatformUNIX();
    }

    public static boolean isLinux() {
        String string = System.getProperty("os.name");
        return string.equals(S_LINUX);
    }

    public static String printArrayToString(String[] stringArray) {
        String string = " , ";
        String string2 = "[";
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = string2.equals("[") ? string2 + stringArray[i] : string2 + string + stringArray[i];
        }
        string2 = string2 + "]";
        return string2;
    }

    public static String hideArgValueIfNecessary(String string, String string2, String[] stringArray) {
        String string3 = string2;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            string3 = S_PASSWD_HIDE;
            break;
        }
        return string3;
    }

    public static boolean runAdministrativeSecurityNonSAFValidator() {
        String string = System.getProperty("enableAdminSecurity");
        String string2 = System.getProperty("useSAFSecurity");
        if (string2 != null && string2.equals("true")) {
            return false;
        }
        return string != null && string.equals("true");
    }

    public static boolean runAdministrativeSecurityValidator() {
        String string = System.getProperty("enableAdminSecurity");
        return string != null && string.equals("true");
    }

    public static String getEnvironmentVariable(String string) {
        if (WASUtilities.isWindows()) {
            String string2 = null;
            Process process = null;
            try {
                String string3;
                process = Runtime.getRuntime().exec("cmd /C set");
                InputStream inputStream = process.getInputStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (string3.indexOf(string) != 0) continue;
                    int n = string3.indexOf("=");
                    string2 = string3.substring(n + 1, string3.length());
                    break;
                }
                inputStream.close();
                inputStreamReader.close();
                bufferedReader.close();
            }
            catch (IOException iOException) {
                string2 = null;
            }
            return string2;
        }
        return null;
    }

    public static String getShortHostName(String string) {
        boolean bl;
        if (string == null || string.length() == 0) {
            return S_LOCALHOST;
        }
        int n = string.indexOf(46);
        if (n != -1) {
            string = string.substring(0, n);
        }
        if (bl = WASUtilities.checkIfPatternMatchesString(string, NoInvalidCharactersValidator.saINVALID_PATTERNS)) {
            return string;
        }
        try {
            string = WASUtilities.findShortHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = S_LOCALHOST;
        }
        return string;
    }

    public static boolean checkIfPatternMatchesString(String string, String[] stringArray) {
        int n;
        Pattern[] patternArray = new Pattern[stringArray.length];
        Matcher[] matcherArray = new Matcher[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            patternArray[n] = Pattern.compile(stringArray[n]);
            matcherArray[n] = patternArray[n].matcher(string);
        }
        for (n = 0; n < matcherArray.length; ++n) {
            if (!matcherArray[n].find()) continue;
            return false;
        }
        return true;
    }

    public static String findShortHostName() throws UnknownHostException {
        String string = null;
        InetAddress inetAddress = InetAddress.getLocalHost();
        String string2 = inetAddress.getHostAddress();
        String string3 = "";
        String string4 = InetAddress.getByName(string2).getHostName();
        if (string2.equals(string4)) {
            String string5;
            String string6 = inetAddress.toString();
            string3 = string5 = string6.substring(0, string6.indexOf("/"));
        } else {
            string3 = string4;
        }
        int n = string3.indexOf(46);
        string = n != -1 ? string3.substring(0, n) : string3;
        return string;
    }

    public static String findHostName() throws UnknownHostException {
        Object object = "";
        if (PlatformConstants.isCurrentPlatformOS400()) {
            InetAddress inetAddress = InetAddress.getLocalHost();
            object = inetAddress.getHostName();
            if (object == null) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "findHostName", "Unable to retieve host name, returning LOOPBACK");
                object = "LOOPBACK";
            }
        } else {
            Object object2;
            Object object3;
            String string;
            InetAddress inetAddress = InetAddress.getLocalHost();
            String string2 = inetAddress.getHostAddress();
            if (string2.equals(string = InetAddress.getByName(string2).getHostName())) {
                object3 = inetAddress.toString();
                object = object2 = ((String)object3).substring(0, ((String)object3).indexOf("/"));
            } else {
                object = string;
            }
            object3 = Pattern.compile("^([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+localdomain");
            object2 = ((Pattern)object3).matcher((CharSequence)object);
            if (((Matcher)object2).matches()) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "findHostName", "Hostname returned is:" + (String)object + " -> converting to short hostname form");
                object = WASUtilities.findShortHostName();
            }
        }
        return object;
    }
}

