/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile;

import com.ibm.ws.install.configmanager.ConfigManagerConstants;
import com.ibm.ws.install.configmanager.logging.LoggerContext;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import com.ibm.ws.profile.bootstrap.LogInitializer;
import com.ibm.ws.profile.utils.DefaultValueManagerUtils;
import com.ibm.ws.profile.utils.ValidationManagerUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileCLI;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.WSProfileTemplate;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WSConfigCreator {
    private static Map m_commandLineData = null;
    private static String m_mode = "";
    private static Logger LOGGER = null;
    private static String S_CLASS_NAME = WSConfigCreator.class.getName();
    private static List wsProfileCommandDataDmgr = null;
    private static List wsProfileCommandDataNode = null;
    private static int argCounter = 0;
    private static int returnCodeDmgr = -1;
    private static int returnCodeNode = -1;
    private static int returnCode = -1;
    private static final String S_DASH = "-";
    private static final String S_SPACE = " ";
    private static final String S_EMPTY = "";
    public static final String S_SERVICE_CHECK_ARG = "winserviceCheck";
    public static final String S_SERVICE_TYPE_ARG = "winserviceAccountType";
    public static final String S_SERVICE_STARTUP_TYPE_ARG = "winserviceStartupType";
    public static final String S_SERVICE_USER_NAME_ARG = "winserviceUserName";
    public static final String S_SERVICE_PASSWORD_ARG = "winservicePassword";
    private static Properties m_propertiesInitSysProps;

    public static void main(String[] stringArray) {
        WSConfigCreator.initLogger(stringArray);
        LOGGER.entering(WSProfile.class.getName(), "main");
        if (!WSConfigCreator.isCellTemplate(stringArray)) {
            WSConfigCreator.installServiceCheck();
            String[] stringArray2 = WSConfigCreator.recreateArgs();
            WSProfileCLI.main(stringArray2);
            LOGGER.exiting(WSProfile.class.getName(), "main");
            return;
        }
        WSConfigCreator.installServiceCheck();
        WSConfigCreator.buildCommandData();
        WSConfigCreator.runWSProfile();
        LOGGER.exiting(WSProfile.class.getName(), "main");
        System.exit(returnCode);
    }

    public static int mainForInProcessCalls(String[] stringArray) {
        m_propertiesInitSysProps = (Properties)System.getProperties().clone();
        LoggerContext loggerContext = new LoggerContext();
        loggerContext.saveAndSwitchCurrentContext();
        WSConfigCreator.initLogger(stringArray);
        LOGGER.entering(WSProfile.class.getName(), "mainForInProcessCalls");
        if (WSConfigCreator.isCellTemplate(stringArray)) {
            WSConfigCreator.installServiceCheck();
            WSConfigCreator.buildCommandData();
            WSConfigCreator.runWSProfile();
        } else {
            WSConfigCreator.installServiceCheck();
            String[] stringArray2 = WSConfigCreator.recreateArgs();
            returnCode = WSProfileCLI.mainForInProcessCalls(stringArray2);
        }
        loggerContext.restoreSavedContext();
        if (m_propertiesInitSysProps != null) {
            System.setProperties(m_propertiesInitSysProps);
        }
        LOGGER.exiting(WSProfile.class.getName(), "mainForInProcessCalls");
        return returnCode;
    }

    private static void installServiceCheck() {
        LOGGER.entering(WSConfigCreator.class.getName(), "installServiceCheck");
        if (!PlatformConstants.isCurrentPlatformWindows()) {
            return;
        }
        if (WSConfigCreator.hasServiceCheck() && !WSConfigCreator.canRunService()) {
            WSConfigCreator.removeServiceCheckArg();
        }
        LOGGER.exiting(WSConfigCreator.class.getName(), "installServiceCheck");
    }

    private static boolean hasServiceCheck() {
        LOGGER.entering(WSConfigCreator.class.getName(), "hasServiceCheck");
        if (m_commandLineData.containsKey(S_SERVICE_CHECK_ARG)) {
            LOGGER.exiting(WSConfigCreator.class.getName(), "hasServiceCheck");
            return true;
        }
        LOGGER.exiting(WSConfigCreator.class.getName(), "hasServiceCheck");
        return false;
    }

    private static boolean canRunService() {
        boolean bl = false;
        String string = (String)m_commandLineData.get(S_SERVICE_CHECK_ARG);
        String string2 = null;
        if (Boolean.valueOf(string).booleanValue()) {
            String string3;
            String[] stringArray = new String[]{"-winserviceCheck", string};
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable = new Hashtable();
            hashtable.put(S_SERVICE_CHECK_ARG, string);
            if (!m_commandLineData.containsKey(S_SERVICE_TYPE_ARG)) {
                string3 = DefaultValueManagerUtils.getDefaultValue(S_SERVICE_TYPE_ARG, stringArray);
                if (string3 != null) {
                    hashtable.put(S_SERVICE_TYPE_ARG, string3);
                    m_commandLineData.put(S_SERVICE_TYPE_ARG, string3);
                }
            } else {
                hashtable.put(S_SERVICE_TYPE_ARG, (String)m_commandLineData.get(S_SERVICE_TYPE_ARG));
            }
            if (!m_commandLineData.containsKey(S_SERVICE_STARTUP_TYPE_ARG)) {
                string3 = DefaultValueManagerUtils.getDefaultValue(S_SERVICE_STARTUP_TYPE_ARG, stringArray);
                if (string3 != null) {
                    hashtable.put(S_SERVICE_STARTUP_TYPE_ARG, string3);
                    m_commandLineData.put(S_SERVICE_STARTUP_TYPE_ARG, string3);
                }
            } else {
                hashtable.put(S_SERVICE_STARTUP_TYPE_ARG, (String)m_commandLineData.get(S_SERVICE_STARTUP_TYPE_ARG));
            }
            if (!m_commandLineData.containsKey(S_SERVICE_USER_NAME_ARG) && (string3 = DefaultValueManagerUtils.getDefaultValue(S_SERVICE_USER_NAME_ARG, stringArray)) != null) {
                m_commandLineData.put(S_SERVICE_USER_NAME_ARG, string3);
            }
            if (m_commandLineData.containsKey(S_SERVICE_PASSWORD_ARG)) {
                hashtable.put(S_SERVICE_PASSWORD_ARG, (String)m_commandLineData.get(S_SERVICE_PASSWORD_ARG));
            }
            if ((string2 = (String)m_commandLineData.get(S_SERVICE_USER_NAME_ARG)) == null) {
                string2 = S_EMPTY;
            }
            ValidationManagerUtils.reinitialize();
            bl = ValidationManagerUtils.isArgumentValueValid(S_SERVICE_USER_NAME_ARG, string2, hashtable);
            if (!bl) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "canRunService", "User does not have permission to create service.  Removing service check parameters");
                m_commandLineData.remove(S_SERVICE_CHECK_ARG);
                m_commandLineData.remove(S_SERVICE_TYPE_ARG);
                m_commandLineData.remove(S_SERVICE_STARTUP_TYPE_ARG);
                m_commandLineData.remove(S_SERVICE_USER_NAME_ARG);
                m_commandLineData.remove(S_SERVICE_PASSWORD_ARG);
            }
        }
        return bl;
    }

    private static void removeServiceCheckArg() {
        LOGGER.entering(WSConfigCreator.class.getName(), "removeRunServiceArgs");
        m_commandLineData.remove(S_SERVICE_CHECK_ARG);
        LOGGER.exiting(WSConfigCreator.class.getName(), "removeRunServiceArgs");
    }

    private static String[] recreateArgs() {
        Vector<String> vector = new Vector<String>();
        Iterator iterator = m_commandLineData.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            vector.add(S_DASH + string);
            if (m_commandLineData.get(string).equals(S_EMPTY)) continue;
            vector.add((String)m_commandLineData.get(string));
        }
        int n = vector.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)vector.get(i);
        }
        return stringArray;
    }

    private static boolean isCellTemplate(String[] stringArray) {
        LOGGER.entering(WSConfigCreator.class.getName(), "isCellTemplate");
        m_commandLineData = WSConfigCreator.convertIncomingCommandLineToCommandLineArguments(stringArray);
        if (!m_commandLineData.containsKey("templatePath")) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "isCellTemplate", "No template type detected, passing through.");
            LOGGER.exiting(WSConfigCreator.class.getName(), "isCellTemplate");
            return false;
        }
        String string = (String)m_commandLineData.get("templatePath");
        WSProfileTemplate wSProfileTemplate = null;
        try {
            wSProfileTemplate = new WSProfileTemplate(string);
        }
        catch (WSProfileException wSProfileException) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "isCellTemplate", "Could not determine template path");
            LOGGER.exiting(WSConfigCreator.class.getName(), "isCellTemplate");
            return false;
        }
        m_mode = WSConfigCreator.getMode(m_commandLineData);
        if (wSProfileTemplate.getType().equalsIgnoreCase("cell")) {
            WSConfigCreator.setupEnvironment(string + File.separator + "dmgr");
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "isCellTemplate", "Cell template type detected");
            LOGGER.exiting(WSProfile.class.getName(), "isCellTemplate");
            return true;
        }
        WSConfigCreator.setupEnvironment(string);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "isCellTemplate", "Cell template type not detected, passing through.");
        LOGGER.exiting(WSConfigCreator.class.getName(), "isCellTemplate");
        return false;
    }

    private static String getMode(Map map) {
        if (map.containsKey("create")) {
            return "create";
        }
        if (map.containsKey("augment")) {
            return "augment";
        }
        return S_EMPTY;
    }

    private static void setupEnvironment(String string) {
        System.setProperty("templatePath", string);
        System.setProperty(ConfigManagerConstants.S_ARG_CONFIG_DIR, string);
        System.setProperty(ConfigManagerConstants.S_ARG_ACTION_REGISTRY, string + File.separator + "actionRegistry.xml");
        if (m_mode != null && !m_mode.equals(S_EMPTY)) {
            System.setProperty(m_mode, S_EMPTY);
        }
    }

    private static void buildCommandData() {
        String string;
        Object object;
        Hashtable<String, String> hashtable;
        LOGGER.entering(WSConfigCreator.class.getName(), "buildCommandData");
        wsProfileCommandDataDmgr = new Vector();
        wsProfileCommandDataNode = new Vector();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        DefaultValueManagerUtils.reinitialize();
        String[] stringArray = new String[]{"-hostName", DefaultValueManagerUtils.getDefaultValue("hostName")};
        if (!m_commandLineData.containsKey("nodeName")) {
            hashtable = DefaultValueManagerUtils.getDefaultValue("nodeName", stringArray);
            m_commandLineData.put("nodeName", hashtable);
        }
        if (!m_commandLineData.containsKey("appServerNodeName")) {
            hashtable = DefaultValueManagerUtils.getDefaultValue("appServerNodeName", stringArray);
            m_commandLineData.put("appServerNodeName", hashtable);
        }
        if (!m_commandLineData.containsKey("cellName")) {
            hashtable = DefaultValueManagerUtils.getDefaultValue("cellName", stringArray);
            m_commandLineData.put("cellName", hashtable);
        }
        if (!m_commandLineData.containsKey("dmgrProfileName")) {
            hashtable = DefaultValueManagerUtils.getDefaultValue("profileName");
            m_commandLineData.put("dmgrProfileName", hashtable);
        }
        if (!m_commandLineData.containsKey("profilePath")) {
            hashtable = new Hashtable();
            hashtable = new Hashtable<String, String>();
            hashtable.put("profileName", (String)m_commandLineData.get("dmgrProfileName"));
            string4 = DefaultValueManagerUtils.getDefaultValue("profilePath", hashtable);
        }
        hashtable = (String)m_commandLineData.get("templatePath");
        WSConfigCreator.setupEnvironment(hashtable + File.separator + "default");
        DefaultValueManagerUtils.reinitialize();
        if (!m_commandLineData.containsKey("appServerProfileName")) {
            object = DefaultValueManagerUtils.getDefaultValue("profileName");
            m_commandLineData.put("appServerProfileName", object);
        }
        if (!m_commandLineData.containsKey("profilePath")) {
            object = new Hashtable();
            object = new Hashtable<String, String>();
            ((Hashtable)object).put("profileName", (String)m_commandLineData.get("appServerProfileName"));
            string3 = DefaultValueManagerUtils.getDefaultValue("profilePath", (Map)object);
        }
        WSConfigCreator.setupEnvironment(hashtable + File.separator + "dmgr");
        DefaultValueManagerUtils.reinitialize();
        object = m_commandLineData.keySet().iterator();
        while (object.hasNext()) {
            string = (String)object.next();
            if (string.equalsIgnoreCase("templatePath")) {
                wsProfileCommandDataDmgr.add(S_DASH + string);
                wsProfileCommandDataDmgr.add(m_commandLineData.get(string) + File.separator + "dmgr");
                wsProfileCommandDataNode.add(S_DASH + string);
                wsProfileCommandDataNode.add(m_commandLineData.get(string) + File.separator + "default");
                continue;
            }
            if (string.equalsIgnoreCase("profilePath")) {
                string4 = m_commandLineData.get(string) + File.separator + m_commandLineData.get("dmgrProfileName");
                string3 = m_commandLineData.get(string) + File.separator + m_commandLineData.get("appServerProfileName");
                continue;
            }
            if (string.equalsIgnoreCase("dmgrProfileName")) {
                wsProfileCommandDataDmgr.add("-profileName");
                wsProfileCommandDataDmgr.add(m_commandLineData.get(string));
                continue;
            }
            if (string.equalsIgnoreCase("appServerProfileName")) {
                wsProfileCommandDataNode.add("-profileName");
                wsProfileCommandDataNode.add(m_commandLineData.get(string));
                continue;
            }
            if (string.equalsIgnoreCase("omitAction")) {
                wsProfileCommandDataDmgr.add("-omitAction");
                wsProfileCommandDataDmgr.add(m_commandLineData.get(string));
                continue;
            }
            if (string.equalsIgnoreCase("nodeOmitAction")) {
                wsProfileCommandDataNode.add("-omitAction");
                wsProfileCommandDataNode.add(m_commandLineData.get(string));
                continue;
            }
            if (string.equalsIgnoreCase("isDefault")) {
                wsProfileCommandDataDmgr.add(S_DASH + string);
                continue;
            }
            if (string.equalsIgnoreCase("defaultPorts")) {
                wsProfileCommandDataDmgr.add(S_DASH + string);
                wsProfileCommandDataDmgr.add(m_commandLineData.get(string));
                continue;
            }
            if (string.equalsIgnoreCase("validatePorts")) {
                wsProfileCommandDataDmgr.add(S_DASH + string);
                wsProfileCommandDataDmgr.add(m_commandLineData.get(string));
                continue;
            }
            if (string.equalsIgnoreCase("startingPort")) {
                wsProfileCommandDataDmgr.add(S_DASH + string);
                wsProfileCommandDataDmgr.add(m_commandLineData.get(string));
                continue;
            }
            if (string.equalsIgnoreCase("nodeStartingPort")) {
                wsProfileCommandDataDmgr.add(S_DASH + string);
                wsProfileCommandDataDmgr.add(m_commandLineData.get(string));
                continue;
            }
            if (string.equalsIgnoreCase("portsFile")) {
                wsProfileCommandDataDmgr.add(S_DASH + string);
                wsProfileCommandDataDmgr.add(m_commandLineData.get(string));
                continue;
            }
            if (string.equalsIgnoreCase("nodePortsFile")) {
                wsProfileCommandDataDmgr.add(S_DASH + string);
                wsProfileCommandDataDmgr.add(m_commandLineData.get(string));
                continue;
            }
            wsProfileCommandDataDmgr.add(S_DASH + string);
            wsProfileCommandDataNode.add(S_DASH + string);
            if (m_commandLineData.get(string).equals(S_EMPTY)) continue;
            wsProfileCommandDataDmgr.add(m_commandLineData.get(string));
            wsProfileCommandDataNode.add(m_commandLineData.get(string));
        }
        string2 = string4 + File.separator + "properties";
        wsProfileCommandDataDmgr.add("-profilePath");
        wsProfileCommandDataDmgr.add(string4);
        wsProfileCommandDataNode.add("-profilePath");
        wsProfileCommandDataNode.add(string3);
        wsProfileCommandDataDmgr.add("-nodeProfilePath");
        wsProfileCommandDataDmgr.add(string3);
        wsProfileCommandDataNode.add("-dmgrProfilePath");
        wsProfileCommandDataNode.add(string4);
        string = string2 + File.separator + "portdef.props";
        String string5 = string2 + File.separator + "nodeportdef.props";
        wsProfileCommandDataNode.add("-portsFile");
        wsProfileCommandDataNode.add(string);
        wsProfileCommandDataNode.add("-nodePortsFile");
        wsProfileCommandDataNode.add(string5);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "buildCommandData", "Generated Command data Dmgr: " + wsProfileCommandDataDmgr);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "buildCommandData", "Generated Command data Node: " + wsProfileCommandDataNode);
        LOGGER.exiting(WSConfigCreator.class.getName(), "buildCommandData");
    }

    private static Map convertIncomingCommandLineToCommandLineArguments(String[] stringArray) {
        LOGGER.entering(WSConfigCreator.class.getName(), "convertIncomingCommandLineToCommandLineArguments");
        if (stringArray.length == 0) {
            return new Hashtable();
        }
        if (!stringArray[0].startsWith(S_DASH)) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "buildCommandData", "Invalid incoming command line");
            LOGGER.exiting(WSConfigCreator.class.getName(), "convertIncomingCommandLineToCommandLineArguments");
            return new Hashtable();
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n].substring(S_DASH.length());
            String string2 = WSConfigCreator.getArgumentValues(stringArray, n);
            hashtable.put(string, string2);
            n = n + argCounter + 1;
        }
        LOGGER.exiting(WSConfigCreator.class.getName(), "convertIncomingCommandLineToCommandLineArguments");
        return hashtable;
    }

    private static String getArgumentValues(String[] stringArray, int n) {
        String string;
        LOGGER.entering(WSConfigCreator.class.getName(), "getArgumentValues");
        String string2 = S_EMPTY;
        argCounter = 0;
        for (int i = n + 1; i < stringArray.length && !(string = stringArray[i]).startsWith(S_DASH); ++i) {
            string2 = string2 + string + S_SPACE;
            ++argCounter;
        }
        LOGGER.exiting(WSConfigCreator.class.getName(), "getArgumentValues");
        return string2.trim();
    }

    private static void runWSProfile() {
        int n;
        LOGGER.entering(WSConfigCreator.class.getName(), "runWSProfile");
        int n2 = wsProfileCommandDataDmgr.size();
        int n3 = wsProfileCommandDataNode.size();
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n3];
        int n4 = wsProfileCommandDataNode.indexOf("-templatePath");
        for (n = 0; n < n2; ++n) {
            stringArray[n] = (String)wsProfileCommandDataDmgr.get(n);
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runWSProfile", "Generated WSProfileCommand Dmgr: " + stringArray.toString());
        for (n = 0; n < n3; ++n) {
            stringArray2[n] = (String)wsProfileCommandDataNode.get(n);
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runWSProfile", "Generated WSProfileCommand Node: " + stringArray2.toString());
        returnCodeDmgr = WSProfileCLI.mainForInProcessCalls(stringArray);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runWSProfile", "Return code for Cell dmgr operation: " + returnCodeDmgr);
        WSConfigCreator.setupEnvironment((String)wsProfileCommandDataNode.get(n4 + 1));
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runWSProfile", "Reinitializing DVM for cell-node creation");
        DefaultValueManagerUtils.reinitialize();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runWSProfile", "Reinitializing ValidationManager for cell-node creation");
        ValidationManagerUtils.reinitialize();
        returnCodeNode = WSProfileCLI.mainForInProcessCalls(stringArray2);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runWSProfile", "Return code for Cell node operation: " + returnCodeNode);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runWSProfile", "WSProfile Command Execution return code DMGR: " + returnCodeDmgr);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runWSProfile", "WSProfile Command Execution return code NODE: " + returnCodeNode);
        if (returnCodeDmgr == 1 || returnCodeNode == 1) {
            returnCode = 1;
        } else if (returnCodeDmgr == 2 || returnCodeNode == 2) {
            returnCode = 2;
        } else if (returnCodeDmgr == 0 && returnCodeNode == 0) {
            returnCode = 0;
        }
        LOGGER.exiting(WSConfigCreator.class.getName(), "runWSProfile");
    }

    private static void initLogger(String[] stringArray) {
        try {
            LOGGER = new LogInitializer(stringArray).initCMTLoggerFactory(WSProfileCLI.class);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            System.exit(1);
        }
    }
}

