/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.anttasks;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ChangeFileEncoding
extends Task {
    private boolean verbose = false;
    private String pathname = null;
    private String currentEncoding = null;
    private String newEncoding = null;
    private File file = null;

    public void setVerbose(boolean bl) {
        this.verbose = bl;
        this.println("Setting verbose to TRUE");
    }

    public void setPathname(String string) {
        this.pathname = string;
        this.println("Setting pathname to " + string);
    }

    public void setCurrentEncoding(String string) {
        this.currentEncoding = string;
        this.println("Setting current encoding to " + string);
    }

    public void setNewEncoding(String string) {
        this.newEncoding = string;
        this.println("Setting new encoding to " + string);
    }

    public void execute() throws BuildException {
        this.println("Converting encoding for file " + this.pathname + " from " + this.currentEncoding + " to " + this.newEncoding);
        this.println("JVM file encoding: " + System.getProperty("file.encoding"));
        try {
            this.validatePathname();
            this.convertEncoding();
        }
        catch (Throwable throwable) {
            if (this.verbose) {
                throwable.printStackTrace();
            }
            throw new BuildException(throwable);
        }
        this.println("exiting execute");
    }

    private void validatePathname() throws Exception {
        this.println("Validating pathname: " + this.pathname);
        if (this.pathname == null) {
            throw new Exception("ERROR - pathname not specified");
        }
        this.file = new File(this.pathname);
        if (!this.file.exists() || !this.file.isFile()) {
            throw new Exception("ERROR - File " + this.file + " is not a valid file.");
        }
        this.println("Done validating pathname");
    }

    private void convertEncoding() throws Exception {
        Vector<String> vector = new Vector<String>();
        this.println("Begin reading file: " + this.file);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(this.file), this.currentEncoding);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            this.println("read line: " + string);
            vector.add(string);
        }
        this.println("Done reading file.");
        bufferedReader.close();
        this.println("Begin deleting file");
        this.file.delete();
        this.println("Done deleting file");
        this.println("Begin writing file. ");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), this.newEncoding);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        for (int i = 0; i < vector.size(); ++i) {
            string = vector.elementAt(i).toString();
            this.println("writing line: " + string);
            bufferedWriter.write(string + "\n");
        }
        bufferedWriter.close();
        this.println("Done writing file.");
    }

    private void println(String string) {
        if (this.verbose) {
            System.out.println("-> " + string);
        }
    }
}

