/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.anttasks;

import com.ibm.ws390.utility.ws390uuid;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class CreateUUIDAnt
extends Task {
    private boolean verbose = false;
    private String pathname = null;
    private File file = null;
    private static final String ENCODING = "ISO8859_1";
    private static final String EYE_CATCHER = "ISHOULDINSERTUUIDHERE";
    private static final int EYE_CATCHER_LENGTH = "ISHOULDINSERTUUIDHERE".length();
    private static Hashtable keyTable = new Hashtable(11);

    public void setVerbose(boolean bl) {
        this.verbose = bl;
        this.println("Setting verbose to TRUE");
    }

    public void setPathname(String string) {
        this.pathname = string;
        this.println("Setting pathname to " + string);
    }

    public void execute() throws BuildException {
        System.out.println("Creating UUID for file: " + this.pathname);
        this.println("entering execute");
        try {
            this.validatePathname();
            this.findAndReplace();
        }
        catch (Throwable throwable) {
            if (this.verbose) {
                throwable.printStackTrace();
            }
            throw new BuildException(throwable);
        }
        this.println("exiting execute");
    }

    private void validatePathname() throws Exception {
        this.println("Validating pathname: " + this.pathname);
        if (this.pathname == null) {
            throw new Exception("ERROR - pathname not specified");
        }
        this.file = new File(this.pathname);
        if (!this.file.exists() || !this.file.isFile()) {
            throw new Exception("ERROR - File " + this.file + " is not a valid file.");
        }
        this.println("Done validating pathname");
    }

    private void findAndReplace() throws Exception {
        Object object;
        Vector<String> vector = new Vector<String>(60, 20);
        boolean bl = false;
        this.println("Find And Replace for file: " + this.file);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(this.file), ENCODING);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string = "";
        while ((string = bufferedReader.readLine()) != null) {
            if (string.indexOf(EYE_CATCHER) != -1) {
                bl = true;
                object = this.generateUUID(string);
                this.println("Found Eye Catcher in: " + string);
                string = this.replace(string, (String)object);
            }
            this.println("adding line to output: " + string);
            vector.add(string);
            this.println(String.valueOf(vector.size()));
        }
        this.println("Done replacing.");
        bufferedReader.close();
        if (bl) {
            this.println("Changes made to input file. ");
            object = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), ENCODING);
            BufferedWriter bufferedWriter = new BufferedWriter((Writer)object);
            int n = vector.size();
            this.println("Size of ov = " + n);
            for (int i = 0; i < n; ++i) {
                string = vector.elementAt(i).toString();
                bufferedWriter.write(string + "\n");
            }
            bufferedWriter.close();
            this.println("Done outputting. ");
        } else {
            this.println("No Change Needed for file " + this.file);
        }
    }

    private String replace(String string, String string2) {
        int n = string.indexOf(EYE_CATCHER);
        int n2 = n + EYE_CATCHER_LENGTH;
        if (string.charAt(n2) != '\"') {
            ++n2;
        }
        String string3 = string.substring(0, n) + string2 + string.substring(n2);
        this.println("Ret = " + string3);
        return string3;
    }

    private String generateUUID(String string) {
        int n = string.indexOf(EYE_CATCHER);
        ws390uuid ws390uuid2 = null;
        if (string.charAt(n + EYE_CATCHER_LENGTH) != '\"') {
            String string2 = string.substring(n, n + EYE_CATCHER_LENGTH + 1);
            this.println("Marked EyeCatcher = " + string2);
            ws390uuid2 = (ws390uuid)keyTable.get(string2);
            if (ws390uuid2 == null) {
                ws390uuid2 = new ws390uuid();
                keyTable.put(string2, ws390uuid2);
                this.println("Generated UUID of " + ws390uuid2);
            } else {
                this.println("Using previously generated UUID: " + ws390uuid2);
            }
        } else {
            ws390uuid2 = new ws390uuid();
            this.println("Generated UUID of " + ws390uuid2);
        }
        this.println("uuid is " + ws390uuid2);
        return ws390uuid2.toString();
    }

    private void println(String string) {
        if (this.verbose) {
            System.out.println("-> " + string);
        }
    }
}

