/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.anttasks;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class DebugPortResolver
extends Task {
    private String m_sDebugPortKey = null;
    private String m_sPortdefPath = null;
    private String m_sTemplatePortdefPath = null;
    private String m_sReferencePortName = null;
    private String m_sErrorMessage = "";
    private static final String S_MISSING_DEBUG_PORT_KEY_PARAMETER = "The debug port key parameter is missing: ";
    private static final String S_MISSING_REFERENCE_PORT_NAME_PARAMETER = "The reference port name parameter is missing: ";
    private static final String S_MISSING_PORT_DEF_PATH_PARAMETER = "The debug port def path parameter is missing.";
    private static final String S_MISSING_PORT_DEF_PATH_INVALID_PARAMETER = "The debug port def path parameter is invalid: ";
    private static final String S_MISSING_TEMPLATE_PORT_DEF_PATH_PARAMETER = "The template debug port def path parameter is missing.";
    private static final String S_MISSING_TEMPLATE_PORT_DEF_PATH_INVALID_PARAMETER = "The template debug port def path parameter is invalid: ";
    private static final String S_EMPTY = "";
    private static final int DEFAULT_DEBUG_PORT = 7777;
    private static final Logger LOGGER = LoggerFactory.createLogger(DebugPortResolver.class);
    private static final String S_CLASS_NAME = DebugPortResolver.class.getName();

    public void init() throws BuildException {
        super.init();
    }

    private void doLog(String string) {
        if (string == null) {
            return;
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "doLog", string);
    }

    public void execute() throws BuildException {
        this.doLog("Executing parent execute()...");
        super.execute();
        this.doLog("Executing DebugPortResolver.execute()...");
        if (!this.doAllParamsCheckOutOk()) {
            this.doLog("Parameter check failed: " + this.m_sErrorMessage);
            throw new BuildException(this.m_sErrorMessage, this.getLocation());
        }
        this.doLog("Parameter check success.");
        int n = this.computeDebugPort();
        if (n > 0) {
            String string = S_EMPTY + n;
            System.setProperty(this.m_sDebugPortKey, string);
            this.getProject().setNewProperty(this.m_sDebugPortKey, S_EMPTY + string);
            this.doLog(" m_sDebugPortKey=" + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int computeDebugPort() {
        int n = -1;
        int n2 = -1;
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        int n3 = -1;
        try {
            Properties properties = new Properties();
            this.doLog("Loading port def file: " + this.m_sPortdefPath);
            inputStream = new FileInputStream(this.m_sPortdefPath);
            properties.load(inputStream);
            this.doLog("Port def prop=" + properties.size());
            String string = properties.getProperty(this.m_sReferencePortName);
            this.doLog("referencePort=" + string);
            n = Integer.parseInt(string);
            Properties properties2 = new Properties();
            this.doLog("Loading template port def file: " + this.m_sPortdefPath);
            inputStream2 = new FileInputStream(this.m_sTemplatePortdefPath);
            properties2.load(inputStream2);
            this.doLog("Template port def prop=" + properties2.size());
            String string2 = properties2.getProperty(this.m_sReferencePortName);
            this.doLog("seedReferencePort=" + string2);
            n2 = Integer.parseInt(string2);
            if (n > 0 && n2 > 0 && n >= n2) {
                n3 = 7777 + n - n2;
                this.doLog("Computed debug port=" + n3);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (Exception exception) {}
            }
        }
        return n3;
    }

    public void setDebugPortKey(String string) {
        this.m_sDebugPortKey = string;
    }

    public void setPortdefPath(String string) {
        this.m_sPortdefPath = string;
        if (this.m_sPortdefPath != null) {
            this.m_sPortdefPath = this.m_sPortdefPath.replace('\\', '/');
        }
    }

    public void setReferencePortName(String string) {
        this.m_sReferencePortName = string;
    }

    public void setTemplatePortdefPath(String string) {
        this.m_sTemplatePortdefPath = string;
        if (this.m_sTemplatePortdefPath != null) {
            this.m_sTemplatePortdefPath = this.m_sTemplatePortdefPath.replace('\\', '/');
        }
    }

    private boolean doAllParamsCheckOutOk() {
        if (this.m_sDebugPortKey == null || this.m_sDebugPortKey.trim().equals(S_EMPTY)) {
            this.m_sErrorMessage = S_MISSING_DEBUG_PORT_KEY_PARAMETER + this.m_sDebugPortKey;
            return false;
        }
        this.doLog("doAllParamsCheckOutOk(): debug port key ok: " + this.m_sDebugPortKey);
        if (this.m_sReferencePortName == null || this.m_sReferencePortName.trim().equals(S_EMPTY)) {
            this.m_sErrorMessage = S_MISSING_REFERENCE_PORT_NAME_PARAMETER + this.m_sReferencePortName;
            return false;
        }
        this.doLog("doAllParamsCheckOutOk(): reference port name ok: " + this.m_sReferencePortName);
        if (this.m_sPortdefPath == null || this.m_sPortdefPath.trim().equals(S_EMPTY)) {
            this.m_sErrorMessage = S_MISSING_PORT_DEF_PATH_PARAMETER;
            return false;
        }
        File file = new File(this.m_sPortdefPath);
        if (!file.exists() || !file.isFile()) {
            this.m_sErrorMessage = S_MISSING_PORT_DEF_PATH_INVALID_PARAMETER + this.m_sPortdefPath;
            return false;
        }
        this.doLog("doAllParamsCheckOutOk(): port def path ok: " + this.m_sPortdefPath);
        if (this.m_sTemplatePortdefPath == null) {
            this.m_sErrorMessage = S_MISSING_TEMPLATE_PORT_DEF_PATH_PARAMETER;
            return false;
        }
        file = new File(this.m_sTemplatePortdefPath);
        if (!file.exists() || !file.isFile()) {
            this.m_sErrorMessage = S_MISSING_TEMPLATE_PORT_DEF_PATH_INVALID_PARAMETER + this.m_sTemplatePortdefPath;
            return false;
        }
        this.doLog("doAllParamsCheckOutOk(): template port def path ok: " + this.m_sTemplatePortdefPath);
        return true;
    }
}

