/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.anttasks;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class GetStringRegExpAntTask
extends Task {
    private String m_sString = null;
    private String m_sRegExp = null;
    private String m_sProperty = null;
    private String m_sErrorMessage = new String();
    private static final Logger LOGGER = LoggerFactory.createLogger(GetStringRegExpAntTask.class);
    private static final String S_CLASS_NAME = GetStringRegExpAntTask.class.getName();
    private static final String S_NO_STRING = "Missing string property";
    private static final String S_NO_REG_EXP = "Missing regular expression property";
    private static final String S_NO_PROPERTY = "Property name for the property that holds the result must be specified";

    public void init() throws BuildException {
        LOGGER.entering(GetStringRegExpAntTask.class.getName(), "init");
        super.init();
        this.m_sString = null;
        this.m_sRegExp = null;
        this.m_sProperty = null;
        LOGGER.exiting(GetStringRegExpAntTask.class.getName(), "init");
    }

    public void execute() throws BuildException {
        LOGGER.entering(GetStringRegExpAntTask.class.getName(), "execute");
        super.execute();
        if (!this.doAllParamsCheckOutOk()) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "Incorrect parameters specified for the GetStringRegExpAntTask");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "Error location is: " + this.getLocation().toString());
            throw new BuildException(this.m_sErrorMessage, this.getLocation());
        }
        String string = null;
        Pattern pattern = Pattern.compile(this.m_sRegExp);
        Matcher matcher = pattern.matcher(this.m_sString);
        if (matcher.find()) {
            string = matcher.group();
        }
        this.getProject().setNewProperty(this.m_sProperty, string);
        LOGGER.exiting(GetStringRegExpAntTask.class.getName(), "execute");
    }

    public void setString(String string) {
        LOGGER.entering(GetStringRegExpAntTask.class.getName(), "setString");
        this.m_sString = string;
        LOGGER.exiting(GetStringRegExpAntTask.class.getName(), "setString");
    }

    public void setRegExp(String string) {
        LOGGER.entering(GetStringRegExpAntTask.class.getName(), "setRegExp");
        this.m_sRegExp = string;
        LOGGER.exiting(GetStringRegExpAntTask.class.getName(), "setRegExp");
    }

    public void setProperty(String string) {
        LOGGER.entering(GetStringRegExpAntTask.class.getName(), "setProperty");
        this.m_sProperty = string;
        LOGGER.exiting(GetStringRegExpAntTask.class.getName(), "setProperty");
    }

    private boolean doAllParamsCheckOutOk() {
        LOGGER.entering(GetStringRegExpAntTask.class.getName(), "doAllParamsCheckOutOk");
        if (this.m_sString == null) {
            this.m_sErrorMessage = S_NO_STRING;
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAllParamsCheckOutOk", "Param check failed, error message is: " + this.m_sErrorMessage);
            LOGGER.exiting(GetStringRegExpAntTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        if (this.m_sRegExp == null) {
            this.m_sErrorMessage = S_NO_REG_EXP;
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAllParamsCheckOutOk", "Param check failed, error message is: " + this.m_sErrorMessage);
            LOGGER.exiting(GetStringRegExpAntTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        if (this.m_sProperty == null) {
            this.m_sErrorMessage = S_NO_PROPERTY;
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAllParamsCheckOutOk", "Param check failed, error message is: " + this.m_sErrorMessage);
            LOGGER.exiting(GetStringRegExpAntTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        LOGGER.exiting(GetStringRegExpAntTask.class.getName(), "doAllParamsCheckOutOk");
        return true;
    }
}

