/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.anttasks;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import com.ibm.ws.install.configmanager.utils.ArrayUtils;
import com.ibm.ws.install.configmanager.utils.ClassPathModifier;
import com.ibm.ws.profile.anttasks.PortResolverRecommendedValues;
import com.ibm.ws.profile.utils.PortResolutionUtils;
import com.ibm.wsspi.profile.WSProfileException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class PortResolver
extends Task {
    private int m_nMinimumPortNumber = 0;
    private File m_WASRegistryFile = null;
    private File m_WAS_HOME = null;
    private String m_sPortKeys = null;
    private String m_sPortKeyValuePairs = null;
    private String m_sErrorMessage = "";
    private File m_reservedPortsFile = null;
    private static final String S_INVALID_MINIMUM_PORT_PARAMETER = "The minimum port number is not valid.";
    private static final String S_INVALID_WAS_HOME_LIB_DIR = "Can not locate the lib directory under WebSphere install location directory.";
    private static final String S_MISSING_PORT_KEYS_PARAMETER = "The port keys parameter is missing.";
    private static final String S_LIB = "lib";
    private static final String[] ARR_DEPENDENT_JARS = new String[]{"admin.jar", "wasproduct.jar"};
    private static final String S_EMPTY = "";
    private static final String S_SPACES = " \t\n\r\f";
    private static final String S_EQUAL = "=";
    private static final Logger LOGGER = LoggerFactory.createLogger(PortResolver.class);
    private static final String S_CLASS_NAME = PortResolver.class.getName();

    public void init() throws BuildException {
        super.init();
    }

    public void execute() throws BuildException {
        super.execute();
        if (!this.doAllParamsCheckOutOk()) {
            throw new BuildException(this.m_sErrorMessage, this.getLocation());
        }
        Hashtable hashtable = null;
        if (this.isSequentialPortAssignment()) {
            hashtable = this.sequentiallyAssignPorts(this.convertPortKeysToArray(), this.m_nMinimumPortNumber);
        } else {
            try {
                int[] nArray = this.determineReservedPorts();
                hashtable = PortResolutionUtils.recommendPorts(this.convertPortKeysToArray(), this.m_nMinimumPortNumber, this.m_WASRegistryFile, nArray);
            }
            catch (WSProfileException wSProfileException) {
                throw new BuildException((Throwable)wSProfileException);
            }
        }
        this.setEnvironmentWithPortMappings(hashtable);
    }

    public void setMinimumPortNumber(int n) {
        this.m_nMinimumPortNumber = n;
    }

    public void setWASRegistryFile(File file) {
        this.m_WASRegistryFile = file;
    }

    public void setWAS_HOME(File file) {
        this.m_WAS_HOME = file;
    }

    public void setPortKeys(String string) {
        this.m_sPortKeys = string;
    }

    public void setPortKeyValuePairs(String string) {
        this.m_sPortKeyValuePairs = string;
    }

    public void setReservedPortsFile(File file) {
        LOGGER.entering(PortResolverRecommendedValues.class.getName(), "setReservedPortsFile");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "setReservedPortsFile", "The reserved ports file is: " + file.toString());
        this.m_reservedPortsFile = file;
        LOGGER.exiting(PortResolverRecommendedValues.class.getName(), "setReservedPortsFile");
    }

    private boolean doAllParamsCheckOutOk() {
        if (this.m_nMinimumPortNumber < 0) {
            this.m_sErrorMessage = S_INVALID_MINIMUM_PORT_PARAMETER;
            return false;
        }
        try {
            String string = this.m_WAS_HOME.getAbsolutePath() + File.separator + S_LIB;
            for (int i = 0; i < ARR_DEPENDENT_JARS.length; ++i) {
                ClassPathModifier.addFileToClassPath(string + File.separator + ARR_DEPENDENT_JARS[i]);
            }
        }
        catch (IOException iOException) {
            this.m_sErrorMessage = S_INVALID_WAS_HOME_LIB_DIR;
            return false;
        }
        if (this.m_sPortKeys == null || this.m_sPortKeys.trim().equals(S_EMPTY)) {
            this.m_sErrorMessage = S_MISSING_PORT_KEYS_PARAMETER;
            return false;
        }
        return true;
    }

    private String[] convertPortKeysToArray() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.m_sPortKeys, S_SPACES);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreElements()) {
            String string = (String)stringTokenizer.nextElement();
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    private void setEnvironmentWithPortMappings(Hashtable hashtable) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String string2 = hashtable.get(string).toString();
            stringBuffer.append(string + S_EQUAL + string2 + "\n");
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "setEnvironmentWithPortMappings", "Returning port key value pairs as property, " + this.m_sPortKeyValuePairs + S_EQUAL + stringBuffer.toString());
        this.getProject().setNewProperty(this.m_sPortKeyValuePairs, stringBuffer.toString());
        System.setProperty(this.m_sPortKeyValuePairs, stringBuffer.toString());
    }

    private int[] determineReservedPorts() throws WSProfileException {
        if (this.m_reservedPortsFile == null || !this.m_reservedPortsFile.exists()) {
            return new int[0];
        }
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(this.m_reservedPortsFile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            LogUtils.logException(LOGGER, fileNotFoundException);
            throw new WSProfileException(fileNotFoundException.getMessage(), fileNotFoundException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            LogUtils.logException(LOGGER, iOException);
            throw new WSProfileException(iOException.getMessage(), iOException.getLocalizedMessage());
        }
        String[] stringArray = properties.values().toArray(new String[0]);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "determineReservedPorts", "Reserved Ports: " + ArrayUtils.join(",", stringArray));
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        return nArray;
    }

    private boolean isSequentialPortAssignment() {
        boolean bl = false;
        if (PlatformConstants.isCurrentPlatformOS400()) {
            bl = true;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "isSequentialPortAssignment", "Use sequential port assignment=" + bl);
        return bl;
    }

    private Hashtable sequentiallyAssignPorts(String[] stringArray, int n) {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        int n2 = n;
        for (int i = 0; i < stringArray.length; ++i) {
            hashtable.put(stringArray[i], new Integer(n2));
            ++n2;
        }
        return hashtable;
    }
}

