/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.anttasks;

import com.ibm.io.file.NativeFile;
import com.ibm.io.file.exception.AccessDeniedException;
import com.ibm.io.file.exception.FileNotFoundException;
import com.ibm.io.file.exception.NativeFileIOException;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.bootstrap.WSProfileProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class UNZIPAntTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.createLogger(UNZIPAntTask.class);
    private static final String S_CLASS_NAME = UNZIPAntTask.class.getName();
    private static final String S_FILE_INVALID = "The specified file is invalid: ";
    private static final String S_FILE_PARM_NOT_FOUND = "The specified file parameter is not found.";
    private static final String S_OUTPUT_DIR_PARM_NOT_FOUND = "The specified output directory parameter is not found.";
    private static final String S_NATIVE_FILE_LIB_DIRECTORY = "com.ibm.io.file.nativefile.libdir";
    private static final String S_UTF_8 = "UTF-8";
    public static final int BUFFER_SIZE = 1024;
    private File m_fileZipFile = null;
    private File m_fileOutputDir = null;
    private File m_fileNativeFileLibDirectory = null;
    private String m_sErrorMessage = new String();
    private byte[] buffer = new byte[1024];

    public void init() throws BuildException {
        LOGGER.entering(UNZIPAntTask.class.getName(), "init");
        super.init();
        this.m_fileOutputDir = null;
        this.m_fileZipFile = null;
        this.m_fileNativeFileLibDirectory = null;
        LOGGER.exiting(UNZIPAntTask.class.getName(), "init");
    }

    public void execute() throws BuildException {
        LOGGER.entering(UNZIPAntTask.class.getName(), "execute");
        super.execute();
        if (!this.doAllParamsCheckOutOk()) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "Parameter validation failed!");
            throw new BuildException(this.m_sErrorMessage, this.getLocation());
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "execute", "Parameter validation passed.");
        try {
            this.unzipToThisDirectory(this.m_fileZipFile, this.m_fileOutputDir);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", fileNotFoundException.getMessage());
            throw new BuildException((Throwable)fileNotFoundException, this.getLocation());
        }
        catch (IOException iOException) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", iOException.getMessage());
            throw new BuildException((Throwable)iOException, this.getLocation());
        }
        catch (NullPointerException nullPointerException) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", " Output directory: " + this.m_fileOutputDir + " - Zip file: " + this.m_fileZipFile);
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", nullPointerException.getMessage());
            throw new BuildException((Throwable)nullPointerException, this.getLocation());
        }
        LOGGER.exiting(UNZIPAntTask.class.getName(), "execute");
    }

    public void setFile(File file) {
        LOGGER.entering(UNZIPAntTask.class.getName(), "setFile");
        this.m_fileZipFile = file;
        LOGGER.exiting(UNZIPAntTask.class.getName(), "setFile");
    }

    public void setOutputDir(File file) {
        LOGGER.entering(UNZIPAntTask.class.getName(), "setOutputDir");
        this.m_fileOutputDir = file;
        LOGGER.exiting(UNZIPAntTask.class.getName(), "setOutputDir");
    }

    public void setNativeFileLibDirectory(File file) {
        LOGGER.entering(UNZIPAntTask.class.getName(), "setNativeFileLibDirectory");
        this.m_fileNativeFileLibDirectory = file;
        LOGGER.exiting(UNZIPAntTask.class.getName(), "setNativeFileLibDirectory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzipToThisDirectory(File file, File file2) throws IOException, FileNotFoundException {
        LOGGER.entering(UNZIPAntTask.class.getName(), "unzipToThisDirectory");
        ZipFile zipFile = new ZipFile(file);
        try {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                this.unzipEntry(zipEntry, zipFile);
                String string = new String(zipEntry.getExtra(), S_UTF_8);
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "unzipToThisDirectory", "The permission from the zip entry is " + string);
                this.setPermissions(new File(this.m_fileOutputDir, zipEntry.getName()), string);
            }
        }
        finally {
            zipFile.close();
        }
        LOGGER.exiting(UNZIPAntTask.class.getName(), "unzipToThisDirectory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzipEntry(ZipEntry zipEntry, ZipFile zipFile) throws IOException {
        LOGGER.entering(UNZIPAntTask.class.getName(), "unzipToThisDirectory");
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        File file = new File(this.m_fileOutputDir, zipEntry.getName());
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "unzipEntry", "Performing mkdir: Creating parent directories.");
        file.getParentFile().mkdirs();
        if (zipEntry.isDirectory()) {
            file.mkdir();
            LOGGER.exiting(UNZIPAntTask.class.getName(), "unzipToThisDirectory");
            return;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            int n = 0;
            while ((n = inputStream.read(this.buffer)) > -1) {
                fileOutputStream.write(this.buffer, 0, n);
            }
        }
        finally {
            fileOutputStream.close();
            inputStream.close();
        }
        LOGGER.exiting(UNZIPAntTask.class.getName(), "unzipToThisDirectory");
    }

    private void setPermissions(File file, String string) throws BuildException {
        LOGGER.entering(UNZIPAntTask.class.getName(), "setPermissions");
        LOGGER.logp(Level.WARNING, S_CLASS_NAME, "setPermissions", "setPermissions - file name: " + file.toString());
        LOGGER.logp(Level.WARNING, S_CLASS_NAME, "setPermissions", "setPermissions - permissions: " + string);
        try {
            String string2 = new WSProfileProperties().getProperty("WS_NATIVE_FILE_JNI_DIRECTORY");
            NativeFile.initializeLibrary(new File(string2), null, true);
            if (!NativeFile.isNativeFileFunctionalityAvailable()) {
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "setPermissions", "NativeFile functionality is not available...Proceeding without proper permissions support.....");
            }
            NativeFile nativeFile = new NativeFile(file.getAbsolutePath());
            char[] cArray = string.toCharArray();
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "setPermissions", "setPermissions - permissions as character array: " + String.valueOf(cArray));
            nativeFile.setUserPermissions(Character.getNumericValue(cArray[0]));
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "setPermissions", "setPermissions - user : " + nativeFile.getUserPermissions());
            nativeFile.setGroupPermissions(Character.getNumericValue(cArray[1]));
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "setPermissions", "setPermissions - group : " + nativeFile.getGroupPermissions());
            nativeFile.setWorldPermissions(Character.getNumericValue(cArray[2]));
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "setPermissions", "setPermissions - world : " + nativeFile.getWorldPermissions());
        }
        catch (AccessDeniedException accessDeniedException) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "setPermissions", "Access denied: " + file);
            throw new BuildException(accessDeniedException.getMessage(), (Throwable)accessDeniedException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "setPermissions", "File not found: " + file);
            throw new BuildException(fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
        }
        catch (NativeFileIOException nativeFileIOException) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "setPermissions", "IO exception: " + file);
            throw new BuildException(nativeFileIOException.getMessage(), (Throwable)nativeFileIOException);
        }
        catch (IOException iOException) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "setPermissions", "IO exception: " + file);
            throw new BuildException(iOException.getMessage(), (Throwable)iOException);
        }
        LOGGER.exiting(UNZIPAntTask.class.getName(), "setPermissions");
    }

    private boolean doAllParamsCheckOutOk() {
        LOGGER.entering(UNZIPAntTask.class.getName(), "doAllParamsCheckOutOk");
        if (this.m_fileZipFile == null) {
            this.m_sErrorMessage = S_FILE_PARM_NOT_FOUND;
            LOGGER.exiting(UNZIPAntTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        if (this.m_fileOutputDir == null) {
            this.m_sErrorMessage = S_OUTPUT_DIR_PARM_NOT_FOUND;
            LOGGER.exiting(UNZIPAntTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        if (!this.m_fileZipFile.isFile()) {
            this.m_sErrorMessage = S_FILE_INVALID + this.m_fileZipFile.getPath();
            LOGGER.exiting(UNZIPAntTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        LOGGER.exiting(UNZIPAntTask.class.getName(), "doAllParamsCheckOutOk");
        return true;
    }
}

