/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.anttasks;

import com.ibm.io.file.NativeFile;
import com.ibm.io.file.exception.FileNotFoundException;
import com.ibm.io.file.exception.NativeFileIOException;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.bootstrap.WSProfileProperties;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ZIPAntTask
extends Task {
    private File m_sDir = null;
    private Vector m_vfilesToExclude = null;
    private File m_sFile = null;
    private String m_sNativeFileLibDirectory = null;
    private String m_sErrorMessage = new String();
    private static final String S_NO_DIR = "Missing dir property";
    private static final String S_NO_FILE = "Missing file property";
    private static final String S_NOT_WRITABLE = "Insufficient permissions to write to dir";
    private static final int N_IO_BUFFER_SIZE = 4096;
    private static final String S_NATIVE_FILE_LIB_DIRECTORY = "com.ibm.io.file.nativefile.libdir";
    private static final String S_UTF_8 = "UTF-8";
    private static final String S_COMMA = ",";
    private static final char CHAR_FORWARD_SLASH = '/';
    private static final Logger LOGGER = LoggerFactory.createLogger(ZIPAntTask.class);
    private static final String S_CLASS_NAME = ZIPAntTask.class.getName();

    public void init() throws BuildException {
        super.init();
        this.m_sDir = null;
        this.m_sFile = null;
    }

    public void execute() throws BuildException {
        super.execute();
        if (!this.doAllParamsCheckOutOk()) {
            throw new BuildException(this.m_sErrorMessage, this.getLocation());
        }
        try {
            this.zipThisDirectoryToThisZIPFile(this.m_sDir, this.m_sFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new BuildException((Throwable)fileNotFoundException, this.getLocation());
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException, this.getLocation());
        }
        catch (NullPointerException nullPointerException) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", " dir: " + this.m_sDir + " ... file: " + this.m_sFile);
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", nullPointerException.getMessage());
            throw new BuildException((Throwable)nullPointerException, this.getLocation());
        }
    }

    public void setDir(File file) {
        this.m_sDir = file;
    }

    public void setFile(File file) {
        this.m_sFile = file;
    }

    public void setNativeFileLibDirectory(String string) {
        this.m_sNativeFileLibDirectory = string;
    }

    public void setFilesToExclude(String string) {
        this.m_vfilesToExclude = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string, S_COMMA);
        while (stringTokenizer.hasMoreTokens()) {
            this.m_vfilesToExclude.add(new File(stringTokenizer.nextToken().trim()));
        }
    }

    private void zipThisDirectoryToThisZIPFile(File file, File file2) throws IOException, FileNotFoundException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
        Vector vector = this.getFilesInDirectoryRecursive(file);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "zipThisDirectoryToThisZIPFile", "Backing up to file: " + file2.getAbsolutePath());
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "zipThisDirectoryToThisZIPFile", " Number of files to be zipped is: " + vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            File file3 = (File)vector.elementAt(i);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "zipThisDirectoryToThisZIPFile", "fileToZip: " + file3);
            if (this.m_vfilesToExclude.contains(file3)) continue;
            String string = file3.getAbsolutePath().substring(file.getAbsolutePath().length() + 1);
            String string2 = this.getPermissions(file3);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "zipThisDirectoryToThisZIPFile", "sThisEntryName: " + string);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "zipThisDirectoryToThisZIPFile", "sThisEntryPermissions: " + string2);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "zipThisDirectoryToThisZIPFile", "getBytes: " + string2.getBytes(S_UTF_8));
            ZipEntry zipEntry = new ZipEntry(string.replace(File.separatorChar, '/'));
            zipEntry.setExtra(string2.getBytes(S_UTF_8));
            zipOutputStream.putNextEntry(zipEntry);
            if (file3.isDirectory()) continue;
            FileInputStream fileInputStream = new FileInputStream(file3);
            this.transferInputStreamToOutputStreamCompletely(fileInputStream, zipOutputStream);
            fileInputStream.close();
        }
        zipOutputStream.close();
    }

    private String getPermissions(File file) throws BuildException {
        try {
            String string = new WSProfileProperties().getProperty("WS_NATIVE_FILE_JNI_DIRECTORY");
            NativeFile.initializeLibrary(new File(string), null, true);
            if (!NativeFile.isNativeFileFunctionalityAvailable()) {
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "getPermissions", "NativeFile functionality is not available");
                throw new BuildException();
            }
            NativeFile nativeFile = new NativeFile(file.getAbsolutePath());
            String string2 = Integer.toString(nativeFile.getUserPermissions());
            string2 = string2 + Integer.toString(nativeFile.getGroupPermissions());
            string2 = string2 + Integer.toString(nativeFile.getWorldPermissions());
            return string2;
        }
        catch (NativeFileIOException nativeFileIOException) {
            throw new BuildException((Throwable)nativeFileIOException);
        }
        catch (Exception exception) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "getPermissions", "Exception caught while getting file permissions!");
            throw new BuildException((Throwable)exception);
        }
    }

    private void transferInputStreamToOutputStreamCompletely(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[4096];
        int n = inputStream.read(byArray);
        while (n != -1) {
            outputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
    }

    private Vector getFilesInDirectoryRecursive(File file) {
        File[] fileArray = file.listFiles();
        Vector<File> vector = new Vector<File>();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                vector.add(new File(fileArray[i], "/"));
                vector.addAll(this.getFilesInDirectoryRecursive(fileArray[i]));
                continue;
            }
            vector.add(fileArray[i]);
        }
        return vector;
    }

    private boolean doAllParamsCheckOutOk() {
        if (this.m_sDir == null) {
            this.m_sErrorMessage = S_NO_DIR;
            return false;
        }
        if (this.m_sFile == null) {
            this.m_sErrorMessage = S_NO_FILE;
            return false;
        }
        if (!this.isWritable(this.m_sFile.getParentFile())) {
            this.m_sErrorMessage = S_NOT_WRITABLE;
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAllParamsCheckOutOk", "Insufficient permissions to write to dir:" + this.m_sFile.getParent());
            return false;
        }
        return true;
    }

    private boolean isWritable(File file) {
        File file2 = new File(file.getAbsolutePath() + File.separator + "tmp");
        boolean bl = false;
        try {
            bl = file2.createNewFile();
            if (bl) {
                file2.delete();
            }
        }
        catch (IOException iOException) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "isWritable", " dir: " + this.m_sDir + " ... file: " + this.m_sFile);
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "isWritable", iOException.getMessage());
        }
        return bl;
    }
}

