/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.bootstrap;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.WSProfileConstants;
import com.ibm.ws.profile.bootstrap.WSProfileProperties;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class LogInitializer {
    private String[] m_asArguments = null;
    private WSProfileProperties m_wspp = null;
    private static final String S_UNDERSCORE = "_";
    private static final String S_DOT_LOG = ".log";
    private static final String S_DASH = "-";

    public LogInitializer(String[] stringArray) throws FileNotFoundException, IOException {
        this.m_asArguments = stringArray;
        this.m_wspp = new WSProfileProperties();
    }

    public Logger initCMTLoggerFactory(Class clazz) throws IOException {
        String string = this.determineLogFileName();
        System.setProperty("WS_CMT_LOG_HOME", this.m_wspp.getProperty("WS_CMT_LOG_HOME"));
        if (!this.validateLogFile(string, this.m_wspp.getProperty("WS_CMT_LOG_HOME"))) {
            string = this.getDefaultLogFileName();
        }
        System.setProperty("WS_CMT_LOG_NAME", string);
        System.setProperty("WS_CMT_LOGLEVEL", this.m_wspp.getProperty("WS_WSPROFILE_LOG_LEVEL"));
        if (this.getAppendLogsValue()) {
            System.setProperty("WS_CMT_APPEND_LOGS", "true");
        }
        return LoggerFactory.reinitAndCreateLogger(clazz);
    }

    private boolean validateLogFile(String string, String string2) {
        File file = new File(string2);
        File file2 = new File(string2 + File.separator + string);
        try {
            if (!file.exists()) {
                file.mkdirs();
            }
            if (file2.exists()) {
                return true;
            }
            boolean bl = file2.createNewFile();
            if (bl) {
                file2.delete();
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public String determineLogFileName() {
        String string = new String();
        string = this.getCurrentProfileName() != null ? this.getCurrentProfileName() + S_UNDERSCORE + this.getCurrentModeName() + S_DOT_LOG : this.getDefaultLogFileName();
        return string;
    }

    public String getDefaultLogFileName() {
        String string = this.getCurrentModeName() + S_DOT_LOG;
        return string;
    }

    private String getCurrentModeName() {
        List<String> list = Arrays.asList(this.m_asArguments);
        for (int i = 0; i < WSProfileConstants.AS_AVAILABLE_CLI_MODES.length; ++i) {
            if (!list.contains(S_DASH + WSProfileConstants.AS_AVAILABLE_CLI_MODES[i])) continue;
            return WSProfileConstants.AS_AVAILABLE_CLI_MODES[i];
        }
        return "help";
    }

    private String getCurrentProfileName() {
        for (int i = 0; i < this.m_asArguments.length; ++i) {
            if (!this.m_asArguments[i].equals("-profileName") || i >= this.m_asArguments.length - 1 || this.m_asArguments[i + 1].startsWith(S_DASH)) continue;
            return this.m_asArguments[i + 1];
        }
        return null;
    }

    private boolean getAppendLogsValue() {
        for (int i = 0; i < this.m_asArguments.length; ++i) {
            if (!this.m_asArguments[i].equals("-appendLogs")) continue;
            return true;
        }
        return false;
    }
}

