/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.bootstrap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WSProfileProperties {
    private Properties m_properties = null;
    private static final String S_WSPROFILE_PROPERTIES_FILE_RELATIVE_PATH = "properties/wasprofile.properties";
    private static final Pattern PATTERN_MACRO_VARIABLE = Pattern.compile("^(.*)\\$\\{(.*?)\\}(.*)$");
    private static final String S_CHARS_TO_ESCAPE = "\\[]{}().*+^$&?|!<>";
    private static final String S_BACK_SLASH = "\\";
    private static final int N_MACRO_VARIABLE_EXTRA_GROUP_1_ID = 1;
    private static final int N_MACRO_VARIABLE_GROUP_ID = 2;
    private static final int N_MACRO_VARIABLE_EXTRA_GROUP_2_ID = 3;
    private static final String S_WASPROFILE_PROPERTIES_FILE_NOT_FOUND = "File wasprofile.properties could not be located.";

    public WSProfileProperties() throws FileNotFoundException, IOException {
        this.parsePropertiesFile();
    }

    public String getProperty(String string) {
        String string2;
        if (this.m_properties == null) {
            return null;
        }
        String string3 = string2 = this.m_properties.getProperty(string);
        Matcher matcher = PATTERN_MACRO_VARIABLE.matcher(string3);
        while (matcher.matches()) {
            String string4 = System.getProperty(matcher.group(2));
            String string5 = this.escapeSpecialRECharacters(string4);
            string3 = matcher.group(1) + matcher.replaceFirst(string5) + matcher.group(3);
            matcher = PATTERN_MACRO_VARIABLE.matcher(string3);
        }
        return string3;
    }

    private void parsePropertiesFile() throws FileNotFoundException, IOException {
        File file = this.getPropertiesFile();
        this.m_properties = new Properties();
        this.m_properties.load(new FileInputStream(file));
    }

    private File getPropertiesFile() throws FileNotFoundException {
        File file = this.getPropertiesFile("WAS_HOME");
        if (file != null) {
            return file;
        }
        file = this.getPropertiesFile("was.install.root");
        if (file == null) {
            throw new FileNotFoundException(S_WASPROFILE_PROPERTIES_FILE_NOT_FOUND);
        }
        return file;
    }

    private File getPropertiesFile(String string) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            return null;
        }
        if (!new File(string2, S_WSPROFILE_PROPERTIES_FILE_RELATIVE_PATH).exists()) {
            return null;
        }
        return new File(string2, S_WSPROFILE_PROPERTIES_FILE_RELATIVE_PATH);
    }

    private String escapeSpecialRECharacters(String string) {
        String string2 = new String();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            string2 = S_CHARS_TO_ESCAPE.indexOf(c) != -1 ? string2 + S_BACK_SLASH + c : string2 + c;
        }
        return string2;
    }
}

