/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.cli;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.logging.LoggerFactoryConstants;
import com.ibm.ws.profile.cli.CommandLineArgument;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.cli.output.OutputStreamHandler;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.registry.Profile;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;

public class WSProfileCLICheckProfileRegistryIntegrityInvoker
extends WSProfileCLIModeInvoker {
    private static final String S_EMPTY = "";
    private static final Vector V_EMPTY_VECTOR = new Vector();
    private static final Vector V_SINGLE_ENTRY_VECTOR = new Vector<String>(Arrays.asList(""));
    private static final CommandLineArgument[] ACLA_RESERVED_REQUIRED_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("validateRegistry", V_EMPTY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final String S_REGISTRY_CORRUPT = "WSProfile.WSProfileCLICheckProfileRegistryIntegrityInvoker.registryCorrupt";
    private static final Logger LOGGER = LoggerFactory.createLogger(WSProfileCLICheckProfileRegistryIntegrityInvoker.class);
    private static final String S_REGISTRY_VALID = "WSProfile.WSProfileCLICheckProfileRegistryIntegrityInvoker.noInvalidProfiles";
    private static final String S_REGISTRY_INVALID = "WSProfile.WSProfileCLICheckProfileRegistryIntegrityInvoker.someInvalidProfiles";

    public String getModeFlag() {
        LOGGER.entering(this.getClass().getName(), "getModeFlag");
        LOGGER.exiting(this.getClass().getName(), "getModeFlag");
        return "validateRegistry";
    }

    protected int executeWSProfileAccordingToMode() {
        LOGGER.entering(this.getClass().getName(), "invokeWSProfile");
        int n = 0;
        try {
            List list = WSProfile.validateRegistry(this.getProfileRegistryPath());
            if (list.size() == 0) {
                OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_REGISTRY_VALID));
            } else {
                OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_REGISTRY_INVALID));
                this.printProfileList(list);
            }
        }
        catch (WSProfileException wSProfileException) {
            LogUtils.logException(LOGGER, wSProfileException);
            n = 1;
            OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_REGISTRY_CORRUPT, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        LOGGER.exiting(this.getClass().getName(), "invokeWSProfile");
        return n;
    }

    protected Vector getListOfRequiredCommandLineArguments() {
        LOGGER.entering(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        Vector<CommandLineArgument> vector = new Vector<CommandLineArgument>(Arrays.asList(ACLA_RESERVED_REQUIRED_ARGUMENTS));
        LOGGER.exiting(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        return vector;
    }

    protected Vector getListOfOptionalCommandLineArguments() {
        return new Vector();
    }

    private void printProfileList(List list) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < list.size(); ++i) {
            Profile profile = (Profile)list.get(i);
            vector.add(profile.getName());
        }
        OutputStreamHandler.println("profileList", vector);
    }
}

