/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.cli;

import com.ibm.ws.install.configmanager.ConfigManager;
import com.ibm.ws.install.configmanager.ConfigManagerConstants;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.logging.LoggerFactoryConstants;
import com.ibm.ws.profile.cli.CommandLineArgument;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.cli.output.OutputStreamHandler;
import com.ibm.ws.profile.utils.PrereqTemplateUtils;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.WSProfileTemplate;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WSProfileCLICreateProfileInvoker
extends WSProfileCLIModeInvoker {
    private static final String S_EMPTY = "";
    private static final Vector V_EMPTY_VECTOR = new Vector();
    private static final Vector V_SINGLE_ENTRY_VECTOR = new Vector<String>(Arrays.asList(""));
    private static final CommandLineArgument[] ACLA_RESERVED_REQUIRED_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("create", V_EMPTY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("templatePath", V_SINGLE_ENTRY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("profileName", V_SINGLE_ENTRY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("profilePath", V_SINGLE_ENTRY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final CommandLineArgument[] ACLA_RESERVED_OPTIONAL_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("isDefault", V_EMPTY_VECTOR, false, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("omitAction", V_SINGLE_ENTRY_VECTOR, false, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final String S_SUCCESS_KEY = "WSProfile.WSProfileCLICreateProfileInvoker.successMessage";
    private static final String S_PARTIAL_SUCCESS_KEY = "WSProfile.WSProfileCLICreateProfileInvoker.partialSuccessMessage";
    private static final String S_FAILURE_KEY = "WSProfile.WSProfileCLICreateProfileInvoker.failureMessage";
    private static final String S_CELL_CREATION_SPECIFIC_HELP = "WSProfile.WSProfileCLICreateProfileInvoker.cellCreationSpecificHelp";
    private static final String S_NL = "\n";
    private static final String S_INVALID_PROFILE_CREATION_TEMPLATE = "WSProfile.WSProfileCLICreateProfileInvoker.invalidProfileCreationTemplate";
    private static final Logger LOGGER = LoggerFactory.createLogger(WSProfileCLICreateProfileInvoker.class);
    private static final String S_CLASS_NAME = WSProfileCLICreateProfileInvoker.class.getName();

    public String getModeFlag() {
        LOGGER.entering(this.getClass().getName(), "getModeFlag");
        LOGGER.entering(this.getClass().getName(), "getModeFlag");
        return "create";
    }

    protected int executeWSProfileAccordingToMode() {
        LOGGER.entering(this.getClass().getName(), "invokeWSProfile");
        String string = this.getArgumentValue("profileName");
        String string2 = this.getArgumentValue("profilePath");
        String string3 = this.getArgumentValue("templatePath");
        String string4 = this.getArgumentValue("nodeName");
        String string5 = this.getArgumentValue("cellName");
        String string6 = this.getArgumentValue("hostName");
        int n = 1;
        try {
            n = WSProfile.create(string, new File(string2).getAbsoluteFile(), new File(string3).getAbsoluteFile(), string4, string5, string6, CommandLineArgument.convertCommandLineArgumentListToMap(this.getIncomingCommandLineArguments()), this.getProfileRegistryPath());
        }
        catch (WSProfileException wSProfileException) {
            LogUtils.logException(LOGGER, wSProfileException);
            n = 1;
        }
        if (n == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(S_FAILURE_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
            OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_FAILURE_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        if (n == 2) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(S_PARTIAL_SUCCESS_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
            OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_PARTIAL_SUCCESS_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        if (n == 0) {
            String string7 = MessageFormat.format(ResourceBundleUtils.getLocaleString(S_SUCCESS_KEY), this.getArgumentValue("profileName"), this.getArgumentValue("profilePath"));
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeWSProfileAccordingToMode", string7);
            OutputStreamHandler.println(string7);
        }
        LOGGER.exiting(this.getClass().getName(), "invokeWSProfile");
        return n;
    }

    protected Vector getListOfRequiredCommandLineArguments() {
        LOGGER.entering(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        Vector vector = new Vector(Arrays.asList(ACLA_RESERVED_REQUIRED_ARGUMENTS));
        String string = this.getArgumentValue("templatePath");
        if (string != null) {
            Vector vector2 = new Vector();
            vector2.addAll(PrereqTemplateUtils.getListOfTemplatePathsForStackCreate(string));
            for (int i = 0; i < vector2.size(); ++i) {
                File file = (File)vector2.get(i);
                Properties properties = this.setJavaSystemPropertiesForConfigManagerArgumentRetrieval();
                System.setProperty(ConfigManagerConstants.S_ARG_ACTION_REGISTRY, new File(file.getAbsoluteFile(), "actionRegistry.xml").getAbsolutePath());
                List list = CommandLineArgument.convertActionArgumentListToCommandLineArgumentList(ConfigManager.getRequiredArgumentsList(file.getAbsolutePath()));
                vector = this.mergeCommandLineArgs(vector, list);
                this.resetJavaSystemProperties(properties);
            }
        }
        LOGGER.exiting(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        return vector;
    }

    protected Vector getListOfOptionalCommandLineArguments() {
        LOGGER.entering(this.getClass().getName(), "getListOfOptionalCommandLineArguments");
        Vector vector = new Vector(Arrays.asList(ACLA_RESERVED_OPTIONAL_ARGUMENTS));
        String string = this.getArgumentValue("templatePath");
        if (string != null) {
            Vector vector2 = new Vector();
            vector2.addAll(PrereqTemplateUtils.getListOfTemplatePathsForStackCreate(string));
            for (int i = 0; i < vector2.size(); ++i) {
                File file = (File)vector2.get(i);
                Properties properties = this.setJavaSystemPropertiesForConfigManagerArgumentRetrieval();
                System.setProperty(ConfigManagerConstants.S_ARG_ACTION_REGISTRY, new File(file.getAbsoluteFile(), "actionRegistry.xml").getAbsolutePath());
                List list = CommandLineArgument.convertActionArgumentListToCommandLineArgumentList(ConfigManager.getOptionalArgumentsList(file.getAbsolutePath()));
                vector = this.mergeCommandLineArgs(vector, list);
                this.resetJavaSystemProperties(properties);
            }
        }
        LOGGER.exiting(this.getClass().getName(), "getListOfOptionalCommandLineArgumetns");
        return vector;
    }

    protected void doHelp() {
        LOGGER.entering(WSProfileCLICreateProfileInvoker.class.getName(), "doHelp");
        String string = this.getArgumentValue("templatePath");
        boolean bl = true;
        if (string != null) {
            try {
                WSProfileTemplate wSProfileTemplate = new WSProfileTemplate(string);
                Vector vector = PrereqTemplateUtils.getTemplatesForStackCreation(wSProfileTemplate);
                PrereqTemplateUtils.validateListForCreation(vector);
                if (wSProfileTemplate.getType().equals("cell.dmgr") || wSProfileTemplate.getType().equals("cell.node") || wSProfileTemplate.getType().equals("cell")) {
                    OutputStreamHandler.println(S_NL + ResourceBundleUtils.getLocaleString(S_CELL_CREATION_SPECIFIC_HELP) + S_NL);
                }
                super.doHelp();
            }
            catch (WSProfileException wSProfileException) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "doHelp", "Could not build a list of prerequisite profile templates for profile template " + string);
                OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_INVALID_PROFILE_CREATION_TEMPLATE, string));
            }
        } else {
            super.doHelp();
        }
        LOGGER.exiting(WSProfileCLICreateProfileInvoker.class.getName(), "doHelp");
    }

    public String getRegistryName() {
        return "actionRegistry.xml";
    }
}

