/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.cli;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.logging.LoggerFactoryConstants;
import com.ibm.ws.profile.cli.CommandLineArgument;
import com.ibm.ws.profile.cli.WSProfileCLIGetProfileNameInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.cli.output.OutputStreamHandler;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.registry.Profile;
import java.util.Arrays;
import java.util.Vector;
import java.util.logging.Logger;

public class WSProfileCLIGetDefaultProfileNameInvoker
extends WSProfileCLIModeInvoker {
    private static final Vector V_EMPTY_VECTOR = new Vector();
    private static final CommandLineArgument[] ACLA_RESERVED_REQUIRED_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("getDefaultName", V_EMPTY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final String S_REGISTRY_CORRUPT = "WSProfile.WSProfileCLIGetDefaultProfileNameInvoker.registryCorrupt";
    private static final String S_NO_DEFAULT_PROFILE_SET = "WSProfile.WSProfileCLIGetDefaultProfileNameInvoker.noDefaultProfile";
    private static final Logger LOGGER = LoggerFactory.createLogger(WSProfileCLIGetProfileNameInvoker.class);

    public String getModeFlag() {
        LOGGER.entering(this.getClass().getName(), "getModeFlag");
        LOGGER.exiting(this.getClass().getName(), "getModeFlag");
        return "getDefaultName";
    }

    protected int executeWSProfileAccordingToMode() {
        LOGGER.entering(this.getClass().getName(), "invokeWSProfile");
        int n = 0;
        try {
            this.printDefaultProfileName(WSProfile.getDefaultProfile());
        }
        catch (WSProfileException wSProfileException) {
            LogUtils.logException(LOGGER, wSProfileException);
            n = 1;
            OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_REGISTRY_CORRUPT, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        LOGGER.exiting(this.getClass().getName(), "invokeWSProfile");
        return n;
    }

    protected Vector getListOfRequiredCommandLineArguments() {
        LOGGER.entering(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        Vector<CommandLineArgument> vector = new Vector<CommandLineArgument>(Arrays.asList(ACLA_RESERVED_REQUIRED_ARGUMENTS));
        LOGGER.exiting(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        return vector;
    }

    protected Vector getListOfOptionalCommandLineArguments() {
        return new Vector();
    }

    private void printDefaultProfileName(Profile profile) {
        if (profile != null) {
            OutputStreamHandler.println("isDefault", profile.getName());
        } else {
            OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_NO_DEFAULT_PROFILE_SET));
        }
    }
}

