/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.cli;

import com.ibm.ws.install.configmanager.ConfigManager;
import com.ibm.ws.install.configmanager.ConfigManagerConstants;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.logging.LoggerFactoryConstants;
import com.ibm.ws.profile.cli.CommandLineArgument;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.cli.output.OutputStreamHandler;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WSProfileCLIListProfileInvoker
extends WSProfileCLIModeInvoker {
    private static final String S_EMPTY = "";
    private static final Vector V_EMPTY_VECTOR = new Vector();
    private static final Vector V_SINGLE_ENTRY_VECTOR = new Vector<String>(Arrays.asList(""));
    private static final CommandLineArgument[] ACLA_RESERVED_REQUIRED_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("list", V_EMPTY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("profileName", V_SINGLE_ENTRY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final CommandLineArgument[] ACLA_RESERVED_OPTIONAL_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("getProfilePath", V_EMPTY_VECTOR, false, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("getTemplatePath", V_EMPTY_VECTOR, false, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("getIsDefault", V_EMPTY_VECTOR, false, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("listAll", V_EMPTY_VECTOR, false, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final String S_SUCCESS_KEY = "WSProfile.WSProfileCLIListProfileInvoker.successMessage";
    private static final String S_PARTIAL_SUCCESS_KEY = "WSProfile.WSProfileCLIListProfileInvoker.partialSuccessMessage";
    private static final String S_FAILURE_KEY = "WSProfile.WSProfileCLIListProfileInvoker.failureMessage";
    private static final Logger LOGGER = LoggerFactory.createLogger(WSProfileCLIListProfileInvoker.class);
    private static final String S_CLASS_NAME = WSProfileCLIListProfileInvoker.class.getName();

    public String getModeFlag() {
        LOGGER.entering(this.getClass().getName(), "getModeFlag");
        LOGGER.exiting(this.getClass().getName(), "getModeFlag");
        return "list";
    }

    protected int executeWSProfileAccordingToMode() {
        LOGGER.entering(this.getClass().getName(), "invokeWSProfile");
        String string = this.getArgumentValue("profileName");
        Map map = CommandLineArgument.convertCommandLineArgumentListToMap(this.getIncomingCommandLineArguments());
        int n = 1;
        try {
            if (map.containsKey("getIsDefault") || map.containsKey("listAll")) {
                OutputStreamHandler.add("isDefault", Boolean.toString(WSProfile.getProfile(string).isDefault()));
            }
            if (map.containsKey("getTemplatePath") || map.containsKey("listAll")) {
                OutputStreamHandler.add("templatePath", WSProfile.getProfileTemplateLocation(string));
            }
            if (map.containsKey("getProfilePath") || map.containsKey("listAll")) {
                OutputStreamHandler.add("profilePath", WSProfile.getProfileLocation(string));
            }
            n = WSProfile.list(string, map, this.getProfileRegistryPath());
        }
        catch (WSProfileException wSProfileException) {
            LogUtils.logException(LOGGER, wSProfileException);
            n = 1;
        }
        if (n == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(S_FAILURE_KEY));
            OutputStreamHandler.put();
            OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_FAILURE_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        if (n == 2) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(S_PARTIAL_SUCCESS_KEY));
            OutputStreamHandler.put();
            OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_PARTIAL_SUCCESS_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        if (n == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(S_SUCCESS_KEY));
            OutputStreamHandler.put();
        }
        LOGGER.exiting(this.getClass().getName(), "invokeWSProfile");
        return n;
    }

    protected Vector getListOfRequiredCommandLineArguments() {
        LOGGER.entering(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        Vector<CommandLineArgument> vector = new Vector<CommandLineArgument>(Arrays.asList(ACLA_RESERVED_REQUIRED_ARGUMENTS));
        String string = this.getArgumentValue("profileName");
        if (string != null) {
            try {
                String string2 = WSProfile.getProfile(string, this.getProfileRegistryPath()).getTemplate().getAbsolutePath();
                System.setProperty(ConfigManagerConstants.S_ARG_ACTION_REGISTRY, new File(string2, "listRegistry.xml").getAbsolutePath());
                List list = CommandLineArgument.convertActionArgumentListToCommandLineArgumentList(ConfigManager.getRequiredArgumentsList(string2));
                vector.addAll(list);
            }
            catch (WSProfileException wSProfileException) {
                LogUtils.logException(LOGGER, wSProfileException);
            }
        }
        LOGGER.exiting(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        return vector;
    }

    protected Vector getListOfOptionalCommandLineArguments() {
        Vector<CommandLineArgument> vector = new Vector<CommandLineArgument>(Arrays.asList(ACLA_RESERVED_OPTIONAL_ARGUMENTS));
        String string = this.getArgumentValue("profileName");
        if (string != null) {
            try {
                String string2 = WSProfile.getProfile(string, this.getProfileRegistryPath()).getTemplate().getAbsolutePath();
                System.setProperty(ConfigManagerConstants.S_ARG_ACTION_REGISTRY, new File(string2, "listRegistry.xml").getAbsolutePath());
                List list = CommandLineArgument.convertActionArgumentListToCommandLineArgumentList(ConfigManager.getOptionalArgumentsList(string2));
                vector.addAll(list);
            }
            catch (WSProfileException wSProfileException) {
                LogUtils.logException(LOGGER, wSProfileException);
            }
        }
        LOGGER.exiting(this.getClass().getName(), "getListOfOptionalCommandLineArgumetns");
        return vector;
    }
}

