/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.cli;

import com.ibm.ws.install.configmanager.ConfigManagerConstants;
import com.ibm.ws.install.configmanager.actionengine.ActionArgument;
import com.ibm.ws.install.configmanager.launcher.OutputStreamHandler;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.MessageFormatUtils;
import com.ibm.ws.profile.WSProfileConstants;
import com.ibm.ws.profile.cli.CommandLineArgument;
import com.ibm.ws.profile.cli.WSProfileCLIAugmentProfileInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIBackupProfileInvoker;
import com.ibm.ws.profile.cli.WSProfileCLICheckProfileRegistryIntegrityInvoker;
import com.ibm.ws.profile.cli.WSProfileCLICreateProfileInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIDeleteAllProfileInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIDeleteProfileInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIEditProfileInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIGetDefaultProfileNameInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIGetProfileNameInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIGetProfilePathInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIHelpInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIListProfileInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIListProfilesInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIRegisterProfileInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIResponseInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIRestoreProfileInvoker;
import com.ibm.ws.profile.cli.WSProfileCLISetDefaultProfileNameInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIUnaugmentProfileInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIUnlockProfileInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIUnregisterProfileInvoker;
import com.ibm.ws.profile.cli.WSProfileCLIUpdateProfileRegistryInvoker;
import com.ibm.ws.profile.utils.CommandLineArgumentsUtils;
import com.ibm.ws.profile.utils.DefaultValueManagerUtils;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.utils.SystemPropertiesUtils;
import com.ibm.ws.profile.utils.ValidationManagerUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class WSProfileCLIModeInvoker {
    private Vector m_vclaIncomingCommandLineArguments = new Vector();
    private static final Class[] aclassRegisteredInvokers = new Class[]{WSProfileCLICreateProfileInvoker.class, WSProfileCLIAugmentProfileInvoker.class, WSProfileCLIDeleteProfileInvoker.class, WSProfileCLIUnaugmentProfileInvoker.class, WSProfileCLIEditProfileInvoker.class, WSProfileCLIListProfileInvoker.class, WSProfileCLIDeleteAllProfileInvoker.class, WSProfileCLIListProfilesInvoker.class, WSProfileCLIRegisterProfileInvoker.class, WSProfileCLIUnregisterProfileInvoker.class, WSProfileCLIBackupProfileInvoker.class, WSProfileCLIRestoreProfileInvoker.class, WSProfileCLIGetProfileNameInvoker.class, WSProfileCLIGetProfilePathInvoker.class, WSProfileCLICheckProfileRegistryIntegrityInvoker.class, WSProfileCLIUpdateProfileRegistryInvoker.class, WSProfileCLIGetDefaultProfileNameInvoker.class, WSProfileCLISetDefaultProfileNameInvoker.class, WSProfileCLIResponseInvoker.class, WSProfileCLIUnlockProfileInvoker.class, WSProfileCLIHelpInvoker.class};
    private static final String S_EMPTY = "";
    public static final String S_DASH = "-";
    private static final String S_SPACE = " ";
    private static final String S_COLON = ":";
    private static final String S_CLA_RESOURCE_BUNDLE_HELP_KEY_POSTFIX = ".help";
    private static final String S_VALIDATION_ERROR_KEY = "WSProfile.WSProfileCLIModeInvoker.validationError";
    private static final String S_PROFILE_REGISTRY_ACCESS_FAILED_KEY = "WSProfile.WSProfileCLIModeInvoker.registryFileAcquireFailed";
    private static final String S_PROFILE_REGISTRY_ACCESS_FAILED = "Unable to access profile registry file ";
    public static final Logger LOGGER = LoggerFactory.createLogger(WSProfileCLIModeInvoker.class);
    private static final String S_CLASS_NAME = WSProfileCLIModeInvoker.class.getName();

    public static boolean isTheUserRequestingHelp(String[] stringArray) {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "isUserRequestingHelp");
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "isUserRequestingHelp");
        return Arrays.asList(stringArray).contains("-help");
    }

    public static int doHelpMode(String[] stringArray) {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "doHelpMode");
        Vector vector = CommandLineArgumentsUtils.convertIncomingCommandLineToCommandLineArguments(stringArray);
        for (int i = 0; i < aclassRegisteredInvokers.length; ++i) {
            Class clazz = aclassRegisteredInvokers[i];
            try {
                WSProfileCLIModeInvoker wSProfileCLIModeInvoker = (WSProfileCLIModeInvoker)clazz.newInstance();
                wSProfileCLIModeInvoker.m_vclaIncomingCommandLineArguments = vector;
                CommandLineArgument commandLineArgument = new CommandLineArgument(wSProfileCLIModeInvoker.getModeFlag(), new Vector());
                if (!CommandLineArgument.isThisModePresentInThisExpectedList(commandLineArgument, vector)) continue;
                wSProfileCLIModeInvoker.doHelp();
                LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "doHelpMode");
                return 0;
            }
            catch (IllegalAccessException illegalAccessException) {
                LogUtils.logException(LOGGER, illegalAccessException);
                LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "doHelpMode");
                return 1;
            }
            catch (InstantiationException instantiationException) {
                LogUtils.logException(LOGGER, instantiationException);
                LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "doHelpMode");
                return 1;
            }
        }
        new WSProfileCLIHelpInvoker().doHelp();
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "doHelpMode");
        return 0;
    }

    public static WSProfileCLIModeInvoker getModeInvoker(String[] stringArray) {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "getModeInvoker");
        Vector vector = CommandLineArgumentsUtils.convertIncomingCommandLineToCommandLineArguments(stringArray);
        try {
            for (int i = 0; i < aclassRegisteredInvokers.length; ++i) {
                Class clazz = aclassRegisteredInvokers[i];
                WSProfileCLIModeInvoker wSProfileCLIModeInvoker = (WSProfileCLIModeInvoker)clazz.newInstance();
                wSProfileCLIModeInvoker.m_vclaIncomingCommandLineArguments = vector;
                Vector vector2 = wSProfileCLIModeInvoker.getListOfRequiredCommandLineArguments();
                if (!WSProfileCLIModeInvoker.checkIfCommandLineIsSufficientForThisMode(vector, vector2)) continue;
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "getModeInvoker", "Identified WSProfile mode invoker to be: " + wSProfileCLIModeInvoker.getClass().getName());
                LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "getModeInvoker");
                return wSProfileCLIModeInvoker;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            LogUtils.logException(LOGGER, illegalAccessException);
            LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "getModeInvoker");
            return new WSProfileCLIHelpInvoker();
        }
        catch (InstantiationException instantiationException) {
            LogUtils.logException(LOGGER, instantiationException);
            LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "getModeInvoker");
            return new WSProfileCLIHelpInvoker();
        }
        LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "getModeInvoker", "Unreachable code block reached.");
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "getModeInvoker");
        return new WSProfileCLIHelpInvoker();
    }

    public int invokeWSProfile() {
        this.setAppropriateDefaults();
        if (!this.areCommandLineArgumentsValid()) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "invokeWSProfile", "Argument Validation Failed.");
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "invokeWSProfile", "Returning with return code: " + WSProfileConstants.AS_RETURN_CODES[1]);
            LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "invokeWSProfile");
            return 1;
        }
        return this.executeWSProfileAccordingToMode();
    }

    public abstract String getModeFlag();

    public String getRegistryName() {
        return null;
    }

    protected abstract int executeWSProfileAccordingToMode();

    protected abstract Vector getListOfRequiredCommandLineArguments();

    protected abstract Vector getListOfOptionalCommandLineArguments();

    protected final Vector getIncomingCommandLineArguments() {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "getIncomingCommandLineArguments");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getIncomingCommandLineArguments", "Parsed incoming command line arguments were: " + this.m_vclaIncomingCommandLineArguments);
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "getIncomingCommandLineArguments");
        return this.m_vclaIncomingCommandLineArguments;
    }

    protected final boolean isArgumentPresent(String string) {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "isArgumentPresent");
        if (this.getArgumentValue(string) != null) {
            LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "isArgumentPresent");
            return true;
        }
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "isArgumentPresent");
        return false;
    }

    protected final String getArgumentValue(String string) {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "getArgumentValue");
        for (int i = 0; i < this.m_vclaIncomingCommandLineArguments.size(); ++i) {
            CommandLineArgument commandLineArgument = (CommandLineArgument)this.m_vclaIncomingCommandLineArguments.elementAt(i);
            if (!commandLineArgument.getKey().equals(string)) continue;
            String string2 = S_EMPTY;
            if (commandLineArgument.getArgumentValues().size() > 0) {
                string2 = (String)commandLineArgument.getArgumentValues().elementAt(0);
            }
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getArgumentValue", string + " was resolved to " + string2);
            LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "getArgumentValue");
            return string2;
        }
        LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getArgumentValue", "Could not resolve " + string + " from command line");
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "getArgumentValue");
        return null;
    }

    protected final File getProfileRegistryPath() throws WSProfileException {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "getProfileRegistryPath");
        String string = this.getArgumentValue("registry");
        if (string == null) {
            string = WSProfile.getRegistryFile().getAbsolutePath();
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getProfileRegistryPath", "Profile registry being used is: " + string);
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "getProfileRegistryPath");
        try {
            return new File(string).getCanonicalFile();
        }
        catch (IOException iOException) {
            LogUtils.logException(LOGGER, iOException);
            throw new WSProfileException(S_PROFILE_REGISTRY_ACCESS_FAILED + string, ResourceBundleUtils.getLocaleString(S_PROFILE_REGISTRY_ACCESS_FAILED_KEY, string), true);
        }
    }

    protected final boolean areCommandLineArgumentsValid() {
        Object object;
        Object object2;
        int n;
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "validateArguments");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "areCommandLineArgumentsValid", "Validating command line arguments.");
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Properties properties = com.ibm.ws.install.configmanager.utils.SystemPropertiesUtils.getCurrentSystemProperties();
        for (n = 0; n < this.m_vclaIncomingCommandLineArguments.size(); ++n) {
            object2 = (CommandLineArgument)this.m_vclaIncomingCommandLineArguments.get(n);
            hashtable.put(((ActionArgument)object2).getKey(), ((CommandLineArgument)object2).getArgumentValues());
            if (!((ActionArgument)object2).getKey().equals("templatePath") || ((CommandLineArgument)object2).getArgumentValues().size() < 1 || (String)((CommandLineArgument)object2).getArgumentValues().firstElement() == null || ((String)((CommandLineArgument)object2).getArgumentValues().firstElement()).equals(S_EMPTY) || this.getRegistryName() == null) continue;
            object = new File((String)((CommandLineArgument)object2).getArgumentValues().firstElement());
            System.setProperty(ConfigManagerConstants.S_ARG_CONFIG_DIR, ((File)object).getAbsolutePath());
            System.setProperty(ConfigManagerConstants.S_ARG_ACTION_REGISTRY, new File(((File)object).getAbsoluteFile(), this.getRegistryName()).getAbsolutePath());
            System.setProperty(this.getModeFlag(), S_EMPTY);
        }
        hashtable.put(this.getModeFlag(), S_EMPTY);
        n = ValidationManagerUtils.areAllArgumentsValid(hashtable) ? 1 : 0;
        com.ibm.ws.install.configmanager.utils.SystemPropertiesUtils.resetSystemProperties(properties);
        if (n == 0) {
            object2 = ValidationManagerUtils.getAllErrorMessages();
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "areCommandLineArgumentsValid", "Validation Failed");
            OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_VALIDATION_ERROR_KEY));
            object = ((Hashtable)object2).keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                List list = (List)((Hashtable)object2).get(string);
                for (int i = 0; i < list.size(); ++i) {
                    LOGGER.logp(Level.INFO, S_CLASS_NAME, "areCommandLineArgumentsValid", "Validation Error for " + string + ": " + list.get(i));
                    String string2 = (String)list.get(i);
                    String string3 = MessageFormatUtils.formatMessage(string2, new String[]{string});
                    OutputStreamHandler.println("\t" + string + ": " + string3);
                }
            }
            return false;
        }
        return true;
    }

    protected void doHelp() {
        Vector vector;
        Object object;
        Object object2;
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "doHelp");
        OutputStreamHandler.println(ResourceBundleUtils.getLocaleString("WSProfile.WSProfileCLIModeInvoker.genericHelpProlog"));
        Vector vector2 = this.getListOfNonDefaultableRequiredCommandLineArguments();
        for (int i = 0; i < vector2.size(); ++i) {
            CommandLineArgument commandLineArgument = (CommandLineArgument)vector2.elementAt(i);
            if (!commandLineArgument.isVisible()) continue;
            object2 = commandLineArgument.getArgumentHelpBundle();
            if (object2 == null) {
                object2 = "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle";
            }
            OutputStreamHandler.println(S_DASH + commandLineArgument.getKey() + S_COLON + S_SPACE + ResourceBundleUtils.getResourceBundleLocaleString(commandLineArgument.getKey() + S_CLA_RESOURCE_BUNDLE_HELP_KEY_POSTFIX, (String)object2));
        }
        Vector vector3 = this.getListOfDefaultableCommandLineArguments();
        if (vector3.size() > 0 && this.isAnyArgumentVisible(vector3)) {
            OutputStreamHandler.println(S_EMPTY);
            OutputStreamHandler.println(ResourceBundleUtils.getLocaleString("WSProfile.WSProfileCLIModeInvoker.optionalDefaultableArgsHelpProlog"));
            for (int i = 0; i < vector3.size(); ++i) {
                object2 = (CommandLineArgument)vector3.elementAt(i);
                if (!((ActionArgument)object2).isVisible()) continue;
                object = ((ActionArgument)object2).getArgumentHelpBundle();
                if (object == null) {
                    object = "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle";
                }
                OutputStreamHandler.println(S_DASH + ((ActionArgument)object2).getKey() + S_COLON + S_SPACE + ResourceBundleUtils.getResourceBundleLocaleString(((ActionArgument)object2).getKey() + S_CLA_RESOURCE_BUNDLE_HELP_KEY_POSTFIX, (String)object));
            }
        }
        if ((vector = this.getListOfNonDefaultableCommandLineArguments()).size() > 0 && this.isAnyArgumentVisible(vector)) {
            OutputStreamHandler.println(S_EMPTY);
            OutputStreamHandler.println(ResourceBundleUtils.getLocaleString("WSProfile.WSProfileCLIModeInvoker.optionalNonDefaultableArgsHelpProlog"));
            for (int i = 0; i < vector.size(); ++i) {
                object = (CommandLineArgument)vector.elementAt(i);
                if (!((ActionArgument)object).isVisible()) continue;
                String string = ((ActionArgument)object).getArgumentHelpBundle();
                if (string == null) {
                    string = "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle";
                }
                OutputStreamHandler.println(S_DASH + ((ActionArgument)object).getKey() + S_COLON + S_SPACE + ResourceBundleUtils.getResourceBundleLocaleString(((ActionArgument)object).getKey() + S_CLA_RESOURCE_BUNDLE_HELP_KEY_POSTFIX, string));
            }
        }
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "doHelp");
    }

    private Vector getListOfNonDefaultableCommandLineArguments() {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "getListOfNonDefaultableRequiredCommandLineArguments");
        Vector vector = this.getListOfOptionalCommandLineArguments();
        Vector<CommandLineArgument> vector2 = new Vector<CommandLineArgument>();
        for (int i = 0; i < vector.size(); ++i) {
            CommandLineArgument commandLineArgument = (CommandLineArgument)vector.elementAt(i);
            if (commandLineArgument.getDefaulter() != null) continue;
            vector2.add(commandLineArgument);
        }
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "getListOfNonDefaultableRequiredCommandLineArguments");
        return vector2;
    }

    private Vector getListOfDefaultableCommandLineArguments() {
        CommandLineArgument commandLineArgument;
        int n;
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "getListOfDefaultableCommandLineArguments");
        Vector vector = this.getListOfRequiredCommandLineArguments();
        Vector vector2 = this.getListOfOptionalCommandLineArguments();
        Vector<CommandLineArgument> vector3 = new Vector<CommandLineArgument>();
        for (n = 0; n < vector.size(); ++n) {
            commandLineArgument = (CommandLineArgument)vector.elementAt(n);
            if (commandLineArgument.getDefaulter() == null) continue;
            vector3.add(commandLineArgument);
        }
        for (n = 0; n < vector2.size(); ++n) {
            commandLineArgument = (CommandLineArgument)vector2.elementAt(n);
            if (commandLineArgument.getDefaulter() == null) continue;
            vector3.add(commandLineArgument);
        }
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "getListOfDefaultableCommandLineArguments");
        return vector3;
    }

    private Vector getListOfNonDefaultableRequiredCommandLineArguments() {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "getListOfNonDefaultableRequiredCommandLineArguments");
        Vector vector = this.getListOfRequiredCommandLineArguments();
        Vector<CommandLineArgument> vector2 = new Vector<CommandLineArgument>();
        for (int i = 0; i < vector.size(); ++i) {
            CommandLineArgument commandLineArgument = (CommandLineArgument)vector.elementAt(i);
            if (commandLineArgument.getDefaulter() != null) continue;
            vector2.add(commandLineArgument);
        }
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "getListOfNonDefaultableRequiredCommandLineArguments");
        return vector2;
    }

    protected Vector getListOfAllCommandLineArguments() {
        Vector vector = this.getListOfRequiredCommandLineArguments();
        vector.addAll(this.getListOfOptionalCommandLineArguments());
        return vector;
    }

    protected Properties setJavaSystemPropertiesForConfigManagerArgumentRetrieval() {
        return SystemPropertiesUtils.setJavaSystemPropertiesForConfigManagerFromGivenOptionalArgumentMap(CommandLineArgument.convertCommandLineArgumentListToMap(this.getIncomingCommandLineArguments()));
    }

    protected void resetJavaSystemProperties(Properties properties) {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "resetJavaSystemProperties");
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "resetJavaSystemProperties");
        SystemPropertiesUtils.resetJavaSystemProperties(properties);
    }

    protected Vector mergeCommandLineArgs(List list, List list2) {
        Vector vector = new Vector(list);
        for (int i = 0; i < list2.size(); ++i) {
            boolean bl = false;
            CommandLineArgument commandLineArgument = (CommandLineArgument)list2.get(i);
            for (int j = 0; j < vector.size(); ++j) {
                CommandLineArgument commandLineArgument2 = (CommandLineArgument)vector.get(j);
                if (!commandLineArgument2.getKey().equals(commandLineArgument.getKey())) continue;
                boolean bl2 = this.isArgumentVisible(commandLineArgument2, commandLineArgument);
                if (commandLineArgument2.getDefaulter() != null && commandLineArgument.getDefaulter() == null) {
                    bl = true;
                } else {
                    vector.remove(j);
                    vector.add(j, list2.get(i));
                    bl = true;
                }
                ((CommandLineArgument)vector.get(j)).setIsVisible(bl2);
                break;
            }
            if (bl) continue;
            vector.add(list2.get(i));
        }
        return vector;
    }

    private boolean isArgumentVisible(CommandLineArgument commandLineArgument, CommandLineArgument commandLineArgument2) {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "isArgumentVisible");
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "isArgumentVisible");
        return commandLineArgument.isVisible() || commandLineArgument2.isVisible();
    }

    private static boolean checkIfCommandLineIsSufficientForThisMode(Vector vector, Vector vector2) {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "checkIfCommandLineIsSufficientForThisMode");
        for (int i = 0; i < vector2.size(); ++i) {
            CommandLineArgument commandLineArgument = (CommandLineArgument)vector2.elementAt(i);
            if (CommandLineArgument.isThisArgumentPresentInThisExpectedList(commandLineArgument, vector) || commandLineArgument.getDefaulter() != null) continue;
            LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "checkIfCommandLineIsSufficientForThisMode");
            return false;
        }
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "checkIfCommandLineIsSufficientForThisMode");
        return true;
    }

    private void setAppropriateDefaults() {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "setAppropriateDefaults");
        Vector vector = this.getListOfAllCommandLineArguments();
        List list = this.findArgumentsNeedingDefaults(vector);
        Properties properties = com.ibm.ws.install.configmanager.utils.SystemPropertiesUtils.getCurrentSystemProperties();
        if (list.size() > 0) {
            Object object;
            Object object2;
            Hashtable<String, Vector> hashtable = new Hashtable<String, Vector>();
            for (int i = 0; i < this.getIncomingCommandLineArguments().size(); ++i) {
                object2 = (CommandLineArgument)this.m_vclaIncomingCommandLineArguments.get(i);
                hashtable.put(((ActionArgument)object2).getKey(), ((CommandLineArgument)object2).getArgumentValues());
                if (!((ActionArgument)object2).getKey().equals("templatePath") || (String)((CommandLineArgument)object2).getArgumentValues().firstElement() == null || ((String)((CommandLineArgument)object2).getArgumentValues().firstElement()).equals(S_EMPTY) || this.getRegistryName() == null) continue;
                object = new File((String)((CommandLineArgument)object2).getArgumentValues().firstElement());
                System.setProperty(ConfigManagerConstants.S_ARG_CONFIG_DIR, ((File)object).getAbsolutePath());
                System.setProperty(ConfigManagerConstants.S_ARG_ACTION_REGISTRY, new File(((File)object).getAbsoluteFile(), this.getRegistryName()).getAbsolutePath());
                System.setProperty(this.getModeFlag(), S_EMPTY);
            }
            String[] stringArray = list.toArray(new String[0]);
            object2 = DefaultValueManagerUtils.getDefaultValues(stringArray, hashtable);
            com.ibm.ws.install.configmanager.utils.SystemPropertiesUtils.resetSystemProperties(properties);
            object = ((Hashtable)object2).keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                Vector<String> vector2 = new Vector<String>();
                vector2.add((String)((Hashtable)object2).get(string));
                this.getIncomingCommandLineArguments().add(new CommandLineArgument(string, vector2));
            }
        }
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "setAppropriateDefaults");
    }

    private boolean isAnyArgumentVisible(Vector vector) {
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                CommandLineArgument commandLineArgument = (CommandLineArgument)vector.elementAt(i);
                if (!commandLineArgument.isVisible()) continue;
                return true;
            }
        }
        return false;
    }

    private List findArgumentsNeedingDefaults(Vector vector) {
        LOGGER.entering(WSProfileCLIModeInvoker.class.getName(), "findArgumentsNeedingDefaults");
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            CommandLineArgument commandLineArgument = (CommandLineArgument)vector.elementAt(i);
            if (CommandLineArgument.isThisArgumentKeyPresentInThisExpectedList(commandLineArgument, this.m_vclaIncomingCommandLineArguments) || commandLineArgument.getDefaulter() == null) continue;
            vector2.add(commandLineArgument.getKey());
        }
        LOGGER.exiting(WSProfileCLIModeInvoker.class.getName(), "findArgumentsNeedingDefaults");
        return vector2;
    }
}

