/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.cli;

import com.ibm.ws.install.configmanager.ConfigManager;
import com.ibm.ws.install.configmanager.ConfigManagerConstants;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.logging.LoggerFactoryConstants;
import com.ibm.ws.profile.cli.CommandLineArgument;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.cli.output.OutputStreamHandler;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WSProfileCLIUnaugmentProfileInvoker
extends WSProfileCLIModeInvoker {
    private static final String S_EMPTY = "";
    private static final Vector V_EMPTY_VECTOR = new Vector();
    private static final Vector V_SINGLE_ENTRY_VECTOR = new Vector<String>(Arrays.asList(""));
    private static final CommandLineArgument[] ACLA_RESERVED_REQUIRED_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("unaugment", V_EMPTY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("profileName", V_SINGLE_ENTRY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final CommandLineArgument[] ACLA_RESERVED_OPTIONAL_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("ignoreStack", V_EMPTY_VECTOR, false, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("templatePath", V_SINGLE_ENTRY_VECTOR, false, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final String S_SUCCESS_KEY = "WSProfile.WSProfileCLIUnaugmentProfileInvoker.successMessage";
    private static final String S_PARTIAL_SUCCESS_KEY = "WSProfile.WSProfileCLIUnaugmentProfileInvoker.partialSuccessMessage";
    private static final String S_FAILURE_KEY = "WSProfile.WSProfileCLIUnaugmentProfileInvoker.failureMessage";
    private static final Logger LOGGER = LoggerFactory.createLogger(WSProfileCLIUnaugmentProfileInvoker.class);
    private static final String S_CLASS_NAME = WSProfileCLIUnaugmentProfileInvoker.class.getName();

    public String getModeFlag() {
        LOGGER.entering(this.getClass().getName(), "getModeFlag");
        LOGGER.exiting(this.getClass().getName(), "getModeFlag");
        return "unaugment";
    }

    protected int executeWSProfileAccordingToMode() {
        LOGGER.entering(this.getClass().getName(), "invokeWSProfile");
        String string = this.getArgumentValue("profileName");
        String string2 = this.getArgumentValue("templatePath");
        String string3 = this.getArgumentValue("ignoreStack");
        int n = 1;
        try {
            n = string2 != null && string3 != null ? WSProfile.unaugment(string, new File(string2), CommandLineArgument.convertCommandLineArgumentListToMap(this.getIncomingCommandLineArguments()), this.getProfileRegistryPath()) : WSProfile.unaugment(string, CommandLineArgument.convertCommandLineArgumentListToMap(this.getIncomingCommandLineArguments()), this.getProfileRegistryPath());
        }
        catch (WSProfileException wSProfileException) {
            LogUtils.logException(LOGGER, wSProfileException);
            n = 1;
        }
        if (n == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(S_FAILURE_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
            OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_FAILURE_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        if (n == 2) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(S_PARTIAL_SUCCESS_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
            OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_PARTIAL_SUCCESS_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        if (n == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(S_SUCCESS_KEY));
            OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_SUCCESS_KEY));
        }
        LOGGER.exiting(this.getClass().getName(), "invokeWSProfile");
        return n;
    }

    protected Vector getListOfRequiredCommandLineArguments() {
        LOGGER.entering(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        Vector vector = new Vector(Arrays.asList(ACLA_RESERVED_REQUIRED_ARGUMENTS));
        String string = this.getArgumentValue("profileName");
        String string2 = this.getArgumentValue("profileName");
        if (string != null) {
            try {
                Vector vector2 = new Vector(WSProfile.getProfile(string, this.getProfileRegistryPath()).getAugmentors());
                if (vector2.size() != 0) {
                    if (string2 == null) {
                        string2 = (String)vector2.get(vector2.size() - 1);
                    }
                    System.setProperty(ConfigManagerConstants.S_ARG_ACTION_REGISTRY, new File(string2, "deleteRegistry.xml").getAbsolutePath());
                    List list = CommandLineArgument.convertActionArgumentListToCommandLineArgumentList(ConfigManager.getRequiredArgumentsList(string2));
                    vector = this.mergeCommandLineArgs(vector, list);
                }
            }
            catch (WSProfileException wSProfileException) {
                LogUtils.logException(LOGGER, wSProfileException);
            }
        }
        LOGGER.exiting(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        return vector;
    }

    protected Vector getListOfOptionalCommandLineArguments() {
        LOGGER.entering(this.getClass().getName(), "getListOfOptionalCommandLineArguments");
        Vector vector = new Vector(Arrays.asList(ACLA_RESERVED_OPTIONAL_ARGUMENTS));
        String string = this.getArgumentValue("profileName");
        String string2 = this.getArgumentValue("templatePath");
        if (string != null) {
            try {
                Vector vector2 = new Vector(WSProfile.getProfile(string, this.getProfileRegistryPath()).getAugmentors());
                if (vector2.size() != 0) {
                    if (string2 == null) {
                        string2 = (String)vector2.get(vector2.size() - 1);
                    }
                    System.setProperty(ConfigManagerConstants.S_ARG_ACTION_REGISTRY, new File(string2, "deleteRegistry.xml").getAbsolutePath());
                    List list = CommandLineArgument.convertActionArgumentListToCommandLineArgumentList(ConfigManager.getOptionalArgumentsList(string2));
                    vector = this.mergeCommandLineArgs(vector, list);
                }
            }
            catch (WSProfileException wSProfileException) {
                LogUtils.logException(LOGGER, wSProfileException);
            }
        }
        LOGGER.exiting(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        return vector;
    }

    public String getRegistryName() {
        return "deleteRegistry.xml";
    }
}

