/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.cli;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.logging.LoggerFactoryConstants;
import com.ibm.ws.profile.cli.CommandLineArgument;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.cli.output.OutputStreamHandler;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import java.util.Arrays;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WSProfileCLIUnlockProfileInvoker
extends WSProfileCLIModeInvoker {
    private static final String S_EMPTY = "";
    private static final Vector V_EMPTY_VECTOR = new Vector();
    private static final Vector V_SINGLE_ENTRY_VECTOR = new Vector<String>(Arrays.asList(""));
    private static final CommandLineArgument[] ACLA_RESERVED_REQUIRED_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("unlock", V_EMPTY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("profileName", V_SINGLE_ENTRY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final String S_SUCCESS_KEY = "WSProfile.WSProfileCLIEditProfileInvoker.successMessage";
    private static final String S_FAILURE_KEY = "WSProfile.WSProfileCLIEditProfileInvoker.failureMessage";
    private static final Logger LOGGER = LoggerFactory.createLogger(WSProfileCLIUnlockProfileInvoker.class);
    private static final String S_CLASS_NAME = WSProfileCLIUnlockProfileInvoker.class.getName();

    public String getModeFlag() {
        LOGGER.entering(this.getClass().getName(), "getModeFlag");
        LOGGER.exiting(this.getClass().getName(), "getModeFlag");
        return "unlock";
    }

    protected int executeWSProfileAccordingToMode() {
        LOGGER.entering(this.getClass().getName(), "invokeWSProfile");
        String string = this.getArgumentValue("profileName");
        int n = 1;
        try {
            n = WSProfile.unlock(string, this.getProfileRegistryPath());
        }
        catch (WSProfileException wSProfileException) {
            LogUtils.logException(LOGGER, wSProfileException);
            n = 1;
        }
        if (n == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(S_FAILURE_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
            OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_FAILURE_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        if (n == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(S_SUCCESS_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
            OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_SUCCESS_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        LOGGER.exiting(this.getClass().getName(), "invokeWSProfile");
        return n;
    }

    protected Vector getListOfOptionalCommandLineArguments() {
        return new Vector();
    }

    protected Vector getListOfRequiredCommandLineArguments() {
        LOGGER.entering(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        Vector<CommandLineArgument> vector = new Vector<CommandLineArgument>(Arrays.asList(ACLA_RESERVED_REQUIRED_ARGUMENTS));
        LOGGER.exiting(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        return vector;
    }
}

