/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.cli;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.logging.LoggerFactoryConstants;
import com.ibm.ws.profile.cli.CommandLineArgument;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.cli.output.OutputStreamHandler;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.registry.Profile;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;

public class WSProfileCLIUpdateProfileRegistryInvoker
extends WSProfileCLIModeInvoker {
    private static final Vector V_EMPTY_VECTOR = new Vector();
    private static final CommandLineArgument[] ACLA_RESERVED_REQUIRED_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("validateAndUpdateRegistry", V_EMPTY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final String S_REGISTRY_CORRUPT = "WSProfile.WSProfileCLIUpdateProfileRegistryInvoker.registryCorrupt";
    private static final Logger LOGGER = LoggerFactory.createLogger(WSProfileCLIUpdateProfileRegistryInvoker.class);

    public String getModeFlag() {
        LOGGER.entering(this.getClass().getName(), "getModeFlag");
        LOGGER.exiting(this.getClass().getName(), "getModeFlag");
        return "validateAndUpdateRegistry";
    }

    protected int executeWSProfileAccordingToMode() {
        LOGGER.entering(this.getClass().getName(), "invokeWSProfile");
        String string = this.getArgumentValue("backup");
        int n = 0;
        try {
            if (string != null) {
                List list = WSProfile.updateAndBackupRegistry(new File(string), this.getProfileRegistryPath());
                this.printProfileList(list);
            } else {
                List list = WSProfile.updateRegistry(this.getProfileRegistryPath());
                this.printProfileList(list);
            }
        }
        catch (WSProfileException wSProfileException) {
            LogUtils.logException(LOGGER, wSProfileException);
            n = 1;
            OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_REGISTRY_CORRUPT, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        LOGGER.exiting(this.getClass().getName(), "invokeWSProfile");
        return n;
    }

    protected Vector getListOfRequiredCommandLineArguments() {
        LOGGER.entering(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        Vector<CommandLineArgument> vector = new Vector<CommandLineArgument>(Arrays.asList(ACLA_RESERVED_REQUIRED_ARGUMENTS));
        LOGGER.exiting(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        return vector;
    }

    protected Vector getListOfOptionalCommandLineArguments() {
        return new Vector();
    }

    private void printProfileList(List list) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < list.size(); ++i) {
            Profile profile = (Profile)list.get(i);
            vector.add(profile.getName());
        }
        OutputStreamHandler.println("profileList", vector);
    }
}

