/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.defaulters;

import com.ibm.websphere.product.WASSystem;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import com.ibm.ws.profile.WASUtilities;
import com.ibm.ws.profile.WSProfileContext;
import com.ibm.ws.profile.defaulters.FindNodeCellNamesUtil;
import com.ibm.ws.profile.defaulters.UniqueTokenCreatorDefaulter;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.utils.StringUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileTemplate;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CellNameDefaulter
extends UniqueTokenCreatorDefaulter {
    public static final String S_WSPROFILE_DEFAULTERS_CELL_NAME_OS400_TAIL = "WSProfile.Defaulters.cellNameTail.os400.";
    private static final Logger LOGGER = LoggerFactory.createLogger(CellNameDefaulter.class);
    private static final String S_CLASS_NAME = CellNameDefaulter.class.getName();

    public boolean runDefaulter() throws Exception {
        LOGGER.entering(CellNameDefaulter.class.getName(), "runDefaulter");
        boolean bl = false;
        String string = System.getProperty("templatePath");
        String string2 = "";
        WSProfileTemplate wSProfileTemplate = new WSProfileTemplate(new File(string));
        string2 = wSProfileTemplate.getType();
        String string3 = System.getProperty("hostName");
        if (string3 == null) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "runDefaulter", "hostName was not set in the system properties, will use an empty string");
            string3 = "";
        } else {
            string3 = WASUtilities.getShortHostName(string3);
        }
        if (PlatformConstants.isCurrentPlatformOS400()) {
            String string4 = System.getProperty("profileName");
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runDefaulter", "using os400 defaulter");
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runDefaulter", "profileName set to [" + string4 + "] in system properties");
            this.sDefaultedValue = string2.equals("cell.dmgr") || string2.equals("dmgr") ? string4 + ResourceBundleUtils.getResourceBundleLocaleString(S_WSPROFILE_DEFAULTERS_CELL_NAME_OS400_TAIL + string2, "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle") : (string3.equals("LOOPBACK") ? "LOCAL_" + string4 : string3 + "_" + string4);
            return true;
        }
        this.setSeed(string3 + ResourceBundleUtils.getResourceBundleLocaleString("WSProfile.Defaulters.cellNameSeed." + string2, "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle"));
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "runDefaulter", "set seed key value:" + this.getSeed());
        this.setTail(ResourceBundleUtils.getResourceBundleLocaleString("WSProfile.Defaulters.cellNameTail." + string2, "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle"));
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "runDefaulter", "set tail key value:" + this.getTail());
        String string5 = "";
        LinkedList<String> linkedList = new LinkedList<String>();
        String string6 = System.getProperty("WAS_HOME");
        WSProfileContext wSProfileContext = new WSProfileContext();
        wSProfileContext.saveCurrentContext();
        WASSystem wASSystem = WASSystem.getWASSystemInstance();
        String[] stringArray = wASSystem.getNonCachedWASLocations();
        if (stringArray.length > 1) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runDefaulter", "Located the following WAS home(s): " + StringUtils.convertStringArrayToCommaSeparatedString(stringArray));
        } else {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runDefaulter", "No other WAS home directories have been found");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string7;
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runDefaulter", "Scanning WAS location:" + stringArray[i]);
            try {
                int n;
                wSProfileContext.switchContext(stringArray[i]);
                List list = WSProfile.listProfileNames();
                for (n = 0; n < list.size(); ++n) {
                    linkedList.add(WSProfile.getProfileLocation("" + list.get(n)).getAbsolutePath());
                }
                if (linkedList != null) {
                    for (n = 0; n < linkedList.size(); ++n) {
                        string7 = (String)linkedList.get(n);
                        FindNodeCellNamesUtil findNodeCellNamesUtil = new FindNodeCellNamesUtil(string7);
                        string5 = CellNameDefaulter.addToken(string5, this.getTokensSeparator(), findNodeCellNamesUtil.getCellNameFound());
                    }
                }
            }
            catch (Exception exception) {
                try {
                    string6 = new File(string6).getCanonicalPath();
                }
                catch (IOException iOException) {
                    string6 = null;
                    LOGGER.logp(Level.WARNING, S_CLASS_NAME, "runDefaulter", "Problems occurred when retrieving reference to current install.  Exception follows.");
                    LogUtils.logException(LOGGER, iOException);
                    throw exception;
                }
                string7 = null;
                try {
                    string7 = new File(stringArray[i]).getCanonicalPath();
                }
                catch (IOException iOException) {
                    string7 = null;
                    LOGGER.logp(Level.WARNING, S_CLASS_NAME, "runDefaulter", "Problems occurred when retrieving reference to the WAS install:" + stringArray[i]);
                    LogUtils.logException(LOGGER, iOException);
                }
                if (string6 != null && string7 != null) {
                    if (!string6.equals(string7)) {
                        LOGGER.logp(Level.WARNING, S_CLASS_NAME, "runDefaulter", "Ignoring incomplete installation: " + stringArray[i]);
                    }
                    LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runDefaulter", "There are problems with the current install: " + stringArray[i]);
                    LogUtils.logException(LOGGER, exception);
                    throw exception;
                }
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "runDefaulter", "Ignoring incomplete installation: " + stringArray[i]);
            }
            linkedList = new LinkedList();
        }
        wSProfileContext.restoreSavedContext();
        this.setExistingTokens(string5);
        bl = this.generateSuggestion();
        if (bl) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runDefaulter", this.getOutput());
        }
        LOGGER.exiting(CellNameDefaulter.class.getName(), "runDefaulter");
        return bl;
    }
}

