/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.defaulters;

import com.ibm.ws.install.configmanager.ijc.IJC;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class GenericDefaulter
implements IJC {
    public final String S_WSPROFILE_DEFAULTERS_ARG_NOT_SET = "WSProfile.Defaulters.arg_not_set";
    public final String S_WSPROFILE_DEFAULTERS_KEY_NOT_FOUND = "WSProfile.Defaulters.key.not.found";
    protected String sErrorMessage;
    protected String sDefaultedValue;
    protected boolean bDoIRun;
    private static final Logger LOGGER = LoggerFactory.createLogger(GenericDefaulter.class);
    private static final String S_CLASS_NAME = GenericDefaulter.class.getName();

    public boolean execute() {
        LOGGER.entering(GenericDefaulter.class.getName(), "execute");
        try {
            if (this.doIRun()) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "execute", "Executing defaulter:" + this.getClass().getName());
                boolean bl = this.runDefaulter();
                LOGGER.exiting(GenericDefaulter.class.getName(), "execute");
                return bl;
            }
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "execute", this.getClass().getName() + " did not run");
            LOGGER.exiting(GenericDefaulter.class.getName(), "execute");
            return true;
        }
        catch (Exception exception) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "An exception occurred while defaulting");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "Exception text:\n" + exception.getMessage());
            LogUtils.logException(LOGGER, exception);
            this.sErrorMessage = exception.getMessage();
            return false;
        }
    }

    public String getErrorOutput() {
        LOGGER.entering(GenericDefaulter.class.getName(), "getErrorOutput");
        LOGGER.exiting(GenericDefaulter.class.getName(), "getErrorOutput");
        return this.sErrorMessage;
    }

    public String getOutput() {
        LOGGER.entering(GenericDefaulter.class.getName(), "getOutput");
        if (this.bDoIRun) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getOutput", "Returning default value:" + this.sDefaultedValue);
            return "defaultValue=" + this.sDefaultedValue;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getOutput", "The defaulter was skipped, returning null");
        LOGGER.exiting(GenericDefaulter.class.getName(), "getOutput");
        return null;
    }

    public abstract boolean runDefaulter() throws Exception;

    public boolean doIRun() {
        LOGGER.entering(GenericDefaulter.class.getName(), "doIRun");
        this.bDoIRun = true;
        LOGGER.exiting(GenericDefaulter.class.getName(), "doIRun");
        return this.bDoIRun;
    }

    public boolean validateResourceBundleReturn(String string, String string2) {
        LOGGER.entering(GenericDefaulter.class.getName(), "resourceBundleReturn");
        if (string.equals(string2)) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("WSProfile.Defaulters.key.not.found", "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle"), string, "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "validateResourceBundleReturn", this.sErrorMessage);
            LOGGER.exiting(GenericDefaulter.class.getName(), "resourceBundleReturn");
            return false;
        }
        LOGGER.exiting(GenericDefaulter.class.getName(), "resourceBundleReturn");
        return true;
    }
}

