/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.defaulters;

import com.ibm.websphere.product.WASSystem;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import com.ibm.ws.profile.WASUtilities;
import com.ibm.ws.profile.WSProfileContext;
import com.ibm.ws.profile.defaulters.FindNodeCellNamesUtil;
import com.ibm.ws.profile.defaulters.UniqueTokenCreatorDefaulter;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.utils.StringUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileTemplate;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NodeNameDefaulter
extends UniqueTokenCreatorDefaulter {
    public static final String S_WSPROFILE_DEFAULTERS_NODE_NAME_SEED = "WSProfile.Defaulters.nodeNameSeed.";
    public static final String S_WSPROFILE_DEFAULTERS_NODE_NAME_OS400_TAIL = "WSProfile.Defaulters.nodeNameTail.os400.";
    private static final Logger LOGGER = LoggerFactory.createLogger(NodeNameDefaulter.class);
    private static final String S_CLASS_NAME = NodeNameDefaulter.class.getName();
    public static final String S_COLON = ":";
    public static final String S_FORCE_PREFIX = "force";
    public static final String S_IS_FORCE_REGEX = "^force:*";
    public static final String S_FORCE_DIST = "dist";
    public static final String S_FORCE_OS400 = "os400";
    public static final String S_FORCE_DIST_DEFAULT = "force:dist:default";
    public static final String S_FORCE_OS400_DEFAULT = "force:os400:default";

    public boolean runDefaulter() throws Exception {
        LOGGER.entering(NodeNameDefaulter.class.getName(), "runDefaulter");
        boolean bl = false;
        String string = System.getProperty("templatePath");
        String string2 = "";
        WSProfileTemplate wSProfileTemplate = new WSProfileTemplate(new File(string));
        string2 = wSProfileTemplate.getType();
        bl = this.generateNodeName(string2);
        if (bl) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runDefaulter", this.getOutput());
        }
        LOGGER.exiting(NodeNameDefaulter.class.getName(), "runDefaulter");
        return bl;
    }

    protected boolean generateOS400NodeName(String string, String string2) {
        String string3 = System.getProperty("profileName");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "generateOS400NodeName", "using os400 defaulter");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "generateOS400NodeName", "profileName set to [" + string3 + "] in system properties");
        this.sDefaultedValue = string.equals("cell.dmgr") || string.equals("dmgr") ? string3 + ResourceBundleUtils.getResourceBundleLocaleString(S_WSPROFILE_DEFAULTERS_NODE_NAME_OS400_TAIL + string, "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle") : (string2.equals("LOOPBACK") ? "LOCAL_" + string3 : string2 + "_" + string3);
        return true;
    }

    protected boolean generateDistributedNodeName(String string, String string2) throws Exception {
        this.setSeed(string2 + ResourceBundleUtils.getResourceBundleLocaleString(S_WSPROFILE_DEFAULTERS_NODE_NAME_SEED + string, "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle"));
        if (!this.validateResourceBundleReturn(S_WSPROFILE_DEFAULTERS_NODE_NAME_SEED + string, this.getSeed())) {
            return false;
        }
        String string3 = "";
        LinkedList<String> linkedList = new LinkedList<String>();
        WSProfileContext wSProfileContext = new WSProfileContext();
        wSProfileContext.saveCurrentContext();
        WASSystem wASSystem = WASSystem.getWASSystemInstance();
        String string4 = System.getProperty("WAS_HOME");
        String[] stringArray = wASSystem.getNonCachedWASLocations();
        if (stringArray.length > 1) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "generateDistributedNodeName", "Located the following WAS home(s): " + StringUtils.convertStringArrayToCommaSeparatedString(stringArray));
        } else {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "generateDistributedNodeName", "No other WAS home directories have been found");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string5;
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "generateDistributedNodeName", "Scanning WAS location:" + stringArray[i]);
            try {
                int n;
                wSProfileContext.switchContext(stringArray[i]);
                List list = WSProfile.listProfileNames();
                for (n = 0; n < list.size(); ++n) {
                    linkedList.add(WSProfile.getProfileLocation("" + list.get(n)).getAbsolutePath());
                }
                if (linkedList != null) {
                    for (n = 0; n < linkedList.size(); ++n) {
                        string5 = (String)linkedList.get(n);
                        FindNodeCellNamesUtil findNodeCellNamesUtil = new FindNodeCellNamesUtil(string5);
                        string3 = NodeNameDefaulter.addToken(string3, this.getTokensSeparator(), findNodeCellNamesUtil.getNodeNameFound());
                    }
                }
            }
            catch (Exception exception) {
                try {
                    string4 = new File(string4).getCanonicalPath();
                }
                catch (IOException iOException) {
                    string4 = null;
                    LOGGER.logp(Level.WARNING, S_CLASS_NAME, "generateDistributedNodeName", "Problems occurred when retrieving reference to current install.  Exception follows.");
                    LogUtils.logException(LOGGER, iOException);
                    throw exception;
                }
                string5 = null;
                try {
                    string5 = new File(stringArray[i]).getCanonicalPath();
                }
                catch (IOException iOException) {
                    string5 = null;
                    LOGGER.logp(Level.WARNING, S_CLASS_NAME, "generateDistributedNodeName", "Problems occurred when retrieving reference to the WAS install:" + stringArray[i]);
                    LogUtils.logException(LOGGER, iOException);
                }
                if (string4 != null && string5 != null) {
                    if (!string4.equals(string5)) {
                        LOGGER.logp(Level.WARNING, S_CLASS_NAME, "generateDistributedNodeName", "Ignoring incomplete installation: " + stringArray[i]);
                    }
                    LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "generateDistributeNodeName", "There are problems with the current install: " + stringArray[i]);
                    LogUtils.logException(LOGGER, exception);
                    throw exception;
                }
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "generateDistributedNodeName", "Ignoring incomplete installation: " + stringArray[i]);
            }
            linkedList = new LinkedList();
        }
        wSProfileContext.restoreSavedContext();
        this.setExistingTokens(string3);
        return this.generateSuggestion();
    }

    public boolean generateNodeName(String string) throws Exception {
        LOGGER.entering(NodeNameDefaulter.class.getName(), "generateNodeName");
        String string2 = string;
        String string3 = System.getProperty("hostName");
        if (string3 == null) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "generateNodeName", "hostName was not set in the system properties, will use an empty string");
            string3 = "";
        } else {
            string3 = WASUtilities.getShortHostName(string3);
        }
        if (this.isForcedOption(string2)) {
            return this.executeForcedOption(string2, string3);
        }
        if (PlatformConstants.isCurrentPlatformOS400()) {
            LOGGER.exiting(NodeNameDefaulter.class.getName(), "generateNodeName");
            return this.generateOS400NodeName(string2, string3);
        }
        LOGGER.exiting(NodeNameDefaulter.class.getName(), "generateNodeName");
        return this.generateDistributedNodeName(string2, string3);
    }

    private boolean isForcedOption(String string) {
        Pattern pattern = Pattern.compile(S_IS_FORCE_REGEX);
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    private boolean executeForcedOption(String string, String string2) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, S_COLON);
        stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        if (string3.equals(S_FORCE_DIST)) {
            return this.generateDistributedNodeName(string4, string2);
        }
        return this.generateOS400NodeName(string4, string2);
    }
}

