/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.defaulters;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.WASUtilities;
import com.ibm.ws.profile.defaulters.GenericDefaulter;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import java.io.File;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProfileLocationDefaulter
extends GenericDefaulter {
    private static final Logger LOGGER = LoggerFactory.createLogger(ProfileLocationDefaulter.class);
    private static final String S_CLASS_NAME = ProfileLocationDefaulter.class.getName();

    public boolean runDefaulter() throws Exception {
        LOGGER.entering(ProfileLocationDefaulter.class.getName(), "runDefaulter");
        char c = File.separatorChar;
        String string = WASUtilities.getWASProperty("WS_WSPROFILE_DEFAULT_PROFILE_HOME").trim();
        if (string == null || string.equals("")) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("WSProfile.Defaulters.arg_not_set", "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle"), "WS_WSPROFILE_DEFAULT_PROFILE_HOME");
            LOGGER.severe(this.sErrorMessage);
            LOGGER.exiting(ProfileLocationDefaulter.class.getName(), "runDefaulter");
            return false;
        }
        String string2 = System.getProperty("profileName");
        if (string2 == null || string2.equals("")) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("WSProfile.Defaulters.arg_not_set", "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle"), "profileName");
            LOGGER.severe(this.sErrorMessage);
            LOGGER.exiting(ProfileLocationDefaulter.class.getName(), "runDefaulter");
            return false;
        }
        this.sDefaultedValue = string + c + string2;
        File file = new File(this.sDefaultedValue);
        this.sDefaultedValue = file.getCanonicalPath();
        if (!this.sDefaultedValue.equals(file.getAbsolutePath())) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runDefaulter", "Potential symbolic link found.");
            this.sDefaultedValue = file.getAbsolutePath();
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runDefaulter", this.getOutput());
        LOGGER.exiting(ProfileLocationDefaulter.class.getName(), "runDefaulter");
        return true;
    }
}

