/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.defaulters;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.WASUtilities;
import com.ibm.ws.profile.defaulters.GenericDefaulter;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebServerPluginPathDefaulter
extends GenericDefaulter {
    public final String S_WSPROFILE_DEFAULTERS_WEBSERVER_PLUGIN_PATH_KEY = "WSProfile.Defaulters.webserver.pluginpath.";
    private static final Logger LOGGER = LoggerFactory.createLogger(WebServerPluginPathDefaulter.class);
    private static final String S_CLASS_NAME = WebServerPluginPathDefaulter.class.getName();
    public final String S_PERIOD = ".";
    public final String S_DEFAULT_PROGRAM_FILES_LOCATION = "C:\\Program Files";

    public boolean runDefaulter() throws IOException {
        String string;
        LOGGER.entering(WebServerPluginPathDefaulter.class.getName(), "runDefaulter");
        String string2 = System.getProperty("WAS_HOME");
        if (string2 == null) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("WSProfile.Defaulters.arg_not_set", "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle"), "WAS_HOME");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runDefaulter", this.sErrorMessage);
            LOGGER.exiting(WebServerPluginPathDefaulter.class.getName(), "runDefaulter");
            return false;
        }
        String string3 = System.getProperty("webServerType");
        if (string3 == null) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("WSProfile.Defaulters.arg_not_set", "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle"), "webServerType");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runDefaulter", this.sErrorMessage);
            LOGGER.exiting(WebServerPluginPathDefaulter.class.getName(), "runDefaulter");
            return false;
        }
        String string4 = System.getProperty("webServerOS");
        if (string4 == null) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("WSProfile.Defaulters.arg_not_set", "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle"), "webServerOS");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runDefaulter", this.sErrorMessage);
            LOGGER.exiting(WebServerPluginPathDefaulter.class.getName(), "runDefaulter");
            return false;
        }
        if (string4.equals("os390")) {
            string = string2;
            string = new File(string).getCanonicalPath();
        } else {
            string = ResourceBundleUtils.getResourceBundleLocaleString("WSProfile.Defaulters.webserver.pluginpath." + string3 + "." + string4, "com.ibm.ws.profile.defaulters.resourcebundle.DefaulterResourceBundle");
            if (string4.equals("windows")) {
                String string5 = WASUtilities.isWindows() ? WASUtilities.getEnvironmentVariable("ProgramFiles") : "C:\\Program Files";
                if (string5 == null || string5.equals("")) {
                    string5 = "C:\\Program Files";
                }
                string = MessageFormat.format(string, string5);
            }
        }
        this.sDefaultedValue = string;
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runDefaulter", this.getOutput());
        LOGGER.exiting(WebServerPluginPathDefaulter.class.getName(), "runDefaulter");
        return true;
    }

    public boolean doIRun() {
        LOGGER.entering(WebServerPluginPathDefaulter.class.getName(), "doIRun");
        this.bDoIRun = true;
        String string = System.getProperty("webServerCheck");
        if (string == null || !string.equals("true")) {
            this.bDoIRun = false;
        }
        LOGGER.exiting(WebServerPluginPathDefaulter.class.getName(), "doIRun");
        return this.bDoIRun;
    }
}

