/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.registry;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import com.ibm.ws.profile.utils.FileUtils;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.registry.Profile;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FSProfileRegistry {
    private String m_sPathToFSRegistryDirectory = null;
    private static final String S_WINDOWS_SCRIPT_SET_COMMAND = "set WAS_USER_SCRIPT=";
    private static final String S_UNIX_SCRIPT_SET_COMMAND_1 = "#!/bin/sh\nWAS_USER_SCRIPT=";
    private static final String S_UNIX_SCRIPT_SET_COMMAND_2 = "\nexport WAS_USER_SCRIPT";
    private static final String S_OS400_SCRIPT_SET_COMMAND_1 = "#!/usr/bin/qsh\nWAS_USER_SCRIPT=";
    private static final String S_OS400_SCRIPT_SET_COMMAND_2 = "\nexport WAS_USER_SCRIPT";
    private static final String S_BIN = "bin";
    private static final String S_WINDOWS_SCRIPT_RELATIVE_PATH = "bin\\setupCmdLine.bat";
    private static final String S_UNIX_SCRIPT_RELATIVE_PATH = "bin/setupCmdLine.sh";
    private static final String S_OS400_SCRIPT_RELATIVE_PATH = "bin/setupCmdLine";
    private static final String S_BAT = ".bat";
    private static final String S_SH = ".sh";
    private static final String S_OS400EXT = "";
    private static final String S_DEFAULT_SCRIPT_DIRECTORY = "_was_profile_default";
    private static final String S_DEFAULT_SCRIPT_NAME = "default";
    private static final String S_EMPTY = "";
    private static final Logger LOGGER = LoggerFactory.createLogger(FSProfileRegistry.class);
    private static final String S_CLASS_NAME = FSProfileRegistry.class.getName();
    private static Vector m_vsScriptPath = new Vector();

    public FSProfileRegistry(String string) {
        LOGGER.entering(this.getClass().getName(), "FSProfileRegistry");
        this.m_sPathToFSRegistryDirectory = new File(new File(string).getParent(), "fsdb").getAbsolutePath();
        LOGGER.exiting(this.getClass().getName(), "FSProfileRegistry");
    }

    public void deleteDefault(Profile profile) throws WSProfileException {
        LOGGER.entering(this.getClass().getName(), "deleteDefault");
        File file = new File(this.getDefaultScriptPath());
        File file2 = new File(this.getScriptPathForThisProfile(profile));
        String string = new String();
        String string2 = new String();
        try {
            string = FileUtils.readShellScript(file);
            string2 = FileUtils.readShellScript(file2);
        }
        catch (IOException iOException) {
            throw new WSProfileException(iOException.getMessage(), iOException.getLocalizedMessage());
        }
        if (string2 != null && string != null && !string2.equals("") && string2.equals(string)) {
            String string3 = file.getParent();
            file.delete();
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "deleteDefault", "Default profile script: " + file.getAbsolutePath() + " is deleted.");
            File file3 = new File(string3);
            if (file3 != null && file3.exists() && file3.isDirectory()) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "deleteDefault", "Default profile script's parent directory: " + file3.getAbsolutePath() + " is deleted.");
                file3.delete();
            }
        }
        LOGGER.exiting(this.getClass().getName(), "deleteDefault");
    }

    public void setDefault(Profile profile) throws WSProfileException {
        LOGGER.entering(this.getClass().getName(), "setDefault");
        File file = new File(this.getDefaultScriptPath());
        file.getParentFile().mkdirs();
        if (file != null && file.exists()) {
            file.delete();
        }
        try {
            FileUtils.createShellScript(file, this.getScriptForThisProfile(profile));
        }
        catch (IOException iOException) {
            throw new WSProfileException(iOException.getMessage(), iOException.getLocalizedMessage());
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "setDefault", "Added default profile: " + profile + " to the FS DB");
        LOGGER.exiting(this.getClass().getName(), "setDefault");
    }

    public void addProfileToRegistry(Profile profile) throws IOException {
        LOGGER.entering(this.getClass().getName(), "addProfileToRegistry");
        File file = new File(this.getScriptPathForThisProfile(profile));
        file.getParentFile().mkdirs();
        FileUtils.createShellScript(file, this.getScriptForThisProfile(profile));
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "addProfileToRegistry", "Added profile: " + profile + " to the FS DB");
        LOGGER.exiting(this.getClass().getName(), "addProfileToRegistry");
    }

    public void deleteProfileFromRegistry(Profile profile) throws WSProfileException {
        LOGGER.entering(this.getClass().getName(), "deleteProfileFromRegistry");
        if (profile.isDefault()) {
            this.deleteDefault(profile);
        }
        File file = new File(this.getScriptPathForThisProfile(profile));
        file.delete();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "deleteProfileFromRegistry", "Deleted profile: " + profile + " from the FS DB");
        File file2 = file.getParentFile();
        if (file2 != null && file2.isDirectory()) {
            file2.delete();
        }
        LOGGER.exiting(this.getClass().getName(), "deleteProfileFromRegistry");
    }

    public void purgeInvalidEntries(List list) throws WSProfileException {
        LOGGER.entering(this.getClass().getName(), "purgeInvalidEntries");
        for (int i = 0; i < list.size(); ++i) {
            Profile profile = (Profile)list.get(i);
            this.deleteProfileFromRegistry(profile);
        }
        LOGGER.exiting(this.getClass().getName(), "purgeInvalidEntries");
    }

    public boolean doesProfileScriptExist(Profile profile) {
        File file = new File(this.getScriptPathForThisProfile(profile));
        return file.exists();
    }

    private String getDefaultScriptPath() {
        LOGGER.entering(this.getClass().getName(), "getDefaultScriptPathForThisProfile");
        String string = null;
        string = PlatformConstants.isCurrentPlatformUNIX() ? S_SH : (PlatformConstants.isCurrentPlatformOS400() ? "" : S_BAT);
        String string2 = new File(this.m_sPathToFSRegistryDirectory, S_DEFAULT_SCRIPT_DIRECTORY + File.separator + S_DEFAULT_SCRIPT_NAME + string).getAbsolutePath();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getDefaultScriptPath", "The default script path is: " + string2);
        LOGGER.exiting(this.getClass().getName(), "getDefaultScriptPathForThisProfile");
        return string2;
    }

    private String getScriptPathForThisProfile(Profile profile) {
        LOGGER.entering(this.getClass().getName(), "getScriptPathForThisProfile");
        String string = null;
        string = PlatformConstants.isCurrentPlatformUNIX() ? S_SH : (PlatformConstants.isCurrentPlatformOS400() ? "" : S_BAT);
        String string2 = new File(this.m_sPathToFSRegistryDirectory, profile.getName() + string).getAbsolutePath();
        if (!m_vsScriptPath.contains(string2)) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getScriptPathForThisProfile", "The script path for this profile: " + profile + ", is: " + string2);
            m_vsScriptPath.add(string2);
        }
        LOGGER.exiting(this.getClass().getName(), "getScriptPathForThisProfile");
        return string2;
    }

    private String getScriptForThisProfile(Profile profile) {
        LOGGER.entering(this.getClass().getName(), "getScriptForThisProfile");
        String string = null;
        string = PlatformConstants.isCurrentPlatformUNIX() ? this.getUNIXScriptForThisProfile(profile) : (PlatformConstants.isCurrentPlatformOS400() ? this.getOS400ScriptForThisProfile(profile) : this.getWindowsScriptForThisProfile(profile));
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getScriptForThisProfile", "The profile script for this profile: " + profile + ", is: " + string);
        LOGGER.exiting(this.getClass().getName(), "getScriptForThisProfile");
        return string;
    }

    private String getWindowsScriptForThisProfile(Profile profile) {
        LOGGER.entering(this.getClass().getName(), "getWindowsScriptForThisProfile");
        String string = S_WINDOWS_SCRIPT_SET_COMMAND + new File(profile.getPath(), S_WINDOWS_SCRIPT_RELATIVE_PATH).getAbsolutePath();
        LOGGER.exiting(this.getClass().getName(), "getWindowsScriptForThisProfile");
        return string;
    }

    private String getUNIXScriptForThisProfile(Profile profile) {
        LOGGER.entering(this.getClass().getName(), "getUNIXScriptForThisProfile");
        String string = S_UNIX_SCRIPT_SET_COMMAND_1 + new File(profile.getPath(), S_UNIX_SCRIPT_RELATIVE_PATH).getAbsolutePath() + "\nexport WAS_USER_SCRIPT";
        LOGGER.exiting(this.getClass().getName(), "getUNIXScriptForThisProfile");
        return string;
    }

    private String getOS400ScriptForThisProfile(Profile profile) {
        LOGGER.entering(this.getClass().getName(), "getOS400ScriptForThisProfile");
        String string = S_OS400_SCRIPT_SET_COMMAND_1 + new File(profile.getPath(), S_OS400_SCRIPT_RELATIVE_PATH).getAbsolutePath() + "\nexport WAS_USER_SCRIPT";
        LOGGER.exiting(this.getClass().getName(), "getOS400ScriptForThisProfile");
        return string;
    }
}

