/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.registry;

import com.ibm.ws.profile.registry.FSProfileRegistry;
import com.ibm.ws.profile.utils.FileLocker;
import com.ibm.ws.profile.utils.FileLockerException;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.registry.Profile;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProfileRegistryMarshaller {
    private String m_sProfileRegistryPath = null;
    private FSProfileRegistry m_fspr = null;
    private FileLocker m_flRegistryLocker = null;
    private static final String S_TAG_PROFILES = "profiles";
    private static final String S_TAG_PROFILE = "profile";
    private static final String S_TAG_AUGMENTOR = "augmentor";
    private static final String S_ATTR_IS_DEFAULT = "isDefault";
    private static final String S_ATTR_IS_A_RESERVATION_TICKET = "isAReservationTicket";
    private static final String S_ATTR_NAME = "name";
    private static final String S_ATTR_PATH = "path";
    private static final String S_ATTR_TEMPLATE = "template";
    private static final String S_YES = "yes";
    private static final String S_INDENT_AMOUNT = "{http://xml.apache.org/xslt}indent-amount";
    private static final String S_N_INDENT_AMOUNT = "4";
    private static final String S_PROFILE_ALREADY_REGISTERED = "Profile is already registered.";
    private static final String S_PROFILE_EXISTS_KEY = "WSProfile.ProfileRegistryMarshaller.profileAlreadyExists";
    private static final String S_PROFILE_NOT_FOUND = "Profile not found: ";
    private static final String S_PROFILE_NOT_FOUND_KEY = "WSProfile.ProfileRegistryMarshaller.profileNotFound";
    private static final String S_PROFILE_REGISTRY_CORRUPT_NO_DEFAULT_PROFILE = "Profile registry is corrupt, no default profile defined";
    private static final String S_FILE_LOCK_ACQUIRE_FAILED = "";
    private static final String S_FILE_LOCK_ACQUIRE_FAILED_KEY = "WSProfile.ProfileRegistryMarshaller.fileLockAcquireFailed";
    private static final String S_FILE_LOCK_RELEASE_FAILED = "";
    private static final String S_FILE_LOCK_RELEASE_FAILED_KEY = "WSProfile.ProfileRegistryMarshaller.fileLockReleaseFailed";
    private static final String S_PROFILE_RESERVATION_TICKET_SET = "The profile is currently being created.  Please wait for creation to complete or validate the profile registry and try again.";
    private static final String S_PROFILE_RESERVATION_TICKET_SET_KEY = "WSProfile.ProfileRegistryMarshaller.profileTicketSet";

    public ProfileRegistryMarshaller(String string) {
        this.m_sProfileRegistryPath = string;
        this.m_fspr = new FSProfileRegistry(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProfileToRegistry(Profile profile) throws WSProfileException {
        this.acquireRegistryLock();
        try {
            this.throwExceptionIfTheGivenProfileIsAlreadyRegistered(profile);
            Vector vector = new Vector();
            if (this.doesProfileRegistryExist()) {
                vector = this.readProfileRegistry();
            }
            if (this.isProfileRegistryEmpty()) {
                profile.setDefault(true);
            }
            vector.add(profile);
            try {
                this.m_fspr.addProfileToRegistry(profile);
            }
            catch (IOException iOException) {
                throw new WSProfileException(iOException.getMessage(), iOException.getLocalizedMessage());
            }
            this.writeProfileRegistry(vector);
        }
        finally {
            this.releaseRegistryLock();
        }
        if (profile.isDefault()) {
            this.markProfileDefault(profile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCreateAddProfileToRegistry(Profile profile) throws WSProfileException {
        this.acquireRegistryLock();
        try {
            this.throwExceptionIfTheGivenProfileIsAlreadyRegistered(profile);
            Vector vector = new Vector();
            if (this.doesProfileRegistryExist()) {
                vector = this.readProfileRegistry();
            }
            vector.add(profile);
            this.writeProfileRegistry(vector);
        }
        finally {
            this.releaseRegistryLock();
        }
    }

    public void postCreateAddProfileToRegistry(Profile profile) throws WSProfileException {
        Vector vector = this.readProfileRegistry();
        if (!ProfileRegistryMarshaller.isThisProfileAlreadyPresentInThisVector(profile, vector)) {
            return;
        }
        boolean bl = this.isProfileRegistryEmpty();
        try {
            this.m_fspr.addProfileToRegistry(profile);
        }
        catch (IOException iOException) {
            throw new WSProfileException(iOException.getMessage(), iOException.getLocalizedMessage());
        }
        if (profile.isDefault() || bl) {
            this.markProfileDefault(profile);
        }
    }

    public Profile getProfile(String string) throws WSProfileException {
        List list = this.listProfilesInRegistry();
        for (int i = 0; i < list.size(); ++i) {
            Profile profile = (Profile)list.get(i);
            if (!profile.getName().equals(string)) continue;
            return profile;
        }
        throw new WSProfileException(S_PROFILE_NOT_FOUND + string, ResourceBundleUtils.getLocaleString(S_PROFILE_NOT_FOUND_KEY, string), false);
    }

    public Profile getProfile(String string, boolean bl) throws WSProfileException {
        List list = this.listAllProfilesInRegistry();
        for (int i = 0; i < list.size(); ++i) {
            Profile profile = (Profile)list.get(i);
            if (!profile.getName().equals(string)) continue;
            return profile;
        }
        throw new WSProfileException(S_PROFILE_NOT_FOUND + string, ResourceBundleUtils.getLocaleString(S_PROFILE_NOT_FOUND_KEY, string), false);
    }

    public Profile getProfile(File file) throws WSProfileException {
        List list = this.listProfilesInRegistry();
        for (int i = 0; i < list.size(); ++i) {
            Profile profile = (Profile)list.get(i);
            try {
                if (!profile.getPath().getCanonicalPath().equals(file.getCanonicalPath())) continue;
                return profile;
            }
            catch (IOException iOException) {
                throw new WSProfileException(iOException.getMessage(), iOException.getLocalizedMessage());
            }
        }
        throw new WSProfileException(S_PROFILE_NOT_FOUND + file, ResourceBundleUtils.getLocaleString(S_PROFILE_NOT_FOUND_KEY, file.toString()), false);
    }

    public void throwExceptionIfTheGivenProfileIsAlreadyRegistered(Profile profile) throws WSProfileException {
        if (this.isThisProfileAlreadyRegistered(profile)) {
            throw new WSProfileException(S_PROFILE_ALREADY_REGISTERED, ResourceBundleUtils.getLocaleString(S_PROFILE_EXISTS_KEY), true);
        }
    }

    public boolean isThisProfileAlreadyRegistered(Profile profile) throws WSProfileException {
        if (!this.doesProfileRegistryExist()) {
            return false;
        }
        Vector vector = this.readProfileRegistry();
        return ProfileRegistryMarshaller.isThisProfileAlreadyPresentInThisVector(profile, vector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteProfileFromRegistry(Profile profile) throws WSProfileException {
        this.acquireRegistryLock();
        try {
            Vector vector = this.readProfileRegistry();
            if (!vector.remove(profile)) {
                boolean bl = false;
                return bl;
            }
            this.m_fspr.deleteProfileFromRegistry(profile);
            this.writeProfileRegistry(vector);
        }
        finally {
            this.releaseRegistryLock();
        }
        if (profile.isDefault()) {
            this.markFirstProfileDefault();
        }
        return true;
    }

    public boolean isProfileRegistryEmpty() throws WSProfileException {
        if (!this.doesProfileRegistryExist()) {
            return true;
        }
        return this.listProfilesInRegistry().isEmpty();
    }

    public boolean isProfileRegistryCompletelyEmpty() throws WSProfileException {
        if (!this.doesProfileRegistryExist()) {
            return true;
        }
        return this.listAllProfilesInRegistry().isEmpty();
    }

    public List listProfilesInRegistry() throws WSProfileException {
        List list = this.listAllProfilesInRegistry();
        for (int i = 0; i < list.size(); ++i) {
            Profile profile = (Profile)list.get(i);
            if (this.isProfileCreated(profile)) continue;
            list.remove(i);
            --i;
        }
        return list;
    }

    public List listAllProfilesInRegistry() throws WSProfileException {
        return this.readProfileRegistry();
    }

    public void markFirstProfileDefault() throws WSProfileException {
        if (this.isProfileRegistryEmpty()) {
            return;
        }
        Vector vector = this.readProfileRegistry();
        Profile profile = (Profile)vector.elementAt(0);
        this.markProfileDefault(profile);
    }

    public void markProfileDefault(Profile profile) throws WSProfileException {
        if (this.isProfileRegistryEmpty()) {
            return;
        }
        this.acquireRegistryLock();
        Vector vector = this.readProfileRegistry();
        for (int i = 0; i < vector.size(); ++i) {
            Profile profile2 = (Profile)vector.elementAt(i);
            if (profile.equals(profile2)) {
                profile2.setDefault(true);
                this.m_fspr.setDefault(profile2);
                continue;
            }
            profile2.setDefault(false);
        }
        this.writeProfileRegistry(vector);
        this.releaseRegistryLock();
    }

    public Profile getDefaultProfile() throws WSProfileException {
        if (this.isProfileRegistryEmpty()) {
            return null;
        }
        List list = this.listProfilesInRegistry();
        for (int i = 0; i < list.size(); ++i) {
            Profile profile = (Profile)list.get(i);
            if (!profile.isDefault()) continue;
            return profile;
        }
        throw new WSProfileException(S_PROFILE_REGISTRY_CORRUPT_NO_DEFAULT_PROFILE);
    }

    public boolean markProfileReservationTicket(String string) throws WSProfileException {
        return this.setProfileReservationTicket(string, true);
    }

    public void unmarkProfileReservationTicket(String string) throws WSProfileException {
        this.setProfileReservationTicket(string, false);
    }

    public List purgeInvalidEntries() throws WSProfileException {
        if (!this.doesProfileRegistryExist()) {
            return new Vector(0);
        }
        this.acquireRegistryLock();
        Vector vector = this.readProfileRegistry();
        List list = this.getInvalidProfiles();
        Vector vector2 = (Vector)vector.clone();
        vector2.removeAll(list);
        this.m_fspr.purgeInvalidEntries(list);
        this.writeProfileRegistry(vector2);
        this.releaseRegistryLock();
        return list;
    }

    public void ensureThereIsOnlyASingleDefaultProfileInTheProfileRegistry() throws WSProfileException {
        if (!this.doesProfileRegistryExist()) {
            return;
        }
        if (this.isProfileRegistryEmpty()) {
            return;
        }
        Vector vector = this.readProfileRegistry();
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            Profile profile = (Profile)vector.elementAt(i);
            if (bl && profile.isDefault()) {
                profile.setDefault(false);
            }
            if (!profile.isDefault()) continue;
            bl = true;
        }
        if (!bl) {
            ((Profile)vector.elementAt(0)).setDefault(true);
        }
        this.writeProfileRegistry(vector);
    }

    public List getInvalidProfiles() throws WSProfileException {
        if (!this.doesProfileRegistryExist()) {
            return new Vector(0);
        }
        Vector vector = this.readProfileRegistry();
        Vector<Profile> vector2 = new Vector<Profile>();
        for (int i = 0; i < vector.size(); ++i) {
            Profile profile = (Profile)vector.elementAt(i);
            if (!profile.isProfileValid() || ProfileRegistryMarshaller.isThisProfileAlreadyPresentInThisVector(profile, vector2)) continue;
            vector2.add(profile);
        }
        Vector vector3 = (Vector)vector.clone();
        vector3.removeAll(vector2);
        return vector3;
    }

    public boolean isProfileCreated(Profile profile) {
        return this.m_fspr.doesProfileScriptExist(profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setProfileReservationTicket(String string, boolean bl) throws WSProfileException {
        this.acquireRegistryLock();
        try {
            if (!this.isProfileRegistryCompletelyEmpty()) {
                Vector vector = this.readProfileRegistry();
                for (int i = 0; i < vector.size(); ++i) {
                    Profile profile = (Profile)vector.elementAt(i);
                    if (!string.equals(profile.getName())) continue;
                    if (bl) {
                        if (profile.isAReservationTicket()) {
                            boolean bl2 = false;
                            return bl2;
                        }
                        profile.setAReservationTicket(true);
                        continue;
                    }
                    profile.setAReservationTicket(false);
                }
                this.writeProfileRegistry(vector);
            }
        }
        finally {
            this.releaseRegistryLock();
        }
        return true;
    }

    private void acquireRegistryLock() throws WSProfileException {
        try {
            this.m_flRegistryLocker = new FileLocker(this.m_sProfileRegistryPath);
            this.m_flRegistryLocker.acquireFileLock(300L, 20);
        }
        catch (FileLockerException fileLockerException) {
            throw new WSProfileException("", ResourceBundleUtils.getLocaleString(S_FILE_LOCK_ACQUIRE_FAILED_KEY, this.m_flRegistryLocker.getLockFilePath()), fileLockerException);
        }
        catch (IOException iOException) {
            throw new WSProfileException(iOException.getMessage());
        }
    }

    private void releaseRegistryLock() throws WSProfileException {
        try {
            this.m_flRegistryLocker.releaseFileLock();
        }
        catch (FileLockerException fileLockerException) {
            throw new WSProfileException("", ResourceBundleUtils.getLocaleString(S_FILE_LOCK_RELEASE_FAILED_KEY, this.m_flRegistryLocker.getLockFilePath()), fileLockerException);
        }
    }

    private static boolean isThisProfileAlreadyPresentInThisVector(Profile profile, Vector vector) throws WSProfileException {
        for (int i = 0; i < vector.size(); ++i) {
            Profile profile2 = (Profile)vector.elementAt(i);
            try {
                if (!profile2.getName().equals(profile.getName()) && !profile2.getPath().getCanonicalPath().equals(profile.getPath().getCanonicalPath())) continue;
                return true;
            }
            catch (IOException iOException) {
                throw new WSProfileException(iOException.getMessage(), iOException.getLocalizedMessage());
            }
        }
        return false;
    }

    private boolean doesProfileRegistryExist() {
        return new File(this.m_sProfileRegistryPath).exists();
    }

    private Vector readProfileRegistry() throws WSProfileException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            Document document = documentBuilderFactory.newDocumentBuilder().parse(new File(this.m_sProfileRegistryPath));
            NodeList nodeList = document.getElementsByTagName(S_TAG_PROFILE);
            return this.unmarshallProfilesFromDOM(nodeList);
        }
        catch (Exception exception) {
            throw new WSProfileException(exception.getMessage(), exception.getLocalizedMessage());
        }
    }

    private void writeProfileRegistry(Vector vector) throws WSProfileException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement(S_TAG_PROFILES);
            for (int i = 0; i < vector.size(); ++i) {
                Profile profile = (Profile)vector.elementAt(i);
                Element element2 = this.marshallThisProfileToDOM(profile, document);
                element.appendChild(element2);
            }
            document.appendChild(element);
            this.saveDocumentToProfileRegistry(document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new WSProfileException(parserConfigurationException.getMessage(), parserConfigurationException.getLocalizedMessage());
        }
    }

    private Vector unmarshallProfilesFromDOM(NodeList nodeList) {
        Vector<Profile> vector = new Vector<Profile>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            boolean bl = Boolean.valueOf(node.getAttributes().getNamedItem(S_ATTR_IS_DEFAULT).getNodeValue());
            Node node2 = node.getAttributes().getNamedItem(S_ATTR_IS_A_RESERVATION_TICKET);
            boolean bl2 = Boolean.valueOf(node2 == null ? "false" : node2.getNodeValue());
            String string = node.getAttributes().getNamedItem(S_ATTR_NAME).getNodeValue();
            String string2 = node.getAttributes().getNamedItem(S_ATTR_PATH).getNodeValue();
            String string3 = node.getAttributes().getNamedItem(S_ATTR_TEMPLATE).getNodeValue();
            Profile profile = new Profile(string, new File(string2), new File(string3), bl, bl2);
            this.unmarshallAugmentorsForThisProfile(node, profile);
            vector.add(profile);
        }
        return vector;
    }

    private void unmarshallAugmentorsForThisProfile(Node node, Profile profile) {
        Element element = (Element)node;
        NodeList nodeList = element.getElementsByTagName(S_TAG_AUGMENTOR);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getAttributes().getNamedItem(S_ATTR_TEMPLATE).getNodeValue();
            profile.addAugmentor(string);
        }
    }

    private Element marshallThisProfileToDOM(Profile profile, Document document) {
        Element element = document.createElement(S_TAG_PROFILE);
        element.setAttribute(S_ATTR_IS_DEFAULT, Boolean.toString(profile.isDefault()));
        element.setAttribute(S_ATTR_IS_A_RESERVATION_TICKET, Boolean.toString(profile.isAReservationTicket()));
        element.setAttribute(S_ATTR_NAME, profile.getName());
        element.setAttribute(S_ATTR_PATH, profile.getPath().getAbsolutePath());
        element.setAttribute(S_ATTR_TEMPLATE, profile.getTemplate().getAbsolutePath());
        List list = profile.getAugmentors();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Element element2 = document.createElement(S_TAG_AUGMENTOR);
            element2.setAttribute(S_ATTR_TEMPLATE, string);
            element.appendChild(element2);
        }
        return element;
    }

    private void saveDocumentToProfileRegistry(Document document) throws WSProfileException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(document);
            File file = new File(this.m_sProfileRegistryPath);
            StreamResult streamResult = new StreamResult(file.toURI().getPath());
            transformer.setOutputProperty("indent", S_YES);
            transformer.setOutputProperty(S_INDENT_AMOUNT, S_N_INDENT_AMOUNT);
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new WSProfileException(transformerConfigurationException.getMessage(), transformerConfigurationException.getLocalizedMessage());
        }
        catch (TransformerException transformerException) {
            throw new WSProfileException(transformerException.getMessage(), transformerException.getLocalizedMessage());
        }
    }
}

