/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.registry;

import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.registry.Profile;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProfileRegistrySnippetMarshaller {
    private static final String S_TAG_PROFILES = "profiles";
    private static final String S_TAG_PROFILE = "profile";
    private static final String S_TAG_AUGMENTOR = "augmentor";
    private static final String S_ATTR_IS_DEFAULT = "isDefault";
    private static final String S_ATTR_IS_A_RESERVATION_TICKET = "isAReservationTicket";
    private static final String S_ATTR_NAME = "name";
    private static final String S_ATTR_PATH = "path";
    private static final String S_ATTR_TEMPLATE = "template";
    private static final String S_YES = "yes";
    private static final String S_INDENT_AMOUNT = "{http://xml.apache.org/xslt}indent-amount";
    private static final String S_N_INDENT_AMOUNT = "4";
    private static final String S_INVALID_NUMBER_OF_PROFILES_IN_SNIPPET = "An invalid number of profiles exist in the profile registry snippet.";
    private static final String S_INVALID_NUMBER_OF_PROFILES_IN_SNIPPET_KEY = "WSProfile.ProfileRegistrySnippetMarshaller.invalidNumberOfProfiles";

    public static void writeProfileToRegistrySnippetFile(Profile profile, File file) throws WSProfileException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement(S_TAG_PROFILES);
            Element element2 = ProfileRegistrySnippetMarshaller.marshallThisProfileToDOM(profile, document);
            element.appendChild(element2);
            document.appendChild(element);
            ProfileRegistrySnippetMarshaller.saveDocumentToProfileRegistry(document, file);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new WSProfileException(parserConfigurationException.getMessage(), parserConfigurationException.getLocalizedMessage());
        }
    }

    public static Profile readProfileFromRegistrySnippetInputStream(InputStream inputStream) throws WSProfileException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            Document document = documentBuilderFactory.newDocumentBuilder().parse(inputStream);
            Vector vector = ProfileRegistrySnippetMarshaller.readProfileRegistryFromDOM(document);
            if (vector.size() != 1) {
                throw new WSProfileException(S_INVALID_NUMBER_OF_PROFILES_IN_SNIPPET, ResourceBundleUtils.getLocaleString(S_INVALID_NUMBER_OF_PROFILES_IN_SNIPPET_KEY), true);
            }
            return (Profile)vector.get(0);
        }
        catch (Exception exception) {
            throw new WSProfileException(exception.getMessage(), exception.getLocalizedMessage());
        }
    }

    public static boolean deleteProfileRegistrySnippet(File file) {
        return file.delete();
    }

    private static Vector readProfileRegistryFromDOM(Document document) throws WSProfileException {
        NodeList nodeList = document.getElementsByTagName(S_TAG_PROFILE);
        return ProfileRegistrySnippetMarshaller.unmarshallProfilesFromDOM(nodeList);
    }

    private static Vector unmarshallProfilesFromDOM(NodeList nodeList) {
        Vector<Profile> vector = new Vector<Profile>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            boolean bl = Boolean.valueOf(node.getAttributes().getNamedItem(S_ATTR_IS_DEFAULT).getNodeValue());
            Node node2 = node.getAttributes().getNamedItem(S_ATTR_IS_A_RESERVATION_TICKET);
            boolean bl2 = Boolean.valueOf(node2 == null ? "false" : node2.getNodeValue());
            String string = node.getAttributes().getNamedItem(S_ATTR_NAME).getNodeValue();
            String string2 = node.getAttributes().getNamedItem(S_ATTR_PATH).getNodeValue();
            String string3 = node.getAttributes().getNamedItem(S_ATTR_TEMPLATE).getNodeValue();
            Profile profile = new Profile(string, new File(string2), new File(string3), bl, bl2);
            ProfileRegistrySnippetMarshaller.unmarshallAugmentorsForThisProfile(node, profile);
            vector.add(profile);
        }
        return vector;
    }

    private static Element marshallThisProfileToDOM(Profile profile, Document document) {
        Element element = document.createElement(S_TAG_PROFILE);
        element.setAttribute(S_ATTR_IS_DEFAULT, Boolean.toString(profile.isDefault()));
        element.setAttribute(S_ATTR_IS_A_RESERVATION_TICKET, Boolean.toString(profile.isAReservationTicket()));
        element.setAttribute(S_ATTR_NAME, profile.getName());
        element.setAttribute(S_ATTR_PATH, profile.getPath().getAbsolutePath());
        element.setAttribute(S_ATTR_TEMPLATE, profile.getTemplate().getAbsolutePath());
        List list = profile.getAugmentors();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Element element2 = document.createElement(S_TAG_AUGMENTOR);
            element2.setAttribute(S_ATTR_TEMPLATE, string);
            element.appendChild(element2);
        }
        return element;
    }

    private static void unmarshallAugmentorsForThisProfile(Node node, Profile profile) {
        Element element = (Element)node;
        NodeList nodeList = element.getElementsByTagName(S_TAG_AUGMENTOR);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getAttributes().getNamedItem(S_ATTR_TEMPLATE).getNodeValue();
            profile.addAugmentor(string);
        }
    }

    private static void saveDocumentToProfileRegistry(Document document, File file) throws WSProfileException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(file);
            transformer.setOutputProperty("indent", S_YES);
            transformer.setOutputProperty(S_INDENT_AMOUNT, S_N_INDENT_AMOUNT);
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new WSProfileException(transformerConfigurationException.getMessage(), transformerConfigurationException.getLocalizedMessage());
        }
        catch (TransformerException transformerException) {
            throw new WSProfileException(transformerException.getMessage(), transformerException.getLocalizedMessage());
        }
    }
}

