/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.cli.CommandLineArgument;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CommandLineArgumentsUtils {
    private static final String S_DASH = "-";
    private static final Logger LOGGER = LoggerFactory.createLogger(CommandLineArgumentsUtils.class);
    private static final String S_CLASS_NAME = CommandLineArgumentsUtils.class.getName();

    public static Hashtable convertCommandLineToHashtable(String[] stringArray) {
        LOGGER.entering(CommandLineArgumentsUtils.class.getName(), "convertCommandLineToHashtable");
        Hashtable<String, Vector> hashtable = new Hashtable<String, Vector>();
        if (stringArray.length == 0) {
            return hashtable;
        }
        if (!stringArray[0].startsWith(S_DASH)) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "convertCommandLineToHashtable", "Invalid incoming command line");
            LOGGER.exiting(CommandLineArgumentsUtils.class.getName(), "convertCommandLineToHashtable");
            return hashtable;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n].substring(S_DASH.length());
            Vector vector = CommandLineArgumentsUtils.getArgumentValues(stringArray, n);
            hashtable.put(string, vector);
            n = n + vector.size() + 1;
        }
        LOGGER.exiting(CommandLineArgumentsUtils.class.getName(), "convertCommandLineToHashtable");
        return hashtable;
    }

    public static Vector getArgumentValues(String[] stringArray, int n) {
        String string;
        LOGGER.entering(CommandLineArgumentsUtils.class.getName(), "getArgumentValues");
        Vector<String> vector = new Vector<String>();
        for (int i = n + 1; i < stringArray.length && !(string = stringArray[i]).startsWith(S_DASH); ++i) {
            vector.add(string);
        }
        LOGGER.exiting(CommandLineArgumentsUtils.class.getName(), "getArgumentValues");
        return vector;
    }

    public static Vector convertIncomingCommandLineToCommandLineArguments(String[] stringArray) {
        LOGGER.entering(CommandLineArgumentsUtils.class.getName(), "convertIncomingCommandLineToCommandLineArguments");
        if (stringArray.length == 0) {
            return new Vector();
        }
        if (!stringArray[0].startsWith(S_DASH)) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "convertIncomingCommandLineToCommandLineArguments", "Invalid incoming command line");
            LOGGER.exiting(CommandLineArgumentsUtils.class.getName(), "convertIncomingCommandLineToCommandLineArguments");
            return new Vector();
        }
        Vector<CommandLineArgument> vector = new Vector<CommandLineArgument>();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n].substring(S_DASH.length());
            Vector vector2 = CommandLineArgumentsUtils.getArgumentValues(stringArray, n);
            vector.add(new CommandLineArgument(string, vector2));
            n = n + vector2.size() + 1;
        }
        LOGGER.exiting(CommandLineArgumentsUtils.class.getName(), "convertIncomingCommandLineToCommandLineArguments");
        return vector;
    }
}

