/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import com.ibm.ws.install.configmanager.ConfigManagerConstants;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.DefaultValueManager;
import com.ibm.ws.install.configmanager.utils.SystemPropertiesUtils;
import com.ibm.ws.profile.utils.CommandLineArgumentsUtils;
import com.ibm.ws.profile.utils.PrereqTemplateUtils;
import com.ibm.ws.profile.utils.ValidationManagerUtils;
import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultValueManagerUtils {
    private static List m_listSortedDefaultValueManagers = null;
    private static Hashtable m_hashtableDVMCache = null;
    private static final String S_EMPTY = "";
    private static final Logger LOGGER = LoggerFactory.createLogger(DefaultValueManagerUtils.class);
    private static final String S_CLASS_NAME = DefaultValueManagerUtils.class.getName();

    public static String getDefaultValue(String string) {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "getDefaultValue");
        String[] stringArray = new String[]{string};
        Hashtable hashtable = DefaultValueManagerUtils.getDefaultValues(stringArray, new Hashtable());
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "getDefaultValue");
        return (String)hashtable.get(string);
    }

    public static String getDefaultValue(String string, Map map) {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "getDefaultValue");
        String[] stringArray = new String[]{string};
        Hashtable hashtable = DefaultValueManagerUtils.getDefaultValues(stringArray, map);
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "getDefaultValue");
        return (String)hashtable.get(string);
    }

    public static Hashtable getDefaultValues(String[] stringArray, Map map) {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "getDefaultValues");
        Properties properties = SystemPropertiesUtils.setArgumentsIntoSystemProperties(map);
        DefaultValueManagerUtils.initialize();
        Map map2 = DefaultValueManagerUtils.matchArgumentsToDefaultValueManager(stringArray);
        Hashtable hashtable = DefaultValueManagerUtils.executeAllDefaulters(map2, map);
        SystemPropertiesUtils.resetSystemProperties(properties);
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "getDefaultValues");
        return hashtable;
    }

    public static String getDefaultValue(String string, String[] stringArray) {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "getDefaultValue");
        String[] stringArray2 = new String[]{string};
        Hashtable hashtable = CommandLineArgumentsUtils.convertCommandLineToHashtable(stringArray);
        Hashtable hashtable2 = DefaultValueManagerUtils.getDefaultValues(stringArray2, hashtable);
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "getDefaultValue");
        return (String)hashtable2.get(string);
    }

    public static Hashtable getDefaultValues(String[] stringArray, String[] stringArray2) {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "getDefaultValues");
        Hashtable hashtable = CommandLineArgumentsUtils.convertCommandLineToHashtable(stringArray2);
        Hashtable hashtable2 = DefaultValueManagerUtils.getDefaultValues(stringArray, hashtable);
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "getDefaultValues");
        return hashtable2;
    }

    public static void reinitialize() {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "reInitialize");
        m_listSortedDefaultValueManagers = null;
        m_hashtableDVMCache = null;
        DefaultValueManagerUtils.initialize();
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "reInitialize");
    }

    private static Hashtable executeAllDefaulters(Map map, Map map2) {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "executeAllDefaulters");
        Hashtable hashtable = new Hashtable();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Vector<String> vector = new Vector<String>();
            String string = (String)iterator.next();
            vector.add(string);
            DefaultValueManager defaultValueManager = (DefaultValueManager)map.get(string);
            Hashtable hashtable2 = defaultValueManager.getDefaultValues(vector, map2);
            hashtable.putAll(hashtable2);
            map2.putAll(hashtable2);
        }
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "executeAllDefaulters");
        return hashtable;
    }

    private static void initialize() {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "initialize");
        if (m_hashtableDVMCache == null) {
            m_hashtableDVMCache = new Hashtable();
        }
        String string = DefaultValueManagerUtils.determineTemplatePath();
        String string2 = DefaultValueManagerUtils.determineCurrentMode();
        String string3 = DefaultValueManagerUtils.determineProfileName();
        List list = PrereqTemplateUtils.getListOfTemplatePathsForMode(string2, string3, string);
        DefaultValueManagerUtils.createDefaultValueManagers(list, string2);
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "initialize");
    }

    private static DefaultValueManager findDefaultValueManagerForArgument(String string) {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "findDefaultValueManagerForArgument");
        for (int i = m_listSortedDefaultValueManagers.size() - 1; i >= 0; --i) {
            DefaultValueManager defaultValueManager = (DefaultValueManager)m_listSortedDefaultValueManagers.get(i);
            if (!defaultValueManager.isArgumentAvailableForDefaulting(string)) continue;
            LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "findDefaultValueManagerForArgument");
            return defaultValueManager;
        }
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "findDefaultValueManagerForArgument");
        return null;
    }

    private static Map matchArgumentsToDefaultValueManager(String[] stringArray) {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "matchArgumentsToDefaultValueManager");
        LinkedHashMap<String, DefaultValueManager> linkedHashMap = new LinkedHashMap<String, DefaultValueManager>();
        if (m_listSortedDefaultValueManagers != null) {
            for (int i = 0; i < m_listSortedDefaultValueManagers.size(); ++i) {
                DefaultValueManager defaultValueManager = (DefaultValueManager)m_listSortedDefaultValueManagers.get(i);
                String[] stringArray2 = defaultValueManager.getAllArgsInDefaultingOrder(stringArray);
                for (int j = 0; j < stringArray2.length; ++j) {
                    String string = stringArray2[j];
                    if (!defaultValueManager.isArgumentAvailableForDefaulting(string)) continue;
                    linkedHashMap.put(string, defaultValueManager);
                }
            }
        }
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "matchArgumentsToDefaultValueManager");
        return linkedHashMap;
    }

    private static void createDefaultValueManagers(List list, String string) {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "createDefaultValueManagers");
        Vector<DefaultValueManager> vector = new Vector<DefaultValueManager>();
        if (m_hashtableDVMCache == null) {
            m_hashtableDVMCache = new Hashtable();
        }
        for (int i = 0; i < list.size(); ++i) {
            DefaultValueManager defaultValueManager;
            File file = (File)list.get(i);
            if (m_hashtableDVMCache.get(file) != null) {
                defaultValueManager = (DefaultValueManager)m_hashtableDVMCache.get(file);
            } else {
                String string2 = file.getAbsolutePath();
                String string3 = DefaultValueManagerUtils.determineActionRegistryFileName();
                defaultValueManager = new DefaultValueManager(string2, string2 + File.separator + string3);
                m_hashtableDVMCache.put(file, defaultValueManager);
            }
            vector.add(defaultValueManager);
        }
        m_listSortedDefaultValueManagers = vector;
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "createDefaultValueManagers");
    }

    private static String determineActionRegistry() {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "determineActionRegistry");
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "determineActionRegistry");
        return System.getProperty(ConfigManagerConstants.S_ARG_ACTION_REGISTRY);
    }

    private static String determineActionRegistryFileName() {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "determineActionRegistryFileName");
        String string = DefaultValueManagerUtils.determineActionRegistry();
        if (string != null && !string.equals(S_EMPTY)) {
            File file = new File(string);
            LOGGER.exiting(ValidationManagerUtils.class.getName(), "determineActionRegistryFileName");
            return file.getName();
        }
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "determineActionRegistryFileName");
        return S_EMPTY;
    }

    private static String determineTemplatePath() {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "determineTemplatePath");
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "determineTemplatePath");
        return System.getProperty(ConfigManagerConstants.S_ARG_CONFIG_DIR);
    }

    private static String determineProfileName() {
        LOGGER.entering(DefaultValueManagerUtils.class.getName(), "determineProfileName");
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "determineProfileName");
        return System.getProperty("profileName");
    }

    private static String determineCurrentMode() {
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "initialize");
        String string = System.getProperty("create");
        String string2 = System.getProperty("augment");
        String string3 = null;
        if (string == null && string2 == null) {
            string3 = null;
        } else if (string == null && string2.equals(S_EMPTY)) {
            string3 = "augment";
        } else if (string.equals(S_EMPTY) && string2 == null) {
            string3 = "create";
        } else if (string.equals(S_EMPTY) && string2.equals(S_EMPTY)) {
            string3 = null;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "determineCurrentMode", "Mode was determined to be: " + string3);
        LOGGER.exiting(DefaultValueManagerUtils.class.getName(), "initialize");
        return string3;
    }
}

