/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import com.ibm.ws.profile.utils.FileLockerException;
import java.io.File;
import java.io.IOException;

public class FileLocker {
    private String m_sLockFilePath = null;
    private String m_sLockFileDirectory = null;
    private static final String S_LOCK = "_LOCK";
    private static final String S_FILE_LOCK_ACQUIRE_FAILED = "File lock acquire failed for: ";
    private static final String S_FILE_LOCK_RELEASE_FAILED = "File lock release failed for: ";
    private static final String S_FILE_PERMISSION_DENIED = "This userid has not been granted full read/write permissions for the directory: ";
    private static final String S_PERMISSION_DENIED = "Permission denied";

    public FileLocker(File file) throws IOException {
        this.m_sLockFileDirectory = file.getParentFile().getAbsolutePath();
        this.m_sLockFilePath = file.getCanonicalPath() + S_LOCK;
    }

    public FileLocker(String string) throws IOException {
        this(new File(string));
    }

    public void acquireFileLock() throws FileLockerException, IOException {
        this.acquireFileLock(0L, 1);
    }

    public void acquireFileLock(long l, int n) throws FileLockerException, IOException {
        File file = new File(this.m_sLockFilePath);
        for (int i = 0; i < n; ++i) {
            block6: {
                try {
                    if (!file.exists() && file.createNewFile()) {
                        return;
                    }
                }
                catch (IOException iOException) {
                    if (!iOException.getMessage().equals(S_PERMISSION_DENIED)) break block6;
                    throw new IOException(S_FILE_PERMISSION_DENIED + this.m_sLockFileDirectory);
                }
            }
            if (i >= n - 1) continue;
            try {
                Thread.sleep(l);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw new FileLockerException(file);
    }

    public void releaseFileLock() throws FileLockerException {
        File file = new File(this.m_sLockFilePath);
        if (!file.delete()) {
            throw new FileLockerException(file);
        }
    }

    public String getLockFilePath() {
        return this.m_sLockFilePath;
    }
}

