/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileUtils {
    private static final int N_IO_BUFFER_SIZE = 4096;
    private static final String S_TMP_FILE_PREFIX = "~$WSP";
    private static final String S_DOT_ESCAPE = "\\.";
    private static final String S_ANY_CHAR = ".*";
    private static final String S_DOT = ".";
    private static final String S_DOTS = "..";
    private static final Logger LOGGER = LoggerFactory.createLogger(FileUtils.class);
    private static final String S_CLASS_NAME = FileUtils.class.getName();

    public static void copyFile(File file, File file2) throws FileNotFoundException, IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[4096];
        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        ((InputStream)fileInputStream).close();
        ((OutputStream)fileOutputStream).close();
    }

    public static void createShellScript(File file, String string) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        String string2 = PlatformConstants.getProperEncodingForCurrentOSShellScripts();
        ((OutputStream)fileOutputStream).write(string.getBytes(string2));
        ((OutputStream)fileOutputStream).close();
    }

    public static boolean isDirectoryWritable(File file) {
        if (file.exists()) {
            try {
                File file2 = File.createTempFile(S_TMP_FILE_PREFIX, null, file);
                file2.delete();
            }
            catch (IOException iOException) {
                return false;
            }
        } else {
            if (!file.mkdirs()) {
                return false;
            }
            file.delete();
        }
        return true;
    }

    public static String readShellScript(File file) throws IOException {
        if (file != null && file.exists()) {
            String string = PlatformConstants.getProperEncodingForCurrentOSShellScripts();
            FileInputStream fileInputStream = null;
            fileInputStream = new FileInputStream(file.getAbsolutePath());
            byte[] byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            String string2 = new String(byArray, string);
            fileInputStream.close();
            return string2;
        }
        return null;
    }

    public static Vector convertStringListToFileVector(List list) {
        Vector<File> vector = new Vector<File>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            vector.add(new File((String)list.get(i)));
        }
        return vector;
    }

    public static String[] getLatestJarFiles(String[] stringArray, String[] stringArray2) {
        int n;
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n = 0; n < stringArray.length; ++n) {
            arrayList2 = new ArrayList();
            for (int i = 0; i < stringArray2.length; ++i) {
                Matcher matcher;
                if (stringArray[n] == null || stringArray2[i] == null || !(matcher = Pattern.compile(stringArray[n].replaceAll(S_DOT_ESCAPE, S_DOT_ESCAPE) + S_ANY_CHAR).matcher(stringArray2[i])).matches()) continue;
                arrayList2.add(stringArray2[i]);
            }
            if (arrayList2.size() < 1) continue;
            Collections.sort(arrayList2);
            arrayList.add(arrayList2.get(arrayList2.size() - 1));
        }
        Object[] objectArray = arrayList.toArray();
        String[] stringArray3 = new String[objectArray.length];
        for (n = 0; n < objectArray.length; ++n) {
            stringArray3[n] = (String)objectArray[n];
        }
        return stringArray3;
    }

    public static List convertFileListIntoCanonicalForm(List list) throws IOException {
        Vector<File> vector = new Vector<File>();
        for (int i = 0; i < list.size(); ++i) {
            vector.add(i, ((File)list.get(i)).getCanonicalFile());
        }
        return vector;
    }

    public static String getNormalizedPath(String string) {
        if (string == null) {
            return null;
        }
        return FileUtils.getNormalizedPath(new File(string).getAbsoluteFile()).getPath();
    }

    public static File getNormalizedPath(File file) {
        CharSequence charSequence;
        if (file == null) {
            return null;
        }
        String string = new String(file.getAbsolutePath());
        boolean bl = string.endsWith(File.separator);
        boolean bl2 = string.startsWith(File.separator);
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
        Vector<CharSequence> vector = new Vector<CharSequence>();
        while (stringTokenizer.hasMoreTokens()) {
            charSequence = stringTokenizer.nextToken();
            if (S_DOT.equals(charSequence)) continue;
            if (vector.size() > 1 && PlatformConstants.isCurrentPlatformWindows() && S_DOTS.equals(charSequence)) {
                vector.remove(vector.size() - 1);
                continue;
            }
            if (vector.size() > 0 && !PlatformConstants.isCurrentPlatformWindows() && S_DOTS.equals(charSequence)) {
                vector.remove(vector.size() - 1);
                continue;
            }
            if (S_DOTS.equals(charSequence)) continue;
            vector.add(charSequence);
        }
        charSequence = new StringBuffer();
        if (bl2) {
            ((StringBuffer)charSequence).append(File.separator);
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ((StringBuffer)charSequence).append(iterator.next());
            if (!iterator.hasNext()) continue;
            ((StringBuffer)charSequence).append(File.separator);
        }
        if (bl) {
            ((StringBuffer)charSequence).append(File.separator);
        } else if (PlatformConstants.isCurrentPlatformWindows() && vector.size() == 1) {
            ((StringBuffer)charSequence).append(File.separator);
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getNormalizedPath", "The path " + string + " was sucessfully normalized to " + ((StringBuffer)charSequence).toString());
        return new File(((StringBuffer)charSequence).toString());
    }
}

