/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import com.ibm.websphere.product.WASSystem;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.management.util.PortConflictResolverException;
import com.ibm.ws.management.util.PortConflictResolverNoTrace;
import com.ibm.ws.profile.utils.FreePortDetector;
import com.ibm.ws.profile.utils.PrereqTemplateUtils;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.utils.StringUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.registry.Profile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PortResolutionUtils {
    private static final String S_CONFIG = "config";
    private static final String S_EMPTY = "";
    public static final int nMAX_PORT_VALUE = 65535;
    private static final String S_INVALID_NUMER_EXCEPTION = "WSProfile.PortResolutionUtils.invalidnumber";
    private static final String S_UNABLE_TO_RECOMMEND_PORT = "WSProfile.PortResolutionUtils.unableToRecommend";
    private static final Logger LOGGER = LoggerFactory.createLogger(PortResolutionUtils.class);
    private static final String S_CLASS_NAME = PortResolutionUtils.class.getName();

    public static Hashtable recommendPorts(String[] stringArray, int n) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "recommendPorts");
        LOGGER.exiting(PortResolutionUtils.class.getName(), "recommendPorts");
        return PortResolutionUtils.recommendPorts(stringArray, n, new File(S_EMPTY));
    }

    public static Hashtable recommendPorts(String[] stringArray, int n, File file) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "recommendPorts");
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        PortConflictResolverNoTrace portConflictResolverNoTrace = PortResolutionUtils.createPortConflictResolver(file);
        int n2 = n;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n3 = PortResolutionUtils.resolvePort(n2, portConflictResolverNoTrace);
            ++n2;
            hashtable.put(string, new Integer(n3));
        }
        LOGGER.exiting(PortResolutionUtils.class.getName(), "recommendPorts");
        return hashtable;
    }

    public static Hashtable recommendPorts(String[] stringArray, int n, File file, int[] nArray) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "recommendPorts");
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        PortConflictResolverNoTrace portConflictResolverNoTrace = PortResolutionUtils.createPortConflictResolver(file, nArray);
        int n2 = n;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n3 = PortResolutionUtils.resolvePort(n2, portConflictResolverNoTrace);
            ++n2;
            hashtable.put(string, new Integer(n3));
        }
        LOGGER.exiting(PortResolutionUtils.class.getName(), "recommendPorts");
        return hashtable;
    }

    public static Hashtable recommendPorts(String[] stringArray, int[] nArray) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "recommendPorts");
        LOGGER.exiting(PortResolutionUtils.class.getName(), "recommendPorts");
        return PortResolutionUtils.recommendPorts(stringArray, nArray, new File(S_EMPTY));
    }

    public static Hashtable recommendPorts(String[] stringArray, int[] nArray, File file) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "recommendPorts");
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        PortConflictResolverNoTrace portConflictResolverNoTrace = PortResolutionUtils.createPortConflictResolver(file);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = PortResolutionUtils.resolvePort(nArray[i], portConflictResolverNoTrace);
            hashtable.put(string, new Integer(n));
        }
        LOGGER.exiting(PortResolutionUtils.class.getName(), "recommendPorts");
        return hashtable;
    }

    public static Properties recommendPorts(Properties properties, File file) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "recommendPorts");
        PortConflictResolverNoTrace portConflictResolverNoTrace = PortResolutionUtils.createPortConflictResolver(file);
        LOGGER.exiting(PortResolutionUtils.class.getName(), "recommendPorts");
        return PortResolutionUtils.resolvePorts(properties, portConflictResolverNoTrace);
    }

    public static Properties recommendPorts(Properties properties, File file, int[] nArray) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "recommendPorts");
        PortConflictResolverNoTrace portConflictResolverNoTrace = PortResolutionUtils.createPortConflictResolver(file, nArray);
        LOGGER.exiting(PortResolutionUtils.class.getName(), "recommendPorts");
        return PortResolutionUtils.resolvePorts(properties, portConflictResolverNoTrace);
    }

    public static Hashtable recommendPorts(Properties[] propertiesArray, String[] stringArray, File file) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "recommendPorts");
        LOGGER.exiting(PortResolutionUtils.class.getName(), "recommendPorts");
        return PortResolutionUtils.recommendPorts(propertiesArray, stringArray, file, new int[0]);
    }

    public static Hashtable recommendPorts(Properties[] propertiesArray, String[] stringArray, File file, int[] nArray) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "recommendPorts");
        PortConflictResolverNoTrace portConflictResolverNoTrace = PortResolutionUtils.createPortConflictResolver(file, nArray);
        Hashtable<String, Properties> hashtable = new Hashtable<String, Properties>(propertiesArray.length);
        for (int i = 0; i < propertiesArray.length; ++i) {
            hashtable.put(stringArray[i], PortResolutionUtils.resolvePorts(propertiesArray[i], portConflictResolverNoTrace));
        }
        LOGGER.exiting(PortResolutionUtils.class.getName(), "recommendPorts");
        return hashtable;
    }

    public static Properties determineBasePorts(String string) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "determineBasePorts");
        Hashtable hashtable = PortResolutionUtils.determineBasePorts(string, new String[]{"portdef.props"});
        return (Properties)hashtable.get("portdef.props");
    }

    public static Hashtable determineBasePorts(String string, String[] stringArray) throws WSProfileException {
        return PortResolutionUtils.determineBasePorts(string, stringArray, "create", S_EMPTY);
    }

    public static Hashtable determineBasePorts(String string, String[] stringArray, String string2, String string3) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "determineBasePorts");
        Hashtable<String, Properties> hashtable = new Hashtable<String, Properties>(stringArray.length);
        List list = PrereqTemplateUtils.getListOfTemplatePathsForMode(string2, string3, string);
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < list.size(); ++j) {
                File file = (File)list.get(j);
                File file2 = new File(file, "actions/portsUpdate" + File.separator + stringArray[i]);
                if (!file2.exists()) continue;
                try {
                    FileInputStream fileInputStream = new FileInputStream(file2);
                    Properties properties = new Properties();
                    properties.load(fileInputStream);
                    if (hashtable.containsKey(stringArray[i])) {
                        ((Properties)hashtable.get(stringArray[i])).putAll((Map<?, ?>)properties);
                        continue;
                    }
                    hashtable.put(stringArray[i], properties);
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    LogUtils.logException(LOGGER, fileNotFoundException);
                    throw new WSProfileException(fileNotFoundException.getMessage(), fileNotFoundException.getLocalizedMessage());
                }
                catch (IOException iOException) {
                    LogUtils.logException(LOGGER, iOException);
                    throw new WSProfileException(iOException.getMessage(), iOException.getLocalizedMessage());
                }
            }
        }
        LOGGER.exiting(PortResolutionUtils.class.getName(), "determineBasePorts");
        return hashtable;
    }

    public static Properties determineRecommendedPorts(String string) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "determineRecommendedPorts");
        Properties properties = PortResolutionUtils.determineBasePorts(string);
        LOGGER.exiting(PortResolutionUtils.class.getName(), "determineRecommendedPorts");
        return PortResolutionUtils.recommendPorts(properties, new File(S_EMPTY));
    }

    public static Hashtable determineRecommendedPorts(String string, String[] stringArray, int[] nArray) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "determineRecommendedPorts");
        LOGGER.exiting(PortResolutionUtils.class.getName(), "determineRecommendedPorts");
        return PortResolutionUtils.determineRecommendedPorts(string, stringArray, nArray, "create", S_EMPTY);
    }

    public static Hashtable determineRecommendedPorts(String string, String[] stringArray) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "determineRecommendedPorts");
        LOGGER.exiting(PortResolutionUtils.class.getName(), "determineRecommendedPorts");
        return PortResolutionUtils.determineRecommendedPorts(string, stringArray, new int[0]);
    }

    public static Hashtable determineRecommendedPorts(String string, String[] stringArray, int[] nArray, String string2, String string3) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "determineRecommendedPorts");
        Properties[] propertiesArray = new Properties[stringArray.length];
        List list = PrereqTemplateUtils.getListOfTemplatePathsForMode(string2, string3, string);
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < list.size(); ++j) {
                File file = (File)list.get(j);
                File file2 = new File(file, "actions/portsUpdate" + File.separator + stringArray[i]);
                if (!file2.exists()) continue;
                if (propertiesArray[i] == null) {
                    propertiesArray[i] = new Properties();
                }
                Properties properties = new Properties();
                try {
                    FileInputStream fileInputStream = new FileInputStream(file2);
                    properties.load(fileInputStream);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    LogUtils.logException(LOGGER, fileNotFoundException);
                    throw new WSProfileException(fileNotFoundException.getMessage(), fileNotFoundException.getLocalizedMessage());
                }
                catch (IOException iOException) {
                    LogUtils.logException(LOGGER, iOException);
                    throw new WSProfileException(iOException.getMessage(), iOException.getLocalizedMessage());
                }
                propertiesArray[i].putAll((Map<?, ?>)properties);
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "determineRecommendedPorts", "Added property file for i=" + i);
            }
        }
        LOGGER.exiting(PortResolutionUtils.class.getName(), "determineRecommendedPorts");
        return PortResolutionUtils.recommendPorts(propertiesArray, stringArray, new File(S_EMPTY), nArray);
    }

    public static boolean validatePorts(Properties properties) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "validatePorts");
        LOGGER.exiting(PortResolutionUtils.class.getName(), "validatePorts");
        return PortResolutionUtils.validatePorts(properties, new File(S_EMPTY));
    }

    public static boolean validatePorts(Properties properties, File file) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "validatePorts");
        boolean bl = true;
        Enumeration<Object> enumeration = properties.keys();
        PortConflictResolverNoTrace portConflictResolverNoTrace = PortResolutionUtils.createPortConflictResolver(file);
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n = Integer.parseInt((String)properties.get(string));
            bl = portConflictResolverNoTrace.reservePort(n);
            bl = bl && FreePortDetector.isPortFree(n);
            if (bl) continue;
            bl = false;
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "validatePorts", "Port [" + n + "] assigned to " + string + " is not free.");
            break;
        }
        LOGGER.exiting(PortResolutionUtils.class.getName(), "validatePorts");
        return bl;
    }

    public static boolean validatePort(int n, File file) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "validatePort");
        boolean bl = true;
        PortConflictResolverNoTrace portConflictResolverNoTrace = PortResolutionUtils.createPortConflictResolver(file);
        bl = portConflictResolverNoTrace.reservePort(n);
        boolean bl2 = bl = bl && FreePortDetector.isPortFree(n);
        if (!bl) {
            bl = false;
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "validatePort", "Port [" + n + "] is not free.");
        }
        LOGGER.exiting(PortResolutionUtils.class.getName(), "validatePort");
        return bl;
    }

    public static boolean validatePort(int n) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "validatePort");
        LOGGER.exiting(PortResolutionUtils.class.getName(), "validatePort");
        return PortResolutionUtils.validatePort(n, new File(S_EMPTY));
    }

    private static Properties resolvePorts(Properties properties, PortConflictResolverNoTrace portConflictResolverNoTrace) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "resolvePorts");
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n = Integer.parseInt((String)properties.get(string));
            int n2 = PortResolutionUtils.resolvePort(n, portConflictResolverNoTrace);
            properties.put(string, new Integer(n2).toString());
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "resolvePorts", "Recommended Port=[" + string + "] base value=[" + n + "]" + "] recommended value=[" + n2 + "]");
        }
        LOGGER.exiting(PortResolutionUtils.class.getName(), "resolvePorts");
        return properties;
    }

    private static int resolvePort(int n, PortConflictResolverNoTrace portConflictResolverNoTrace) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "resolvePort");
        if (n > 65535 || n < 0) {
            throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_INVALID_NUMER_EXCEPTION));
        }
        int n2 = portConflictResolverNoTrace.getPort(n);
        LOGGER.logp(Level.FINEST, S_CLASS_NAME, "resolvePort", "Initially recommending port=" + n2 + " for seed value= " + n);
        if (!FreePortDetector.isPortFree(n2)) {
            LOGGER.logp(Level.FINEST, S_CLASS_NAME, "resolvePort", "Port=" + n2 + " is not free, looking for next available port");
            while (!FreePortDetector.isPortFree(n2) || !portConflictResolverNoTrace.reservePort(n2)) {
                LOGGER.logp(Level.FINEST, S_CLASS_NAME, "resolvePort", "Port=" + n2 + " is not free or available, looking for next available port");
                if (++n2 <= 65535 && n2 >= 0) continue;
                Exception exception = FreePortDetector.getLastError();
                if (exception != null) {
                    LogUtils.logException(LOGGER, exception);
                }
                throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_UNABLE_TO_RECOMMEND_PORT));
            }
        }
        LOGGER.exiting(PortResolutionUtils.class.getName(), "resolvePort");
        return n2;
    }

    private static PortConflictResolverNoTrace createPortConflictResolver(File file) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "createPortConflictResolver");
        String[] stringArray = PortResolutionUtils.getAllWASLocations(file);
        Vector vector = new Vector();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            vector = PortResolutionUtils.getAllConfigLocations(vector, stringArray[i]);
        }
        String[] stringArray2 = vector.toArray(new String[0]);
        try {
            LOGGER.exiting(PortResolutionUtils.class.getName(), "createPortConflictResolver");
            return new PortConflictResolverNoTrace(stringArray2);
        }
        catch (PortConflictResolverException portConflictResolverException) {
            LogUtils.logException(LOGGER, portConflictResolverException);
            throw new WSProfileException(portConflictResolverException.getMessage(), portConflictResolverException.getLocalizedMessage());
        }
    }

    private static PortConflictResolverNoTrace createPortConflictResolver(File file, int[] nArray) throws WSProfileException {
        PortConflictResolverNoTrace portConflictResolverNoTrace;
        LOGGER.entering(PortResolutionUtils.class.getName(), "createPortConflictResolver");
        String[] stringArray = PortResolutionUtils.getAllWASLocations(file);
        Vector vector = new Vector();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            vector = PortResolutionUtils.getAllConfigLocations(vector, stringArray[i]);
        }
        String[] stringArray2 = vector.toArray(new String[0]);
        try {
            LOGGER.exiting(PortResolutionUtils.class.getName(), "createPortConflictResolver");
            portConflictResolverNoTrace = new PortConflictResolverNoTrace(stringArray2);
        }
        catch (PortConflictResolverException portConflictResolverException) {
            LogUtils.logException(LOGGER, portConflictResolverException);
            throw new WSProfileException(portConflictResolverException.getMessage(), portConflictResolverException.getLocalizedMessage());
        }
        for (int i = 0; i < nArray.length; ++i) {
            portConflictResolverNoTrace.reservePort(nArray[i]);
        }
        return portConflictResolverNoTrace;
    }

    private static String[] getAllWASLocations(File file) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), "getAllWASLocations");
        WASSystem wASSystem = null;
        try {
            wASSystem = file == null || file.equals(new File(S_EMPTY)) ? WASSystem.getWASSystemInstance() : WASSystem.getWASSystemInstance(file.getAbsolutePath());
            String[] stringArray = wASSystem.getWASLocations();
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getAllWASLocations", "Located the following WAS homes:" + StringUtils.convertStringArrayToCommaSeparatedString(stringArray));
            LOGGER.exiting(PortResolutionUtils.class.getName(), "getAllWASLocations");
            return stringArray;
        }
        catch (Throwable throwable) {
            LogUtils.logException(LOGGER, throwable);
            throw new WSProfileException(throwable.getMessage(), throwable.getLocalizedMessage());
        }
    }

    private static Vector getAllConfigLocations(Vector vector, String string) throws WSProfileException {
        LOGGER.entering(PortResolutionUtils.class.getName(), S_EMPTY);
        if (string == null) {
            return vector;
        }
        if (vector == null) {
            vector = new Vector<String>();
        }
        try {
            if (WSProfile.isWasprofilePropertiesAvailable(string)) {
                File file = WSProfile.getRegistryFile(string);
                if (file != null && file.exists()) {
                    List list = WSProfile.getProfileList(file);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Profile profile = (Profile)iterator.next();
                        String string2 = profile.getPath().getAbsolutePath();
                        String string3 = PortResolutionUtils.getConfigRootFromProfileHome(string2);
                        if (string3 == null) continue;
                        vector.addElement(string3);
                    }
                }
            } else {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getAllConfigLocations", "wasprofile.properties unavailable for WAS_HOME [" + string + "].  The ports from the profiles under this WAS_HOME cannot be detected.");
            }
        }
        catch (Throwable throwable) {
            LogUtils.logException(LOGGER, throwable);
            throw new WSProfileException(throwable.getMessage(), throwable.getLocalizedMessage());
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "getAllConfigLocations", "All current config homes: " + vector);
        LOGGER.exiting(PortResolutionUtils.class.getName(), S_EMPTY);
        return vector;
    }

    private static String getConfigRootFromProfileHome(String string) {
        LOGGER.entering(PortResolutionUtils.class.getName(), "getConfigRootFromProfileHome");
        String string2 = null;
        File file = new File(string + File.separator + S_CONFIG);
        if (file.exists() && file.isDirectory()) {
            try {
                string2 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                LogUtils.logException(LOGGER, iOException);
                string2 = null;
            }
        }
        LOGGER.exiting(PortResolutionUtils.class.getName(), "getConfigRootFromProfileHome");
        return string2;
    }
}

