/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.utils.FileUtils;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.utils.VectorUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.WSProfileTemplate;
import com.ibm.wsspi.profile.registry.Profile;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PrereqTemplateUtils {
    private static int N_ONE = 1;
    private static int N_ZERO = 0;
    private static int N_NEGATIVE_ONE = -1;
    private static final String S_PREREQ_TEMPLATE_ERROR_KEY = "WSProfile.PrereqTemplateUtils.prereqTemplateError";
    private static final Logger LOGGER = LoggerFactory.createLogger(PrereqTemplateUtils.class);
    private static final String S_CLASS_NAME = PrereqTemplateUtils.class.getName();

    public static Vector getTemplatesForStackCreation(File file) throws WSProfileException {
        return PrereqTemplateUtils.getTemplatesForStackCreation(new WSProfileTemplate(file));
    }

    public static Vector getTemplatesForStackCreation(WSProfileTemplate wSProfileTemplate) throws WSProfileException {
        Vector vector = PrereqTemplateUtils.getListOfPrereqs(wSProfileTemplate);
        PrereqTemplateUtils.throwExceptionIfTemplateAlreadyExists(vector, wSProfileTemplate);
        vector.add(wSProfileTemplate);
        PrereqTemplateUtils.validateListForCreation(vector);
        return vector;
    }

    public static Vector getListOfTemplatePathsForStackCreate(String string) {
        Vector<File> vector = new Vector<File>();
        try {
            Vector vector2 = PrereqTemplateUtils.getTemplatesForStackCreation(new File(string));
            for (int i = 0; i < vector2.size(); ++i) {
                vector.add(((WSProfileTemplate)vector2.get(i)).getProfileTemplatePath());
            }
        }
        catch (WSProfileException wSProfileException) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getListOfTemplatePathsForStackCreate", "Could not build a list of prerequisite profile templates for profile template " + string);
            return new Vector();
        }
        return vector;
    }

    public static Vector getTemplatesForStackAugmentation(File file, Profile profile) throws WSProfileException {
        return PrereqTemplateUtils.getTemplatesForStackAugmentation(new WSProfileTemplate(file), profile);
    }

    public static Vector getTemplatesForStackAugmentation(WSProfileTemplate wSProfileTemplate, Profile profile) throws WSProfileException {
        Vector vector = PrereqTemplateUtils.getListOfPrereqs(wSProfileTemplate);
        PrereqTemplateUtils.throwExceptionIfTemplateAlreadyExists(vector, wSProfileTemplate);
        vector.add(wSProfileTemplate);
        PrereqTemplateUtils.validateListForAugmentation(vector, profile);
        return PrereqTemplateUtils.removeExistingPrereqsForAugment(vector, profile);
    }

    public static Vector getListOfTemplatePathsForStackAugment(String string, String string2) {
        Vector<File> vector = new Vector<File>();
        try {
            Vector vector2 = PrereqTemplateUtils.getTemplatesForStackAugmentation(new File(string), WSProfile.getProfile(string2));
            for (int i = 0; i < vector2.size(); ++i) {
                vector.add(((WSProfileTemplate)vector2.get(i)).getProfileTemplatePath());
            }
        }
        catch (WSProfileException wSProfileException) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getListOfTemplatePathsForStackAugment", string + " is not a valid profile template.");
            return new Vector();
        }
        return vector;
    }

    public static List getListOfTemplatePathsForMode(String string, String string2, String string3) {
        LOGGER.entering(PrereqTemplateUtils.class.getName(), "getTemplateList");
        Vector vector = new Vector();
        if (string != null && string.equals("create") && string3 != null) {
            vector = PrereqTemplateUtils.getListOfTemplatePathsForStackCreate(string3);
        } else if (string != null && string.equals("augment") && string2 != null && string3 != null) {
            vector = PrereqTemplateUtils.getListOfTemplatePathsForStackAugment(string3, string2);
        } else if (string != null && string.equals("unaugment") && string2 != null) {
            vector = (Vector)PrereqTemplateUtils.getTemplatePathInTheFormOfAListForUnaugment(string2, string3);
        } else if (string != null && string.equals("delete") && string2 != null) {
            vector = (Vector)PrereqTemplateUtils.getListOfTemplatePathsForDelete(string2);
        }
        LOGGER.exiting(PrereqTemplateUtils.class.getName(), "getTemplateList");
        return vector;
    }

    public static List getTemplatePathInTheFormOfAListForUnaugment(String string, String string2) {
        Vector<File> vector;
        block8: {
            LOGGER.entering(PrereqTemplateUtils.class.getName(), "getTemplatePathInTheFormOfAListForUnaugment");
            String string3 = System.getProperty("ignoreStack");
            vector = new Vector<File>();
            Vector vector2 = new Vector();
            try {
                File file;
                vector2 = (Vector)WSProfile.getProfile(string).getAugmentors();
                if (string3 != null && string3.equals("")) {
                    File file2;
                    LOGGER.logp(Level.INFO, S_CLASS_NAME, "getTemplatePathInTheFormOfAListForUnaugment", "-ignoreStack was specified");
                    if (string2 != null && string2.length() > 0 && vector2 != null && (file2 = new File(string2)) != null) {
                        for (int i = 0; i < vector2.size(); ++i) {
                            if (!vector2.elementAt(i).equals(file2.getPath())) continue;
                            Vector vector3 = (Vector)PrereqTemplateUtils.getListOfDependantTemplates(string, new WSProfileTemplate(file2.getPath()));
                            vector3.remove(new WSProfileTemplate(file2.getPath()));
                            if (vector3 == null || vector3.size() == 0) {
                                vector.add(file2);
                            } else {
                                LOGGER.logp(Level.INFO, S_CLASS_NAME, "getTemplatePathInTheFormOfAListForUnaugment", "There are other templates which depend on this template thus a valid template path cannot be returned for unaugmentation");
                            }
                            return vector;
                        }
                    }
                    break block8;
                }
                if (vector2 != null && vector2.size() >= 1 && (file = new File((String)vector2.get(vector2.size() - 1))) != null) {
                    vector.add(file);
                }
                return vector;
            }
            catch (WSProfileException wSProfileException) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getTemplatePathInTheFormOfAListForUnaugment", string + " is not a valid profile name or the templatePath " + string2 + " refer to an existing template");
                LOGGER.exiting(S_CLASS_NAME, "getTemplatePathInTheFormOfAListForUnaugment");
                return new Vector();
            }
        }
        LOGGER.exiting(S_CLASS_NAME, "getTemplatePathInTheFormOfAListForUnaugment");
        return vector;
    }

    public static List getListOfDependantTemplates(String string, WSProfileTemplate wSProfileTemplate) throws WSProfileException {
        LOGGER.entering(PrereqTemplateUtils.class.getName(), "getListStackOfUnaugments");
        List list = WSProfile.getAllAugmentationProfileTemplates(string);
        Vector vector = new Vector();
        if (!list.contains(wSProfileTemplate)) {
            return new Vector();
        }
        vector.add(list.get(list.indexOf(wSProfileTemplate)));
        for (int i = 0; i < list.size(); ++i) {
            WSProfileTemplate wSProfileTemplate2 = (WSProfileTemplate)list.get(i);
            if (wSProfileTemplate2.getPrereqTemplatePath() == null || !vector.contains(new WSProfileTemplate(wSProfileTemplate2.getPrereqTemplatePath()))) continue;
            vector.add(wSProfileTemplate2);
        }
        LOGGER.exiting(PrereqTemplateUtils.class.getName(), "getListStackOfUnaugments");
        return vector;
    }

    public static List getListOfTemplatePathsForDelete(String string) {
        LOGGER.entering(S_CLASS_NAME, "getListOfTemplatePathsForDelete");
        Vector<File> vector = new Vector<File>();
        try {
            vector.add(WSProfile.getProfile(string).getPath());
            Vector vector2 = (Vector)WSProfile.getProfile(string).getAugmentors();
            if (vector2 != null) {
                for (int i = 0; i < vector2.size(); ++i) {
                    vector.add(new File((String)vector2.elementAt(i)));
                }
            }
        }
        catch (WSProfileException wSProfileException) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getTemplatePathInTheFormOfAListForUnaugment", string + " is not a valid profile name ");
            LOGGER.exiting(S_CLASS_NAME, "getListOfTemplatePathsForDelete");
            return new Vector();
        }
        LOGGER.exiting(S_CLASS_NAME, "getListOfTemplatePathsForDelete");
        return vector;
    }

    public static void validateListForCreation(Vector vector) throws WSProfileException {
        LOGGER.entering(PrereqTemplateUtils.class.getName(), "validateListForCreation");
        boolean bl = true;
        WSProfileTemplate wSProfileTemplate = (WSProfileTemplate)vector.get(N_ZERO);
        bl = bl && wSProfileTemplate.isCreateTemplate();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "validateListForCreation", "Evaluating if " + wSProfileTemplate + " is a profile-creating template.");
        for (int i = 1; i < vector.size() && bl; ++i) {
            wSProfileTemplate = (WSProfileTemplate)vector.get(i);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "validateListForCreation", "Evaluating if " + wSProfileTemplate + " is a profile-augmenting template.");
            bl = bl && wSProfileTemplate.isAugmentTemplate();
        }
        if (!bl) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "validateListForCreation", "Prerequiste profile template " + wSProfileTemplate.getProfileTemplatePath() + " cannot be used for creation.");
            throw new WSProfileException();
        }
        LOGGER.exiting(PrereqTemplateUtils.class.getName(), "validateListForCreation");
    }

    public static void validateListForAugmentation(Vector vector, Profile profile) throws WSProfileException {
        WSProfileTemplate wSProfileTemplate;
        boolean bl;
        block5: {
            LOGGER.entering(PrereqTemplateUtils.class.getName(), "validateListForAugmentation");
            bl = true;
            if (vector.size() == 0) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "validateListForAugmentation", "Validation successful. There are no augmentations that need to be performed.");
                LOGGER.exiting(PrereqTemplateUtils.class.getName(), "validateListForAugmentation");
                return;
            }
            wSProfileTemplate = (WSProfileTemplate)vector.get(0);
            try {
                if (!wSProfileTemplate.isAugmentTemplate() && !wSProfileTemplate.getProfileTemplatePath().getCanonicalFile().equals(profile.getTemplate().getCanonicalFile())) {
                    LOGGER.logp(Level.WARNING, S_CLASS_NAME, "validateListForAugmentation", "The prerequisite template " + wSProfileTemplate.getProfileTemplatePath() + " failed validation. " + "It should be an augmenting template, or the template that was used " + "to create this profile.");
                    throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_PREREQ_TEMPLATE_ERROR_KEY), ResourceBundleUtils.getLocaleString(S_PREREQ_TEMPLATE_ERROR_KEY));
                }
            }
            catch (IOException iOException) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "unaugment", "Failed to resolve prerequisites using canonical paths. Trying to use unmodified paths.");
                if (wSProfileTemplate.isAugmentTemplate() || wSProfileTemplate.getProfileTemplatePath().equals(profile.getTemplate())) break block5;
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "validateListForAugmentation", "The prerequisite template " + wSProfileTemplate.getProfileTemplatePath() + " failed validation. " + "It should be an augmenting template, or the template that was used " + "to create this profile.");
                throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_PREREQ_TEMPLATE_ERROR_KEY), ResourceBundleUtils.getLocaleString(S_PREREQ_TEMPLATE_ERROR_KEY));
            }
        }
        for (int i = N_ONE; i < vector.size(); ++i) {
            wSProfileTemplate = (WSProfileTemplate)vector.get(i);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "validateListForAugmentation", "Evaluating if " + wSProfileTemplate + " is a profile-augmenting template.");
            boolean bl2 = bl = bl && wSProfileTemplate.isAugmentTemplate();
            if (bl) continue;
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "validateListForAugmentation", "Prerequiste profile templates " + wSProfileTemplate.getProfileTemplatePath() + " cannot be used for augmentation.");
            throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_PREREQ_TEMPLATE_ERROR_KEY), ResourceBundleUtils.getLocaleString(S_PREREQ_TEMPLATE_ERROR_KEY));
        }
        LOGGER.exiting(PrereqTemplateUtils.class.getName(), "validateListForAugmentation");
    }

    public static boolean isValidTemplateForUnaugmentation(String string, File file) throws WSProfileException {
        LOGGER.entering(PrereqTemplateUtils.class.getName(), "isValidTemplateForUnaugmentation");
        Profile profile = WSProfile.getProfile(string);
        Vector vector = new Vector(profile.getAugmentors());
        if (!vector.contains(file)) {
            return false;
        }
        LOGGER.exiting(PrereqTemplateUtils.class.getName(), "isValidTemplateForUnaugmentation");
        return false;
    }

    public static int getTotalTemplateSizeForStackCreation(File file) throws WSProfileException {
        LOGGER.entering(PrereqTemplateUtils.class.getName(), "getTotalTemplateSizeForStackCreation");
        int n = 0;
        Vector vector = PrereqTemplateUtils.getTemplatesForStackCreation(file);
        for (int i = 0; i < vector.size(); ++i) {
            n += ((WSProfileTemplate)vector.elementAt(i)).getSize();
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getTotalTemplateSizeForStackCreation", "The size of the template including prerequisite templates is: " + n + " Megabytes");
        LOGGER.exiting(PrereqTemplateUtils.class.getName(), "getTotalTemplateSizeForStackCreation");
        return n;
    }

    public static int getTotalTemplateSizeForStackAugmentation(File file, String string) throws WSProfileException {
        LOGGER.entering(PrereqTemplateUtils.class.getName(), "getTotalTemplateSizeForStackAugmentation");
        int n = 0;
        Profile profile = WSProfile.getProfile(string);
        Vector vector = PrereqTemplateUtils.getTemplatesForStackAugmentation(file, profile);
        for (int i = 0; i < vector.size(); ++i) {
            n += ((WSProfileTemplate)vector.elementAt(i)).getSize();
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getTotalTemplateSizeForStackAugmentation", "The size of the template including prerequisite templates is: " + n + " Megabytes");
        LOGGER.exiting(PrereqTemplateUtils.class.getName(), "getTotalTemplateSizeForStackAugmentation");
        return n;
    }

    private static Vector getListOfPrereqs(WSProfileTemplate wSProfileTemplate) throws WSProfileException {
        LOGGER.entering(PrereqTemplateUtils.class.getName(), "getPrerequisiteTemplateList");
        Vector<WSProfileTemplate> vector = new Vector<WSProfileTemplate>();
        WSProfileTemplate wSProfileTemplate2 = wSProfileTemplate;
        File file = wSProfileTemplate2.getPrereqTemplatePath();
        if (file == null) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getListOfPrereqs", "No prerequisite profile template was found.");
            LOGGER.exiting(PrereqTemplateUtils.class.getName(), "getPrerequisiteTemplateList");
            return new Vector();
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getListOfPrereqs", "Building list of prerequisite profile templates...");
        do {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getListOfPrereqs", "Adding prerequisite profile template " + file + " to the list.");
            wSProfileTemplate2 = new WSProfileTemplate(file);
            PrereqTemplateUtils.throwExceptionIfTemplateAlreadyExists(vector, wSProfileTemplate2);
            vector.add(wSProfileTemplate2);
        } while ((file = wSProfileTemplate2.getPrereqTemplatePath()) != null);
        LOGGER.exiting(PrereqTemplateUtils.class.getName(), "getPrerequisiteTemplateList");
        return VectorUtils.reverseVector(vector);
    }

    private static Vector removeExistingPrereqsForAugment(Vector vector, Profile profile) throws WSProfileException {
        int n;
        LOGGER.entering(PrereqTemplateUtils.class.getName(), "removeExistingPrereqsForAugment");
        Vector vector2 = FileUtils.convertStringListToFileVector((Vector)profile.getAugmentors());
        try {
            vector2 = (Vector)FileUtils.convertFileListIntoCanonicalForm(vector2);
            vector2.add(0, profile.getTemplate().getCanonicalFile());
        }
        catch (IOException iOException) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "removeExistingPrereqsForAugment", "Failed to convert the list of existing templates into canonical form. Trying to use unmodified list.");
            vector2 = FileUtils.convertStringListToFileVector((Vector)profile.getAugmentors());
            vector2.add(0, profile.getTemplate());
        }
        int[] nArray = new int[vector.size()];
        for (n = N_ZERO; n < vector.size(); ++n) {
            File file = ((WSProfileTemplate)vector.get(n)).getProfileTemplatePath();
            try {
                nArray[n] = vector2.indexOf(file.getCanonicalFile());
                continue;
            }
            catch (IOException iOException) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "removeExistingPrereqsForAugment", "Failed to to find the index of the template in canonical form. Trying to use unmodified template path.");
                nArray[n] = vector2.indexOf(file);
            }
        }
        n = nArray.length;
        int n2 = nArray.length - 1;
        while (n2 >= 0 && nArray[n2] == N_NEGATIVE_ONE) {
            n = n2--;
        }
        n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] < n2) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "removeExistingPrereqsForAugment", "The registered profile template augmentor stacka is not valid.");
                throw new WSProfileException("invalid registered augmentor stack!", "invalid registered augmentor stack!");
            }
            n2 = nArray[i];
        }
        LOGGER.exiting(PrereqTemplateUtils.class.getName(), "removeExistingPrereqsForAugment");
        return new Vector(vector.subList(n, nArray.length));
    }

    private static void throwExceptionIfTemplateAlreadyExists(Vector vector, WSProfileTemplate wSProfileTemplate) throws WSProfileException {
        if (vector.contains(wSProfileTemplate)) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "throwExceptionIfTemplateAlreadyExists", "The prerequisite profile template " + wSProfileTemplate.getProfileTemplatePath() + " is already in the list of prerequisites.");
            throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_PREREQ_TEMPLATE_ERROR_KEY), ResourceBundleUtils.getLocaleString(S_PREREQ_TEMPLATE_ERROR_KEY));
        }
    }
}

