/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResponseFileUtils {
    private static final Logger LOGGER = LoggerFactory.createLogger(ResponseFileUtils.class);
    private static final String S_CLASS_NAME = ResponseFileUtils.class.getName();
    private static char[] AC_SPECIAL_CHARS_NOT_TO_UNICODE_ESCAPE = new char[]{'\b', '\t', '\n', '\f', '\r', '\"', '\'', '\\'};
    private static final String S_UNICODE_ESCAPE_STRING = "\\u";
    private static final char C_LOWER_ASCII_LIMIT = ' ';
    private static final char C_UPPER_ASCII_LIMIT = '~';
    private static final String S_DEFAULT_OUTPUT_ENCODING = "ISO-8859-1";
    private static final String S_JAVA_FILE_ENCODING_PROPERTY = "file.encoding";

    public static String encodeResponseFile(String string) throws FileNotFoundException, IOException {
        LOGGER.entering(ResponseFileUtils.class.getName(), "encodeResponseFile");
        File file = new File(string);
        String string2 = ResponseFileUtils.createEncodedFileName(file.getName());
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "encodeResponseFile", "Encoded response file name =" + string2);
        String string3 = ResponseFileUtils.determineNativeEncoding();
        ResponseFileUtils.encodeFile(string3, string, string2);
        ResponseFileUtils.markFileForDeletionOnExit(string2);
        LOGGER.exiting(ResponseFileUtils.class.getName(), "encodeResponseFile");
        return string2;
    }

    private static void encodeFile(String string, String string2, String string3) throws FileNotFoundException, IOException {
        int n;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        fileInputStream = new FileInputStream(string2);
        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, string));
        fileOutputStream = new FileOutputStream(string3);
        bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, S_DEFAULT_OUTPUT_ENCODING));
        char[] cArray = new char[4096];
        while ((n = bufferedReader.read(cArray)) != -1) {
            bufferedWriter.write(ResponseFileUtils.escapeBuffer(cArray, n));
        }
        bufferedReader.close();
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    private static String escapeBuffer(char[] cArray, int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = ResponseFileUtils.doesCharNeedUnicodeEscape(cArray[i]) ? string + ResponseFileUtils.createUnicodeEscapedString(cArray[i]) : string + cArray[i];
        }
        return string;
    }

    private static String createUnicodeEscapedString(char c) {
        String string = "";
        String string2 = S_UNICODE_ESCAPE_STRING;
        String string3 = Integer.toHexString(c);
        while (string3.length() < 4) {
            string3 = "0" + string3;
        }
        string = string + string2;
        string = string + string3;
        return string;
    }

    private static void markFileForDeletionOnExit(String string) {
        LOGGER.entering(ResponseFileUtils.class.getName(), "markFileForDeletionOnExit");
        File file = new File(string);
        file.deleteOnExit();
        LOGGER.exiting(ResponseFileUtils.class.getName(), "markFileForDeletionOnExit");
    }

    private static String createEncodedFileName(String string) throws IOException {
        LOGGER.entering(ResponseFileUtils.class.getName(), "");
        String string2 = null;
        File file = File.createTempFile(string, null);
        string2 = file.getCanonicalPath();
        file.delete();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "createEncodedFileName", "Encoded file name=" + string2);
        LOGGER.exiting(ResponseFileUtils.class.getName(), "");
        return string2;
    }

    private static String determineNativeEncoding() {
        LOGGER.entering(ResponseFileUtils.class.getName(), "determineNativeEncoding");
        String string = System.getProperty(S_JAVA_FILE_ENCODING_PROPERTY);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "determineNativeEncoding", "Native file encoding=" + string);
        LOGGER.exiting(ResponseFileUtils.class.getName(), "determineNativeEncoding");
        return string;
    }

    private static boolean doesCharNeedUnicodeEscape(char c) {
        LOGGER.entering(ResponseFileUtils.class.getName(), "doesCharNeedUnicodeEscape");
        if (c >= ' ' && c <= '~' || ResponseFileUtils.isSpecialCharacter(c)) {
            return false;
        }
        LOGGER.logp(Level.FINER, S_CLASS_NAME, "doesCharNeedUnicodeEscape", "Does character " + c + " need a unicode escape " + true);
        LOGGER.exiting(ResponseFileUtils.class.getName(), "doesCharNeedUnicodeEscape");
        return true;
    }

    private static boolean isSpecialCharacter(char c) {
        LOGGER.entering(ResponseFileUtils.class.getName(), "isSpecialCharacter");
        for (int i = 0; i < AC_SPECIAL_CHARS_NOT_TO_UNICODE_ESCAPE.length; ++i) {
            if (c != AC_SPECIAL_CHARS_NOT_TO_UNICODE_ESCAPE[i]) continue;
            return true;
        }
        LOGGER.exiting(ResponseFileUtils.class.getName(), "isSpecialCharacter");
        return false;
    }
}

