/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import com.ibm.ws.install.configmanager.ConfigManagerConstants;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.wsspi.profile.WSProfile;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SystemPropertiesUtils {
    private static final String S_EMPTY = "";
    private static final Logger LOGGER = LoggerFactory.createLogger(WSProfile.class);
    private static final String S_CLASS_NAME = SystemPropertiesUtils.class.getName();

    public static void setJavaSystemPropertiesForConfigManagerBasedOnActionRegistry(String string, String string2, String string3, String string4, String string5, String string6, Map map, File file) {
        LOGGER.entering(WSProfile.class.getName(), "setJavaSystemPropertiesForConfigManagerProfileBasedOnActionRegistry");
        System.setProperty(ConfigManagerConstants.S_ARG_ACTION_REGISTRY, file.getAbsolutePath());
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "setJavaSystemPropertiesForConfigManagerBasedOnActionRegistry", "Action registry set to: " + file.getAbsolutePath());
        SystemPropertiesUtils.setJavaSystemPropertiesForConfigManagerProfileOperation(string, string2, string3, string4, string5, string6, map);
        LOGGER.exiting(WSProfile.class.getName(), "setJavaSystemPropertiesForConfigManagerProfileBasedOnActionRegistry");
    }

    public static void setJavaSystemPropertiesForConfigManagerProfileOperation(String string, String string2, String string3, String string4, String string5, String string6, Map map) {
        LOGGER.entering(WSProfile.class.getName(), "setJavaSystemPropertiesForConfigManagerProfileOperation");
        SystemPropertiesUtils.setJavaSystemPropertiesForConfigManagerFromGivenOptionalArgumentMap(map);
        SystemPropertiesUtils.setSystemPropertyIfGivenValueIsNotNull(ConfigManagerConstants.S_ARG_CONFIG_DIR, string3);
        SystemPropertiesUtils.setSystemPropertyIfGivenValueIsNotNull("WS_CMT_NODE_NAME", string4);
        SystemPropertiesUtils.setSystemPropertyIfGivenValueIsNotNull("WS_CMT_CELL_NAME", string5);
        SystemPropertiesUtils.setSystemPropertyIfGivenValueIsNotNull("WS_CMT_HOST_NAME", string6);
        SystemPropertiesUtils.setSystemPropertyIfGivenValueIsNotNull("profilePath", string2);
        SystemPropertiesUtils.setSystemPropertyIfGivenValueIsNotNull("templatePath", string3);
        SystemPropertiesUtils.setSystemPropertyIfGivenValueIsNotNull("profileName", string);
        LOGGER.exiting(WSProfile.class.getName(), "setJavaSystemPropertiesForConfigManagerProfileOperation");
    }

    public static void resetJavaSystemPropertiesForConfigManagerProfileCreationOrDeletion(Map map) {
        LOGGER.entering(WSProfile.class.getName(), "resetJavaSystemPropertiesForConfigManagerProfileCreationOrDeletion");
        Properties properties = System.getProperties();
        properties.remove(ConfigManagerConstants.S_ARG_ACTION_REGISTRY);
        properties.remove(ConfigManagerConstants.S_ARG_CONFIG_DIR);
        properties.remove("WS_CMT_NODE_NAME");
        properties.remove("WS_CMT_CELL_NAME");
        properties.remove("WS_CMT_HOST_NAME");
        properties.remove("profilePath");
        properties.remove("templatePath");
        properties.remove("profileName");
        SystemPropertiesUtils.resetJavaSystemPropertiesForConfigManagerFromGivenOptionalArgumentMap(map, properties);
        System.setProperties(properties);
        LOGGER.exiting(WSProfile.class.getName(), "resetJavaSystemPropertiesForConfigManagerProfileCreationOrDeletion");
    }

    private static void setSystemPropertyIfGivenValueIsNotNull(String string, String string2) {
        LOGGER.entering(WSProfile.class.getName(), "setSystemPropertyIfGivenValueIsNotNull");
        if (string2 != null) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "setSystemPropertyIfGivenValueIsNotNull", "Setting system property: " + string);
            System.setProperty(string, string2);
        } else {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "setSystemPropertyIfGivenValueIsNotNull", "Skipping to set system property: " + string + " as its value specified was null");
        }
        LOGGER.exiting(WSProfile.class.getName(), "setSystemPropertyIfGivenValueIsNotNull");
    }

    public static Properties setJavaSystemPropertiesForConfigManagerFromGivenOptionalArgumentMap(Map map) {
        LOGGER.entering(WSProfile.class.getName(), "setJavaSystemPropertiesForConfigManagerFromGivenOptionalArgumentMap");
        Properties properties = (Properties)System.getProperties().clone();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            String string = k.toString();
            Vector vector = (Vector)map.get(k);
            if (vector.size() > 1) {
                for (int i = 0; i < vector.size(); ++i) {
                    System.setProperty(string + (i + 1), vector.elementAt(i).toString());
                }
            }
            if (vector.size() == 1) {
                System.setProperty(string, vector.elementAt(0).toString());
            }
            if (vector.size() != 0) continue;
            System.setProperty(string, S_EMPTY);
        }
        LOGGER.exiting(WSProfile.class.getName(), "setJavaSystemPropertiesForConfigManagerFromGivenOptionalArgumentMap");
        return properties;
    }

    public static void resetJavaSystemPropertiesForConfigManagerFromGivenOptionalArgumentMap(Map map, Properties properties) {
        LOGGER.entering(WSProfile.class.getName(), "resetJavaSystemPropertiesForConfigManagerFromGivenOptionalArgumentMap");
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            String string = k.toString();
            Vector vector = (Vector)map.get(k);
            if (vector.size() > 1) {
                for (int i = 0; i < vector.size(); ++i) {
                    properties.remove(string + (i + 1));
                }
            }
            if (vector.size() > 1) continue;
            properties.remove(string);
        }
        LOGGER.exiting(WSProfile.class.getName(), "resetJavaSystemPropertiesForConfigManagerFromGivenOptionalArgumentMap");
    }

    public static void resetJavaSystemPropertiesForConfigManagerFromGivenOptionalArgumentMap(Map map) {
        LOGGER.entering(WSProfile.class.getName(), "resetJavaSystemPropertiesForConfigManagerFromGivenOptionalArgumentMap");
        Properties properties = System.getProperties();
        SystemPropertiesUtils.resetJavaSystemPropertiesForConfigManagerFromGivenOptionalArgumentMap(map, properties);
        LOGGER.exiting(WSProfile.class.getName(), "resetJavaSystemPropertiesForConfigManagerFromGivenOptionalArgumentMap");
    }

    public static void resetJavaSystemProperties(Properties properties) {
        LOGGER.entering(WSProfile.class.getName(), "resetJavaSystemProperties");
        System.setProperties(properties);
        LOGGER.exiting(WSProfile.class.getName(), "resetJavaSystemProperties");
    }
}

